using System;
using System.Collections.Generic;
using System.Text;
using MySQL.Grt;
using Aga.Controls.Tree;
using Aga.Controls.Tree.NodeControls;

namespace MySQL.GUI.Workbench
{
  public class ModelCatalogTreeModel : SimpleGrtTreeModel
  {
    /// <summary>
    /// Constructor that initializes the model with the given objects
    /// </summary>
    /// <param name="TreeView">The TreeViewAdv control this model belongs to</param>
    /// <param name="GrtTree">The GRT tree this model belongs to</param>
    /// <param name="NodeStateIcon">The NodeControl representing the state icon</param>
    public ModelCatalogTreeModel(TreeViewAdv TreeView, GrtValueTree GrtTree, NodeStateIcon NodeStateIcon)
      : base(TreeView, GrtTree, NodeStateIcon, false)
    {

    }

    /// <summary>
    /// Function to get the GRT Value the given node represents
    /// </summary>
    /// <param name="node">The tree node</param>
    /// <returns>The GRT Value</returns>
    public GrtValue GetNodeGrtValue(TreeNodeAdv node)
    {
      if (node == null)
        return null;

      GrtTreeNode grtTreeNode = node.Tag as GrtTreeNode;

      return ((GrtValueTree)model).get_node_value(grtTreeNode.NodeId);
    }

  }
}
