using System;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace MySQL.Utilities
{
  public class StringUtilities
  {
    /**
     * Adjusts the given string so that it fits into the given width. EllipsisWidth gives the width of
     * the three points to be added to the shorted string. If this value is 0 then it will be determined implicitely.
     * For higher speed (and multiple entries to be shorted) specify this value explicitely.
     */
    public static String ShortenString(String text, int targetWidth, Font font)
    {
      String result;
      int length = text.Length;
      if (length == 0 || targetWidth <= 0)
        result = "";
      else
      {
        // Proposed size is set to the target width as maximum.
        Size proposedSize = new Size(targetWidth, int.MaxValue);
        Size size = TextRenderer.MeasureText(text, font, proposedSize, TextFormatFlags.EndEllipsis | 
          TextFormatFlags.ModifyString);

        // MeasureText insert ellipsis and a null terminator, so we only return chars up to that terminator.
        String[] parts = text.Split('\0');
        if (parts.Length < 1)
          result = text;
        else
          result = parts[0];
      };
      return result;
    }
  }
}
