﻿// Copyright © 2008, 2010, Oracle and/or its affiliates. All rights reserved.
//
// MySQL for Visual Studio is licensed under the terms of the GPLv2
// <http://www.gnu.org/licenses/old-licenses/gpl-2.0.html>, like most 
// MySQL Connectors. There are special exceptions to the terms and 
// conditions of the GPLv2 as it is applied to this software, see the 
// FLOSS License Exception
// <http://www.mysql.com/about/legal/licensing/foss-exception.html>.
//
// This program is free software; you can redistribute it and/or modify 
// it under the terms of the GNU General Public License as published 
// by the Free Software Foundation; version 2 of the License.
//
// This program is distributed in the hope that it will be useful, but 
// WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
// or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License 
// for more details.
//
// You should have received a copy of the GNU General Public License along 
// with this program; if not, write to the Free Software Foundation, Inc., 
// 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA

using System.ComponentModel;
using System;
using MySql.Data.VisualStudio.DbObjects;

namespace MySql.Data.VisualStudio.Editors
{
  class CustomPropertyDescriptor : PropertyDescriptor
  {
    private PropertyDescriptor myProp;
    private bool readOnly;

    public CustomPropertyDescriptor(PropertyDescriptor pd) :
      base(pd)
    {
      myProp = pd;
    }

    public override bool IsReadOnly
    {
      get { return readOnly; }
    }

    public void SetReadOnly(bool value)
    {
      readOnly = value;
    }

    public override bool CanResetValue(object component)
    {
      return true;
    }

    public override Type ComponentType
    {
      get { return typeof(Table); }
    }

    public override object GetValue(object component)
    {
      return myProp.GetValue(component);
    }

    public override System.Type PropertyType
    {
      get { return typeof(string); }
    }

    public override void ResetValue(object component)
    {
    }

    public override void SetValue(object component, object value)
    {
      myProp.SetValue(component, value);
    }

    public override bool ShouldSerializeValue(object component)
    {
      return false;
    }
  }
}
