# coding: utf-8
# Copyright (c) 2016, 2022, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Report(object):
    """
    Description of Report.
    """

    #: A constant which can be used with the mime_type property of a Report.
    #: This constant has a value of "PDF"
    MIME_TYPE_PDF = "PDF"

    #: A constant which can be used with the mime_type property of a Report.
    #: This constant has a value of "XLS"
    MIME_TYPE_XLS = "XLS"

    #: A constant which can be used with the lifecycle_state property of a Report.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a Report.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    def __init__(self, **kwargs):
        """
        Initializes a new Report object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this Report.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this Report.
        :type display_name: str

        :param report_definition_id:
            The value to assign to the report_definition_id property of this Report.
        :type report_definition_id: str

        :param description:
            The value to assign to the description property of this Report.
        :type description: str

        :param compartment_id:
            The value to assign to the compartment_id property of this Report.
        :type compartment_id: str

        :param mime_type:
            The value to assign to the mime_type property of this Report.
            Allowed values for this property are: "PDF", "XLS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type mime_type: str

        :param time_generated:
            The value to assign to the time_generated property of this Report.
        :type time_generated: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this Report.
            Allowed values for this property are: "UPDATING", "ACTIVE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this Report.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this Report.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this Report.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'report_definition_id': 'str',
            'description': 'str',
            'compartment_id': 'str',
            'mime_type': 'str',
            'time_generated': 'datetime',
            'lifecycle_state': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'report_definition_id': 'reportDefinitionId',
            'description': 'description',
            'compartment_id': 'compartmentId',
            'mime_type': 'mimeType',
            'time_generated': 'timeGenerated',
            'lifecycle_state': 'lifecycleState',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }

        self._id = None
        self._display_name = None
        self._report_definition_id = None
        self._description = None
        self._compartment_id = None
        self._mime_type = None
        self._time_generated = None
        self._lifecycle_state = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this Report.
        The OCID of the report.


        :return: The id of this Report.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Report.
        The OCID of the report.


        :param id: The id of this Report.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this Report.
        Name of the report.


        :return: The display_name of this Report.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this Report.
        Name of the report.


        :param display_name: The display_name of this Report.
        :type: str
        """
        self._display_name = display_name

    @property
    def report_definition_id(self):
        """
        Gets the report_definition_id of this Report.
        The OCID of the report definition.


        :return: The report_definition_id of this Report.
        :rtype: str
        """
        return self._report_definition_id

    @report_definition_id.setter
    def report_definition_id(self, report_definition_id):
        """
        Sets the report_definition_id of this Report.
        The OCID of the report definition.


        :param report_definition_id: The report_definition_id of this Report.
        :type: str
        """
        self._report_definition_id = report_definition_id

    @property
    def description(self):
        """
        Gets the description of this Report.
        Specifies a description of the report.


        :return: The description of this Report.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this Report.
        Specifies a description of the report.


        :param description: The description of this Report.
        :type: str
        """
        self._description = description

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this Report.
        The OCID of the compartment containing the report.


        :return: The compartment_id of this Report.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this Report.
        The OCID of the compartment containing the report.


        :param compartment_id: The compartment_id of this Report.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def mime_type(self):
        """
        Gets the mime_type of this Report.
        Specifies the format of report to be excel or pdf

        Allowed values for this property are: "PDF", "XLS", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The mime_type of this Report.
        :rtype: str
        """
        return self._mime_type

    @mime_type.setter
    def mime_type(self, mime_type):
        """
        Sets the mime_type of this Report.
        Specifies the format of report to be excel or pdf


        :param mime_type: The mime_type of this Report.
        :type: str
        """
        allowed_values = ["PDF", "XLS"]
        if not value_allowed_none_or_none_sentinel(mime_type, allowed_values):
            mime_type = 'UNKNOWN_ENUM_VALUE'
        self._mime_type = mime_type

    @property
    def time_generated(self):
        """
        **[Required]** Gets the time_generated of this Report.
        Specifies the time at which the report was generated.


        :return: The time_generated of this Report.
        :rtype: datetime
        """
        return self._time_generated

    @time_generated.setter
    def time_generated(self, time_generated):
        """
        Sets the time_generated of this Report.
        Specifies the time at which the report was generated.


        :param time_generated: The time_generated of this Report.
        :type: datetime
        """
        self._time_generated = time_generated

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this Report.
        The current state of the report.

        Allowed values for this property are: "UPDATING", "ACTIVE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this Report.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this Report.
        The current state of the report.


        :param lifecycle_state: The lifecycle_state of this Report.
        :type: str
        """
        allowed_values = ["UPDATING", "ACTIVE"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this Report.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see `Resource Tags`__

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this Report.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this Report.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see `Resource Tags`__

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this Report.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this Report.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see `Resource Tags`__

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this Report.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this Report.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see `Resource Tags`__

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this Report.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this Report.
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this Report.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this Report.
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this Report.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
