# coding: utf-8
# Copyright (c) 2016, 2022, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CveDetails(object):
    """
    Details on a CVE
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CveDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param cve_reference:
            The value to assign to the cve_reference property of this CveDetails.
        :type cve_reference: str

        :param title:
            The value to assign to the title property of this CveDetails.
        :type title: str

        :param description:
            The value to assign to the description property of this CveDetails.
        :type description: str

        :param related_cve_reference:
            The value to assign to the related_cve_reference property of this CveDetails.
        :type related_cve_reference: str

        :param cvss3:
            The value to assign to the cvss3 property of this CveDetails.
        :type cvss3: str

        :param time_published:
            The value to assign to the time_published property of this CveDetails.
        :type time_published: datetime

        :param time_updated:
            The value to assign to the time_updated property of this CveDetails.
        :type time_updated: datetime

        """
        self.swagger_types = {
            'cve_reference': 'str',
            'title': 'str',
            'description': 'str',
            'related_cve_reference': 'str',
            'cvss3': 'str',
            'time_published': 'datetime',
            'time_updated': 'datetime'
        }

        self.attribute_map = {
            'cve_reference': 'cveReference',
            'title': 'title',
            'description': 'description',
            'related_cve_reference': 'relatedCveReference',
            'cvss3': 'cvss3',
            'time_published': 'timePublished',
            'time_updated': 'timeUpdated'
        }

        self._cve_reference = None
        self._title = None
        self._description = None
        self._related_cve_reference = None
        self._cvss3 = None
        self._time_published = None
        self._time_updated = None

    @property
    def cve_reference(self):
        """
        **[Required]** Gets the cve_reference of this CveDetails.
        CVE ID


        :return: The cve_reference of this CveDetails.
        :rtype: str
        """
        return self._cve_reference

    @cve_reference.setter
    def cve_reference(self, cve_reference):
        """
        Sets the cve_reference of this CveDetails.
        CVE ID


        :param cve_reference: The cve_reference of this CveDetails.
        :type: str
        """
        self._cve_reference = cve_reference

    @property
    def title(self):
        """
        **[Required]** Gets the title of this CveDetails.
        Vulnerability title


        :return: The title of this CveDetails.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """
        Sets the title of this CveDetails.
        Vulnerability title


        :param title: The title of this CveDetails.
        :type: str
        """
        self._title = title

    @property
    def description(self):
        """
        Gets the description of this CveDetails.
        CVE description


        :return: The description of this CveDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CveDetails.
        CVE description


        :param description: The description of this CveDetails.
        :type: str
        """
        self._description = description

    @property
    def related_cve_reference(self):
        """
        Gets the related_cve_reference of this CveDetails.
        ID of related CVE, if applicable


        :return: The related_cve_reference of this CveDetails.
        :rtype: str
        """
        return self._related_cve_reference

    @related_cve_reference.setter
    def related_cve_reference(self, related_cve_reference):
        """
        Sets the related_cve_reference of this CveDetails.
        ID of related CVE, if applicable


        :param related_cve_reference: The related_cve_reference of this CveDetails.
        :type: str
        """
        self._related_cve_reference = related_cve_reference

    @property
    def cvss3(self):
        """
        **[Required]** Gets the cvss3 of this CveDetails.
        CVSS 3 Score


        :return: The cvss3 of this CveDetails.
        :rtype: str
        """
        return self._cvss3

    @cvss3.setter
    def cvss3(self, cvss3):
        """
        Sets the cvss3 of this CveDetails.
        CVSS 3 Score


        :param cvss3: The cvss3 of this CveDetails.
        :type: str
        """
        self._cvss3 = cvss3

    @property
    def time_published(self):
        """
        **[Required]** Gets the time_published of this CveDetails.
        Date/time the CVE was published


        :return: The time_published of this CveDetails.
        :rtype: datetime
        """
        return self._time_published

    @time_published.setter
    def time_published(self, time_published):
        """
        Sets the time_published of this CveDetails.
        Date/time the CVE was published


        :param time_published: The time_published of this CveDetails.
        :type: datetime
        """
        self._time_published = time_published

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this CveDetails.
        Date/time the CVE was last modified


        :return: The time_updated of this CveDetails.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this CveDetails.
        Date/time the CVE was last modified


        :param time_updated: The time_updated of this CveDetails.
        :type: datetime
        """
        self._time_updated = time_updated

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
