# coding: utf-8
# Copyright (c) 2016, 2021, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ContainerScanRegistry(object):
    """
    Registry information for a container scan target
    """

    #: A constant which can be used with the type property of a ContainerScanRegistry.
    #: This constant has a value of "OCIR"
    TYPE_OCIR = "OCIR"

    def __init__(self, **kwargs):
        """
        Initializes a new ContainerScanRegistry object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.vulnerability_scanning.models.OcirContainerScanRegistry`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this ContainerScanRegistry.
            Allowed values for this property are: "OCIR", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param url:
            The value to assign to the url property of this ContainerScanRegistry.
        :type url: str

        """
        self.swagger_types = {
            'type': 'str',
            'url': 'str'
        }

        self.attribute_map = {
            'type': 'type',
            'url': 'url'
        }

        self._type = None
        self._url = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['type']

        if type == 'OCIR':
            return 'OcirContainerScanRegistry'
        else:
            return 'ContainerScanRegistry'

    @property
    def type(self):
        """
        **[Required]** Gets the type of this ContainerScanRegistry.
        The scan level

        Allowed values for this property are: "OCIR", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this ContainerScanRegistry.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this ContainerScanRegistry.
        The scan level


        :param type: The type of this ContainerScanRegistry.
        :type: str
        """
        allowed_values = ["OCIR"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    @property
    def url(self):
        """
        **[Required]** Gets the url of this ContainerScanRegistry.
        URL of the registry.


        :return: The url of this ContainerScanRegistry.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """
        Sets the url of this ContainerScanRegistry.
        URL of the registry.


        :param url: The url of this ContainerScanRegistry.
        :type: str
        """
        self._url = url

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
