# coding: utf-8
# Copyright (c) 2016, 2021, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateHostScanTargetDetails(object):
    """
    The information to update an existing host scan target
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateHostScanTargetDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this UpdateHostScanTargetDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this UpdateHostScanTargetDetails.
        :type description: str

        :param target_compartment_id:
            The value to assign to the target_compartment_id property of this UpdateHostScanTargetDetails.
        :type target_compartment_id: str

        :param instance_ids:
            The value to assign to the instance_ids property of this UpdateHostScanTargetDetails.
        :type instance_ids: list[str]

        :param host_scan_recipe_id:
            The value to assign to the host_scan_recipe_id property of this UpdateHostScanTargetDetails.
        :type host_scan_recipe_id: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateHostScanTargetDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateHostScanTargetDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'description': 'str',
            'target_compartment_id': 'str',
            'instance_ids': 'list[str]',
            'host_scan_recipe_id': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'display_name': 'displayName',
            'description': 'description',
            'target_compartment_id': 'targetCompartmentId',
            'instance_ids': 'instanceIds',
            'host_scan_recipe_id': 'hostScanRecipeId',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }

        self._display_name = None
        self._description = None
        self._target_compartment_id = None
        self._instance_ids = None
        self._host_scan_recipe_id = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        Gets the display_name of this UpdateHostScanTargetDetails.
        Target identifier, which can be renamed. Avoid entering confidential information.


        :return: The display_name of this UpdateHostScanTargetDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UpdateHostScanTargetDetails.
        Target identifier, which can be renamed. Avoid entering confidential information.


        :param display_name: The display_name of this UpdateHostScanTargetDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this UpdateHostScanTargetDetails.
        Target description.


        :return: The description of this UpdateHostScanTargetDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this UpdateHostScanTargetDetails.
        Target description.


        :param description: The description of this UpdateHostScanTargetDetails.
        :type: str
        """
        self._description = description

    @property
    def target_compartment_id(self):
        """
        Gets the target_compartment_id of this UpdateHostScanTargetDetails.
        Compartment ID to target. If a list of hosts is provided, all hosts must be in this compartment.


        :return: The target_compartment_id of this UpdateHostScanTargetDetails.
        :rtype: str
        """
        return self._target_compartment_id

    @target_compartment_id.setter
    def target_compartment_id(self, target_compartment_id):
        """
        Sets the target_compartment_id of this UpdateHostScanTargetDetails.
        Compartment ID to target. If a list of hosts is provided, all hosts must be in this compartment.


        :param target_compartment_id: The target_compartment_id of this UpdateHostScanTargetDetails.
        :type: str
        """
        self._target_compartment_id = target_compartment_id

    @property
    def instance_ids(self):
        """
        Gets the instance_ids of this UpdateHostScanTargetDetails.
        List of compute instance IDs to target (optional). If empty, targets the entire targetCompartmentId.


        :return: The instance_ids of this UpdateHostScanTargetDetails.
        :rtype: list[str]
        """
        return self._instance_ids

    @instance_ids.setter
    def instance_ids(self, instance_ids):
        """
        Sets the instance_ids of this UpdateHostScanTargetDetails.
        List of compute instance IDs to target (optional). If empty, targets the entire targetCompartmentId.


        :param instance_ids: The instance_ids of this UpdateHostScanTargetDetails.
        :type: list[str]
        """
        self._instance_ids = instance_ids

    @property
    def host_scan_recipe_id(self):
        """
        Gets the host_scan_recipe_id of this UpdateHostScanTargetDetails.
        ID of the host scan recipe this target applies.


        :return: The host_scan_recipe_id of this UpdateHostScanTargetDetails.
        :rtype: str
        """
        return self._host_scan_recipe_id

    @host_scan_recipe_id.setter
    def host_scan_recipe_id(self, host_scan_recipe_id):
        """
        Sets the host_scan_recipe_id of this UpdateHostScanTargetDetails.
        ID of the host scan recipe this target applies.


        :param host_scan_recipe_id: The host_scan_recipe_id of this UpdateHostScanTargetDetails.
        :type: str
        """
        self._host_scan_recipe_id = host_scan_recipe_id

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateHostScanTargetDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this UpdateHostScanTargetDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateHostScanTargetDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this UpdateHostScanTargetDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateHostScanTargetDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this UpdateHostScanTargetDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateHostScanTargetDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this UpdateHostScanTargetDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
