/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.core.store.Column;
import com.mysql.clusterj.core.store.PartitionKey;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.tie.DbImpl;
import com.mysql.clusterj.tie.KeyPart;
import com.mysql.clusterj.tie.Utility;
import com.mysql.ndbjtie.ndbapi.NdbOperation;
import com.mysql.ndbjtie.ndbapi.NdbTransaction;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

class PartitionKeyImpl
implements PartitionKey {
    static final I18NHelper local = I18NHelper.getInstance(PartitionKeyImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(PartitionKeyImpl.class);
    private static PartitionKeyImpl theInstance = new PartitionKeyImpl();
    private List<KeyPartBuilder> keyPartBuilders = new ArrayList<KeyPartBuilder>();
    private List<KeyPart> keyParts = new ArrayList<KeyPart>();
    private String tableName = null;
    private int partitionId;

    PartitionKeyImpl() {
    }

    @Override
    public void addIntKey(final Column column, final int n) {
        this.keyPartBuilders.add(new KeyPartBuilder(){

            @Override
            public void addKeyPart(DbImpl.BufferManager bufferManager) {
                ByteBuffer byteBuffer = Utility.convertValue(column, n);
                KeyPart keyPart = new KeyPart(byteBuffer, byteBuffer.limit());
                PartitionKeyImpl.this.keyParts.add(keyPart);
            }
        });
    }

    @Override
    public void addLongKey(final Column column, final long l) {
        this.keyPartBuilders.add(new KeyPartBuilder(){

            @Override
            public void addKeyPart(DbImpl.BufferManager bufferManager) {
                ByteBuffer byteBuffer = Utility.convertValue(column, l);
                KeyPart keyPart = new KeyPart(byteBuffer, byteBuffer.limit());
                PartitionKeyImpl.this.keyParts.add(keyPart);
            }
        });
    }

    @Override
    public void addStringKey(final Column column, final String string) {
        this.keyPartBuilders.add(new KeyPartBuilder(){

            @Override
            public void addKeyPart(DbImpl.BufferManager bufferManager) {
                ByteBuffer byteBuffer = Utility.encode(string, column, bufferManager);
                ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(byteBuffer.limit() - byteBuffer.position());
                byteBuffer2.put(byteBuffer);
                byteBuffer2.flip();
                KeyPart keyPart = new KeyPart(byteBuffer2, byteBuffer2.limit());
                PartitionKeyImpl.this.keyParts.add(keyPart);
            }
        });
    }

    @Override
    public void addBytesKey(final Column column, final byte[] byArray) {
        this.keyPartBuilders.add(new KeyPartBuilder(){

            @Override
            public void addKeyPart(DbImpl.BufferManager bufferManager) {
                ByteBuffer byteBuffer = Utility.convertValue(column, byArray);
                KeyPart keyPart = new KeyPart(byteBuffer, byteBuffer.limit());
                PartitionKeyImpl.this.keyParts.add(keyPart);
            }
        });
    }

    public void setTable(String string) {
        this.tableName = string;
    }

    public void setPartitionId(int n) {
        this.partitionId = n;
    }

    protected void handleError(int n, NdbOperation ndbOperation) {
        if (n == 0) {
            return;
        }
        Utility.throwError(n, ndbOperation.getNdbError());
    }

    protected static void handleError(Object object, NdbOperation ndbOperation) {
        if (object != null) {
            return;
        }
        Utility.throwError(null, ndbOperation.getNdbError());
    }

    public NdbTransaction enlist(DbImpl dbImpl) {
        DbImpl.BufferManager bufferManager = dbImpl.getBufferManager();
        for (KeyPartBuilder keyPartBuilder : this.keyPartBuilders) {
            keyPartBuilder.addKeyPart(bufferManager);
        }
        Object object = null;
        if (this.keyParts == null || this.keyParts.size() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("PartitionKeyImpl.enlist via partitionId with keyparts " + (this.keyParts == null ? "null." : "size " + this.keyParts.size()) + " table: " + (this.tableName == null ? "null" : this.tableName) + " partition id: " + this.partitionId);
            }
            object = dbImpl.enlist(this.tableName, this.partitionId);
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("PartitionKeyImpl.enlist via keyParts with keyparts " + (this.keyParts == null ? "null." : "size " + this.keyParts.size()) + " table: " + (this.tableName == null ? "null" : this.tableName));
            }
            object = dbImpl.enlist(this.tableName, this.keyParts);
        }
        return object;
    }

    public static PartitionKeyImpl getInstance() {
        return theInstance;
    }

    private static interface KeyPartBuilder {
        public void addKeyPart(DbImpl.BufferManager var1);
    }
}

