/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.openjpa;

import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.core.CacheManager;
import com.mysql.clusterj.core.metadata.IndexHandlerImpl;
import com.mysql.clusterj.core.metadata.KeyValueHandlerImpl;
import com.mysql.clusterj.core.query.CandidateIndexImpl;
import com.mysql.clusterj.core.spi.DomainFieldHandler;
import com.mysql.clusterj.core.spi.DomainTypeHandler;
import com.mysql.clusterj.core.spi.ValueHandler;
import com.mysql.clusterj.core.store.Column;
import com.mysql.clusterj.core.store.Db;
import com.mysql.clusterj.core.store.Dictionary;
import com.mysql.clusterj.core.store.Operation;
import com.mysql.clusterj.core.store.PartitionKey;
import com.mysql.clusterj.core.store.ResultData;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.openjpa.NdbOpenJPAConfigurationImpl;
import com.mysql.clusterj.openjpa.NdbOpenJPADomainFieldHandlerImpl;
import com.mysql.clusterj.openjpa.NdbOpenJPAResult;
import com.mysql.clusterj.openjpa.NdbOpenJPAStoreManager;
import com.mysql.clusterj.openjpa.NdbOpenJPAUtility;
import com.mysql.clusterj.openjpa.NdbOpenJPAValueHandler;
import java.lang.reflect.Modifier;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.openjpa.jdbc.kernel.JDBCFetchConfiguration;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.PCState;

public class NdbOpenJPADomainTypeHandlerImpl<T>
implements DomainTypeHandler<T> {
    static final I18NHelper local = I18NHelper.getInstance(NdbOpenJPADomainTypeHandlerImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(NdbOpenJPADomainTypeHandlerImpl.class);
    private String typeName;
    private Class<T> describedType;
    private Class<?> oidClass;
    private com.mysql.clusterj.core.store.Table storeTable;
    private String tableName;
    private List<NdbOpenJPADomainFieldHandlerImpl> primaryKeyFields = new ArrayList<NdbOpenJPADomainFieldHandlerImpl>();
    private int[] primaryKeyFieldNumbers;
    private List<NdbOpenJPADomainFieldHandlerImpl> fields = new ArrayList<NdbOpenJPADomainFieldHandlerImpl>();
    private ClassMapping classMapping;
    private NdbOpenJPADomainFieldHandlerImpl[] fieldHandlers;
    private Set<Column> allStoreColumns = new HashSet<Column>();
    private List<IndexHandlerImpl> indexHandlerImpls = new ArrayList<IndexHandlerImpl>();
    private String[] partitionKeyColumnNames;
    private int numberOfPartitionKeyColumns;
    private NdbOpenJPADomainFieldHandlerImpl[] partitionKeyFieldHandlers;
    private NdbOpenJPAConfigurationImpl domainTypeHandlerFactory;
    private Dictionary dictionary;
    private Set<NdbOpenJPADomainTypeHandlerImpl<?>> dependencies = new HashSet();
    private Status status = Status.IN_PROCESS;
    private List<String> reasons = new ArrayList<String>();

    /*
     * WARNING - void declaration
     */
    NdbOpenJPADomainTypeHandlerImpl(Dictionary dictionary, ClassMapping classMapping, NdbOpenJPAConfigurationImpl ndbOpenJPAConfigurationImpl) {
        void var10_14;
        int n;
        String string = null;
        this.dictionary = dictionary;
        this.domainTypeHandlerFactory = ndbOpenJPAConfigurationImpl;
        this.classMapping = classMapping;
        classMapping.resolve(-1);
        this.oidClass = classMapping.getObjectIdType();
        this.describedType = classMapping.getDescribedType();
        if (classMapping.getPCSuperclass() != null) {
            string = local.message("ERR_Subclass", (Object)this.describedType);
            this.setUnsupported(string);
        }
        if (classMapping.getPCSubclasses() != null && classMapping.getPCSubclasses().length > 0) {
            string = local.message("ERR_Superclass", (Object)this.describedType);
            this.setUnsupported(string);
        }
        if (Modifier.isAbstract(n = this.describedType.getClass().getModifiers())) {
            string = local.message("ERR_Abstract_Class", (Object)this.describedType.getClass().getName());
            this.setUnsupported(string);
        }
        this.typeName = this.describedType.getName();
        Table table = classMapping.getTable();
        if (table != null) {
            this.tableName = table.getFullName();
            this.storeTable = dictionary.getTable(this.tableName);
            if (this.storeTable == null) {
                string = local.message("ERR_No_Table", (Object)this.describedType.getClass().getName(), (Object)this.tableName);
                logger.info(string);
                this.setUnsupported(string);
            } else {
                if (logger.isTraceEnabled()) {
                    logger.trace("initialize for class: " + this.typeName + " mapped to table: " + this.storeTable.getName());
                }
                this.partitionKeyColumnNames = this.storeTable.getPartitionKeyColumnNames();
                this.numberOfPartitionKeyColumns = this.partitionKeyColumnNames.length;
                this.partitionKeyFieldHandlers = new NdbOpenJPADomainFieldHandlerImpl[this.numberOfPartitionKeyColumns];
                if (logger.isDetailEnabled()) {
                    logger.detail("partition key columns for class: " + this.typeName + " partition key columns: " + this.numberOfPartitionKeyColumns + " names: " + Arrays.toString(this.partitionKeyColumnNames));
                }
            }
        } else {
            string = local.message("ERR_No_Mapped_Table", (Object)this.describedType.getClass().getName());
            logger.info(string);
            this.setUnsupported(string);
        }
        ArrayList<FieldMapping> arrayList = new ArrayList<FieldMapping>();
        arrayList.addAll(Arrays.asList(classMapping.getFieldMappings()));
        FieldMapping fieldMapping = classMapping.getVersionFieldMapping();
        if (fieldMapping != null) {
            arrayList.add(fieldMapping);
        }
        for (FieldMapping object : arrayList) {
            if (logger.isDetailEnabled()) {
                logger.detail("field name: " + object.getName() + " of type: " + object.getTypeCode());
            }
            NdbOpenJPADomainFieldHandlerImpl ndbOpenJPADomainFieldHandlerImpl = new NdbOpenJPADomainFieldHandlerImpl(dictionary, this, ndbOpenJPAConfigurationImpl, object);
            this.fields.add(ndbOpenJPADomainFieldHandlerImpl);
            if (!ndbOpenJPADomainFieldHandlerImpl.isSupported()) {
                this.setUnsupported(ndbOpenJPADomainFieldHandlerImpl.getReason());
                continue;
            }
            for (Column column : ndbOpenJPADomainFieldHandlerImpl.getStoreColumns()) {
                this.allStoreColumns.add(column);
            }
            if (!ndbOpenJPADomainFieldHandlerImpl.isPrimaryKey()) continue;
            this.primaryKeyFields.add(ndbOpenJPADomainFieldHandlerImpl);
        }
        this.primaryKeyFieldNumbers = new int[this.primaryKeyFields.size()];
        int n2 = 0;
        for (NdbOpenJPADomainFieldHandlerImpl ndbOpenJPADomainFieldHandlerImpl : this.primaryKeyFields) {
            this.primaryKeyFieldNumbers[n2++] = ndbOpenJPADomainFieldHandlerImpl.getFieldNumber();
        }
        this.fieldHandlers = this.fields.toArray(new NdbOpenJPADomainFieldHandlerImpl[this.fields.size()]);
        boolean bl = false;
        while (var10_14 < this.numberOfPartitionKeyColumns) {
            if (this.partitionKeyFieldHandlers[var10_14] == null) {
                this.setUnsupported();
                this.reasons.add("Unmapped partition key " + this.partitionKeyColumnNames[var10_14]);
            }
            ++var10_14;
        }
    }

    protected void registerPrimaryKeyColumn(NdbOpenJPADomainFieldHandlerImpl ndbOpenJPADomainFieldHandlerImpl, String string) {
        for (int i = 0; i < this.partitionKeyColumnNames.length; ++i) {
            if (this.partitionKeyColumnNames[i].equals(string)) {
                this.partitionKeyFieldHandlers[i] = ndbOpenJPADomainFieldHandlerImpl;
                continue;
            }
            if (!logger.isDetailEnabled()) continue;
            logger.detail("NdbOpenJPADomainTypeHandlerImpl.registerPrimaryKeyColumn mismatch between partition key column name: " + this.partitionKeyColumnNames[i] + " and primary key column name: " + string);
        }
    }

    @Override
    public String getName() {
        return this.typeName;
    }

    @Override
    public Class<?> getOidClass() {
        return this.oidClass;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public DomainFieldHandler getFieldHandler(String string) {
        if (logger.isDetailEnabled()) {
            logger.detail("In " + this.getName() + " looking for " + string);
        }
        for (NdbOpenJPADomainFieldHandlerImpl ndbOpenJPADomainFieldHandlerImpl : this.fields) {
            if (!string.equals(ndbOpenJPADomainFieldHandlerImpl.getName())) continue;
            return ndbOpenJPADomainFieldHandlerImpl;
        }
        throw new ClusterJFatalInternalException(local.message("ERR_Unknown_Field_Name", (Object)string, (Object)this.getName()));
    }

    @Override
    public Class<T> getProxyClass() {
        return null;
    }

    @Override
    public T newInstance(Db db) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    @Override
    public T newInstance(ValueHandler valueHandler) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    @Override
    public T newInstance(ResultData resultData, Db db) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    @Override
    public void objectMarkModified(ValueHandler valueHandler, String string) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    @Override
    public void objectSetKeys(Object object, Object object2) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    @Override
    public void objectSetValues(ResultData resultData, ValueHandler valueHandler) {
        for (NdbOpenJPADomainFieldHandlerImpl ndbOpenJPADomainFieldHandlerImpl : this.fields) {
            ndbOpenJPADomainFieldHandlerImpl.objectSetValue(resultData, valueHandler);
        }
    }

    public void objectSetValuesExcept(ResultData resultData, ValueHandler valueHandler, String string) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    @Override
    public void objectSetCacheManager(CacheManager cacheManager, Object object) {
    }

    @Override
    public void objectResetModified(ValueHandler valueHandler) {
    }

    @Override
    public void operationGetValues(Operation operation) {
        for (NdbOpenJPADomainFieldHandlerImpl ndbOpenJPADomainFieldHandlerImpl : this.fields) {
            ndbOpenJPADomainFieldHandlerImpl.operationGetValue(operation);
        }
    }

    public void operationGetKeys(Operation operation) {
        for (NdbOpenJPADomainFieldHandlerImpl ndbOpenJPADomainFieldHandlerImpl : this.primaryKeyFields) {
            ndbOpenJPADomainFieldHandlerImpl.operationGetValue(operation);
        }
    }

    @Override
    public void operationGetValues(Operation operation, BitSet bitSet) {
        if (bitSet == null) {
            this.operationGetValues(operation);
        } else {
            int n = 0;
            for (NdbOpenJPADomainFieldHandlerImpl ndbOpenJPADomainFieldHandlerImpl : this.fields) {
                if (!bitSet.get(n++)) continue;
                ndbOpenJPADomainFieldHandlerImpl.operationGetValue(operation);
            }
        }
    }

    @Override
    public void operationSetKeys(ValueHandler valueHandler, Operation operation) {
        for (NdbOpenJPADomainFieldHandlerImpl ndbOpenJPADomainFieldHandlerImpl : this.primaryKeyFields) {
            if (logger.isDetailEnabled()) {
                logger.detail("Class: " + this.typeName + " Primary Key Field: " + ndbOpenJPADomainFieldHandlerImpl.getName() + valueHandler.pkToString(this));
            }
            ndbOpenJPADomainFieldHandlerImpl.operationSetValue(valueHandler, operation);
        }
    }

    @Override
    public void operationSetModifiedValues(ValueHandler valueHandler, Operation operation) {
        for (NdbOpenJPADomainFieldHandlerImpl ndbOpenJPADomainFieldHandlerImpl : this.fields) {
            ndbOpenJPADomainFieldHandlerImpl.operationSetModifiedValue(valueHandler, operation);
        }
    }

    public void operationSetValuesExcept(ValueHandler valueHandler, Operation operation, String string) {
        try {
            for (NdbOpenJPADomainFieldHandlerImpl ndbOpenJPADomainFieldHandlerImpl : this.fields) {
                if (ndbOpenJPADomainFieldHandlerImpl.includedInIndex(string)) continue;
                ndbOpenJPADomainFieldHandlerImpl.operationSetValue(valueHandler, operation);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("NdbOpenJPADomainTypeHandlerImpl.operationSetValuesExcept caught exception", exception);
        }
    }

    @Override
    public void operationSetModifiedNonPKValues(ValueHandler valueHandler, Operation operation) {
        try {
            for (NdbOpenJPADomainFieldHandlerImpl ndbOpenJPADomainFieldHandlerImpl : this.fields) {
                if (ndbOpenJPADomainFieldHandlerImpl.isPrimaryKey()) continue;
                ndbOpenJPADomainFieldHandlerImpl.operationSetModifiedValue(valueHandler, operation);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("NdbOpenJPADomainTypeHandlerImpl.operationSetModifiedValuesExcept caught " + exception);
        }
    }

    @Override
    public T getInstance(ValueHandler valueHandler) {
        OpenJPAStateManager openJPAStateManager = ((NdbOpenJPAValueHandler)valueHandler).getStateManager();
        openJPAStateManager.initialize(this.describedType, PCState.PNONTRANS);
        Object object = openJPAStateManager.getManagedInstance();
        return (T)object;
    }

    @Override
    public ValueHandler createKeyValueHandler(Object object, Db db) {
        FieldMapping[] fieldMappingArray = this.classMapping.getPrimaryKeyFieldMappings();
        int n = this.classMapping.getFieldMappings().length;
        Object[] objectArray = new Object[n];
        boolean bl = false;
        if (fieldMappingArray.length != 1) {
            for (NdbOpenJPADomainFieldHandlerImpl ndbOpenJPADomainFieldHandlerImpl : this.primaryKeyFields) {
                Object object2;
                objectArray[ndbOpenJPADomainFieldHandlerImpl.getFieldNumber()] = object2 = ndbOpenJPADomainFieldHandlerImpl.getKeyValue(object);
                if (object2 != null) continue;
                bl = true;
            }
        } else {
            objectArray[fieldMappingArray[0].getIndex()] = object;
        }
        KeyValueHandlerImpl keyValueHandlerImpl = new KeyValueHandlerImpl(objectArray);
        return bl ? null : keyValueHandlerImpl;
    }

    @Override
    public ValueHandler getValueHandler(Object object) {
        if (object instanceof ValueHandler) {
            return (ValueHandler)object;
        }
        OpenJPAStateManager openJPAStateManager = (OpenJPAStateManager)object;
        return new NdbOpenJPAValueHandler(openJPAStateManager);
    }

    public ValueHandler getValueHandler(OpenJPAStateManager openJPAStateManager, NdbOpenJPAStoreManager ndbOpenJPAStoreManager) {
        return new NdbOpenJPAValueHandler(openJPAStateManager, ndbOpenJPAStoreManager);
    }

    @Override
    public int[] getKeyFieldNumbers() {
        return this.primaryKeyFieldNumbers;
    }

    public void newInstance(OpenJPAStateManager openJPAStateManager) {
        openJPAStateManager.initialize(this.describedType, PCState.PNONTRANS);
    }

    @Override
    public CandidateIndexImpl[] createCandidateIndexes() {
        CandidateIndexImpl[] candidateIndexImplArray = new CandidateIndexImpl[this.indexHandlerImpls.size()];
        int n = 0;
        for (IndexHandlerImpl indexHandlerImpl : this.indexHandlerImpls) {
            candidateIndexImplArray[n++] = indexHandlerImpl.toCandidateIndexImpl();
        }
        return candidateIndexImplArray;
    }

    public boolean load(OpenJPAStateManager openJPAStateManager, NdbOpenJPAStoreManager ndbOpenJPAStoreManager, BitSet bitSet, JDBCFetchConfiguration jDBCFetchConfiguration, Object object) throws SQLException {
        if (logger.isDetailEnabled()) {
            StringBuilder stringBuilder = new StringBuilder("load for ");
            stringBuilder.append(this.typeName);
            stringBuilder.append(" for fields ");
            stringBuilder.append(NdbOpenJPAUtility.printBitSet(openJPAStateManager, bitSet));
            logger.detail(stringBuilder.toString());
        }
        boolean bl = false;
        ArrayList<NdbOpenJPADomainFieldHandlerImpl> arrayList = new ArrayList<NdbOpenJPADomainFieldHandlerImpl>();
        int n = bitSet.nextSetBit(0);
        while (n >= 0) {
            if (!openJPAStateManager.getLoaded().get(n)) {
                NdbOpenJPADomainFieldHandlerImpl[] ndbOpenJPADomainFieldHandlerImplArray = this.fieldHandlers[n];
                if (logger.isDebugEnabled()) {
                    logger.debug("loading field " + ndbOpenJPADomainFieldHandlerImplArray.getName() + " for column " + ndbOpenJPADomainFieldHandlerImplArray.getColumnName());
                }
                if (ndbOpenJPADomainFieldHandlerImplArray.isRelation()) {
                    ndbOpenJPADomainFieldHandlerImplArray.load(openJPAStateManager, ndbOpenJPAStoreManager, jDBCFetchConfiguration);
                    bl = true;
                } else {
                    arrayList.add((NdbOpenJPADomainFieldHandlerImpl)ndbOpenJPADomainFieldHandlerImplArray);
                }
            }
            n = bitSet.nextSetBit(n + 1);
        }
        if (arrayList.size() != 0) {
            NdbOpenJPAResult ndbOpenJPAResult = ndbOpenJPAStoreManager.lookup(openJPAStateManager, this, arrayList);
            for (NdbOpenJPADomainFieldHandlerImpl ndbOpenJPADomainFieldHandlerImpl : this.fieldHandlers) {
                bl = true;
                ndbOpenJPADomainFieldHandlerImpl.load(openJPAStateManager, ndbOpenJPAStoreManager, jDBCFetchConfiguration, ndbOpenJPAResult);
            }
        }
        return bl;
    }

    public void load(OpenJPAStateManager openJPAStateManager, NdbOpenJPAStoreManager ndbOpenJPAStoreManager, JDBCFetchConfiguration jDBCFetchConfiguration, NdbOpenJPAResult ndbOpenJPAResult) throws SQLException {
        for (NdbOpenJPADomainFieldHandlerImpl ndbOpenJPADomainFieldHandlerImpl : this.fieldHandlers) {
            if (logger.isDebugEnabled()) {
                logger.debug("loading field " + ndbOpenJPADomainFieldHandlerImpl.getName() + " for column " + ndbOpenJPADomainFieldHandlerImpl.getColumnName() + " from result data.");
            }
            ndbOpenJPADomainFieldHandlerImpl.load(openJPAStateManager, ndbOpenJPAStoreManager, jDBCFetchConfiguration, ndbOpenJPAResult);
        }
    }

    @Override
    public Set<Column> getStoreColumns(BitSet bitSet) {
        if (bitSet == null) {
            return this.allStoreColumns;
        }
        HashSet<Column> hashSet = new HashSet<Column>();
        int n = bitSet.nextSetBit(0);
        while (n >= 0) {
            NdbOpenJPADomainFieldHandlerImpl ndbOpenJPADomainFieldHandlerImpl = this.fieldHandlers[n];
            for (Column column : ndbOpenJPADomainFieldHandlerImpl.getStoreColumns()) {
                hashSet.add(column);
            }
            n = bitSet.nextSetBit(n + 1);
        }
        return hashSet;
    }

    public NdbOpenJPADomainFieldHandlerImpl getDomainFieldHandler(FieldMapping fieldMapping) {
        for (NdbOpenJPADomainFieldHandlerImpl ndbOpenJPADomainFieldHandlerImpl : this.fieldHandlers) {
            if (!fieldMapping.equals((Object)ndbOpenJPADomainFieldHandlerImpl.getFieldMapping())) continue;
            return ndbOpenJPADomainFieldHandlerImpl;
        }
        throw new ClusterJFatalInternalException(local.message("ERR_Unknown_Field_Mapping", (Object)this.getName(), (Object)fieldMapping.getName()));
    }

    public int[][] createIndexHandler(NdbOpenJPADomainFieldHandlerImpl ndbOpenJPADomainFieldHandlerImpl, Dictionary dictionary, String string) {
        IndexHandlerImpl indexHandlerImpl = new IndexHandlerImpl(this, dictionary, string, ndbOpenJPADomainFieldHandlerImpl);
        int n = this.indexHandlerImpls.size();
        this.indexHandlerImpls.add(indexHandlerImpl);
        int[][] nArray = new int[1][2];
        nArray[0][0] = n;
        nArray[0][1] = 0;
        return nArray;
    }

    public com.mysql.clusterj.core.store.Table getTable() {
        return this.storeTable;
    }

    @Override
    public com.mysql.clusterj.core.store.Table getStoreTable() {
        return this.storeTable;
    }

    @Override
    public PartitionKey createPartitionKey(ValueHandler valueHandler) {
        PartitionKey partitionKey = this.storeTable.createPartitionKey();
        for (NdbOpenJPADomainFieldHandlerImpl ndbOpenJPADomainFieldHandlerImpl : this.partitionKeyFieldHandlers) {
            if (logger.isDetailEnabled()) {
                logger.detail("Field number " + ndbOpenJPADomainFieldHandlerImpl.getFieldNumber() + " column name " + ndbOpenJPADomainFieldHandlerImpl.getColumnName() + " field name " + ndbOpenJPADomainFieldHandlerImpl.getName());
            }
            ndbOpenJPADomainFieldHandlerImpl.partitionKeySetPart(partitionKey, valueHandler);
        }
        return partitionKey;
    }

    public NdbOpenJPADomainTypeHandlerImpl<?> registerDependency(ClassMapping classMapping) {
        NdbOpenJPADomainTypeHandlerImpl<?> ndbOpenJPADomainTypeHandlerImpl = this.domainTypeHandlerFactory.getDomainTypeHandler(classMapping, this.dictionary);
        this.dependencies.add(ndbOpenJPADomainTypeHandlerImpl);
        return ndbOpenJPADomainTypeHandlerImpl;
    }

    private Status supportStatus() {
        return this.status;
    }

    public void initializeRelations() {
        for (NdbOpenJPADomainFieldHandlerImpl iterator : this.fieldHandlers) {
            iterator.initializeRelations();
        }
        boolean bl = this.status != Status.BAD;
        int n = !bl ? 1 : 0;
        ArrayList arrayList = new ArrayList(this.dependencies);
        for (NdbOpenJPADomainTypeHandlerImpl<?> ndbOpenJPADomainTypeHandlerImpl : arrayList) {
            String string;
            this.dependencies.addAll(ndbOpenJPADomainTypeHandlerImpl.getDependencies());
            switch (ndbOpenJPADomainTypeHandlerImpl.supportStatus()) {
                case IN_PROCESS: {
                    n = 1;
                    break;
                }
                case GOOD: {
                    break;
                }
                case BAD: {
                    this.setUnsupported();
                    bl = false;
                    n = 1;
                    string = local.message("ERR_Bad_Dependency", (Object)ndbOpenJPADomainTypeHandlerImpl.typeName);
                    this.reasons.add(string);
                    if (!logger.isDebugEnabled()) break;
                    logger.debug(string);
                }
            }
            string = "Processing class " + this.typeName + " found dependency " + ndbOpenJPADomainTypeHandlerImpl.typeName + " support status is: " + (Object)((Object)super.supportStatus());
            if (!logger.isDetailEnabled()) continue;
            logger.detail(string);
        }
        if (n != 0) {
            if (!bl) {
                for (NdbOpenJPADomainTypeHandlerImpl<?> ndbOpenJPADomainTypeHandlerImpl : this.dependencies) {
                    super.setUnsupported();
                }
            } else {
                for (NdbOpenJPADomainTypeHandlerImpl<?> ndbOpenJPADomainTypeHandlerImpl : this.dependencies) {
                    super.setSupported();
                }
            }
        } else {
            this.setSupported();
        }
        if (logger.isDetailEnabled()) {
            logger.detail("Processing class " + this.typeName + " has dependencies " + this.dependencies);
        }
        if (logger.isDetailEnabled()) {
            logger.detail("Processing class " + this.typeName + " has dependencies " + this.dependencies);
        }
    }

    private Set<NdbOpenJPADomainTypeHandlerImpl<?>> getDependencies() {
        return this.dependencies;
    }

    private void setUnsupported() {
        if (this.status != Status.BAD) {
            if (logger.isDetailEnabled()) {
                logger.detail("Class " + this.typeName + " marked as BAD.");
            }
            this.status = Status.BAD;
        }
    }

    @Override
    public void setUnsupported(String string) {
        if (this.status != Status.BAD) {
            if (logger.isDetailEnabled()) {
                logger.detail("Class " + this.typeName + " marked as BAD.");
            }
            this.status = Status.BAD;
        }
        this.reasons.add(string);
    }

    private void setSupported() {
        if (this.status != Status.GOOD) {
            if (logger.isDetailEnabled()) {
                logger.detail("Class " + this.typeName + " marked as GOOD.");
            }
            this.status = Status.GOOD;
        }
    }

    @Override
    public boolean isSupportedType() {
        return Status.GOOD == this.status;
    }

    public String getReasons() {
        if (this.reasons.size() == 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(local.message("MSG_Unsupported_Class", (Object)this.getName()));
        for (String string : this.reasons) {
            stringBuilder.append('\n');
            stringBuilder.append(string);
            stringBuilder.append(';');
        }
        stringBuilder.append('\n');
        return stringBuilder.toString();
    }

    public String toString() {
        return "NdbOpenJPADomainTypeHandlerImpl:" + this.typeName;
    }

    @Override
    public String[] getFieldNames() {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    @Override
    public void operationSetValues(ValueHandler valueHandler, Operation operation) {
        try {
            for (NdbOpenJPADomainFieldHandlerImpl ndbOpenJPADomainFieldHandlerImpl : this.fields) {
                ndbOpenJPADomainFieldHandlerImpl.operationSetValue(valueHandler, operation);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("NdbOpenJPADomainTypeHandlerImpl.operationSetValues caught exception", exception);
        }
    }

    @Override
    public void operationSetNonPKValues(ValueHandler valueHandler, Operation operation) {
        try {
            for (NdbOpenJPADomainFieldHandlerImpl ndbOpenJPADomainFieldHandlerImpl : this.fields) {
                if (ndbOpenJPADomainFieldHandlerImpl.isPrimaryKey()) continue;
                ndbOpenJPADomainFieldHandlerImpl.operationSetValue(valueHandler, operation);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("NdbOpenJPADomainTypeHandlerImpl.operationSetNonPKValues caught exception", exception);
        }
    }

    private static enum Status {
        IN_PROCESS,
        GOOD,
        BAD;

    }
}

