/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.core.util;

import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class I18NHelper {
    private static Logger logger = LoggerFactoryService.getFactory().getInstance(I18NHelper.class);
    private static Hashtable<String, ResourceBundle> bundles = new Hashtable();
    private static Hashtable<String, I18NHelper> helpers = new Hashtable();
    private static Locale locale = Locale.getDefault();
    private final String bundleName;
    private ResourceBundle bundle = null;
    private Throwable failure = null;
    private static final String bundleSuffix = ".Bundle";

    private I18NHelper() {
        this.bundleName = null;
    }

    private I18NHelper(String string, ClassLoader classLoader) {
        this.bundleName = string;
        try {
            this.bundle = I18NHelper.loadBundle(string, string, classLoader);
        }
        catch (Throwable throwable) {
            this.failure = throwable;
        }
    }

    public static I18NHelper getInstance(String string) {
        return I18NHelper.getInstance(string, I18NHelper.class.getClassLoader());
    }

    public static I18NHelper getInstance(final Class<?> clazz) {
        ClassLoader classLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return clazz.getClassLoader();
            }
        });
        String string = I18NHelper.getPackageName(clazz.getName()) + bundleSuffix;
        return I18NHelper.getInstance(string, classLoader);
    }

    public static I18NHelper getInstance(String string, ClassLoader classLoader) {
        I18NHelper i18NHelper = helpers.get(string);
        if (i18NHelper != null) {
            return i18NHelper;
        }
        i18NHelper = new I18NHelper(string, classLoader);
        helpers.put(string, i18NHelper);
        return helpers.get(string);
    }

    public String message(String string) {
        this.assertBundle(string);
        return I18NHelper.getMessage(this.bundle, string);
    }

    public String message(String string, Object object) {
        this.assertBundle(string);
        return I18NHelper.getMessage(this.bundle, string, object);
    }

    public String message(String string, Object object, Object object2) {
        this.assertBundle(string);
        return I18NHelper.getMessage(this.bundle, string, object, object2);
    }

    public String message(String string, Object ... objectArray) {
        this.assertBundle(string);
        return I18NHelper.getMessage(this.bundle, string, objectArray);
    }

    public String message(String string, int n) {
        this.assertBundle(string);
        return I18NHelper.getMessage(this.bundle, string, n);
    }

    public String message(String string, boolean bl) {
        this.assertBundle(string);
        return I18NHelper.getMessage(this.bundle, string, bl);
    }

    public ResourceBundle getResourceBundle() {
        this.assertBundle();
        return this.bundle;
    }

    private static final ResourceBundle loadBundle(String string, String string2, ClassLoader classLoader) {
        ResourceBundle resourceBundle = bundles.get(string2);
        if (resourceBundle == null) {
            try {
                resourceBundle = classLoader != null ? ResourceBundle.getBundle(string2, locale, classLoader) : ResourceBundle.getBundle(string2, locale, I18NHelper.getSystemClassLoaderPrivileged());
                bundles.put(string2, resourceBundle);
            }
            catch (MissingResourceException missingResourceException) {
                String string3 = I18NHelper.removeDirectoryName(string2);
                if (string3 == null) {
                    throw new ClusterJFatalInternalException("Missing resource bundle " + string);
                }
                resourceBundle = I18NHelper.loadBundle(string, string3, classLoader);
            }
        }
        return resourceBundle;
    }

    private void assertBundle() {
        if (this.failure != null) {
            throw new ClusterJFatalInternalException("No resources could be found for bundle:\"" + this.bundleName + "\" ", this.failure);
        }
    }

    private void assertBundle(String string) {
        if (this.failure != null) {
            throw new ClusterJFatalInternalException("No resources could be found for bundle: " + this.bundleName + " to annotate error message key:\"" + string + "\"", this.failure);
        }
    }

    private static final String getMessage(ResourceBundle resourceBundle, String string) {
        return resourceBundle.getString(string);
    }

    private static final String getMessage(ResourceBundle resourceBundle, String string, Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != null) continue;
            objectArray[i] = "";
        }
        MessageFormat messageFormat = new MessageFormat(resourceBundle.getString(string));
        return messageFormat.format(objectArray);
    }

    private static final String getMessage(ResourceBundle resourceBundle, String string, Object object) {
        Object[] objectArray = new Object[]{object};
        return I18NHelper.getMessage(resourceBundle, string, objectArray);
    }

    private static final String getMessage(ResourceBundle resourceBundle, String string, Object object, Object object2) {
        Object[] objectArray = new Object[]{object, object2};
        return I18NHelper.getMessage(resourceBundle, string, objectArray);
    }

    private static final String getMessage(ResourceBundle resourceBundle, String string, int n) {
        Object[] objectArray = new Object[]{new Integer(n)};
        return I18NHelper.getMessage(resourceBundle, string, objectArray);
    }

    private static final String getMessage(ResourceBundle resourceBundle, String string, boolean bl) {
        Object[] objectArray = new Object[]{String.valueOf(bl)};
        return I18NHelper.getMessage(resourceBundle, string, objectArray);
    }

    private static final String getPackageName(String string) {
        int n = string.lastIndexOf(46);
        return n != -1 ? string.substring(0, n) : "";
    }

    private static String removeDirectoryName(String string) {
        int n = string.lastIndexOf(".");
        String string2 = string.substring(0, n);
        String string3 = string.substring(n);
        int n2 = string2.lastIndexOf(".");
        if (n2 == -1) {
            return null;
        }
        String string4 = string2.substring(0, n2);
        String string5 = string4 + string3;
        if (logger.isDebugEnabled()) {
            logger.debug("bundleName is: " + string + "; superPackageName is: " + string4 + "; suffix is: " + string3 + "; packageName is: " + string2 + "; returning: " + string5);
        }
        return string5;
    }

    private static ClassLoader getSystemClassLoaderPrivileged() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return ClassLoader.getSystemClassLoader();
            }
        });
    }
}

