/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import junit.framework.Test;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class AllTests {
    private static String jarFile = "";
    private static boolean onlyRunSlowTests = false;

    private static void usage() {
        System.out.println("Usage: java -cp <jar file>:... AllTests <jar file> [--only-run-slow-tests]");
        System.out.println("Will run all tests in the given jar file.");
        System.exit(2);
    }

    private static boolean isPossibleTestClass(String string) {
        return string.endsWith("Test.class");
    }

    private static boolean isSlowTestAnnotationPresent(Class<?> clazz) {
        for (Annotation annotation : clazz.getAnnotations()) {
            if (!((Object)annotation).toString().contains("SlowTest")) continue;
            return true;
        }
        return false;
    }

    private static boolean isIgnoreAnnotationPresent(Class<?> clazz) {
        for (Annotation annotation : clazz.getAnnotations()) {
            if (!((Object)annotation).toString().contains("Ignore")) continue;
            return true;
        }
        return false;
    }

    private static boolean isTestClass(Class<?> clazz) {
        return clazz.getName().endsWith("Test") && !clazz.getName().contains("Abstract") && Test.class.isAssignableFrom(clazz);
    }

    private static boolean isSlowTest(Class<?> clazz) {
        return AllTests.isSlowTestAnnotationPresent(clazz);
    }

    private static boolean isTestDisabled(Class<?> clazz) {
        return AllTests.isIgnoreAnnotationPresent(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Class<?>> getClasses(File file) throws IOException, ClassNotFoundException {
        ArrayList arrayList = new ArrayList();
        JarInputStream jarInputStream = new JarInputStream(new FileInputStream(file));
        try {
            JarEntry jarEntry = jarInputStream.getNextJarEntry();
            while (jarEntry != null) {
                try {
                    String string = jarEntry.getName();
                    if (AllTests.isPossibleTestClass(string)) {
                        String string2 = string.replaceAll("/", "\\.");
                        string2 = string2.substring(0, string2.length() - ".class".length());
                        Class<?> clazz = Class.forName(string2);
                        arrayList.add(clazz);
                    }
                }
                finally {
                    jarInputStream.closeEntry();
                }
                jarEntry = jarInputStream.getNextJarEntry();
            }
        }
        finally {
            jarInputStream.close();
        }
        return arrayList;
    }

    public static Test suite() throws IllegalAccessException, IOException, ClassNotFoundException {
        TestSuite testSuite = new TestSuite("Cluster/J");
        if (jarFile.equals("")) {
            throw new IOException("Jar file to look for not given");
        }
        List<Class<?>> list = AllTests.getClasses(new File(jarFile));
        for (Class<?> clazz : list) {
            if (!AllTests.isTestClass(clazz) || AllTests.isTestDisabled(clazz) || (!AllTests.isSlowTest(clazz) || !onlyRunSlowTests) && (AllTests.isSlowTest(clazz) || onlyRunSlowTests)) continue;
            testSuite.addTestSuite(clazz);
        }
        return testSuite;
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length > 0 && stringArray.length <= 2) {
            jarFile = stringArray[0];
            if (stringArray.length > 1 && stringArray[1].equalsIgnoreCase("--only-run-slow-tests")) {
                onlyRunSlowTests = true;
            }
            System.out.println("Running all tests in '" + jarFile + "'");
            TestSuite testSuite = (TestSuite)AllTests.suite();
            System.out.println("Found '" + testSuite.testCount() + "' test classes in jar file.");
            TestResult testResult = TestRunner.run((Test)testSuite);
            System.exit(testResult.wasSuccessful() ? 0 : 1);
        } else {
            AllTests.usage();
        }
    }
}

