/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.jpatest;

import com.mysql.clusterj.jpatest.Driver;
import com.mysql.clusterj.jpatest.model.A;
import com.mysql.clusterj.jpatest.model.B0;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.Query;

public class JpaLoad
extends Driver {
    protected String driver;
    protected String url;
    protected EntityManagerFactory emf;
    protected EntityManager em;
    protected Query delAllA;
    protected Query delAllB0;

    @Override
    protected void initProperties() {
        super.initProperties();
        this.driver = this.props.getProperty("openjpa.ConnectionDriverName");
        if (this.driver == null) {
            throw new RuntimeException("Missing property: openjpa.ConnectionDriverName");
        }
        try {
            Class.forName(this.driver);
        }
        catch (ClassNotFoundException classNotFoundException) {
            out.println("Cannot load JDBC driver '" + this.driver + "' from classpath '" + System.getProperty("java.class.path") + "'");
            throw new RuntimeException(classNotFoundException);
        }
        this.url = this.props.getProperty("openjpa.ConnectionURL");
        if (this.url == null) {
            throw new RuntimeException("Missing property: openjpa.ConnectionURL");
        }
        this.descr = "->JPA->" + this.url;
    }

    @Override
    protected void printProperties() {
        super.printProperties();
        out.println("openjpa.ConnectionDriverName: " + this.driver);
        out.println("openjpa.ConnectionURL:        " + this.url);
    }

    @Override
    protected void init() throws Exception {
        super.init();
        out.println();
        out.print("creating EMFactory ...");
        out.flush();
        this.emf = Persistence.createEntityManagerFactory((String)"crundjpa", (Map)this.props);
        out.println("      [EMF: 1]");
    }

    @Override
    protected void close() throws Exception {
        out.print("closing EMFactory ...");
        out.flush();
        if (this.emf != null) {
            this.emf.close();
        }
        this.emf = null;
        out.println("       [ok]");
        super.close();
    }

    @Override
    protected void initConnection() {
        out.print("creating EntityManager ...");
        out.flush();
        this.em = this.emf.createEntityManager();
        this.delAllA = this.em.createQuery("DELETE FROM A");
        this.delAllB0 = this.em.createQuery("DELETE FROM B0");
        out.println("  [EM: 1]");
    }

    @Override
    protected void closeConnection() {
        out.print("closing EntityManager ...");
        out.flush();
        this.delAllB0 = null;
        this.delAllA = null;
        if (this.em != null) {
            this.em.close();
        }
        this.em = null;
        out.println("   [ok]");
    }

    protected int checkFields(A a) {
        int n = a.getCint();
        long l = a.getClong();
        JpaLoad.verify(l == (long)n);
        float f = a.getCfloat();
        JpaLoad.verify(f == (float)n);
        double d = a.getCdouble();
        JpaLoad.verify(d == (double)n);
        return n;
    }

    protected int checkFields(B0 b0) {
        int n = b0.getCint();
        long l = b0.getClong();
        JpaLoad.verify(l == (long)n);
        float f = b0.getCfloat();
        JpaLoad.verify(f == (float)n);
        double d = b0.getCdouble();
        JpaLoad.verify(d == (double)n);
        return n;
    }

    @Override
    protected void initOperations() {
        out.print("initializing operations ...");
        out.flush();
        this.ops.add(new JpaOp("insA"){

            @Override
            public void run(int n, int n2) {
                for (int i = 0; i < n; ++i) {
                    A a = new A();
                    a.setId(i);
                    JpaLoad.this.em.persist((Object)a);
                }
            }
        });
        this.ops.add(new JpaOp("insB0"){

            @Override
            public void run(int n, int n2) {
                for (int i = 0; i < n2; ++i) {
                    B0 b0 = new B0();
                    b0.setId(i);
                    JpaLoad.this.em.persist((Object)b0);
                }
            }
        });
        this.ops.add(new JpaOp("setAByPK"){

            @Override
            public void run(int n, int n2) {
                for (int i = 0; i < n; ++i) {
                    A a = (A)JpaLoad.this.em.find(A.class, (Object)i);
                    assert (a != null);
                    a.setCint(i);
                    a.setClong(i);
                    a.setCfloat(i);
                    a.setCdouble(i);
                }
            }
        });
        this.ops.add(new JpaOp("setB0ByPK"){

            @Override
            public void run(int n, int n2) {
                for (int i = 0; i < n2; ++i) {
                    B0 b0 = (B0)JpaLoad.this.em.find(B0.class, (Object)i);
                    assert (b0 != null);
                    b0.setCint(i);
                    b0.setClong(i);
                    b0.setCfloat(i);
                    b0.setCdouble(i);
                }
            }
        });
        this.ops.add(new JpaOp("getAByPK"){

            @Override
            public void run(int n, int n2) {
                for (int i = 0; i < n; ++i) {
                    A a = (A)JpaLoad.this.em.find(A.class, (Object)i);
                    assert (a != null);
                    int n3 = a.getId();
                    Driver.verify(n3 == i);
                    int n4 = JpaLoad.this.checkFields(a);
                    Driver.verify(n4 == n3);
                }
            }
        });
        this.ops.add(new JpaOp("getB0ByPK"){

            @Override
            public void run(int n, int n2) {
                for (int i = 0; i < n2; ++i) {
                    B0 b0 = (B0)JpaLoad.this.em.find(B0.class, (Object)i);
                    assert (b0 != null);
                    int n3 = b0.getId();
                    Driver.verify(n3 == i);
                    int n4 = JpaLoad.this.checkFields(b0);
                    Driver.verify(n4 == n3);
                }
            }
        });
        this.ops.add(new JpaOp("setB0->A"){

            @Override
            public void run(int n, int n2) {
                for (int i = 0; i < n2; ++i) {
                    B0 b0 = (B0)JpaLoad.this.em.find(B0.class, (Object)i);
                    assert (b0 != null);
                    int n3 = i % n;
                    A a = (A)JpaLoad.this.em.find(A.class, (Object)n3);
                    assert (a != null);
                    b0.setA(a);
                }
            }
        });
        this.ops.add(new JpaOp("navB0->A"){

            @Override
            public void run(int n, int n2) {
                for (int i = 0; i < n2; ++i) {
                    B0 b0 = (B0)JpaLoad.this.em.find(B0.class, (Object)i);
                    assert (b0 != null);
                    A a = b0.getA();
                    assert (a != null);
                    int n3 = a.getId();
                    Driver.verify(n3 == i % n);
                    int n4 = JpaLoad.this.checkFields(a);
                    Driver.verify(n4 == n3);
                }
            }
        });
        this.ops.add(new JpaOp("nullB0->A"){

            @Override
            public void run(int n, int n2) {
                for (int i = 0; i < n2; ++i) {
                    B0 b0 = (B0)JpaLoad.this.em.find(B0.class, (Object)i);
                    assert (b0 != null);
                    b0.setA(null);
                }
            }
        });
        this.ops.add(new JpaOp("setA->B0"){

            @Override
            public void run(int n, int n2) {
                for (int i = 0; i < n; ++i) {
                    A a = (A)JpaLoad.this.em.find(A.class, (Object)i);
                    assert (a != null);
                    ArrayList<B0> arrayList = new ArrayList<B0>();
                    for (int j = i; j < n2; j += n) {
                        B0 b0 = (B0)JpaLoad.this.em.find(B0.class, (Object)j);
                        assert (b0 != null);
                        arrayList.add(b0);
                    }
                    a.setB0s(arrayList);
                }
            }
        });
        if (this.allowExtendedPC) {
            this.ops.add(new JpaOp("navA->B0"){

                @Override
                public void run(int n, int n2) {
                    for (int i = 0; i < n; ++i) {
                        A a = (A)JpaLoad.this.em.find(A.class, (Object)i);
                        assert (a != null);
                        Collection<B0> collection = a.getB0s();
                        assert (collection != null);
                        Driver.verify(collection.size() > 0);
                        for (B0 b0 : collection) {
                            assert (b0 != null);
                            int n3 = b0.getId();
                            Driver.verify(n3 % n == i);
                            int n4 = JpaLoad.this.checkFields(b0);
                            Driver.verify(n4 == n3);
                        }
                    }
                }
            });
        }
        this.ops.add(new JpaOp("nullA->B0"){

            @Override
            public void run(int n, int n2) {
                for (int i = 0; i < n; ++i) {
                    A a = (A)JpaLoad.this.em.find(A.class, (Object)i);
                    assert (a != null);
                    a.setB0s(null);
                }
            }
        });
        this.ops.add(new JpaOp("delB0ByPK"){

            @Override
            public void run(int n, int n2) {
                for (int i = 0; i < n2; ++i) {
                    B0 b0 = (B0)JpaLoad.this.em.find(B0.class, (Object)i);
                    assert (b0 != null);
                    JpaLoad.this.em.remove((Object)b0);
                }
            }
        });
        this.ops.add(new JpaOp("delAByPK"){

            @Override
            public void run(int n, int n2) {
                for (int i = 0; i < n; ++i) {
                    A a = (A)JpaLoad.this.em.find(A.class, (Object)i);
                    assert (a != null);
                    JpaLoad.this.em.remove((Object)a);
                }
            }
        });
        this.ops.add(new JpaOp("insA_attr"){

            @Override
            public void run(int n, int n2) {
                for (int i = 0; i < n; ++i) {
                    A a = new A();
                    a.setId(i);
                    a.setCint(-i);
                    a.setClong(-i);
                    a.setCfloat(-i);
                    a.setCdouble(-i);
                    a.setCstring(String.valueOf(i));
                    JpaLoad.this.em.persist((Object)a);
                }
            }
        });
        this.ops.add(new JpaOp("insB0_attr"){

            @Override
            public void run(int n, int n2) {
                for (int i = 0; i < n2; ++i) {
                    B0 b0 = new B0();
                    b0.setId(i);
                    b0.setCint(-i);
                    b0.setClong(-i);
                    b0.setCfloat(-i);
                    b0.setCdouble(-i);
                    b0.setCstring(String.valueOf(i));
                    JpaLoad.this.em.persist((Object)b0);
                }
            }
        });
        this.ops.add(new JpaOp("delAllB0"){

            @Override
            public void run(int n, int n2) {
                int n3 = JpaLoad.this.em.createQuery("DELETE FROM B0").executeUpdate();
                assert (n3 == n2);
            }
        });
        this.ops.add(new JpaOp("delAllA"){

            @Override
            public void run(int n, int n2) {
                int n3 = JpaLoad.this.em.createQuery("DELETE FROM A").executeUpdate();
                assert (n3 == n);
            }
        });
        Iterator iterator = this.ops.iterator();
        while (iterator.hasNext()) {
            ((JpaOp)iterator.next()).init();
        }
        out.println(" [JpaOp: " + this.ops.size() + "]");
    }

    @Override
    protected void closeOperations() {
        out.print("closing operations ...");
        out.flush();
        Iterator iterator = this.ops.iterator();
        while (iterator.hasNext()) {
            ((JpaOp)iterator.next()).close();
        }
        this.ops.clear();
        out.println("      [ok]");
    }

    @Override
    protected void beginTransaction() {
        this.em.getTransaction().begin();
    }

    @Override
    protected void commitTransaction() {
        this.em.getTransaction().commit();
    }

    @Override
    protected void rollbackTransaction() {
        this.em.getTransaction().rollback();
    }

    @Override
    protected void clearPersistenceContext() {
        this.em.clear();
    }

    @Override
    protected void clearData() {
        out.print("deleting all objects ...");
        out.flush();
        this.em.getTransaction().begin();
        int n = this.delAllB0.executeUpdate();
        out.print("    [B0: " + n);
        out.flush();
        int n2 = this.delAllA.executeUpdate();
        out.print(", A: " + n2);
        out.flush();
        this.em.getTransaction().commit();
        this.em.clear();
        out.println("]");
    }

    public static void main(String[] stringArray) {
        JpaLoad.clearPropFileNames();
        System.out.println("JpaLoad.main()");
        JpaLoad.parseArguments(stringArray);
        new JpaLoad().run();
        System.out.println();
        System.out.println("JpaLoad.main(): done.");
    }

    protected abstract class JpaOp
    extends Driver.Op {
        public JpaOp(String string) {
            super(string);
        }

        public void init() {
        }

        public void close() {
        }
    }
}

