/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.core.metadata;

import com.mysql.clusterj.ClusterJDatastoreException;
import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.ColumnType;
import com.mysql.clusterj.annotation.Index;
import com.mysql.clusterj.annotation.Lob;
import com.mysql.clusterj.annotation.NotPersistent;
import com.mysql.clusterj.annotation.NullValue;
import com.mysql.clusterj.annotation.Persistent;
import com.mysql.clusterj.core.metadata.AbstractDomainFieldHandlerImpl;
import com.mysql.clusterj.core.metadata.DomainTypeHandlerImpl;
import com.mysql.clusterj.core.spi.ValueHandler;
import com.mysql.clusterj.core.store.Column;
import com.mysql.clusterj.core.store.Operation;
import com.mysql.clusterj.core.store.Table;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public class DomainFieldHandlerImpl
extends AbstractDomainFieldHandlerImpl {
    NullValue nullValue = NullValue.NONE;
    Method getMethod;
    protected Method setMethod;
    protected NullObjectOperationHandler nullValueDelegate;
    protected Index indexAnnotation = null;
    protected Persistent persistentAnnotation = null;
    protected com.mysql.clusterj.annotation.Column columnAnnotation = null;
    protected String columnAllowsNull;
    protected Lob lobAnnotation;
    protected boolean lob = false;
    protected NotPersistent notPersistentAnnotation;
    static NullObjectOperationHandler nullValueDEFAULT = new NullObjectOperationHandler(){

        @Override
        public boolean operationSetValue(DomainFieldHandlerImpl fmd, Operation op) {
            fmd.operationSetValue(fmd, fmd.defaultValue, op);
            return true;
        }
    };
    static NullObjectOperationHandler nullValueEXCEPTION = new NullObjectOperationHandler(){

        @Override
        public boolean operationSetValue(DomainFieldHandlerImpl fmd, Operation op) {
            throw new ClusterJUserException(AbstractDomainFieldHandlerImpl.local.message("ERR_Null_Value_Exception", (Object)fmd.domainTypeHandler.getName(), (Object)fmd.name));
        }
    };
    static NullObjectOperationHandler nullValueNONE = new NullObjectOperationHandler(){

        @Override
        public boolean operationSetValue(DomainFieldHandlerImpl fmd, Operation op) {
            return false;
        }
    };

    public int compareTo(Object other) {
        return this.compareTo((DomainFieldHandlerImpl)other);
    }

    public DomainFieldHandlerImpl(DomainTypeHandlerImpl<?> domainTypeHandler, Table table, int fieldNumber, String name, Class<?> type, Method getMethod, Method setMethod) {
        if (logger.isDebugEnabled()) {
            logger.debug("new DomainFieldHandlerImpl: fieldNumber: " + fieldNumber + "; name:" + name + "; getMethod: " + getMethod + "; setMethod: " + setMethod);
        }
        this.domainTypeHandler = domainTypeHandler;
        this.fieldNumber = fieldNumber;
        this.name = name;
        this.type = type;
        this.setMethod = setMethod;
        this.getMethod = getMethod;
        Annotation[] annotations = setMethod.getAnnotations();
        if (annotations != null && annotations.length != 0) {
            for (Annotation a : annotations) {
                this.error(local.message("ERR_Annotate_Set_Method", (Object)name, (Object)a.annotationType().getName()));
            }
        }
        this.notPersistentAnnotation = getMethod.getAnnotation(NotPersistent.class);
        if (this.isPersistent()) {
            this.columnName = name.toLowerCase();
            this.columnNames = new String[]{name};
            this.columnAnnotation = getMethod.getAnnotation(com.mysql.clusterj.annotation.Column.class);
            if (this.columnAnnotation != null) {
                if (this.columnAnnotation.name() != null) {
                    this.columnName = this.columnAnnotation.name();
                    this.columnNames = new String[]{this.columnName};
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Column name annotation for " + name + " is " + this.columnName);
                }
                this.columnAllowsNull = this.columnAnnotation.allowsNull();
                if (logger.isDebugEnabled()) {
                    logger.debug("Column allowsNull annotation for " + name + " is " + this.columnAllowsNull);
                }
                this.columnDefaultValue = this.columnAnnotation.defaultValue();
                if (this.columnDefaultValue.equals("")) {
                    this.columnDefaultValue = null;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Column defaultValue annotation for " + name + " is " + this.columnDefaultValue);
                }
            }
            this.storeColumn = table.getColumn(this.columnName);
            if (this.storeColumn == null) {
                throw new ClusterJUserException(local.message("ERR_No_Column", name, table.getName(), this.columnName));
            }
            this.initializeColumnMetadata(this.storeColumn);
            if (logger.isDebugEnabled()) {
                logger.debug("Column type for " + name + " is " + this.storeColumnType.toString() + "; charset name is " + this.charsetName);
            }
            domainTypeHandler.registerPrimaryKeyColumn(this, this.columnName);
            this.lobAnnotation = getMethod.getAnnotation(Lob.class);
        }
        if (this.primaryKey) {
            if (type.equals(Integer.TYPE)) {
                this.objectOperationHandlerDelegate = objectOperationHandlerKeyInt;
            } else if (type.equals(Long.TYPE)) {
                this.objectOperationHandlerDelegate = objectOperationHandlerKeyLong;
            } else if (type.equals(String.class)) {
                this.objectOperationHandlerDelegate = objectOperationHandlerKeyString;
            } else if (type.equals(byte[].class)) {
                this.objectOperationHandlerDelegate = objectOperationHandlerKeyBytes;
            } else if (type.equals(Short.TYPE)) {
                this.objectOperationHandlerDelegate = objectOperationHandlerKeyShort;
            } else if (type.equals(Byte.TYPE)) {
                this.objectOperationHandlerDelegate = objectOperationHandlerKeyByte;
            } else {
                this.objectOperationHandlerDelegate = objectOperationHandlerUnsupportedType;
                this.error(local.message("ERR_Primary_Field_Type", domainTypeHandler.getName(), name, this.printableName(type)));
            }
        } else if (this.lobAnnotation != null) {
            this.lob = true;
            if (type.equals(byte[].class)) {
                this.objectOperationHandlerDelegate = objectOperationHandlerBytesLob;
            } else if (type.equals(String.class)) {
                this.objectOperationHandlerDelegate = objectOperationHandlerStringLob;
            } else {
                this.objectOperationHandlerDelegate = objectOperationHandlerUnsupportedType;
                this.error(local.message("ERR_Unsupported_Field_Type", (Object)this.printableName(type), (Object)name));
            }
        } else if (!this.isPersistent()) {
            this.objectOperationHandlerDelegate = type.equals(Byte.TYPE) ? objectOperationHandlerNotPersistentByte : (type.equals(Double.TYPE) ? objectOperationHandlerNotPersistentDouble : (type.equals(Float.TYPE) ? objectOperationHandlerNotPersistentFloat : (type.equals(Integer.TYPE) ? objectOperationHandlerNotPersistentInt : (type.equals(Long.TYPE) ? objectOperationHandlerNotPersistentLong : (type.equals(Short.TYPE) ? objectOperationHandlerNotPersistentShort : objectOperationHandlerNotPersistentObject)))));
        } else if (type.equals(byte[].class)) {
            if (ColumnType.Blob == this.storeColumnType) {
                this.lob = true;
                this.objectOperationHandlerDelegate = objectOperationHandlerBytesLob;
            } else {
                this.objectOperationHandlerDelegate = objectOperationHandlerBytes;
            }
        } else if (type.equals(java.util.Date.class)) {
            this.objectOperationHandlerDelegate = objectOperationHandlerJavaUtilDate;
        } else if (type.equals(BigDecimal.class)) {
            this.objectOperationHandlerDelegate = objectOperationHandlerDecimal;
        } else if (type.equals(BigInteger.class)) {
            this.objectOperationHandlerDelegate = objectOperationHandlerBigInteger;
        } else if (type.equals(Double.TYPE)) {
            this.objectOperationHandlerDelegate = objectOperationHandlerDouble;
        } else if (type.equals(Float.TYPE)) {
            this.objectOperationHandlerDelegate = objectOperationHandlerFloat;
        } else if (type.equals(Integer.TYPE)) {
            this.objectOperationHandlerDelegate = objectOperationHandlerInt;
        } else if (type.equals(Integer.class)) {
            this.objectOperationHandlerDelegate = objectOperationHandlerObjectInteger;
        } else if (type.equals(Long.class)) {
            this.objectOperationHandlerDelegate = objectOperationHandlerObjectLong;
        } else if (type.equals(Short.class)) {
            this.objectOperationHandlerDelegate = ColumnType.Year.equals((Object)this.storeColumnType) ? objectOperationHandlerObjectShortYear : objectOperationHandlerObjectShort;
        } else if (type.equals(Float.class)) {
            this.objectOperationHandlerDelegate = objectOperationHandlerObjectFloat;
        } else if (type.equals(Double.class)) {
            this.objectOperationHandlerDelegate = objectOperationHandlerObjectDouble;
        } else if (type.equals(Long.TYPE)) {
            this.objectOperationHandlerDelegate = objectOperationHandlerLong;
        } else if (type.equals(Short.TYPE)) {
            this.objectOperationHandlerDelegate = ColumnType.Year.equals((Object)this.storeColumnType) ? objectOperationHandlerShortYear : objectOperationHandlerShort;
        } else if (type.equals(String.class)) {
            if (ColumnType.Text == this.storeColumnType) {
                this.lob = true;
                this.objectOperationHandlerDelegate = objectOperationHandlerStringLob;
            } else {
                this.objectOperationHandlerDelegate = objectOperationHandlerString;
            }
        } else if (type.equals(Byte.class)) {
            this.objectOperationHandlerDelegate = objectOperationHandlerObjectByte;
        } else if (type.equals(Byte.TYPE)) {
            this.objectOperationHandlerDelegate = objectOperationHandlerByte;
        } else if (type.equals(Boolean.TYPE)) {
            this.objectOperationHandlerDelegate = objectOperationHandlerBoolean;
        } else if (type.equals(Boolean.class)) {
            this.objectOperationHandlerDelegate = objectOperationHandlerObjectBoolean;
        } else if (type.equals(Date.class)) {
            this.objectOperationHandlerDelegate = objectOperationHandlerJavaSqlDate;
        } else if (type.equals(Time.class)) {
            this.objectOperationHandlerDelegate = objectOperationHandlerJavaSqlTime;
        } else if (type.equals(Timestamp.class)) {
            this.objectOperationHandlerDelegate = objectOperationHandlerJavaSqlTimestamp;
        } else {
            this.objectOperationHandlerDelegate = objectOperationHandlerUnsupportedType;
            this.error(local.message("ERR_Unsupported_Field_Type", (Object)type.getName(), (Object)name));
        }
        this.indexAnnotation = getMethod.getAnnotation(Index.class);
        String indexName = null;
        if (this.indexAnnotation != null) {
            indexName = this.indexAnnotation.name();
            if (this.indexAnnotation.columns().length != 0) {
                throw new ClusterJUserException(local.message("ERR_Index_Annotation_Columns", (Object)domainTypeHandler.getName(), (Object)name));
            }
        }
        this.registerIndices(domainTypeHandler);
        this.persistentAnnotation = getMethod.getAnnotation(Persistent.class);
        if (this.persistentAnnotation != null) {
            this.nullValue = this.persistentAnnotation.nullValue();
            logger.debug("Persistent nullValue annotation for " + name + " is " + (Object)((Object)this.nullValue));
        }
        this.defaultValue = this.objectOperationHandlerDelegate.getDefaultValueFor(this, this.columnDefaultValue);
        logger.debug("Default null value for " + name + " is " + this.defaultValue);
        switch (this.nullValue) {
            case DEFAULT: {
                this.nullValueDelegate = nullValueDEFAULT;
                break;
            }
            case EXCEPTION: {
                this.nullValueDelegate = nullValueEXCEPTION;
                break;
            }
            case NONE: {
                this.nullValueDelegate = nullValueNONE;
            }
        }
        this.reportErrors();
    }

    public DomainFieldHandlerImpl(DomainTypeHandlerImpl<?> domainTypeHandler, Table table, int i, Column storeColumn) {
        this.domainTypeHandler = domainTypeHandler;
        this.fieldNumber = i;
        this.storeColumn = storeColumn;
        this.initializeColumnMetadata(storeColumn);
        this.name = this.columnName;
        this.columnNames = new String[]{this.columnName};
        if (this.primaryKey) {
            domainTypeHandler.registerPrimaryKeyColumn(this, this.columnName);
            switch (this.storeColumnType) {
                case Int: 
                case Unsigned: {
                    this.objectOperationHandlerDelegate = objectOperationHandlerKeyInt;
                    this.type = Integer.TYPE;
                    break;
                }
                case Char: 
                case Varchar: {
                    this.objectOperationHandlerDelegate = objectOperationHandlerKeyString;
                    this.type = String.class;
                    break;
                }
                case Bigint: 
                case Bigunsigned: {
                    this.objectOperationHandlerDelegate = objectOperationHandlerKeyLong;
                    this.type = Long.TYPE;
                    break;
                }
                case Binary: 
                case Varbinary: 
                case Longvarbinary: {
                    this.objectOperationHandlerDelegate = objectOperationHandlerKeyBytes;
                    this.type = byte[].class;
                    break;
                }
                case Smallint: 
                case Smallunsigned: {
                    this.objectOperationHandlerDelegate = objectOperationHandlerKeyShort;
                    this.type = Short.TYPE;
                    break;
                }
                case Tinyint: 
                case Tinyunsigned: {
                    this.objectOperationHandlerDelegate = objectOperationHandlerKeyByte;
                    this.type = Byte.TYPE;
                    break;
                }
                default: {
                    this.error(local.message("ERR_Primary_Column_Type", new Object[]{domainTypeHandler.getName(), this.name, this.storeColumnType}));
                    break;
                }
            }
        } else {
            switch (this.storeColumnType) {
                case Bigint: 
                case Bigunsigned: {
                    if (storeColumn.getNullable()) {
                        this.objectOperationHandlerDelegate = objectOperationHandlerObjectLong;
                        this.type = Long.class;
                        break;
                    }
                    this.objectOperationHandlerDelegate = objectOperationHandlerLong;
                    this.type = Long.TYPE;
                    break;
                }
                case Binary: {
                    this.objectOperationHandlerDelegate = objectOperationHandlerBytes;
                    this.type = byte[].class;
                    break;
                }
                case Bit: {
                    if (storeColumn.getNullable()) {
                        this.objectOperationHandlerDelegate = objectOperationHandlerObjectLong;
                        this.type = Long.class;
                        break;
                    }
                    this.objectOperationHandlerDelegate = objectOperationHandlerLong;
                    this.type = Long.TYPE;
                    break;
                }
                case Blob: {
                    this.lob = true;
                    this.objectOperationHandlerDelegate = objectOperationHandlerBytesLob;
                    this.type = byte[].class;
                    break;
                }
                case Char: {
                    this.objectOperationHandlerDelegate = objectOperationHandlerString;
                    this.type = String.class;
                    break;
                }
                case Date: {
                    this.objectOperationHandlerDelegate = objectOperationHandlerJavaSqlDate;
                    this.type = Date.class;
                    break;
                }
                case Datetime: 
                case Datetime2: {
                    this.objectOperationHandlerDelegate = objectOperationHandlerJavaSqlTimestamp;
                    this.type = Timestamp.class;
                    break;
                }
                case Decimal: 
                case Decimalunsigned: {
                    this.objectOperationHandlerDelegate = objectOperationHandlerDecimal;
                    this.type = BigDecimal.class;
                    break;
                }
                case Double: {
                    if (storeColumn.getNullable()) {
                        this.objectOperationHandlerDelegate = objectOperationHandlerObjectDouble;
                        this.type = Double.class;
                        break;
                    }
                    this.objectOperationHandlerDelegate = objectOperationHandlerDouble;
                    this.type = Double.TYPE;
                    break;
                }
                case Float: {
                    if (storeColumn.getNullable()) {
                        this.objectOperationHandlerDelegate = objectOperationHandlerObjectFloat;
                        this.type = Float.class;
                        break;
                    }
                    this.objectOperationHandlerDelegate = objectOperationHandlerFloat;
                    this.type = Float.TYPE;
                    break;
                }
                case Int: {
                    if (storeColumn.getNullable()) {
                        this.objectOperationHandlerDelegate = objectOperationHandlerObjectInteger;
                        this.type = Integer.class;
                        break;
                    }
                    this.objectOperationHandlerDelegate = objectOperationHandlerInt;
                    this.type = Integer.TYPE;
                    break;
                }
                case Longvarbinary: {
                    this.objectOperationHandlerDelegate = objectOperationHandlerBytes;
                    this.type = byte[].class;
                    break;
                }
                case Longvarchar: {
                    this.objectOperationHandlerDelegate = objectOperationHandlerString;
                    this.type = String.class;
                    break;
                }
                case Mediumint: 
                case Mediumunsigned: {
                    if (storeColumn.getNullable()) {
                        this.objectOperationHandlerDelegate = objectOperationHandlerObjectInteger;
                        this.type = Integer.class;
                        break;
                    }
                    this.objectOperationHandlerDelegate = objectOperationHandlerInt;
                    this.type = Integer.TYPE;
                    break;
                }
                case Olddecimal: {
                    this.error(local.message("ERR_Unsupported_Field_Type", (Object)"Olddecimal", (Object)this.name));
                    this.objectOperationHandlerDelegate = objectOperationHandlerUnsupportedType;
                    break;
                }
                case Olddecimalunsigned: {
                    this.error(local.message("ERR_Unsupported_Field_Type", (Object)"Olddecimalunsigned", (Object)this.name));
                    this.objectOperationHandlerDelegate = objectOperationHandlerUnsupportedType;
                    break;
                }
                case Smallint: 
                case Smallunsigned: {
                    if (storeColumn.getNullable()) {
                        this.objectOperationHandlerDelegate = objectOperationHandlerObjectShort;
                        this.type = Short.class;
                        break;
                    }
                    this.objectOperationHandlerDelegate = objectOperationHandlerShort;
                    this.type = Short.TYPE;
                    break;
                }
                case Text: {
                    this.lob = true;
                    this.objectOperationHandlerDelegate = objectOperationHandlerStringLob;
                    this.type = String.class;
                    break;
                }
                case Time: 
                case Time2: {
                    this.objectOperationHandlerDelegate = objectOperationHandlerJavaSqlTime;
                    this.type = Time.class;
                    break;
                }
                case Timestamp: 
                case Timestamp2: {
                    this.objectOperationHandlerDelegate = objectOperationHandlerJavaSqlTimestamp;
                    this.type = Timestamp.class;
                    break;
                }
                case Tinyint: 
                case Tinyunsigned: {
                    if (storeColumn.getNullable()) {
                        this.objectOperationHandlerDelegate = objectOperationHandlerObjectByte;
                        this.type = Byte.class;
                        break;
                    }
                    this.objectOperationHandlerDelegate = objectOperationHandlerByte;
                    this.type = Byte.TYPE;
                    break;
                }
                case Undefined: {
                    this.error(local.message("ERR_Unsupported_Field_Type", (Object)"Undefined", (Object)this.name));
                    this.objectOperationHandlerDelegate = objectOperationHandlerUnsupportedType;
                    break;
                }
                case Unsigned: {
                    if (storeColumn.getNullable()) {
                        this.objectOperationHandlerDelegate = objectOperationHandlerObjectInteger;
                        this.type = Integer.class;
                    } else {
                        this.objectOperationHandlerDelegate = objectOperationHandlerInt;
                        this.type = Integer.TYPE;
                    }
                }
                case Varbinary: {
                    this.objectOperationHandlerDelegate = objectOperationHandlerBytes;
                    this.type = byte[].class;
                    break;
                }
                case Varchar: {
                    this.objectOperationHandlerDelegate = objectOperationHandlerString;
                    this.type = String.class;
                    break;
                }
                case Year: {
                    if (storeColumn.getNullable()) {
                        this.objectOperationHandlerDelegate = objectOperationHandlerObjectShort;
                        this.type = Short.class;
                        break;
                    }
                    this.objectOperationHandlerDelegate = objectOperationHandlerShort;
                    this.type = Short.TYPE;
                    break;
                }
                default: {
                    this.error(local.message("ERR_Unsupported_Field_Type", (Object)this.storeColumnType, (Object)this.name));
                    this.objectOperationHandlerDelegate = objectOperationHandlerUnsupportedType;
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("new dynamic DomainFieldHandlerImpl: fieldNumber: " + this.fieldNumber + "; name: " + this.name + "; type: " + this.type);
        }
        this.nullValueDelegate = nullValueNONE;
        this.registerIndices(domainTypeHandler);
        this.reportErrors();
    }

    @Override
    public boolean isPersistent() {
        return this.notPersistentAnnotation == null;
    }

    protected void registerIndices(DomainTypeHandlerImpl<?> domainTypeHandler) {
        this.indices = domainTypeHandler.registerIndices(this, this.columnName);
        this.indexNames = domainTypeHandler.getIndexNames(this.indices);
        if (logger.isDebugEnabled()) {
            logger.debug("Index names for " + this.name + " are " + this.indexNames);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Indices for " + this.name + " are " + this.printIndices());
        }
    }

    @Override
    public void operationSetValue(ValueHandler handler, Operation op) {
        boolean isNull = handler.isNull(this.fieldNumber);
        if (logger.isDetailEnabled()) {
            logger.detail("Column: " + this.columnName + " field: " + this.name + " isNull: " + isNull + " type: " + this.type + " delegate " + this.objectOperationHandlerDelegate.handler());
        }
        try {
            if (isNull && this.nullValueDelegate.operationSetValue(this, op)) {
                return;
            }
            this.objectOperationHandlerDelegate.operationSetValue((AbstractDomainFieldHandlerImpl)this, handler, op);
        }
        catch (ClusterJDatastoreException ex) {
            throw new ClusterJDatastoreException(local.message("ERR_Value_Delegate", this.name, this.columnName, this.objectOperationHandlerDelegate.handler(), "setValue"), ex);
        }
    }

    @Override
    public boolean isLob() {
        return this.lob;
    }

    @Override
    public Object getDefaultValue() {
        Object value = this.objectOperationHandlerDelegate.getDefaultValueFor(this, null);
        return value;
    }

    protected static interface NullObjectOperationHandler {
        public boolean operationSetValue(DomainFieldHandlerImpl var1, Operation var2);
    }
}

