/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.core.util;

import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class I18NHelper {
    private static Logger logger = LoggerFactoryService.getFactory().getInstance(I18NHelper.class);
    private static Hashtable<String, ResourceBundle> bundles = new Hashtable();
    private static Hashtable<String, I18NHelper> helpers = new Hashtable();
    private static Locale locale = Locale.getDefault();
    private final String bundleName;
    private ResourceBundle bundle = null;
    private Throwable failure = null;
    private static final String bundleSuffix = ".Bundle";

    private I18NHelper() {
        this.bundleName = null;
    }

    private I18NHelper(String bundleName, ClassLoader loader) {
        this.bundleName = bundleName;
        try {
            this.bundle = I18NHelper.loadBundle(bundleName, bundleName, loader);
        }
        catch (Throwable e) {
            this.failure = e;
        }
    }

    public static I18NHelper getInstance(String bundleName) {
        return I18NHelper.getInstance(bundleName, I18NHelper.class.getClassLoader());
    }

    public static I18NHelper getInstance(final Class<?> cls) {
        ClassLoader classLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return cls.getClassLoader();
            }
        });
        String bundle = I18NHelper.getPackageName(cls.getName()) + bundleSuffix;
        return I18NHelper.getInstance(bundle, classLoader);
    }

    public static I18NHelper getInstance(String bundleName, ClassLoader loader) {
        I18NHelper helper = helpers.get(bundleName);
        if (helper != null) {
            return helper;
        }
        helper = new I18NHelper(bundleName, loader);
        helpers.put(bundleName, helper);
        return helpers.get(bundleName);
    }

    public String message(String messageKey) {
        this.assertBundle(messageKey);
        return I18NHelper.getMessage(this.bundle, messageKey);
    }

    public String message(String messageKey, Object arg1) {
        this.assertBundle(messageKey);
        return I18NHelper.getMessage(this.bundle, messageKey, arg1);
    }

    public String message(String messageKey, Object arg1, Object arg2) {
        this.assertBundle(messageKey);
        return I18NHelper.getMessage(this.bundle, messageKey, arg1, arg2);
    }

    public String message(String messageKey, Object ... args) {
        this.assertBundle(messageKey);
        return I18NHelper.getMessage(this.bundle, messageKey, args);
    }

    public String message(String messageKey, int arg) {
        this.assertBundle(messageKey);
        return I18NHelper.getMessage(this.bundle, messageKey, arg);
    }

    public String message(String messageKey, boolean arg) {
        this.assertBundle(messageKey);
        return I18NHelper.getMessage(this.bundle, messageKey, arg);
    }

    public ResourceBundle getResourceBundle() {
        this.assertBundle();
        return this.bundle;
    }

    private static final ResourceBundle loadBundle(String original, String bundleName, ClassLoader loader) {
        ResourceBundle messages = bundles.get(bundleName);
        if (messages == null) {
            try {
                messages = loader != null ? ResourceBundle.getBundle(bundleName, locale, loader) : ResourceBundle.getBundle(bundleName, locale, I18NHelper.getSystemClassLoaderPrivileged());
                bundles.put(bundleName, messages);
            }
            catch (MissingResourceException ex) {
                String superBundleName = I18NHelper.removeDirectoryName(bundleName);
                if (superBundleName == null) {
                    throw new ClusterJFatalInternalException("Missing resource bundle " + original);
                }
                messages = I18NHelper.loadBundle(original, superBundleName, loader);
            }
        }
        return messages;
    }

    private void assertBundle() {
        if (this.failure != null) {
            throw new ClusterJFatalInternalException("No resources could be found for bundle:\"" + this.bundleName + "\" ", this.failure);
        }
    }

    private void assertBundle(String key) {
        if (this.failure != null) {
            throw new ClusterJFatalInternalException("No resources could be found for bundle: " + this.bundleName + " to annotate error message key:\"" + key + "\"", this.failure);
        }
    }

    private static final String getMessage(ResourceBundle messages, String messageKey) {
        return messages.getString(messageKey);
    }

    private static final String getMessage(ResourceBundle messages, String messageKey, Object[] msgArgs) {
        for (int i = 0; i < msgArgs.length; ++i) {
            if (msgArgs[i] != null) continue;
            msgArgs[i] = "";
        }
        MessageFormat formatter = new MessageFormat(messages.getString(messageKey));
        return formatter.format(msgArgs);
    }

    private static final String getMessage(ResourceBundle messages, String messageKey, Object arg) {
        Object[] args = new Object[]{arg};
        return I18NHelper.getMessage(messages, messageKey, args);
    }

    private static final String getMessage(ResourceBundle messages, String messageKey, Object arg1, Object arg2) {
        Object[] args = new Object[]{arg1, arg2};
        return I18NHelper.getMessage(messages, messageKey, args);
    }

    private static final String getMessage(ResourceBundle messages, String messageKey, int arg) {
        Object[] args = new Object[]{new Integer(arg)};
        return I18NHelper.getMessage(messages, messageKey, args);
    }

    private static final String getMessage(ResourceBundle messages, String messageKey, boolean arg) {
        Object[] args = new Object[]{String.valueOf(arg)};
        return I18NHelper.getMessage(messages, messageKey, args);
    }

    private static final String getPackageName(String className) {
        int index = className.lastIndexOf(46);
        return index != -1 ? className.substring(0, index) : "";
    }

    private static String removeDirectoryName(String bundleName) {
        int lastDot = bundleName.lastIndexOf(".");
        String packageName = bundleName.substring(0, lastDot);
        String suffix = bundleName.substring(lastDot);
        int index = packageName.lastIndexOf(".");
        if (index == -1) {
            return null;
        }
        String superPackageName = packageName.substring(0, index);
        String result = superPackageName + suffix;
        if (logger.isDebugEnabled()) {
            logger.debug("bundleName is: " + bundleName + "; superPackageName is: " + superPackageName + "; suffix is: " + suffix + "; packageName is: " + packageName + "; returning: " + result);
        }
        return result;
    }

    private static ClassLoader getSystemClassLoaderPrivileged() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return ClassLoader.getSystemClassLoader();
            }
        });
    }
}

