/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.core.query;

import com.mysql.clusterj.ClusterJException;
import com.mysql.clusterj.core.query.AndPredicateImpl;
import com.mysql.clusterj.core.query.CandidateIndexImpl;
import com.mysql.clusterj.core.query.ComparativePredicateImpl;
import com.mysql.clusterj.core.query.InPredicateImpl;
import com.mysql.clusterj.core.query.PredicateImpl;
import com.mysql.clusterj.core.query.QueryDomainTypeImpl;
import com.mysql.clusterj.core.spi.QueryExecutionContext;
import com.mysql.clusterj.core.store.ScanFilter;
import com.mysql.clusterj.core.store.ScanOperation;
import com.mysql.clusterj.query.Predicate;
import java.util.ArrayList;
import java.util.List;

public class OrPredicateImpl
extends PredicateImpl {
    List<PredicateImpl> predicates = new ArrayList<PredicateImpl>();

    public OrPredicateImpl(QueryDomainTypeImpl<?> dobj, PredicateImpl left, PredicateImpl right) {
        super(dobj);
        this.predicates.add(left);
        this.predicates.add(right);
    }

    @Override
    public Predicate or(Predicate predicate) {
        if (predicate instanceof ComparativePredicateImpl) {
            this.predicates.add((PredicateImpl)predicate);
            return this;
        }
        if (predicate instanceof AndPredicateImpl) {
            this.predicates.add((PredicateImpl)predicate);
            return this;
        }
        if (predicate instanceof OrPredicateImpl) {
            this.predicates.addAll(((OrPredicateImpl)predicate).predicates);
            return this;
        }
        if (predicate instanceof InPredicateImpl) {
            this.predicates.add((PredicateImpl)predicate);
            return this;
        }
        throw new UnsupportedOperationException(local.message("ERR_NotImplemented"));
    }

    @Override
    public void markParameters() {
    }

    @Override
    public void unmarkParameters() {
    }

    @Override
    void markBoundsForCandidateIndices(QueryExecutionContext context, CandidateIndexImpl[] candidateIndices) {
    }

    @Override
    public void filterCmpValue(QueryExecutionContext context, ScanOperation op) {
        try {
            ScanFilter filter = op.getScanFilter(context);
            filter.begin(ScanFilter.Group.GROUP_OR);
            for (PredicateImpl predicate : this.predicates) {
                predicate.filterCmpValue(context, op, filter);
            }
            filter.end();
        }
        catch (ClusterJException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ClusterJException(local.message("ERR_Get_NdbFilter"), ex);
        }
    }

    @Override
    public void filterCmpValue(QueryExecutionContext context, ScanOperation op, ScanFilter filter) {
        try {
            filter.begin(ScanFilter.Group.GROUP_OR);
            for (PredicateImpl predicate : this.predicates) {
                predicate.filterCmpValue(context, op, filter);
            }
            filter.end();
        }
        catch (ClusterJException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ClusterJException(local.message("ERR_Get_NdbFilter"), ex);
        }
    }
}

