/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import java.util.ArrayList;
import testsuite.clusterj.AbstractClusterJModelTest;
import testsuite.clusterj.model.Employee;

public class UpdateTest
extends AbstractClusterJModelTest {
    private static final int NUMBER_TO_INSERT = 4;

    @Override
    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.tx = this.session.currentTransaction();
        this.tx.begin();
        this.session.deletePersistentAll(Employee.class);
        this.tx.commit();
        this.createEmployeeInstances(4);
        this.tx.begin();
        this.session.makePersistentAll((Iterable)this.employees);
        this.tx.commit();
        this.addTearDownClasses(Employee.class);
    }

    public void testUpdate() {
        Employee e;
        int i;
        this.tx.begin();
        for (i = 0; i < 4; ++i) {
            e = (Employee)this.session.find(Employee.class, (Object)i);
            e.setAge(4 - i);
            this.session.updatePersistent((Object)e);
        }
        this.tx.commit();
        this.tx.begin();
        for (i = 0; i < 4; ++i) {
            int expected = 4 - i;
            e = (Employee)this.session.find(Employee.class, (Object)i);
            int actual = e.getAge();
            if (expected == actual) continue;
            this.error("Failed update: for employee " + i + " expected age " + expected + " actual age " + actual);
        }
        this.tx.commit();
        this.failOnError();
    }

    public void testBlindUpdate() {
        Employee e;
        int i;
        this.tx.begin();
        for (i = 0; i < 4; ++i) {
            e = (Employee)this.session.newInstance(Employee.class);
            e.setId(i);
            e.setAge(4 - i);
            this.session.updatePersistent((Object)e);
        }
        this.tx.commit();
        this.tx.begin();
        for (i = 0; i < 4; ++i) {
            int expected = 4 - i;
            e = (Employee)this.session.find(Employee.class, (Object)i);
            int actual = e.getAge();
            if (expected == actual) continue;
            this.error("Failed update: for employee " + i + " expected age " + expected + " actual age " + actual);
        }
        this.tx.commit();
        this.failOnError();
    }

    public void testUpdateAll() {
        Employee e;
        int i;
        ArrayList<Employee> employees = new ArrayList<Employee>();
        this.tx.begin();
        for (i = 0; i < 4; ++i) {
            e = (Employee)this.session.find(Employee.class, (Object)i);
            e.setAge(4 - i);
            employees.add(e);
        }
        this.session.updatePersistentAll(employees);
        this.tx.commit();
        this.tx.begin();
        for (i = 0; i < 4; ++i) {
            int expected = 4 - i;
            e = (Employee)this.session.find(Employee.class, (Object)i);
            int actual = e.getAge();
            if (expected == actual) continue;
            this.error("Failed update: for employee " + i + " expected age " + expected + " actual age " + actual);
        }
        this.tx.commit();
        this.failOnError();
    }

    public void testBlindUpdateAll() {
        Employee e;
        int i;
        ArrayList<Employee> employees = new ArrayList<Employee>();
        this.tx.begin();
        for (i = 0; i < 4; ++i) {
            e = (Employee)this.session.newInstance(Employee.class);
            e.setId(i);
            e.setAge(4 - i);
            employees.add(e);
        }
        this.session.updatePersistentAll(employees);
        this.tx.commit();
        this.tx.begin();
        for (i = 0; i < 4; ++i) {
            int expected = 4 - i;
            e = (Employee)this.session.find(Employee.class, (Object)i);
            int actual = e.getAge();
            if (expected == actual) continue;
            this.error("Failed update: for employee " + i + " expected age " + expected + " actual age " + actual);
        }
        this.tx.commit();
        this.failOnError();
    }

    public void testUpdateAllAutocommit() {
        Employee e;
        int i;
        ArrayList<Employee> employees = new ArrayList<Employee>();
        for (i = 0; i < 4; ++i) {
            e = (Employee)this.session.find(Employee.class, (Object)i);
            e.setAge(4 - i);
            employees.add(e);
        }
        this.session.updatePersistentAll(employees);
        this.tx.begin();
        for (i = 0; i < 4; ++i) {
            int expected = 4 - i;
            e = (Employee)this.session.find(Employee.class, (Object)i);
            int actual = e.getAge();
            if (expected == actual) continue;
            this.error("Failed update: for employee " + i + " expected age " + expected + " actual age " + actual);
        }
        this.tx.commit();
        this.failOnError();
    }

    public void testBlindUpdateAllAutocommit() {
        Employee e;
        int i;
        ArrayList<Employee> employees = new ArrayList<Employee>();
        for (i = 0; i < 4; ++i) {
            e = (Employee)this.session.newInstance(Employee.class);
            e.setId(i);
            e.setAge(4 - i);
            employees.add(e);
        }
        this.session.updatePersistentAll(employees);
        this.tx.begin();
        for (i = 0; i < 4; ++i) {
            int expected = 4 - i;
            e = (Employee)this.session.find(Employee.class, (Object)i);
            int actual = e.getAge();
            if (expected == actual) continue;
            this.error("Failed update: for employee " + i + " expected age " + expected + " actual age " + actual);
        }
        this.tx.commit();
        this.failOnError();
    }
}

