/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import testsuite.clusterj.AbstractQueryTest;
import testsuite.clusterj.model.CharsetUtf8;
import testsuite.clusterj.model.IdBase;

public class QueryTextIndexScanTest
extends AbstractQueryTest {
    protected String constant = "0000000000";
    protected String change = "1111111111";
    protected String variable = "abcdefghij";
    protected CharsetUtf8[] instancesToUpdate = new CharsetUtf8[this.getNumberOfInstances()];

    @Override
    public Class<?> getInstanceType() {
        return CharsetUtf8.class;
    }

    @Override
    void createInstances(int number) {
        for (int i = 0; i < number; ++i) {
            CharsetUtf8 b = (CharsetUtf8)this.session.newInstance(CharsetUtf8.class);
            b.setId(i);
            b.setLargeColumn(this.getCharacters(i));
            this.instances.add(b);
        }
    }

    public void test() {
        this.equalQuery("id", "PRIMARY", 5, 5);
        this.testUpdate(5);
        this.greaterEqualQuery("id", "PRIMARY", 7, 7, 8, 9);
        this.greaterThanQuery("id", "PRIMARY", 6, 7, 8, 9);
        this.testUpdate(7);
        this.lessEqualQuery("id", "PRIMARY", 4, 4, 3, 2, 1, 0);
        this.lessThanQuery("id", "PRIMARY", 4, 3, 2, 1, 0);
        this.betweenQuery("id", "PRIMARY", 2, 4, 2, 3, 4);
        this.greaterEqualAndLessEqualQuery("id", "PRIMARY", 2, 4, 2, 3, 4);
        this.greaterThanAndLessEqualQuery("id", "PRIMARY", 2, 4, 3, 4);
        this.greaterEqualAndLessThanQuery("id", "PRIMARY", 2, 4, 2, 3);
        this.greaterThanAndLessThanQuery("id", "PRIMARY", 2, 4, 3);
        this.testDelete(5);
        this.testDelete(8);
        this.failOnError();
    }

    protected String getCharacters(int number) {
        return this.constant + this.variable.charAt(number);
    }

    protected void testUpdate(int id) {
        String updated = this.change + this.variable.charAt(id);
        CharsetUtf8 before = this.instancesToUpdate[id];
        before.setLargeColumn(updated);
        this.session.updatePersistent((Object)before);
        CharsetUtf8 after = (CharsetUtf8)this.session.find(CharsetUtf8.class, (Object)id);
        this.errorIfNotEqual("Mismatch on update " + id, updated, after.getLargeColumn());
    }

    protected void testDelete(int id) {
        CharsetUtf8 before = this.instancesToUpdate[id];
        this.session.deletePersistent((Object)before);
        CharsetUtf8 after = (CharsetUtf8)this.session.find(CharsetUtf8.class, (Object)id);
        if (after != null) {
            this.error("Failed to delete " + id + ".");
        }
    }

    @Override
    protected void printResultInstance(IdBase instance) {
        CharsetUtf8 b = (CharsetUtf8)instance;
        int id = b.getId();
        this.instancesToUpdate[id] = b;
        this.errorIfNotEqual("Mismatch reading instance " + id, this.constant + this.variable.charAt(id), b.getLargeColumn());
    }
}

