/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.Query;
import com.mysql.clusterj.query.QueryBuilder;
import com.mysql.clusterj.query.QueryDefinition;
import com.mysql.clusterj.query.QueryDomainType;
import java.util.Map;
import testsuite.clusterj.AbstractQueryTest;
import testsuite.clusterj.model.AllPrimitives;

public class QueryExplainTest
extends AbstractQueryTest {
    @Override
    public Class<?> getInstanceType() {
        return AllPrimitives.class;
    }

    @Override
    void createInstances(int number) {
        this.createAllPrimitivesInstances(10);
    }

    public void testExplainWithNoWhereClause() {
        QueryBuilder builder = this.session.getQueryBuilder();
        QueryDomainType dobj = builder.createQueryDefinition(AllPrimitives.class);
        Query query = this.session.createQuery((QueryDefinition)dobj);
        Map result = query.explain();
        String indexUsed = result.get("IndexUsed").toString();
        String scanType = result.get("ScanType").toString();
        this.errorIfNotEqual("Query explain with no where clause should have index none", "none", indexUsed);
        this.errorIfNotEqual("Query explain with no where clause should have scan type TABLE_SCAN", "TABLE_SCAN", scanType);
        this.failOnError();
    }

    public void testExplainBeforeBindingParameters() {
        QueryBuilder builder = this.session.getQueryBuilder();
        QueryDomainType dobj = builder.createQueryDefinition(AllPrimitives.class);
        dobj.where(dobj.get("int_null_none").equal(dobj.param("equal")));
        Query query = this.session.createQuery((QueryDefinition)dobj);
        try {
            query.explain();
            QueryExplainTest.fail("Explain before binding parameters should throw ClusterJUserException");
        }
        catch (ClusterJUserException ex) {
            this.errorIfNotEqual("Message should include parameter name \"equal\"", true, ex.getMessage().contains("equal"));
        }
        this.failOnError();
    }

    public void testExplainAfterBindingParametersNoIndexEqual() {
        QueryBuilder builder = this.session.getQueryBuilder();
        QueryDomainType dobj = builder.createQueryDefinition(AllPrimitives.class);
        dobj.where(dobj.get("int_null_none").equal(dobj.param("equal")));
        Query query = this.session.createQuery((QueryDefinition)dobj);
        query.setParameter("equal", (Object)1);
        Map result = query.explain();
        String indexUsed = result.get("IndexUsed").toString();
        String scanType = result.get("ScanType").toString();
        this.errorIfNotEqual("Query explain with no index should have index none", "none", indexUsed);
        this.errorIfNotEqual("Query explain with no index should have scan type TABLE_SCAN", "TABLE_SCAN", scanType);
        this.failOnError();
    }

    public void testExplainAfterBindingParametersUniqueEqual() {
        QueryBuilder builder = this.session.getQueryBuilder();
        QueryDomainType dobj = builder.createQueryDefinition(AllPrimitives.class);
        dobj.where(dobj.get("int_not_null_hash").equal(dobj.param("equal")));
        Query query = this.session.createQuery((QueryDefinition)dobj);
        query.setParameter("equal", (Object)1);
        Map result = query.explain();
        String indexUsed = result.get("IndexUsed").toString();
        String scanType = result.get("ScanType").toString();
        this.errorIfNotEqual("Query explain with PRIMARY key equal should have index int_not_null_hash", "idx_int_not_null_hash", indexUsed);
        this.errorIfNotEqual("Query explain with PRIMARY key equal should have scan type UNIQUE_KEY", "UNIQUE_KEY", scanType);
        this.failOnError();
    }

    public void testExplainAfterBindingParametersPrimaryEqual() {
        QueryBuilder builder = this.session.getQueryBuilder();
        QueryDomainType dobj = builder.createQueryDefinition(AllPrimitives.class);
        dobj.where(dobj.get("id").equal(dobj.param("equal")));
        Query query = this.session.createQuery((QueryDefinition)dobj);
        query.setParameter("equal", (Object)1);
        Map result = query.explain();
        String indexUsed = result.get("IndexUsed").toString();
        String scanType = result.get("ScanType").toString();
        this.errorIfNotEqual("Query explain with PRIMARY key equal should have index PRIMARY", "PRIMARY", indexUsed);
        this.errorIfNotEqual("Query explain with PRIMARY key equal should have scan type PRIMARY_KEY", "PRIMARY_KEY", scanType);
        this.failOnError();
    }

    public void testExplainAfterBindingParametersPrimaryLessThan() {
        QueryBuilder builder = this.session.getQueryBuilder();
        QueryDomainType dobj = builder.createQueryDefinition(AllPrimitives.class);
        dobj.where(dobj.get("id").lessThan(dobj.param("lessThan")));
        Query query = this.session.createQuery((QueryDefinition)dobj);
        query.setParameter("lessThan", (Object)1);
        Map result = query.explain();
        String indexUsed = result.get("IndexUsed").toString();
        String scanType = result.get("ScanType").toString();
        this.errorIfNotEqual("Query explain with PRIMARY key lessThan should have index PRIMARY", "PRIMARY", indexUsed);
        this.errorIfNotEqual("Query explain with PRIMARY key lessThan should have scan type INDEX_SCAN", "INDEX_SCAN", scanType);
        this.failOnError();
    }

    public void testExplainAfterBindingParametersPrimaryLessThanNull() {
        QueryBuilder builder = this.session.getQueryBuilder();
        QueryDomainType dobj = builder.createQueryDefinition(AllPrimitives.class);
        dobj.where(dobj.get("id").lessThan(dobj.param("lessThan")));
        Query query = this.session.createQuery((QueryDefinition)dobj);
        query.setParameter("lessThan", null);
        Map result = query.explain();
        String indexUsed = result.get("IndexUsed").toString();
        String scanType = result.get("ScanType").toString();
        this.errorIfNotEqual("Query explain with PRIMARY key lessThan null should have index none", "none", indexUsed);
        this.errorIfNotEqual("Query explain with PRIMARY key lessThan null should have scan type TABLE_SCAN", "TABLE_SCAN", scanType);
        this.failOnError();
    }
}

