/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import testsuite.clusterj.AbstractQueryTest;
import testsuite.clusterj.model.ByteArrayTypes;
import testsuite.clusterj.model.IdBase;

public class QueryByteArrayTypesTest
extends AbstractQueryTest {
    public Class getInstanceType() {
        return ByteArrayTypes.class;
    }

    @Override
    void createInstances(int number) {
        this.createAllByteArrayTypesInstances(number);
    }

    public void test() {
        this.btreeIndexScanByteArray();
        this.hashIndexScanByteArray();
        this.bothIndexScanByteArray();
        this.noneIndexScanByteArray();
        this.failOnError();
    }

    public void btreeIndexScanByteArray() {
        this.equalQuery("bytes_null_btree", "idx_bytes_null_btree", this.getByteArray(8), 8);
        this.greaterEqualQuery("bytes_null_btree", "idx_bytes_null_btree", this.getByteArray(7), 7, 8, 9);
        this.greaterThanQuery("bytes_null_btree", "idx_bytes_null_btree", this.getByteArray(6), 7, 8, 9);
        this.lessEqualQuery("bytes_null_btree", "idx_bytes_null_btree", this.getByteArray(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("bytes_null_btree", "idx_bytes_null_btree", this.getByteArray(4), 3, 2, 1, 0);
        this.betweenQuery("bytes_null_btree", "idx_bytes_null_btree", this.getByteArray(4), this.getByteArray(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("bytes_null_btree", "idx_bytes_null_btree", this.getByteArray(4), this.getByteArray(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("bytes_null_btree", "idx_bytes_null_btree", this.getByteArray(4), this.getByteArray(6), 5, 6);
        this.greaterEqualAndLessThanQuery("bytes_null_btree", "idx_bytes_null_btree", this.getByteArray(4), this.getByteArray(6), 4, 5);
        this.greaterThanAndLessThanQuery("bytes_null_btree", "idx_bytes_null_btree", this.getByteArray(4), this.getByteArray(6), 5);
    }

    public void hashIndexScanByteArray() {
        this.equalQuery("bytes_null_hash", "idx_bytes_null_hash", this.getByteArray(8), 8);
        this.greaterEqualQuery("bytes_null_hash", "none", this.getByteArray(7), 7, 8, 9);
        this.greaterThanQuery("bytes_null_hash", "none", this.getByteArray(6), 7, 8, 9);
        this.lessEqualQuery("bytes_null_hash", "none", this.getByteArray(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("bytes_null_hash", "none", this.getByteArray(4), 3, 2, 1, 0);
        this.betweenQuery("bytes_null_hash", "none", this.getByteArray(4), this.getByteArray(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("bytes_null_hash", "none", this.getByteArray(4), this.getByteArray(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("bytes_null_hash", "none", this.getByteArray(4), this.getByteArray(6), 5, 6);
        this.greaterEqualAndLessThanQuery("bytes_null_hash", "none", this.getByteArray(4), this.getByteArray(6), 4, 5);
        this.greaterThanAndLessThanQuery("bytes_null_hash", "none", this.getByteArray(4), this.getByteArray(6), 5);
    }

    public void bothIndexScanByteArray() {
        this.equalQuery("bytes_null_both", "idx_bytes_null_both", this.getByteArray(8), 8);
        this.greaterEqualQuery("bytes_null_both", "idx_bytes_null_both", this.getByteArray(7), 7, 8, 9);
        this.greaterThanQuery("bytes_null_both", "idx_bytes_null_both", this.getByteArray(6), 7, 8, 9);
        this.lessEqualQuery("bytes_null_both", "idx_bytes_null_both", this.getByteArray(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("bytes_null_both", "idx_bytes_null_both", this.getByteArray(4), 3, 2, 1, 0);
        this.betweenQuery("bytes_null_both", "idx_bytes_null_both", this.getByteArray(4), this.getByteArray(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("bytes_null_both", "idx_bytes_null_both", this.getByteArray(4), this.getByteArray(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("bytes_null_both", "idx_bytes_null_both", this.getByteArray(4), this.getByteArray(6), 5, 6);
        this.greaterEqualAndLessThanQuery("bytes_null_both", "idx_bytes_null_both", this.getByteArray(4), this.getByteArray(6), 4, 5);
        this.greaterThanAndLessThanQuery("bytes_null_both", "idx_bytes_null_both", this.getByteArray(4), this.getByteArray(6), 5);
    }

    public void noneIndexScanByteArray() {
        this.equalQuery("bytes_null_none", "none", this.getByteArray(8), 8);
        this.greaterEqualQuery("bytes_null_none", "none", this.getByteArray(7), 7, 8, 9);
        this.greaterThanQuery("bytes_null_none", "none", this.getByteArray(6), 7, 8, 9);
        this.lessEqualQuery("bytes_null_none", "none", this.getByteArray(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("bytes_null_none", "none", this.getByteArray(4), 3, 2, 1, 0);
        this.betweenQuery("bytes_null_none", "none", this.getByteArray(4), this.getByteArray(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("bytes_null_none", "none", this.getByteArray(4), this.getByteArray(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("bytes_null_none", "none", this.getByteArray(4), this.getByteArray(6), 5, 6);
        this.greaterEqualAndLessThanQuery("bytes_null_none", "none", this.getByteArray(4), this.getByteArray(6), 4, 5);
        this.greaterThanAndLessThanQuery("bytes_null_none", "none", this.getByteArray(4), this.getByteArray(6), 5);
    }

    private void createAllByteArrayTypesInstances(int number) {
        for (int i = 0; i < number; ++i) {
            ByteArrayTypes instance = (ByteArrayTypes)this.session.newInstance(ByteArrayTypes.class);
            instance.setId(i);
            instance.setBytes_null_hash(this.getByteArray(i));
            instance.setBytes_null_btree(this.getByteArray(i));
            instance.setBytes_null_both(this.getByteArray(i));
            instance.setBytes_null_none(this.getByteArray(i));
            this.instances.add(instance);
        }
    }

    protected byte[] getByteArray(int number) {
        return new byte[]{0, 0, 0, 0, 0, 0, 0, (byte)number};
    }

    public static String toString(IdBase idBase) {
        ByteArrayTypes instance = (ByteArrayTypes)idBase;
        StringBuffer buffer = new StringBuffer("ByteArrayTypes id: ");
        buffer.append(instance.getId());
        buffer.append("; bytes_null_both: ");
        buffer.append(instance.getBytes_null_both().toString());
        buffer.append("; bytes_null_btree: ");
        buffer.append(instance.getBytes_null_btree().toString());
        buffer.append("; bytes_null_hash: ");
        buffer.append(instance.getBytes_null_hash().toString());
        buffer.append("; bytes_null_none: ");
        buffer.append(instance.getBytes_null_none().toString());
        return buffer.toString();
    }
}

