/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import com.mysql.clusterj.Query;
import com.mysql.clusterj.Session;
import com.mysql.clusterj.query.QueryDefinition;
import com.mysql.clusterj.query.QueryDomainType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import testsuite.clusterj.AbstractClusterJModelTest;
import testsuite.clusterj.AbstractClusterJTest;
import testsuite.clusterj.model.Customer;
import testsuite.clusterj.model.Order;
import testsuite.clusterj.model.OrderLine;

public class MultithreadedTest
extends AbstractClusterJModelTest {
    private int numberOfThreads = 50;
    private int numberOfNewCustomersPerThread = 5;
    private int numberOfNewOrdersPerNewCustomer = 5;
    private int numberOfUpdatesPerThread = 2;
    private int maximumOrderLinesPerOrder = 5;
    private int maximumQuantityPerOrderLine = 100;
    private int maximumUnitPrice = 100;
    private int numberOfInitialCustomers;
    private int nextCustomerId = this.numberOfInitialCustomers = 10;
    private int nextOrderId = 0;
    private int nextOrderLineId = 0;
    private int numberOfUpdatedOrderLines = 0;
    private int numberOfDeletedOrders = 0;
    private int numberOfDeletedOrderLines = 0;
    private ThreadGroup threadGroup;
    List<Customer> customers = new ArrayList<Customer>();
    List<Order> orders = new ArrayList<Order>();
    Set<OrderLine> orderlines = new TreeSet<OrderLine>(new Comparator<OrderLine>(){

        @Override
        public int compare(OrderLine o1, OrderLine o2) {
            return o1.getId() - o2.getId();
        }
    });

    @Override
    protected boolean getDebug() {
        return false;
    }

    @Override
    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.tx = this.session.currentTransaction();
        this.tx.begin();
        this.session.deletePersistentAll(Customer.class);
        this.session.deletePersistentAll(Order.class);
        this.session.deletePersistentAll(OrderLine.class);
        this.tx.commit();
        this.createCustomerInstances(this.nextCustomerId);
        this.tx.begin();
        this.session.makePersistentAll(this.customers);
        this.tx.commit();
        this.addTearDownClasses(Customer.class);
        this.addTearDownClasses(Order.class);
        this.addTearDownClasses(OrderLine.class);
    }

    private void createCustomerInstances(int numberToCreate) {
        for (int i = 0; i < numberToCreate; ++i) {
            Customer customer = (Customer)this.session.newInstance(Customer.class);
            customer.setId(i);
            customer.setName("Customer number " + i + " (initial)");
            customer.setMagic(i * 100);
            this.customers.add(customer);
        }
    }

    public void test() {
        ArrayList<Thread> threads = new ArrayList<Thread>();
        this.threadGroup = new ThreadGroup("Stuff");
        AbstractClusterJTest.MyUncaughtExceptionHandler uncaughtExceptionHandler = new AbstractClusterJTest.MyUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(uncaughtExceptionHandler);
        for (int i = 0; i < this.numberOfThreads; ++i) {
            Thread thread = new Thread(this.threadGroup, new StuffToDo());
            threads.add(thread);
            thread.start();
        }
        for (Thread t : threads) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted while joining threads.");
            }
        }
        for (Throwable thrown : uncaughtExceptionHandler.getUncaughtExceptions()) {
            StackTraceElement[] elements;
            this.error("Caught exception: " + thrown.getClass().getName() + ": " + thrown.getMessage());
            for (StackTraceElement element : elements = thrown.getStackTrace()) {
                this.error("        at " + element.toString());
            }
        }
        if (this.getDebug()) {
            System.out.println("Number of threads: " + this.numberOfThreads + "; number of new customers per thread: " + this.numberOfNewCustomersPerThread + "; number of orders per new customer: " + this.numberOfNewOrdersPerNewCustomer);
            System.out.println("Created " + this.nextCustomerId + " customers; " + this.nextOrderId + " orders; and " + this.nextOrderLineId + " order lines.");
            System.out.println("Deleted " + this.numberOfDeletedOrders + " orders; and " + this.numberOfDeletedOrderLines + " order lines.");
            System.out.println("Updated " + this.numberOfUpdatedOrderLines + " order lines.");
        }
        this.errorIfNotEqual("Failed to create customers.", this.numberOfThreads * this.numberOfNewCustomersPerThread + this.numberOfInitialCustomers, this.nextCustomerId);
        this.errorIfNotEqual("Failed to create orders. ", this.numberOfThreads * this.numberOfNewCustomersPerThread * this.numberOfNewOrdersPerNewCustomer, this.nextOrderId);
        Session session = this.sessionFactory.getSession();
        QueryDomainType queryOrderType = session.getQueryBuilder().createQueryDefinition(OrderLine.class);
        queryOrderType.where(queryOrderType.get("orderId").equal(queryOrderType.param("orderId")));
        Query query = session.createQuery((QueryDefinition)queryOrderType);
        for (Order order : this.orders) {
            int orderId = order.getId();
            if (this.getDebug()) {
                System.out.println("Read order " + orderId + " total " + order.getValue());
            }
            order = (Order)session.find(Order.class, (Object)orderId);
            double expectedTotal = order.getValue();
            double actualTotal = 0.0;
            ArrayList<OrderLine> orderLines = new ArrayList<OrderLine>();
            for (OrderLine orderLine : this.getOrderLines(session, (Query<OrderLine>)query, orderId)) {
                orderLines.add(orderLine);
                if (this.getDebug()) {
                    System.out.println("order " + orderLine.getOrderId() + " orderline " + orderLine.getId() + " value " + orderLine.getTotalValue());
                }
                actualTotal += orderLine.getTotalValue();
            }
            this.errorIfNotEqual("For order " + orderId + ", order value does not equal sum of order line values." + " orderLines: " + MultithreadedTest.dump(orderLines), expectedTotal, actualTotal);
        }
        this.failOnError();
    }

    private void createCustomer(Session session, String threadId) {
        Customer customer = (Customer)session.newInstance(Customer.class);
        int id = this.getNextCustomerId();
        customer.setId(id);
        customer.setName("Customer number " + id + " thread " + threadId);
        customer.setMagic(id * 10000);
        session.makePersistent((Object)customer);
        this.addCustomer(customer);
    }

    public void createOrder(Session session, Random random) {
        session.currentTransaction().begin();
        int orderid = this.getNextOrderId();
        Order order = (Order)session.newInstance(Order.class);
        order.setId(orderid);
        int customerId = random.nextInt(this.nextCustomerId);
        order.setCustomerId(customerId);
        order.setDescription("Order " + orderid + " for Customer " + customerId);
        Double orderValue = 0.0;
        int numberOfOrderLines = random.nextInt(this.maximumOrderLinesPerOrder);
        if (this.getDebug()) {
            System.out.println("Create Order " + orderid + " with numberOfOrderLines: " + numberOfOrderLines);
        }
        for (int i = 0; i < numberOfOrderLines; ++i) {
            int orderLineNumber = this.getNextOrderLineId();
            OrderLine orderLine = (OrderLine)session.newInstance(OrderLine.class);
            orderLine.setId(orderLineNumber);
            orderLine.setOrderId(orderid);
            long quantity = random.nextInt(this.maximumQuantityPerOrderLine);
            orderLine.setQuantity(quantity);
            float unitPrice = (float)random.nextInt(this.maximumUnitPrice) / 4.0f;
            orderLine.setUnitPrice(unitPrice);
            double orderLineValue = unitPrice * (float)quantity;
            orderValue = orderValue + orderLineValue;
            if (this.getDebug()) {
                System.out.println("Create orderline " + orderLineNumber + " for Order " + orderid + " quantity " + quantity + " price " + unitPrice + " order line value " + orderLineValue + " order value " + orderValue);
            }
            orderLine.setTotalValue(orderLineValue);
            this.addOrderLine(orderLine);
            session.persist((Object)orderLine);
        }
        order.setValue(orderValue);
        session.persist((Object)order);
        session.currentTransaction().commit();
        this.addOrder(order);
    }

    public void updateOrder(Session session, Random random, Query<OrderLine> query) {
        session.currentTransaction().begin();
        Order order = null;
        order = this.removeOrderFromOrdersCollection(random);
        if (order == null) {
            return;
        }
        int orderId = order.getId();
        order = (Order)session.find(Order.class, (Object)orderId);
        List<OrderLine> orderLines = this.getOrderLines(session, query, orderId);
        int numberOfOrderLines = orderLines.size();
        OrderLine orderLine = null;
        double orderValue = order.getValue();
        if (numberOfOrderLines > 0) {
            int index = random.nextInt(numberOfOrderLines);
            orderLine = orderLines.get(index);
            orderValue -= orderLine.getTotalValue();
            this.updateOrderLine(orderLine, random);
            orderValue += orderLine.getTotalValue();
        }
        order.setValue(orderValue);
        session.updatePersistent(orderLine);
        session.updatePersistent((Object)order);
        session.currentTransaction().commit();
        this.addOrder(order);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOrderLine(OrderLine orderLine, Random random) {
        int orderid = orderLine.getOrderId();
        int orderLineNumber = orderLine.getId();
        double previousValue = orderLine.getTotalValue();
        long quantity = random.nextInt(this.maximumQuantityPerOrderLine);
        orderLine.setQuantity(quantity);
        float unitPrice = (float)random.nextInt(this.maximumUnitPrice) / 4.0f;
        orderLine.setUnitPrice(unitPrice);
        double orderLineValue = unitPrice * (float)quantity;
        orderLine.setTotalValue(orderLineValue);
        if (this.getDebug()) {
            System.out.println("For order " + orderid + " orderline " + orderLineNumber + " previous order line value " + previousValue + " new order line value " + orderLineValue);
        }
        Set<OrderLine> set = this.orderlines;
        synchronized (set) {
            ++this.numberOfUpdatedOrderLines;
        }
    }

    public void deleteOrder(Session session, Random random, Query<OrderLine> query) {
        session.currentTransaction().begin();
        Order order = null;
        order = this.removeOrderFromOrdersCollection(random);
        if (order == null) {
            return;
        }
        int orderId = order.getId();
        List<OrderLine> orderLines = this.getOrderLines(session, query, orderId);
        this.removeOrderLinesFromOrderLinesCollection(orderLines);
        session.deletePersistentAll(orderLines);
        session.deletePersistent((Object)order);
        session.currentTransaction().commit();
    }

    private List<OrderLine> getOrderLines(Session session, Query<OrderLine> query, int orderId) {
        query.setParameter("orderId", (Object)orderId);
        return query.getResultList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Order removeOrderFromOrdersCollection(Random random) {
        List<Order> list = this.orders;
        synchronized (list) {
            int numberOfOrders = this.orders.size();
            if (numberOfOrders < 10) {
                return null;
            }
            int which = random.nextInt(numberOfOrders);
            ++this.numberOfDeletedOrders;
            return this.orders.remove(which);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOrderLinesFromOrderLinesCollection(Collection<OrderLine> orderLinesToRemove) {
        Set<OrderLine> set = this.orderlines;
        synchronized (set) {
            this.orderlines.removeAll(orderLinesToRemove);
            this.numberOfDeletedOrderLines += orderLinesToRemove.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCustomer(Customer customer) {
        List<Customer> list = this.customers;
        synchronized (list) {
            this.customers.add(customer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextCustomerId() {
        List<Customer> list = this.customers;
        synchronized (list) {
            int result = this.nextCustomerId++;
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextOrderId() {
        List<Order> list = this.orders;
        synchronized (list) {
            int result = this.nextOrderId++;
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextOrderLineId() {
        Set<OrderLine> set = this.orderlines;
        synchronized (set) {
            int result = this.nextOrderLineId++;
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOrder(Order order) {
        List<Order> list = this.orders;
        synchronized (list) {
            this.orders.add(order);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOrderLine(OrderLine orderLine) {
        Set<OrderLine> set = this.orderlines;
        synchronized (set) {
            this.orderlines.add(orderLine);
        }
    }

    class StuffToDo
    implements Runnable {
        private Random myRandom = new Random();

        StuffToDo() {
        }

        @Override
        public void run() {
            Session session = MultithreadedTest.this.sessionFactory.getSession();
            QueryDomainType queryOrderType = session.getQueryBuilder().createQueryDefinition(OrderLine.class);
            queryOrderType.where(queryOrderType.get("orderId").equal(queryOrderType.param("orderId")));
            Query query = session.createQuery((QueryDefinition)queryOrderType);
            for (int i = 0; i < MultithreadedTest.this.numberOfNewCustomersPerThread; ++i) {
                MultithreadedTest.this.createCustomer(session, String.valueOf(Thread.currentThread().getId()));
                for (int j = 0; j < MultithreadedTest.this.numberOfNewOrdersPerNewCustomer; ++j) {
                    MultithreadedTest.this.createOrder(session, this.myRandom);
                }
            }
            for (int j = 0; j < MultithreadedTest.this.numberOfUpdatesPerThread; ++j) {
                MultithreadedTest.this.updateOrder(session, this.myRandom, (Query<OrderLine>)query);
            }
            MultithreadedTest.this.deleteOrder(session, this.myRandom, (Query<OrderLine>)query);
        }
    }
}

