/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import com.mysql.clusterj.ClusterJFatalUserException;
import com.mysql.clusterj.ClusterJHelper;
import com.mysql.clusterj.Session;
import com.mysql.clusterj.SessionFactory;
import com.mysql.clusterj.core.SessionFactoryImpl;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.junit.Ignore;
import testsuite.clusterj.AbstractClusterJTest;
import testsuite.clusterj.model.Employee;

@Ignore(value="test requires specific connection pooling setup")
public class ConnectionPoolTest
extends AbstractClusterJTest {
    @Override
    public boolean getDebug() {
        return false;
    }

    protected boolean runSpecificNodeIdTests() {
        return false;
    }

    @Override
    public void localSetUp() {
        this.loadProperties();
        if (this.sessionFactory != null) {
            this.sessionFactory.close();
            this.sessionFactory = null;
        }
    }

    public void testNoPooling() {
        Properties modifiedProperties = new Properties();
        modifiedProperties.putAll((Map<?, ?>)props);
        SessionFactory sessionFactory1 = null;
        SessionFactory sessionFactory2 = null;
        modifiedProperties.put("com.mysql.clusterj.connection.pool.size", (Object)1);
        sessionFactory1 = ClusterJHelper.getSessionFactory((Map)modifiedProperties);
        sessionFactory2 = ClusterJHelper.getSessionFactory((Map)modifiedProperties);
        sessionFactory1.close();
        sessionFactory2.close();
        this.errorIfNotEqual("With connection pooling, SessionFactory1 should be the same object as SessionFactory2", true, sessionFactory1 == sessionFactory2);
        modifiedProperties.put("com.mysql.clusterj.connection.pool.size", (Object)0);
        sessionFactory1 = ClusterJHelper.getSessionFactory((Map)modifiedProperties);
        sessionFactory2 = ClusterJHelper.getSessionFactory((Map)modifiedProperties);
        try {
            SessionFactory sessionFactory3 = ClusterJHelper.getSessionFactory((Map)modifiedProperties);
            sessionFactory3.close();
        }
        catch (ClusterJFatalUserException ex) {
            // empty catch block
        }
        sessionFactory1.close();
        sessionFactory2.close();
        this.errorIfNotEqual("With no connection pooling, SessionFactory1 should not be the same object as SessionFactory2", false, sessionFactory1 == sessionFactory2);
        this.failOnError();
    }

    public void testConnectionPoolSize() {
        Properties modifiedProperties = new Properties();
        modifiedProperties.putAll((Map<?, ?>)props);
        modifiedProperties.put("com.mysql.clusterj.connection.pool.size", (Object)2);
        this.checkConnectionPoolSize2("testConnectionPoolSize", modifiedProperties);
        this.failOnError();
    }

    public void testConnectionPoolSizeAndNodeIds() {
        if (!this.runSpecificNodeIdTests()) {
            return;
        }
        Properties modifiedProperties = new Properties();
        modifiedProperties.putAll((Map<?, ?>)props);
        modifiedProperties.put("com.mysql.clusterj.connection.pool.size", (Object)2);
        modifiedProperties.put("com.mysql.clusterj.connection.pool.nodeids", "4;5");
        this.checkConnectionPoolSize2("testConnectionPoolSizeAndNodeIds", modifiedProperties);
        this.failOnError();
    }

    public void testConnectionNodeIds() {
        if (!this.runSpecificNodeIdTests()) {
            return;
        }
        Properties modifiedProperties = new Properties();
        modifiedProperties.putAll((Map<?, ?>)props);
        modifiedProperties.put("com.mysql.clusterj.connection.pool.nodeids", "4,5");
        this.checkConnectionPoolSize2("testConnectionNodeIds", modifiedProperties);
        this.failOnError();
    }

    public void testConnectionSingleNodeIdAndConnectionPoolSize() {
        if (!this.runSpecificNodeIdTests()) {
            return;
        }
        Properties modifiedProperties = new Properties();
        modifiedProperties.putAll((Map<?, ?>)props);
        modifiedProperties.put("com.mysql.clusterj.connection.pool.size", (Object)2);
        modifiedProperties.put("com.mysql.clusterj.connection.pool.nodeids", "4");
        this.checkConnectionPoolSize2("testConnectionNodeIds", modifiedProperties);
        this.failOnError();
    }

    private void checkConnectionPoolSize2(String where, Properties modifiedProperties) {
        SessionFactory sessionFactory1 = null;
        SessionFactory sessionFactory2 = null;
        SessionFactory sessionFactory3 = null;
        sessionFactory1 = ClusterJHelper.getSessionFactory((Map)modifiedProperties);
        sessionFactory2 = ClusterJHelper.getSessionFactory((Map)modifiedProperties);
        sessionFactory3 = ClusterJHelper.getSessionFactory((Map)modifiedProperties);
        this.errorIfNotEqual(where + " SessionFactory1 should be the same object as SessionFactory2", true, sessionFactory1 == sessionFactory2);
        this.errorIfNotEqual(where + " SessionFactory1 should be the same object as SessionFactory3", true, sessionFactory1 == sessionFactory3);
        Session session1 = sessionFactory1.getSession();
        Employee e1 = (Employee)session1.find(Employee.class, (Object)0);
        this.checkSessions(where + " after get session1", sessionFactory1, new Integer[]{1, 0});
        Session session2 = sessionFactory1.getSession();
        Employee e2 = (Employee)session2.find(Employee.class, (Object)0);
        this.checkSessions(where + " after get session2", sessionFactory1, new Integer[]{1, 1});
        Session session3 = sessionFactory1.getSession();
        this.checkSessions(where + " nafter get session3", sessionFactory1, new Integer[]{2, 1});
        Session session4 = sessionFactory1.getSession();
        this.checkSessions(where + " after get session4", sessionFactory1, new Integer[]{2, 2});
        Session session5 = sessionFactory1.getSession();
        this.checkSessions(where + " after get session5", sessionFactory1, new Integer[]{3, 2});
        Session session6 = sessionFactory1.getSession();
        this.checkSessions(where + " after get session6", sessionFactory1, new Integer[]{3, 3});
        session1.close();
        this.checkSessions(where + " after close session1", sessionFactory1, new Integer[]{2, 3});
        session4.close();
        this.checkSessions(where + " after close session4", sessionFactory1, new Integer[]{2, 2});
        session5.close();
        this.checkSessions(where + " after close session5", sessionFactory1, new Integer[]{1, 2});
        Session session7 = sessionFactory1.getSession();
        this.checkSessions(where + " after get session7", sessionFactory1, new Integer[]{2, 2});
        session2.close();
        session3.close();
        session6.close();
        session7.close();
        sessionFactory1.close();
    }

    public void testNegativeMismatchConnectionPoolSizeAndConnectionPoolNodeids() {
        block3: {
            Properties modifiedProperties = new Properties();
            modifiedProperties.putAll((Map<?, ?>)props);
            modifiedProperties.put("com.mysql.clusterj.connection.pool.size", (Object)3);
            modifiedProperties.put("com.mysql.clusterj.connection.pool.nodeids", "4\t5");
            try {
                ClusterJHelper.getSessionFactory((Map)modifiedProperties);
            }
            catch (ClusterJFatalUserException ex) {
                if (this.getDebug()) {
                    ex.printStackTrace();
                }
                String expected = "4\t5";
                if (ex.getMessage().contains(expected)) break block3;
                this.error("Mismatch error message should contain " + expected);
            }
        }
        this.failOnError();
    }

    public void testNegativeConnectionPoolNodeidsFormatError() {
        block3: {
            Properties modifiedProperties = new Properties();
            modifiedProperties.putAll((Map<?, ?>)props);
            modifiedProperties.put("com.mysql.clusterj.connection.pool.size", (Object)2);
            modifiedProperties.put("com.mysql.clusterj.connection.pool.nodeids", "7 t");
            try {
                ClusterJHelper.getSessionFactory((Map)modifiedProperties);
            }
            catch (ClusterJFatalUserException ex) {
                if (this.getDebug()) {
                    ex.printStackTrace();
                }
                String expected = "NumberFormatException";
                if (ex.getMessage().contains(expected)) break block3;
                this.error("Mismatch error message '" + ex.getMessage() + "' should contain '" + expected + '\"');
            }
        }
        this.failOnError();
    }

    public void testNegativeConnectionPoolIllegalNodeids() {
        block3: {
            Properties modifiedProperties = new Properties();
            modifiedProperties.putAll((Map<?, ?>)props);
            modifiedProperties.put("com.mysql.clusterj.connection.pool.nodeids", "256");
            try {
                ClusterJHelper.getSessionFactory((Map)modifiedProperties);
            }
            catch (ClusterJFatalUserException ex) {
                if (this.getDebug()) {
                    ex.printStackTrace();
                }
                String expected = "illegal";
                if (ex.getMessage().contains(expected)) break block3;
                this.error("Mismatch error message '" + ex.getMessage() + "' should contain '" + expected + '\"');
            }
        }
        this.failOnError();
    }

    public void testNegativeConnectionPoolNoNodeId() {
        block4: {
            if (!this.runSpecificNodeIdTests()) {
                return;
            }
            Properties modifiedProperties = new Properties();
            modifiedProperties.putAll((Map<?, ?>)props);
            modifiedProperties.put("com.mysql.clusterj.connection.pool.nodeids", "48");
            try {
                ClusterJHelper.getSessionFactory((Map)modifiedProperties);
            }
            catch (ClusterJFatalUserException ex) {
                if (this.getDebug()) {
                    ex.printStackTrace();
                }
                String expected = "No node defined";
                if (ex.getMessage().contains(expected)) break block4;
                this.error("Mismatch error message '" + ex.getMessage() + "' should contain '" + expected + '\"');
            }
        }
        this.failOnError();
    }

    private void checkSessions(String where, SessionFactory sessionFactory1, Integer[] expected) {
        SessionFactoryImpl sessionFactoryImpl = (SessionFactoryImpl)sessionFactory1;
        List connectionCounts = sessionFactoryImpl.getConnectionPoolSessionCounts();
        if (expected.length != connectionCounts.size()) {
            this.error(where + " wrong number of connections in pool\n" + "Expected: " + Arrays.toString((Object[])expected) + " Actual: " + connectionCounts);
            return;
        }
        int i = 0;
        for (Integer connectionCount : connectionCounts) {
            if (this.getDebug()) {
                System.out.println("Connection " + i + " has " + connectionCount + " sessions.");
            }
            if (i >= expected.length) break;
            this.errorIfNotEqual(where + " wrong count on connection " + i, expected[i], connectionCount);
            ++i;
        }
        if (this.getDebug()) {
            System.out.println();
        }
    }
}

