/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import com.mysql.clusterj.Query;
import com.mysql.clusterj.query.QueryBuilder;
import com.mysql.clusterj.query.QueryDefinition;
import com.mysql.clusterj.query.QueryDomainType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import testsuite.clusterj.AbstractClusterJModelTest;
import testsuite.clusterj.model.Employee;

public class AutoCommitTest
extends AbstractClusterJModelTest {
    protected static final int NUMBER_TO_INSERT = 4;

    @Override
    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.createEmployeeInstances(4);
        this.tx = this.session.currentTransaction();
        this.tx.begin();
        this.session.deletePersistentAll(Employee.class);
        this.tx.commit();
        this.addTearDownClasses(Employee.class);
    }

    public void test() {
        this.nontransactionalMakePersistent(0);
        this.assertTransactionNotActive("nontransactionalMakePersistent(0)");
        this.nontransactionalFind(0);
        this.assertTransactionNotActive("nontransactionalFind(0)");
        this.nontransactionalQuery(0);
        this.assertTransactionNotActive("nontransactionalQuery(0)");
        this.nontransactionalUpdate(0, 9);
        this.assertTransactionNotActive("nontransactionalUpdate(0, 9)");
        this.nontransactionalMakePersistentAll(1, 4);
        this.assertTransactionNotActive("nontransactionalMakePersistentAll(1, 4)");
        this.nontransactionalUpdateAll(1, 3, 9);
        this.assertTransactionNotActive("nontransactionalUpdateAll(1, 3, 9)");
        this.nontransactionalQuery(0, 1, 2, 3);
        this.assertTransactionNotActive("nontransactionalQuery(0, 1, 2, 3");
        this.nontransactionalDeletePersistent(2);
        this.assertTransactionNotActive("nontransactionalDeletePersistent(2)");
        this.nontransactionalQuery(0, 1, 3);
        this.assertTransactionNotActive("nontransactionalQuery(0, 1, 3)");
        this.nontransactionalDeletePersistentAll(0, 1);
        this.assertTransactionNotActive("nontransactionalDeletePersistentAll(0, 1)");
        this.nontransactionalQuery(1, 3);
        this.assertTransactionNotActive("nontransactionalQuery(1, 3)");
        this.nontransactionalDeletePersistentAll();
        this.assertTransactionNotActive("nontransactionalDeletePersistentAll()");
        this.nontransactionalQuery(new int[0]);
        this.assertTransactionNotActive("nontransactionalQuery()");
        this.failOnError();
    }

    protected void nontransactionalDeletePersistent(int which) {
        this.session.deletePersistent(this.employees.get(which));
    }

    protected void nontransactionalDeletePersistentAll() {
        this.session.deletePersistentAll(Employee.class);
    }

    protected void nontransactionalDeletePersistentAll(int low, int high) {
        this.session.deletePersistentAll(this.employees.subList(low, high));
    }

    protected void nontransactionalMakePersistent(int which) {
        this.session.makePersistent(this.employees.get(which));
    }

    protected void nontransactionalMakePersistentAll(int low, int high) {
        List emps = this.employees.subList(low, high);
        this.session.makePersistentAll(emps);
    }

    protected void nontransactionalQuery(int ... expected) {
        QueryBuilder builder = this.session.getQueryBuilder();
        QueryDomainType dobj = builder.createQueryDefinition(Employee.class);
        Query query = this.session.createQuery((QueryDefinition)dobj);
        List result = query.getResultList();
        HashSet<Integer> expectedList = new HashSet<Integer>();
        for (int i : expected) {
            expectedList.add(i);
        }
        HashSet<Integer> actualList = new HashSet<Integer>();
        for (Employee e : result) {
            actualList.add(e.getId());
        }
        this.errorIfNotEqual("Mismatch in query result list", expectedList, actualList);
    }

    protected void nontransactionalUpdate(int which, int newAge) {
        Employee e = (Employee)this.session.find(Employee.class, (Object)which);
        e.setAge(newAge);
        this.session.updatePersistent((Object)e);
        e = (Employee)this.session.find(Employee.class, (Object)which);
        this.errorIfNotEqual("Mismatch in nontransactionalUpdate result age", newAge, e.getAge());
    }

    protected void nontransactionalUpdateAll(int low, int high, int newAge) {
        Employee e;
        int i;
        ArrayList<Employee> emps = new ArrayList<Employee>();
        for (i = low; i < high; ++i) {
            e = (Employee)this.session.find(Employee.class, (Object)i);
            e.setAge(newAge);
            emps.add(e);
        }
        this.session.updatePersistentAll(emps);
        for (i = low; i < high; ++i) {
            e = (Employee)this.session.find(Employee.class, (Object)i);
            this.errorIfNotEqual("Mismatch in nontransactionalUpdateAll result age", newAge, e.getAge());
        }
    }

    private void assertTransactionNotActive(String where) {
        if (this.tx.isActive()) {
            this.error("After " + where + " the transaction was active.");
        }
    }

    private void nontransactionalFind(int which) {
        this.session.find(Employee.class, (Object)which);
    }
}

