/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.jpatest;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import junit.framework.TestCase;
import junit.framework.TestResult;

public abstract class PersistenceTestCase
extends TestCase {
    protected TestResult testResult;
    private StringBuffer errorMessages;
    private String NL = "\n";
    protected Map map;

    protected EntityManagerFactory createEMF(Object ... props) {
        String puName = this.getPersistenceUnitName();
        EntityManagerFactory result = this.createNamedEMF(puName, props);
        return result;
    }

    protected String getPersistenceUnitName() {
        String puName = System.getProperty("com.mysql.clusterj.jpa.PersistenceUnit", "ndb");
        if (puName.length() == 0 || puName.equals("${com.mysql.clusterj.jpa.PersistenceUnit}")) {
            return "ndb";
        }
        return puName;
    }

    protected EntityManagerFactory createNamedEMF(String pu, Object ... props) {
        this.map = new HashMap();
        boolean prop = false;
        for (int i = 0; props != null && i < props.length; ++i) {
            if (prop) {
                this.map.put(props[i - 1], props[i]);
                prop = false;
                continue;
            }
            if (props[i] == null) continue;
            prop = true;
        }
        return Persistence.createEntityManagerFactory((String)pu, (Map)this.map);
    }

    public void run(TestResult testResult) {
        this.testResult = testResult;
        super.run(testResult);
    }

    public void tearDown() throws Exception {
        block2: {
            try {
                super.tearDown();
            }
            catch (Exception e) {
                if (!this.testResult.wasSuccessful()) break block2;
                throw e;
            }
        }
    }

    protected boolean closeEMF(EntityManagerFactory emf) {
        if (emf == null || !emf.isOpen()) {
            return false;
        }
        emf.close();
        return !emf.isOpen();
    }

    protected void initializeErrorMessages() {
        if (this.errorMessages == null) {
            this.errorMessages = new StringBuffer();
            this.errorMessages.append(this.NL);
        }
    }

    protected void error(String message) {
        this.initializeErrorMessages();
        this.errorMessages.append(message + this.NL);
    }

    protected void errorIfNotEqual(String message, Object expected, Object actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null && expected.equals(actual)) {
            return;
        }
        this.initializeErrorMessages();
        this.errorMessages.append(message + this.NL);
        this.errorMessages.append("Expected: " + (expected == null ? "null" : expected.toString()) + " actual: " + (actual == null ? "null" : actual.toString()) + this.NL);
    }

    protected void errorIfNull(String message, Object actual) {
        if (actual != null) {
            return;
        }
        this.initializeErrorMessages();
        this.errorMessages.append(message + this.NL);
    }

    protected void failOnError() {
        if (this.errorMessages != null) {
            PersistenceTestCase.fail((String)this.errorMessages.toString());
        }
    }
}

