/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.jpatest;

import com.mysql.clusterj.jpatest.Driver;
import com.mysql.clusterj.jpatest.model.A;
import com.mysql.clusterj.jpatest.model.B0;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.Query;

public class JpaLoad
extends Driver {
    protected String driver;
    protected String url;
    protected EntityManagerFactory emf;
    protected EntityManager em;
    protected Query delAllA;
    protected Query delAllB0;

    @Override
    protected void initProperties() {
        super.initProperties();
        this.driver = this.props.getProperty("openjpa.ConnectionDriverName");
        if (this.driver == null) {
            throw new RuntimeException("Missing property: openjpa.ConnectionDriverName");
        }
        try {
            Class.forName(this.driver);
        }
        catch (ClassNotFoundException e) {
            out.println("Cannot load JDBC driver '" + this.driver + "' from classpath '" + System.getProperty("java.class.path") + "'");
            throw new RuntimeException(e);
        }
        this.url = this.props.getProperty("openjpa.ConnectionURL");
        if (this.url == null) {
            throw new RuntimeException("Missing property: openjpa.ConnectionURL");
        }
        this.descr = "->JPA->" + this.url;
    }

    @Override
    protected void printProperties() {
        super.printProperties();
        out.println("openjpa.ConnectionDriverName: " + this.driver);
        out.println("openjpa.ConnectionURL:        " + this.url);
    }

    @Override
    protected void init() throws Exception {
        super.init();
        out.println();
        out.print("creating EMFactory ...");
        out.flush();
        this.emf = Persistence.createEntityManagerFactory((String)"crundjpa", (Map)this.props);
        out.println("      [EMF: 1]");
    }

    @Override
    protected void close() throws Exception {
        out.print("closing EMFactory ...");
        out.flush();
        if (this.emf != null) {
            this.emf.close();
        }
        this.emf = null;
        out.println("       [ok]");
        super.close();
    }

    @Override
    protected void initConnection() {
        out.print("creating EntityManager ...");
        out.flush();
        this.em = this.emf.createEntityManager();
        this.delAllA = this.em.createQuery("DELETE FROM A");
        this.delAllB0 = this.em.createQuery("DELETE FROM B0");
        out.println("  [EM: 1]");
    }

    @Override
    protected void closeConnection() {
        out.print("closing EntityManager ...");
        out.flush();
        this.delAllB0 = null;
        this.delAllA = null;
        if (this.em != null) {
            this.em.close();
        }
        this.em = null;
        out.println("   [ok]");
    }

    protected int checkFields(A o) {
        int cint = o.getCint();
        long clong = o.getClong();
        JpaLoad.verify(clong == (long)cint);
        float cfloat = o.getCfloat();
        JpaLoad.verify(cfloat == (float)cint);
        double cdouble = o.getCdouble();
        JpaLoad.verify(cdouble == (double)cint);
        return cint;
    }

    protected int checkFields(B0 o) {
        int cint = o.getCint();
        long clong = o.getClong();
        JpaLoad.verify(clong == (long)cint);
        float cfloat = o.getCfloat();
        JpaLoad.verify(cfloat == (float)cint);
        double cdouble = o.getCdouble();
        JpaLoad.verify(cdouble == (double)cint);
        return cint;
    }

    @Override
    protected void initOperations() {
        out.print("initializing operations ...");
        out.flush();
        this.ops.add(new JpaOp("insA"){

            @Override
            public void run(int countA, int countB) {
                for (int i = 0; i < countA; ++i) {
                    A o = new A();
                    o.setId(i);
                    JpaLoad.this.em.persist((Object)o);
                }
            }
        });
        this.ops.add(new JpaOp("insB0"){

            @Override
            public void run(int countA, int countB) {
                for (int i = 0; i < countB; ++i) {
                    B0 o = new B0();
                    o.setId(i);
                    JpaLoad.this.em.persist((Object)o);
                }
            }
        });
        this.ops.add(new JpaOp("setAByPK"){

            @Override
            public void run(int countA, int countB) {
                for (int i = 0; i < countA; ++i) {
                    A o = (A)JpaLoad.this.em.find(A.class, (Object)i);
                    assert (o != null);
                    o.setCint(i);
                    o.setClong(i);
                    o.setCfloat(i);
                    o.setCdouble(i);
                }
            }
        });
        this.ops.add(new JpaOp("setB0ByPK"){

            @Override
            public void run(int countA, int countB) {
                for (int i = 0; i < countB; ++i) {
                    B0 o = (B0)JpaLoad.this.em.find(B0.class, (Object)i);
                    assert (o != null);
                    o.setCint(i);
                    o.setClong(i);
                    o.setCfloat(i);
                    o.setCdouble(i);
                }
            }
        });
        this.ops.add(new JpaOp("getAByPK"){

            @Override
            public void run(int countA, int countB) {
                for (int i = 0; i < countA; ++i) {
                    A o = (A)JpaLoad.this.em.find(A.class, (Object)i);
                    assert (o != null);
                    int id = o.getId();
                    Driver.verify(id == i);
                    int j = JpaLoad.this.checkFields(o);
                    Driver.verify(j == id);
                }
            }
        });
        this.ops.add(new JpaOp("getB0ByPK"){

            @Override
            public void run(int countA, int countB) {
                for (int i = 0; i < countB; ++i) {
                    B0 o = (B0)JpaLoad.this.em.find(B0.class, (Object)i);
                    assert (o != null);
                    int id = o.getId();
                    Driver.verify(id == i);
                    int j = JpaLoad.this.checkFields(o);
                    Driver.verify(j == id);
                }
            }
        });
        this.ops.add(new JpaOp("setB0->A"){

            @Override
            public void run(int countA, int countB) {
                for (int i = 0; i < countB; ++i) {
                    B0 b0 = (B0)JpaLoad.this.em.find(B0.class, (Object)i);
                    assert (b0 != null);
                    int aId = i % countA;
                    A a = (A)JpaLoad.this.em.find(A.class, (Object)aId);
                    assert (a != null);
                    b0.setA(a);
                }
            }
        });
        this.ops.add(new JpaOp("navB0->A"){

            @Override
            public void run(int countA, int countB) {
                for (int i = 0; i < countB; ++i) {
                    B0 b0 = (B0)JpaLoad.this.em.find(B0.class, (Object)i);
                    assert (b0 != null);
                    A a = b0.getA();
                    assert (a != null);
                    int id = a.getId();
                    Driver.verify(id == i % countA);
                    int j = JpaLoad.this.checkFields(a);
                    Driver.verify(j == id);
                }
            }
        });
        this.ops.add(new JpaOp("nullB0->A"){

            @Override
            public void run(int countA, int countB) {
                for (int i = 0; i < countB; ++i) {
                    B0 b0 = (B0)JpaLoad.this.em.find(B0.class, (Object)i);
                    assert (b0 != null);
                    b0.setA(null);
                }
            }
        });
        this.ops.add(new JpaOp("setA->B0"){

            @Override
            public void run(int countA, int countB) {
                for (int i = 0; i < countA; ++i) {
                    A a = (A)JpaLoad.this.em.find(A.class, (Object)i);
                    assert (a != null);
                    ArrayList<B0> b0s = new ArrayList<B0>();
                    for (int j = i; j < countB; j += countA) {
                        B0 b0 = (B0)JpaLoad.this.em.find(B0.class, (Object)j);
                        assert (b0 != null);
                        b0s.add(b0);
                    }
                    a.setB0s(b0s);
                }
            }
        });
        if (this.allowExtendedPC) {
            this.ops.add(new JpaOp("navA->B0"){

                @Override
                public void run(int countA, int countB) {
                    for (int i = 0; i < countA; ++i) {
                        A a = (A)JpaLoad.this.em.find(A.class, (Object)i);
                        assert (a != null);
                        Collection<B0> b0s = a.getB0s();
                        assert (b0s != null);
                        Driver.verify(b0s.size() > 0);
                        for (B0 b0 : b0s) {
                            assert (b0 != null);
                            int id = b0.getId();
                            Driver.verify(id % countA == i);
                            int j = JpaLoad.this.checkFields(b0);
                            Driver.verify(j == id);
                        }
                    }
                }
            });
        }
        this.ops.add(new JpaOp("nullA->B0"){

            @Override
            public void run(int countA, int countB) {
                for (int i = 0; i < countA; ++i) {
                    A a = (A)JpaLoad.this.em.find(A.class, (Object)i);
                    assert (a != null);
                    a.setB0s(null);
                }
            }
        });
        this.ops.add(new JpaOp("delB0ByPK"){

            @Override
            public void run(int countA, int countB) {
                for (int i = 0; i < countB; ++i) {
                    B0 o = (B0)JpaLoad.this.em.find(B0.class, (Object)i);
                    assert (o != null);
                    JpaLoad.this.em.remove((Object)o);
                }
            }
        });
        this.ops.add(new JpaOp("delAByPK"){

            @Override
            public void run(int countA, int countB) {
                for (int i = 0; i < countA; ++i) {
                    A o = (A)JpaLoad.this.em.find(A.class, (Object)i);
                    assert (o != null);
                    JpaLoad.this.em.remove((Object)o);
                }
            }
        });
        this.ops.add(new JpaOp("insA_attr"){

            @Override
            public void run(int countA, int countB) {
                for (int i = 0; i < countA; ++i) {
                    A o = new A();
                    o.setId(i);
                    o.setCint(-i);
                    o.setClong(-i);
                    o.setCfloat(-i);
                    o.setCdouble(-i);
                    o.setCstring(String.valueOf(i));
                    JpaLoad.this.em.persist((Object)o);
                }
            }
        });
        this.ops.add(new JpaOp("insB0_attr"){

            @Override
            public void run(int countA, int countB) {
                for (int i = 0; i < countB; ++i) {
                    B0 o = new B0();
                    o.setId(i);
                    o.setCint(-i);
                    o.setClong(-i);
                    o.setCfloat(-i);
                    o.setCdouble(-i);
                    o.setCstring(String.valueOf(i));
                    JpaLoad.this.em.persist((Object)o);
                }
            }
        });
        this.ops.add(new JpaOp("delAllB0"){

            @Override
            public void run(int countA, int countB) {
                int del = JpaLoad.this.em.createQuery("DELETE FROM B0").executeUpdate();
                assert (del == countB);
            }
        });
        this.ops.add(new JpaOp("delAllA"){

            @Override
            public void run(int countA, int countB) {
                int del = JpaLoad.this.em.createQuery("DELETE FROM A").executeUpdate();
                assert (del == countA);
            }
        });
        Iterator i = this.ops.iterator();
        while (i.hasNext()) {
            ((JpaOp)i.next()).init();
        }
        out.println(" [JpaOp: " + this.ops.size() + "]");
    }

    @Override
    protected void closeOperations() {
        out.print("closing operations ...");
        out.flush();
        Iterator i = this.ops.iterator();
        while (i.hasNext()) {
            ((JpaOp)i.next()).close();
        }
        this.ops.clear();
        out.println("      [ok]");
    }

    @Override
    protected void beginTransaction() {
        this.em.getTransaction().begin();
    }

    @Override
    protected void commitTransaction() {
        this.em.getTransaction().commit();
    }

    @Override
    protected void rollbackTransaction() {
        this.em.getTransaction().rollback();
    }

    @Override
    protected void clearPersistenceContext() {
        this.em.clear();
    }

    @Override
    protected void clearData() {
        out.print("deleting all objects ...");
        out.flush();
        this.em.getTransaction().begin();
        int delB0 = this.delAllB0.executeUpdate();
        out.print("    [B0: " + delB0);
        out.flush();
        int delA = this.delAllA.executeUpdate();
        out.print(", A: " + delA);
        out.flush();
        this.em.getTransaction().commit();
        this.em.clear();
        out.println("]");
    }

    public static void main(String[] args) {
        JpaLoad.clearPropFileNames();
        System.out.println("JpaLoad.main()");
        JpaLoad.parseArguments(args);
        new JpaLoad().run();
        System.out.println();
        System.out.println("JpaLoad.main(): done.");
    }

    protected abstract class JpaOp
    extends Driver.Op {
        public JpaOp(String name) {
            super(name);
        }

        public void init() {
        }

        public void close() {
        }
    }
}

