/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.jpatest;

import com.mysql.clusterj.jpatest.AbstractJPABaseTest;
import com.mysql.clusterj.jpatest.model.ClobTypes;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ClobTest
extends AbstractJPABaseTest {
    private static final int NUMBER_TO_INSERT = 16;
    protected List<ClobTypes> clobs = new ArrayList<ClobTypes>();
    private char[] chars = this.getChars(Charset.forName("latin1"));

    @Override
    protected boolean getDebug() {
        return false;
    }

    private char[] getChars(Charset charset) {
        CharsetEncoder encoder = charset.newEncoder();
        char[] result = new char[128];
        char current = '\u0000';
        for (int i = 0; i < result.length; ++i) {
            result[i] = current = this.nextChar(encoder, current);
        }
        return result;
    }

    char nextChar(CharsetEncoder encoder, char current) {
        if (encoder.canEncode(current = (char)(current + '\u0001'))) {
            return current;
        }
        return this.nextChar(encoder, current);
    }

    public void test() {
        this.createClobInstances(16);
        this.remove();
        this.insert();
        this.update();
        this.failOnError();
    }

    protected void remove() {
        this.removeAll(ClobTypes.class);
    }

    protected void insert() {
        this.tx = this.em.getTransaction();
        this.tx.begin();
        int count = 0;
        for (int i = 0; i < 16; ++i) {
            this.em.persist((Object)this.clobs.get(i));
            ++count;
        }
        this.tx.commit();
    }

    protected void update() {
        String string;
        int actualId;
        ClobTypes e;
        int i;
        this.tx.begin();
        for (i = 1; i < 16; ++i) {
            e = (ClobTypes)this.em.find(ClobTypes.class, (Object)i);
            actualId = e.getId();
            if (actualId != i) {
                this.error("Expected ClobTypes.id " + i + " but got " + actualId);
            }
            string = e.getLarge10000();
            this.checkString("before update", string, i, false);
            int position = this.getClobSizeFor(i) / 2;
            if (string.length() == position * 2) {
                StringBuilder sb = new StringBuilder(string);
                sb.replace(position, position + 1, "!");
                string = sb.toString();
                this.checkString("after update", string, i, true);
            }
            e.setLarge10000(string);
        }
        this.tx.commit();
        this.tx.begin();
        for (i = 1; i < 16; ++i) {
            e = (ClobTypes)this.em.find(ClobTypes.class, (Object)i);
            actualId = e.getId();
            if (actualId != i) {
                this.error("Expected ClobTypes.id " + i + " but got " + actualId);
            }
            string = e.getLarge10000();
            this.checkString("after commit", string, i, true);
        }
        this.tx.commit();
    }

    protected void createClobInstances(int number) {
        for (int i = 0; i < number; ++i) {
            ClobTypes instance = new ClobTypes();
            instance.setId(i);
            int length = this.getClobSizeFor(i);
            instance.setLarge10000(this.getString(length));
            this.clobs.add(instance);
        }
    }

    protected String getString(int size) {
        char[] result = new char[size];
        for (int i = 0; i < size; ++i) {
            result[i] = this.chars[i % 128];
        }
        return new String(result);
    }

    protected void checkString(String where, String string, int number, boolean updated) {
        int actualSize;
        int expectedSize;
        if (this.getDebug()) {
            this.dumpClob(where, string);
        }
        if ((expectedSize = this.getClobSizeFor(number)) != (actualSize = string.length())) {
            this.error("In " + where + " wrong size of string; " + "expected: " + expectedSize + " actual: " + actualSize);
        }
        for (int i = 0; i < actualSize; ++i) {
            char actual;
            int position = expectedSize / 2;
            char expected = updated && i == position ? (char)'!' : this.chars[i % 128];
            if (expected == (actual = string.charAt(i))) continue;
            this.error("In " + where + " for size: " + actualSize + " mismatch in string at position " + i + " expected: " + expected + " actual: " + actual);
        }
    }

    protected InputStream getClobStream(final int i) {
        return new InputStream(){
            int size;
            int counter;
            {
                this.size = i;
                this.counter = 0;
            }

            @Override
            public int read() throws IOException {
                if (this.counter >= i) {
                    return -1;
                }
                return this.counter++ % 256;
            }
        };
    }

    protected void dumpClob(String where, String string) {
        System.out.println("In " + where + " dumpClob of size: " + string.length() + " " + Arrays.toString(string.getBytes()));
    }

    protected int getClobSizeFor(int i) {
        int length = (int)Math.pow(2.0, i);
        return length;
    }
}

