/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.core.store.Column;
import com.mysql.clusterj.core.store.IndexScanOperation;
import com.mysql.clusterj.core.store.Table;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.tie.ClusterTransactionImpl;
import com.mysql.clusterj.tie.ScanOperationImpl;
import com.mysql.clusterj.tie.Utility;
import com.mysql.ndbjtie.ndbapi.NdbIndexScanOperation;
import java.math.BigDecimal;
import java.math.BigInteger;

class IndexScanOperationImpl
extends ScanOperationImpl
implements IndexScanOperation {
    static final I18NHelper local = I18NHelper.getInstance(IndexScanOperationImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(IndexScanOperationImpl.class);
    private NdbIndexScanOperation ndbIndexScanOperation;

    public IndexScanOperationImpl(Table storeTable, NdbIndexScanOperation ndbIndexScanOperation, ClusterTransactionImpl transaction) {
        super(storeTable, ndbIndexScanOperation, transaction);
        this.ndbIndexScanOperation = ndbIndexScanOperation;
    }

    @Override
    public void setBoundBigInteger(Column storeColumn, IndexScanOperation.BoundType type, BigInteger value) {
        int returnCode = this.ndbIndexScanOperation.setBound(storeColumn.getName(), this.convertBoundType(type), Utility.convertValue(storeColumn, value));
        this.handleError(returnCode, this.ndbIndexScanOperation);
    }

    @Override
    public void setBoundByte(Column storeColumn, IndexScanOperation.BoundType type, byte value) {
        int returnCode = this.ndbIndexScanOperation.setBound(storeColumn.getName(), this.convertBoundType(type), Utility.convertValue(storeColumn, value));
        this.handleError(returnCode, this.ndbIndexScanOperation);
    }

    @Override
    public void setBoundBytes(Column storeColumn, IndexScanOperation.BoundType type, byte[] value) {
        int returnCode = this.ndbIndexScanOperation.setBound(storeColumn.getName(), this.convertBoundType(type), Utility.convertValue(storeColumn, value));
        this.handleError(returnCode, this.ndbIndexScanOperation);
    }

    @Override
    public void setBoundDecimal(Column storeColumn, IndexScanOperation.BoundType type, BigDecimal value) {
        int returnCode = this.ndbIndexScanOperation.setBound(storeColumn.getName(), this.convertBoundType(type), Utility.convertValue(storeColumn, value));
        this.handleError(returnCode, this.ndbIndexScanOperation);
    }

    @Override
    public void setBoundDouble(Column storeColumn, IndexScanOperation.BoundType type, Double value) {
        int returnCode = this.ndbIndexScanOperation.setBound(storeColumn.getName(), this.convertBoundType(type), Utility.convertValue(storeColumn, value));
        this.handleError(returnCode, this.ndbIndexScanOperation);
    }

    @Override
    public void setBoundFloat(Column storeColumn, IndexScanOperation.BoundType type, Float value) {
        int returnCode = this.ndbIndexScanOperation.setBound(storeColumn.getName(), this.convertBoundType(type), Utility.convertValue(storeColumn, value.floatValue()));
        this.handleError(returnCode, this.ndbIndexScanOperation);
    }

    @Override
    public void setBoundShort(Column storeColumn, IndexScanOperation.BoundType type, short value) {
        int returnCode = this.ndbIndexScanOperation.setBound(storeColumn.getName(), this.convertBoundType(type), Utility.convertValue(storeColumn, value));
        this.handleError(returnCode, this.ndbIndexScanOperation);
    }

    @Override
    public void setBoundInt(Column storeColumn, IndexScanOperation.BoundType type, Integer value) {
        int returnCode = this.ndbIndexScanOperation.setBound(storeColumn.getName(), this.convertBoundType(type), Utility.convertValue(storeColumn, value));
        this.handleError(returnCode, this.ndbIndexScanOperation);
    }

    @Override
    public void setBoundLong(Column storeColumn, IndexScanOperation.BoundType type, long value) {
        int returnCode = this.ndbIndexScanOperation.setBound(storeColumn.getName(), this.convertBoundType(type), Utility.convertValue(storeColumn, value));
        this.handleError(returnCode, this.ndbIndexScanOperation);
    }

    @Override
    public void setBoundString(Column storeColumn, IndexScanOperation.BoundType type, String value) {
        int returnCode = this.ndbIndexScanOperation.setBound(storeColumn.getName(), this.convertBoundType(type), Utility.convertValue(storeColumn, value));
        this.handleError(returnCode, this.ndbIndexScanOperation);
    }

    private int convertBoundType(IndexScanOperation.BoundType type) {
        switch (type) {
            case BoundEQ: {
                return 4;
            }
            case BoundGE: {
                return 2;
            }
            case BoundGT: {
                return 3;
            }
            case BoundLE: {
                return 0;
            }
            case BoundLT: {
                return 1;
            }
        }
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    @Override
    public void endBound(int rangeNumber) {
        if (logger.isDetailEnabled()) {
            logger.detail("IndexScanOperationImpl.endBound(" + rangeNumber + ")");
        }
        int returnCode = this.ndbIndexScanOperation.end_of_bound(rangeNumber);
        this.handleError(returnCode, this.ndbIndexScanOperation);
    }
}

