/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.core.store.Index;
import com.mysql.clusterj.core.store.IndexOperation;
import com.mysql.clusterj.core.store.Table;
import com.mysql.clusterj.tie.ClusterTransactionImpl;
import com.mysql.clusterj.tie.NdbRecordOperationImpl;

public class NdbRecordUniqueKeyOperationImpl
extends NdbRecordOperationImpl
implements IndexOperation {
    public NdbRecordUniqueKeyOperationImpl(ClusterTransactionImpl clusterTransaction, Index storeIndex, Table storeTable) {
        super(clusterTransaction, storeTable);
        this.ndbRecordKeys = clusterTransaction.getCachedNdbRecordImpl(storeIndex, storeTable);
        this.keyBufferSize = this.ndbRecordKeys.getBufferSize();
        this.keyBuffer = this.ndbRecordKeys.newBuffer();
    }

    public void endDefinition() {
        this.keyBuffer.limit(this.keyBufferSize);
        this.keyBuffer.position(0);
        this.valueBuffer.limit(this.valueBufferSize);
        this.valueBuffer.position(0);
        this.ndbOperation = this.clusterTransaction.readTuple(this.ndbRecordKeys.getNdbRecord(), this.keyBuffer, this.ndbRecordValues.getNdbRecord(), this.valueBuffer, this.mask, null);
        this.activateBlobs();
        this.clusterTransaction.postExecuteCallback(new Runnable(){

            public void run() {
                NdbRecordUniqueKeyOperationImpl.this.freeResourcesAfterExecute();
            }
        });
    }

    public String toString() {
        return " unique key " + this.tableName;
    }
}

