/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.core.query;

import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.Query;
import com.mysql.clusterj.Results;
import com.mysql.clusterj.core.SessionImpl;
import com.mysql.clusterj.core.query.BetweenPredicateImpl;
import com.mysql.clusterj.core.query.QueryDomainTypeImpl;
import com.mysql.clusterj.core.query.QueryExecutionContextImpl;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryImpl<E>
implements Query<E> {
    static final I18NHelper local = I18NHelper.getInstance(BetweenPredicateImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(BetweenPredicateImpl.class);
    protected SessionImpl session;
    protected QueryDomainTypeImpl<E> dobj;
    protected QueryExecutionContextImpl context = null;
    protected long skip = 0L;
    protected long limit = Long.MAX_VALUE;
    protected Query.Ordering ordering = null;
    protected String[] orderingFields = null;

    public QueryImpl(SessionImpl session, QueryDomainTypeImpl<E> dobj) {
        this.session = session;
        this.context = new QueryExecutionContextImpl(session);
        this.dobj = dobj;
    }

    @Override
    public void setLimits(long skip, long limit) {
        if (skip < 0L || limit < 0L) {
            throw new ClusterJUserException(local.message("ERR_Invalid_Limits", (Object)skip, (Object)limit));
        }
        this.skip = skip;
        if (Long.MAX_VALUE - skip < limit) {
            limit = Long.MAX_VALUE;
        } else {
            this.limit = limit + skip;
        }
    }

    @Override
    public void setOrdering(Query.Ordering ordering, String ... orderingFields) {
        this.ordering = ordering;
        this.orderingFields = orderingFields;
        StringBuilder builder = new StringBuilder();
        String separator = "";
        for (String orderingField : orderingFields) {
            try {
                this.dobj.get(orderingField);
            }
            catch (ClusterJUserException ex) {
                builder.append(separator);
                builder.append(orderingField);
                separator = ", ";
            }
        }
        String errors = builder.toString();
        if (errors.length() > 0) {
            throw new ClusterJUserException(local.message("ERR_Ordering_Field_Does_Not_Exist", (Object)errors));
        }
    }

    @Override
    public Results<E> execute(Object arg0) {
        throw new UnsupportedOperationException(local.message("ERR_NotImplemented"));
    }

    @Override
    public Results<E> execute(Object ... arg0) {
        throw new UnsupportedOperationException(local.message("ERR_NotImplemented"));
    }

    @Override
    public Results<E> execute(Map<String, ?> arg0) {
        throw new UnsupportedOperationException(local.message("ERR_NotImplemented"));
    }

    @Override
    public void setParameter(String parameterName, Object parameterValue) {
        this.context.bindParameterValue(parameterName, parameterValue);
    }

    @Override
    public List<E> getResultList() {
        List<E> results = this.dobj.getResultList(this.context, this.skip, this.limit, this.ordering, this.orderingFields);
        this.context = new QueryExecutionContextImpl(this.context);
        return results;
    }

    @Override
    public int deletePersistentAll() {
        if (this.skip != 0L || this.limit != Long.MAX_VALUE) {
            throw new ClusterJUserException(local.message("ERR_Invalid_Limits", (Object)this.skip, (Object)this.limit));
        }
        int result = this.dobj.deletePersistentAll(this.context);
        return result;
    }

    @Override
    public Map<String, Object> explain() {
        Map<String, Object> result = this.context.getExplain();
        if (result == null) {
            this.dobj.explain(this.context);
            return this.context.getExplain();
        }
        return result;
    }
}

