/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.core.metadata;

import com.mysql.clusterj.ClusterJException;
import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.ColumnMetadata;
import com.mysql.clusterj.DynamicObject;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.core.CacheManager;
import com.mysql.clusterj.core.metadata.AbstractDomainFieldHandlerImpl;
import com.mysql.clusterj.core.metadata.AbstractDomainTypeHandlerImpl;
import com.mysql.clusterj.core.metadata.DomainFieldHandlerImpl;
import com.mysql.clusterj.core.metadata.IndexHandlerImpl;
import com.mysql.clusterj.core.metadata.InvocationHandlerImpl;
import com.mysql.clusterj.core.metadata.KeyValueHandlerImpl;
import com.mysql.clusterj.core.spi.DomainFieldHandler;
import com.mysql.clusterj.core.spi.ValueHandler;
import com.mysql.clusterj.core.spi.ValueHandlerFactory;
import com.mysql.clusterj.core.store.Column;
import com.mysql.clusterj.core.store.Db;
import com.mysql.clusterj.core.store.Dictionary;
import com.mysql.clusterj.core.store.Index;
import com.mysql.clusterj.core.store.Operation;
import com.mysql.clusterj.core.store.ResultData;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainTypeHandlerImpl<T>
extends AbstractDomainTypeHandlerImpl<T> {
    Class<T> cls;
    boolean dynamic = false;
    private Map<String, Method> unmatchedGetMethods = new HashMap<String, Method>();
    private Map<String, Method> unmatchedSetMethods = new HashMap<String, Method>();
    protected Class<T> proxyClass;
    Constructor<T> ctor;
    PersistenceCapable persistenceCapable;
    ValueHandlerFactory valueHandlerFactory;
    private int[] fieldNumberToColumnNumberMap;
    private int numberOfTransientFields;
    private DomainFieldHandlerImpl[] transientFieldHandlers;
    protected static final Class<?>[] invocationHandlerClassArray = new Class[]{InvocationHandler.class};
    protected ValueHandlerFactory defaultInvocationHandlerFactory = new ValueHandlerFactory(){

        public <V> ValueHandler getValueHandler(DomainTypeHandlerImpl<V> domainTypeHandler, Db db) {
            return new InvocationHandlerImpl<V>(domainTypeHandler);
        }

        public <V> ValueHandler getKeyValueHandler(DomainTypeHandlerImpl<V> domainTypeHandler, Db db, Object keyValues) {
            Object[] expandedKeyValues = DomainTypeHandlerImpl.this.expandKeyValues(keyValues);
            return new KeyValueHandlerImpl(expandedKeyValues);
        }

        public <V> ValueHandler getValueHandler(DomainTypeHandlerImpl<V> domainTypeHandler, Db db, ResultData resultData) {
            InvocationHandlerImpl<V> result = new InvocationHandlerImpl<V>(domainTypeHandler);
            DomainTypeHandlerImpl.this.objectSetValues(resultData, result);
            return result;
        }
    };

    public DomainTypeHandlerImpl(Class<T> cls, Dictionary dictionary) {
        this(cls, dictionary, null);
    }

    public DomainTypeHandlerImpl(Class<T> cls, Dictionary dictionary, ValueHandlerFactory smartValueHandlerFactory) {
        ArrayList<String> fieldNameList;
        String[] indexNames;
        this.valueHandlerFactory = smartValueHandlerFactory != null ? smartValueHandlerFactory : this.defaultInvocationHandlerFactory;
        this.cls = cls;
        this.name = cls.getName();
        if (DynamicObject.class.isAssignableFrom(cls)) {
            this.dynamic = true;
            this.tableName = DomainTypeHandlerImpl.getTableNameForDynamicObject(cls);
        } else {
            this.proxyClass = Proxy.getProxyClass(cls.getClassLoader(), cls);
            this.ctor = this.getConstructorForInvocationHandler(this.proxyClass);
            this.persistenceCapable = cls.getAnnotation(PersistenceCapable.class);
            if (this.persistenceCapable == null) {
                throw new ClusterJUserException(local.message("ERR_No_Persistence_Capable_Annotation", (Object)this.name));
            }
            this.tableName = this.persistenceCapable.table();
        }
        this.table = this.getTable(dictionary);
        if (this.table == null) {
            throw new ClusterJUserException(local.message("ERR_Get_NdbTable", (Object)this.name, (Object)this.tableName));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Found Table for " + this.tableName);
        }
        this.primaryKeyColumnNames = this.table.getPrimaryKeyColumnNames();
        this.numberOfIdFields = this.primaryKeyColumnNames.length;
        this.idFieldHandlers = new DomainFieldHandlerImpl[this.numberOfIdFields];
        this.idFieldNumbers = new int[this.numberOfIdFields];
        this.partitionKeyColumnNames = this.table.getPartitionKeyColumnNames();
        this.numberOfPartitionKeyColumns = this.partitionKeyColumnNames.length;
        this.partitionKeyFieldHandlers = new DomainFieldHandlerImpl[this.numberOfPartitionKeyColumns];
        Index primaryIndex = dictionary.getIndex("PRIMARY$KEY", this.tableName, "PRIMARY");
        IndexHandlerImpl primaryIndexHandler = new IndexHandlerImpl(this, dictionary, primaryIndex, this.primaryKeyColumnNames);
        this.indexHandlerImpls.add(primaryIndexHandler);
        ArrayList<AbstractDomainFieldHandlerImpl> fieldHandlerList = new ArrayList<AbstractDomainFieldHandlerImpl>();
        for (String indexName : indexNames = this.table.getIndexNames()) {
            String indexAlias = this.removeUniqueSuffix(indexName);
            Index index = dictionary.getIndex(indexName, this.tableName, indexAlias);
            String[] columnNames = index.getColumnNames();
            IndexHandlerImpl imd = new IndexHandlerImpl(this, dictionary, index, columnNames);
            this.indexHandlerImpls.add(imd);
        }
        if (this.dynamic) {
            fieldNameList = new ArrayList<String>();
            for (String columnName : this.table.getColumnNames()) {
                Column storeColumn = this.table.getColumn(columnName);
                DomainFieldHandlerImpl domainFieldHandler = null;
                domainFieldHandler = new DomainFieldHandlerImpl(this, this.table, this.numberOfFields++, storeColumn);
                String fieldName = domainFieldHandler.getName();
                fieldNameList.add(fieldName);
                this.fieldNameToNumber.put(domainFieldHandler.getName(), domainFieldHandler.getFieldNumber());
                this.persistentFieldHandlers.add(domainFieldHandler);
                fieldHandlerList.add(domainFieldHandler);
                if (storeColumn.isPrimaryKey()) continue;
                this.nonPKFieldHandlers.add(domainFieldHandler);
            }
            this.fieldNames = fieldNameList.toArray(new String[fieldNameList.size()]);
        } else {
            Method[] methods;
            fieldNameList = new ArrayList();
            for (Method method : methods = cls.getMethods()) {
                Method unmatched;
                String methodName = method.getName();
                String name = this.convertMethodName(methodName);
                Class<?> type = this.getType(method);
                AbstractDomainFieldHandlerImpl domainFieldHandler = null;
                if (methodName.startsWith("get")) {
                    unmatched = this.unmatchedSetMethods.get(name);
                    if (unmatched == null) {
                        this.unmatchedGetMethods.put(name, method);
                    } else if (this.getType(unmatched).equals(type)) {
                        this.unmatchedSetMethods.remove(name);
                        domainFieldHandler = new DomainFieldHandlerImpl(this, this.table, this.numberOfFields++, name, type, method, unmatched);
                    } else {
                        this.unmatchedGetMethods.put(name, method);
                    }
                } else if (methodName.startsWith("set")) {
                    unmatched = this.unmatchedGetMethods.get(name);
                    if (unmatched == null) {
                        this.unmatchedSetMethods.put(name, method);
                    } else if (this.getType(unmatched).equals(type)) {
                        this.unmatchedGetMethods.remove(name);
                        domainFieldHandler = new DomainFieldHandlerImpl(this, this.table, this.numberOfFields++, name, type, unmatched, method);
                    } else {
                        this.unmatchedSetMethods.put(name, method);
                    }
                }
                if (domainFieldHandler == null) continue;
                String fieldName = domainFieldHandler.getName();
                fieldNameList.add(fieldName);
                this.fieldNameToNumber.put(domainFieldHandler.getName(), domainFieldHandler.getFieldNumber());
                if (((DomainFieldHandlerImpl)domainFieldHandler).isPersistent()) {
                    this.persistentFieldHandlers.add(domainFieldHandler);
                    if (!domainFieldHandler.isPrimaryKey()) {
                        this.nonPKFieldHandlers.add(domainFieldHandler);
                    }
                }
                if (domainFieldHandler.isPrimitive()) {
                    this.primitiveFieldHandlers.add(domainFieldHandler);
                }
                fieldHandlerList.add(domainFieldHandler);
            }
            this.fieldNames = fieldNameList.toArray(new String[fieldNameList.size()]);
            if (!this.unmatchedGetMethods.isEmpty() || !this.unmatchedSetMethods.isEmpty()) {
                this.setUnsupported(local.message("ERR_Unmatched_Methods", (Object)this.unmatchedGetMethods, (Object)this.unmatchedSetMethods));
            }
        }
        String reasons = this.getUnsupported();
        if (reasons != null) {
            throw new ClusterJUserException(local.message("ERR_Field_Construction", (Object)this.name, (Object)reasons.toString()));
        }
        for (IndexHandlerImpl indexHandler : this.indexHandlerImpls) {
            indexHandler.assertAllColumnsHaveFields();
        }
        if (!((IndexHandlerImpl)this.indexHandlerImpls.get(0)).isUsable()) {
            String reason = local.message("ERR_Primary_Field_Missing", (Object)this.name);
            logger.info(reason);
            throw new ClusterJUserException(reason);
        }
        if (logger.isDebugEnabled()) {
            logger.debug(this.toString());
            logger.debug("DomainTypeHandlerImpl " + this.name + "Indices " + this.indexHandlerImpls);
        }
        this.fieldNumberToColumnNumberMap = new int[this.numberOfFields];
        String[] columnNames = this.table.getColumnNames();
        this.fieldHandlers = fieldHandlerList.toArray(new DomainFieldHandlerImpl[this.numberOfFields]);
        int transientFieldNumber = 0;
        ArrayList<DomainFieldHandlerImpl> transientFieldHandlerList = new ArrayList<DomainFieldHandlerImpl>();
        for (int fieldNumber = 0; fieldNumber < this.numberOfFields; ++fieldNumber) {
            DomainFieldHandler fieldHandler = (DomainFieldHandler)fieldHandlerList.get(fieldNumber);
            String columnName = fieldHandler.getColumnName();
            boolean found = false;
            for (int columnNumber = 0; columnNumber < columnNames.length; ++columnNumber) {
                if (!columnNames[columnNumber].equals(columnName)) continue;
                this.fieldNumberToColumnNumberMap[fieldNumber] = columnNumber;
                found = true;
                break;
            }
            if (found) continue;
            this.fieldNumberToColumnNumberMap[fieldNumber] = --transientFieldNumber;
            transientFieldHandlerList.add((DomainFieldHandlerImpl)fieldHandler);
        }
        this.numberOfTransientFields = 0 - transientFieldNumber;
        this.transientFieldHandlers = transientFieldHandlerList.toArray(new DomainFieldHandlerImpl[transientFieldHandlerList.size()]);
    }

    protected static String getTableName(Class<?> cls) {
        String tableName = null;
        if (DynamicObject.class.isAssignableFrom(cls)) {
            tableName = DomainTypeHandlerImpl.getTableNameForDynamicObject(cls);
        } else {
            PersistenceCapable persistenceCapable = cls.getAnnotation(PersistenceCapable.class);
            if (persistenceCapable != null) {
                tableName = persistenceCapable.table();
            }
        }
        return tableName;
    }

    protected static <O extends DynamicObject> String getTableNameForDynamicObject(Class<O> cls) {
        PersistenceCapable persistenceCapable = cls.getAnnotation(PersistenceCapable.class);
        String tableName = null;
        try {
            DynamicObject dynamicObject = (DynamicObject)cls.newInstance();
            tableName = dynamicObject.table();
            if (tableName == null && persistenceCapable != null) {
                tableName = persistenceCapable.table();
            }
        }
        catch (InstantiationException e) {
            throw new ClusterJUserException(local.message("ERR_Dynamic_Object_Instantiation", (Object)cls.getName()), e);
        }
        catch (IllegalAccessException e) {
            throw new ClusterJUserException(local.message("ERR_Dynamic_Object_Illegal_Access", (Object)cls.getName()), e);
        }
        if (tableName == null) {
            throw new ClusterJUserException(local.message("ERR_Dynamic_Object_Null_Table_Name", (Object)cls.getName()));
        }
        return tableName;
    }

    @Override
    public boolean isSupportedType() {
        return true;
    }

    @Override
    public ValueHandler getValueHandler(Object instance) throws IllegalArgumentException {
        if (instance instanceof ValueHandler) {
            return (ValueHandler)instance;
        }
        if (instance instanceof DynamicObject) {
            return (ValueHandler)((DynamicObject)instance).delegate();
        }
        ValueHandler handler = (ValueHandler)Proxy.getInvocationHandler(instance);
        return handler;
    }

    @Override
    public void objectMarkModified(ValueHandler handler, String fieldName) {
        int fieldNumber = (Integer)this.fieldNameToNumber.get(fieldName);
        handler.markModified(fieldNumber);
    }

    @Override
    public Class<T> getProxyClass() {
        return this.proxyClass;
    }

    public Class<T> getDomainClass() {
        return this.cls;
    }

    public void operationSetValues(Object instance, Operation op) {
        ValueHandler handler = this.getValueHandler(instance);
        for (DomainFieldHandler fmd : this.persistentFieldHandlers) {
            fmd.operationSetValue(handler, op);
        }
    }

    @Override
    public void objectSetKeys(Object keys, Object instance) {
        ValueHandler handler = this.getValueHandler(instance);
        this.objectSetKeys(keys, handler);
    }

    public void objectSetKeys(Object keys, ValueHandler handler) {
        int size = this.idFieldHandlers.length;
        if (size == 1) {
            this.idFieldHandlers[0].objectSetKeyValue(keys, handler);
        } else if (keys instanceof Object[]) {
            if (logger.isDetailEnabled()) {
                logger.detail(keys.toString());
            }
            for (int i = 0; i < this.idFieldHandlers.length; ++i) {
                this.idFieldHandlers[i].objectSetKeyValue(((Object[])keys)[i], handler);
            }
        } else {
            throw new ClusterJUserException(local.message("ERR_Composite_Key_Parameter"));
        }
    }

    @Override
    public void objectResetModified(ValueHandler handler) {
        handler.resetModified();
    }

    @Override
    public void objectSetCacheManager(CacheManager cm, Object instance) {
        this.getValueHandler(instance).setCacheManager(cm);
    }

    @Override
    public T newInstance(Db db) {
        ValueHandler valueHandler = this.valueHandlerFactory.getValueHandler(this, db);
        return this.newInstance(valueHandler);
    }

    @Override
    public T newInstance(ResultData resultData, Db db) {
        ValueHandler valueHandler = this.valueHandlerFactory.getValueHandler(this, db, resultData);
        T result = this.newInstance(valueHandler);
        return result;
    }

    @Override
    public T newInstance(ValueHandler valueHandler) {
        try {
            T instance;
            if (this.dynamic) {
                instance = this.cls.newInstance();
                ((DynamicObject)instance).delegate(valueHandler);
            } else {
                instance = this.ctor.newInstance(valueHandler);
                valueHandler.setProxy(instance);
            }
            return instance;
        }
        catch (InstantiationException ex) {
            throw new ClusterJException(local.message("ERR_Create_Instance", (Object)this.cls.getName()), ex);
        }
        catch (IllegalAccessException ex) {
            throw new ClusterJException(local.message("ERR_Create_Instance", (Object)this.cls.getName()), ex);
        }
        catch (IllegalArgumentException ex) {
            throw new ClusterJException(local.message("ERR_Create_Instance", (Object)this.cls.getName()), ex);
        }
        catch (InvocationTargetException ex) {
            throw new ClusterJException(local.message("ERR_Create_Instance", (Object)this.cls.getName()), ex);
        }
        catch (SecurityException ex) {
            throw new ClusterJException(local.message("ERR_Create_Instance", (Object)this.cls.getName()), ex);
        }
    }

    public void initializePrimitiveFields(ValueHandler handler) {
        for (DomainFieldHandler fmd : this.primitiveFieldHandlers) {
            ((AbstractDomainFieldHandlerImpl)fmd).objectSetDefaultValue(handler);
        }
        handler.resetModified();
    }

    private String convertMethodName(String methodName) {
        String head = methodName.substring(3, 4).toLowerCase();
        String tail = methodName.substring(4);
        return head + tail;
    }

    @Override
    public T getInstance(ValueHandler valueHandler) {
        Object instance = valueHandler.getProxy();
        return (T)instance;
    }

    private Class<?> getType(Method method) {
        Class<?> result = null;
        if (method.getName().startsWith("get")) {
            result = method.getReturnType();
        } else if (method.getName().startsWith("set")) {
            Class<?>[] types = method.getParameterTypes();
            if (types.length != 1) {
                throw new ClusterJUserException(local.message("ERR_Set_Method_Parameters", (Object)method.getName(), (Object)types.length));
            }
            result = types[0];
        } else {
            throw new ClusterJFatalInternalException(local.message("ERR_Method_Name", (Object)method.getName()));
        }
        if (result == null) {
            throw new ClusterJUserException(local.message("ERR_Unmatched_Method" + method.getName()));
        }
        return result;
    }

    protected Constructor<T> getConstructorForInvocationHandler(Class<T> cls) {
        try {
            return cls.getConstructor(invocationHandlerClassArray);
        }
        catch (NoSuchMethodException ex) {
            throw new ClusterJFatalInternalException(local.message("ERR_Get_Constructor", (Object)cls), ex);
        }
        catch (SecurityException ex) {
            throw new ClusterJFatalInternalException(local.message("ERR_Get_Constructor", (Object)cls), ex);
        }
    }

    @Override
    public ValueHandler createKeyValueHandler(Object keys, Db db) {
        if (keys == null) {
            throw new ClusterJUserException(local.message("ERR_Key_Must_Not_Be_Null", (Object)this.getName(), (Object)"unknown"));
        }
        if (this.numberOfIdFields == 1) {
            Class<?> keyType = this.idFieldHandlers[0].getType();
            DomainFieldHandler fmd = this.idFieldHandlers[0];
            this.checkKeyType(fmd.getName(), keyType, keys);
        } else {
            if (!keys.getClass().isArray()) {
                throw new ClusterJUserException(local.message("ERR_Key_Must_Be_An_Object_Array", this.numberOfIdFields));
            }
            for (int i = 0; i < this.numberOfIdFields; ++i) {
                DomainFieldHandler fmd = this.idFieldHandlers[i];
                Object keyObject = ((Object[])keys)[i];
                Class<?> keyType = fmd.getType();
                this.checkKeyType(fmd.getName(), keyType, keyObject);
                if (keyObject != null || !fmd.isPartitionKey()) continue;
                throw new ClusterJUserException(local.message("ERR_Key_Must_Not_Be_Null", (Object)this.getName(), (Object)this.fieldHandlers[i].getName()));
            }
        }
        return this.valueHandlerFactory.getKeyValueHandler(this, db, keys);
    }

    public void checkKeyType(String name, Class<?> keyType, Object keys) throws ClusterJUserException {
        if (keys == null) {
            return;
        }
        Class<?> valueType = keys.getClass();
        if (keyType.isAssignableFrom(valueType) || keyType == Integer.TYPE && valueType == Integer.class || keyType == Integer.class & valueType == Integer.TYPE || keyType == Long.class & valueType == Long.TYPE || keyType == Long.TYPE & valueType == Long.class) {
            return;
        }
        throw new ClusterJUserException(local.message("ERR_Incorrect_Key_Type", name, valueType.getName(), keyType.getName()));
    }

    public Object[] expandKeyValues(Object keys) {
        Object[] keyValues = keys instanceof Object[] ? (Object[])keys : new Object[]{keys};
        Object[] result = new Object[this.numberOfFields];
        int i = 0;
        int[] arr$ = this.idFieldNumbers;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer idFieldNumber = arr$[i$];
            result[idFieldNumber.intValue()] = keyValues[i++];
        }
        return result;
    }

    @Override
    public Class<?> getOidClass() {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    public ColumnMetadata[] columnMetadata() {
        ColumnMetadata[] result = new ColumnMetadata[this.numberOfFields];
        return this.persistentFieldHandlers.toArray(result);
    }

    public int getNumberOfTransientFields() {
        return this.numberOfTransientFields;
    }

    public int[] getFieldNumberToColumnNumberMap() {
        return this.fieldNumberToColumnNumberMap;
    }

    public Object[] newTransientValues() {
        Object[] result = new Object[this.numberOfTransientFields];
        int i = 0;
        for (DomainFieldHandlerImpl transientFieldHandler : this.transientFieldHandlers) {
            Object value = transientFieldHandler.getDefaultValue();
            result[i++] = value;
        }
        return result;
    }
}

