/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import com.mysql.clusterj.ClusterJUserException;
import java.util.Arrays;
import testsuite.clusterj.AbstractQueryTest;
import testsuite.clusterj.model.LongIntStringIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryMultiColumnIndexInTest
extends AbstractQueryTest {
    private static final int MULTI_RANGE_IN_ITERATIONS = 1;
    protected int PK_MODULUS = 3;
    protected long PRETTY_BIG_NUMBER = 1000000000000000L;

    @Override
    public Class<?> getInstanceType() {
        return LongIntStringIndex.class;
    }

    @Override
    protected boolean getCleanupAfterTest() {
        return true;
    }

    public void testInAndBetween() {
        this.inAndBetweenQuery("longix", new Object[]{1000000000000000L, 0L}, "intix", 1, 2, "idx_long_int_string", 3, 4, 5, 6, 7, 8);
        this.inAndBetweenQuery("longix", Arrays.asList(1000000000000000L, 0L), "stringix", "1", "4", "idx_long_int_string", 1, 2, 4, 5, 7, 8);
        this.failOnError();
    }

    public void testBetweenAndIn() {
        this.betweenAndInQuery("longix", 0L, 3000000000000000L, "intix", new Object[]{2, 0}, "idx_long_int_string", 0, 1, 2, 6, 7, 8, 9);
        this.betweenAndInQuery("longix", 0L, 1000000000000000L, "intix", Arrays.asList(2, 1), "idx_long_int_string", 3, 4, 5, 6, 7, 8);
        this.failOnError();
    }

    public void testPartialBoundsAndEqual() {
        this.greaterThanAnd1ExtraQuery("longix", 0, "intix", this.extraEqualPredicateProvider, 0, "idx_long_int_string", 9);
        this.greaterEqualAnd1ExtraQuery("longix", 0, "intix", this.extraEqualPredicateProvider, 0, "idx_long_int_string", 0, 1, 2, 9);
        this.lessThanAnd1ExtraQuery("longix", 1000000000000000L, "intix", this.extraEqualPredicateProvider, 0, "idx_long_int_string", 0, 1, 2);
        this.lessEqualAnd1ExtraQuery("longix", 1000000000000000L, "intix", this.extraEqualPredicateProvider, 0, "idx_long_int_string", 0, 1, 2, 9);
        this.failOnError();
    }

    public void testGapBoundsAndEqual() {
        this.greaterThanAnd1ExtraQuery("longix", 0, "stringix", this.extraEqualPredicateProvider, "0", "idx_long_int_string", 9);
        this.greaterEqualAnd1ExtraQuery("longix", 0, "stringix", this.extraEqualPredicateProvider, "0", "idx_long_int_string", 0, 3, 6, 9);
        this.lessThanAnd1ExtraQuery("longix", 1000000000000000L, "stringix", this.extraEqualPredicateProvider, "0", "idx_long_int_string", 0, 3, 6);
        this.lessEqualAnd1ExtraQuery("longix", 1000000000000000L, "stringix", this.extraEqualPredicateProvider, "0", "idx_long_int_string", 0, 3, 6, 9);
        this.failOnError();
    }

    public void testNegativeInParameter() {
        block3: {
            int[] keys = new int[]{};
            try {
                this.inQuery("id", keys, "PRIMARY", keys);
                this.error("Query with ''in'' parameter of int[] type should fail.");
            }
            catch (ClusterJUserException e) {
                String message;
                if (this.getDebug()) {
                    e.printStackTrace();
                }
                if ((message = e.getMessage()).contains("id")) break block3;
                this.error("Query with ''in'' parameter of int[] type should fail.");
            }
        }
        this.failOnError();
    }

    public void testPrettyBigIn() {
        int arraySize = 4096;
        Integer[] keys = new Integer[arraySize];
        for (int i = 0; i < arraySize; ++i) {
            keys[i] = i;
        }
        int[] expectedKeys = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        for (int i = 0; i < 1; ++i) {
            this.inQuery("iteration " + Integer.toString(i) + " ", "id", keys, "PRIMARY", expectedKeys);
        }
        this.failOnError();
    }

    public void testNegativeInTooBig() {
        block4: {
            int arraySize = 4097;
            Integer[] keys = new Integer[arraySize];
            for (int i = 0; i < arraySize; ++i) {
                keys[i] = i;
            }
            int[] expectedKeys = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
            try {
                this.inQuery("id", keys, "PRIMARY", expectedKeys);
                this.error("Query with more than 4096 elements should fail.");
            }
            catch (ClusterJUserException e) {
                String message;
                if (this.getDebug()) {
                    e.printStackTrace();
                }
                if ((message = e.getMessage()).contains("4097")) break block4;
                this.error("Query with more than 4096 elements should fail.");
            }
        }
        this.failOnError();
    }

    @Override
    protected void createInstances(int number) {
        for (int i = 0; i < number; ++i) {
            LongIntStringIndex instance = this.createInstance(i);
            this.instances.add(instance);
        }
    }

    protected LongIntStringIndex createInstance(int index) {
        LongIntStringIndex instance = (LongIntStringIndex)this.session.newInstance(LongIntStringIndex.class);
        instance.setId(index);
        instance.setLongix(this.getPK1(index));
        instance.setIntix(this.getPK2(index));
        instance.setStringix(this.getPK3(index));
        instance.setStringvalue(this.getValue(index));
        return instance;
    }

    protected long getPK1(int index) {
        return this.PRETTY_BIG_NUMBER * (long)(index / this.PK_MODULUS / this.PK_MODULUS % this.PK_MODULUS);
    }

    protected int getPK2(int index) {
        return index / this.PK_MODULUS % this.PK_MODULUS;
    }

    protected String getPK3(int index) {
        return "" + index % this.PK_MODULUS;
    }

    protected String getValue(int index) {
        return "Value " + index;
    }

    protected String toString(LongIntStringIndex instance) {
        StringBuffer result = new StringBuffer();
        result.append("LongIntStringIndex[");
        result.append(instance.getId());
        result.append("]: ");
        result.append(instance.getLongix());
        result.append(", ");
        result.append(instance.getIntix());
        result.append(", \"");
        result.append(instance.getStringix());
        result.append("\", \"");
        result.append(instance.getStringvalue());
        result.append("\".");
        return result.toString();
    }
}

