/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import testsuite.clusterj.AbstractQueryTest;
import testsuite.clusterj.model.DoubleTypes;
import testsuite.clusterj.model.IdBase;

public class QueryDoubleTypesTest
extends AbstractQueryTest {
    public Class getInstanceType() {
        return DoubleTypes.class;
    }

    void createInstances(int number) {
        this.createAllDoubleTypesInstances(number);
    }

    public void test() {
        this.btreeIndexScanDouble();
        this.hashIndexScanDouble();
        this.bothIndexScanDouble();
        this.noneIndexScanDouble();
        this.failOnError();
    }

    public void btreeIndexScanDouble() {
        this.equalQuery("double_not_null_btree", "idx_double_not_null_btree", this.getDouble(8), 8);
        this.greaterEqualQuery("double_not_null_btree", "idx_double_not_null_btree", this.getDouble(7), 7, 8, 9);
        this.greaterThanQuery("double_not_null_btree", "idx_double_not_null_btree", this.getDouble(6), 7, 8, 9);
        this.lessEqualQuery("double_not_null_btree", "idx_double_not_null_btree", this.getDouble(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("double_not_null_btree", "idx_double_not_null_btree", this.getDouble(4), 3, 2, 1, 0);
        this.betweenQuery("double_not_null_btree", "idx_double_not_null_btree", this.getDouble(4), this.getDouble(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("double_not_null_btree", "idx_double_not_null_btree", this.getDouble(4), this.getDouble(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("double_not_null_btree", "idx_double_not_null_btree", this.getDouble(4), this.getDouble(6), 5, 6);
        this.greaterEqualAndLessThanQuery("double_not_null_btree", "idx_double_not_null_btree", this.getDouble(4), this.getDouble(6), 4, 5);
        this.greaterThanAndLessThanQuery("double_not_null_btree", "idx_double_not_null_btree", this.getDouble(4), this.getDouble(6), 5);
        this.equalQuery("double_null_btree", "idx_double_null_btree", this.getDouble(8), 8);
        this.greaterEqualQuery("double_null_btree", "idx_double_null_btree", this.getDouble(7), 7, 8, 9);
        this.greaterThanQuery("double_null_btree", "idx_double_null_btree", this.getDouble(6), 7, 8, 9);
        this.lessEqualQuery("double_null_btree", "idx_double_null_btree", this.getDouble(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("double_null_btree", "idx_double_null_btree", this.getDouble(4), 3, 2, 1, 0);
        this.betweenQuery("double_null_btree", "idx_double_null_btree", this.getDouble(4), this.getDouble(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("double_null_btree", "idx_double_null_btree", this.getDouble(4), this.getDouble(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("double_null_btree", "idx_double_null_btree", this.getDouble(4), this.getDouble(6), 5, 6);
        this.greaterEqualAndLessThanQuery("double_null_btree", "idx_double_null_btree", this.getDouble(4), this.getDouble(6), 4, 5);
        this.greaterThanAndLessThanQuery("double_null_btree", "idx_double_null_btree", this.getDouble(4), this.getDouble(6), 5);
    }

    public void hashIndexScanDouble() {
        this.equalQuery("double_not_null_hash", "idx_double_not_null_hash", this.getDouble(8), 8);
        this.greaterEqualQuery("double_not_null_hash", "none", this.getDouble(7), 7, 8, 9);
        this.greaterThanQuery("double_not_null_hash", "none", this.getDouble(6), 7, 8, 9);
        this.lessEqualQuery("double_not_null_hash", "none", this.getDouble(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("double_not_null_hash", "none", this.getDouble(4), 3, 2, 1, 0);
        this.betweenQuery("double_not_null_hash", "none", this.getDouble(4), this.getDouble(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("double_not_null_hash", "none", this.getDouble(4), this.getDouble(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("double_not_null_hash", "none", this.getDouble(4), this.getDouble(6), 5, 6);
        this.greaterEqualAndLessThanQuery("double_not_null_hash", "none", this.getDouble(4), this.getDouble(6), 4, 5);
        this.greaterThanAndLessThanQuery("double_not_null_hash", "none", this.getDouble(4), this.getDouble(6), 5);
        this.equalQuery("double_null_hash", "idx_double_null_hash", this.getDouble(8), 8);
        this.greaterEqualQuery("double_null_hash", "none", this.getDouble(7), 7, 8, 9);
        this.greaterThanQuery("double_null_hash", "none", this.getDouble(6), 7, 8, 9);
        this.lessEqualQuery("double_null_hash", "none", this.getDouble(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("double_null_hash", "none", this.getDouble(4), 3, 2, 1, 0);
        this.betweenQuery("double_null_hash", "none", this.getDouble(4), this.getDouble(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("double_null_hash", "none", this.getDouble(4), this.getDouble(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("double_null_hash", "none", this.getDouble(4), this.getDouble(6), 5, 6);
        this.greaterEqualAndLessThanQuery("double_null_hash", "none", this.getDouble(4), this.getDouble(6), 4, 5);
        this.greaterThanAndLessThanQuery("double_null_hash", "none", this.getDouble(4), this.getDouble(6), 5);
    }

    public void bothIndexScanDouble() {
        this.equalQuery("double_not_null_both", "idx_double_not_null_both", this.getDouble(8), 8);
        this.greaterEqualQuery("double_not_null_both", "idx_double_not_null_both", this.getDouble(7), 7, 8, 9);
        this.greaterThanQuery("double_not_null_both", "idx_double_not_null_both", this.getDouble(6), 7, 8, 9);
        this.lessEqualQuery("double_not_null_both", "idx_double_not_null_both", this.getDouble(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("double_not_null_both", "idx_double_not_null_both", this.getDouble(4), 3, 2, 1, 0);
        this.betweenQuery("double_not_null_both", "idx_double_not_null_both", this.getDouble(4), this.getDouble(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("double_not_null_both", "idx_double_not_null_both", this.getDouble(4), this.getDouble(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("double_not_null_both", "idx_double_not_null_both", this.getDouble(4), this.getDouble(6), 5, 6);
        this.greaterEqualAndLessThanQuery("double_not_null_both", "idx_double_not_null_both", this.getDouble(4), this.getDouble(6), 4, 5);
        this.greaterThanAndLessThanQuery("double_not_null_both", "idx_double_not_null_both", this.getDouble(4), this.getDouble(6), 5);
        this.equalQuery("double_null_both", "idx_double_null_both", this.getDouble(8), 8);
        this.greaterEqualQuery("double_null_both", "idx_double_null_both", this.getDouble(7), 7, 8, 9);
        this.greaterThanQuery("double_null_both", "idx_double_null_both", this.getDouble(6), 7, 8, 9);
        this.lessEqualQuery("double_null_both", "idx_double_null_both", this.getDouble(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("double_null_both", "idx_double_null_both", this.getDouble(4), 3, 2, 1, 0);
        this.betweenQuery("double_null_both", "idx_double_null_both", this.getDouble(4), this.getDouble(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("double_null_both", "idx_double_null_both", this.getDouble(4), this.getDouble(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("double_null_both", "idx_double_null_both", this.getDouble(4), this.getDouble(6), 5, 6);
        this.greaterEqualAndLessThanQuery("double_null_both", "idx_double_null_both", this.getDouble(4), this.getDouble(6), 4, 5);
        this.greaterThanAndLessThanQuery("double_null_both", "idx_double_null_both", this.getDouble(4), this.getDouble(6), 5);
    }

    public void noneIndexScanDouble() {
        this.equalQuery("double_not_null_none", "none", this.getDouble(8), 8);
        this.greaterEqualQuery("double_not_null_none", "none", this.getDouble(7), 7, 8, 9);
        this.greaterThanQuery("double_not_null_none", "none", this.getDouble(6), 7, 8, 9);
        this.lessEqualQuery("double_not_null_none", "none", this.getDouble(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("double_not_null_none", "none", this.getDouble(4), 3, 2, 1, 0);
        this.betweenQuery("double_not_null_none", "none", this.getDouble(4), this.getDouble(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("double_not_null_none", "none", this.getDouble(4), this.getDouble(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("double_not_null_none", "none", this.getDouble(4), this.getDouble(6), 5, 6);
        this.greaterEqualAndLessThanQuery("double_not_null_none", "none", this.getDouble(4), this.getDouble(6), 4, 5);
        this.greaterThanAndLessThanQuery("double_not_null_none", "none", this.getDouble(4), this.getDouble(6), 5);
        this.equalQuery("double_null_none", "none", this.getDouble(8), 8);
        this.greaterEqualQuery("double_null_none", "none", this.getDouble(7), 7, 8, 9);
        this.greaterThanQuery("double_null_none", "none", this.getDouble(6), 7, 8, 9);
        this.lessEqualQuery("double_null_none", "none", this.getDouble(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("double_null_none", "none", this.getDouble(4), 3, 2, 1, 0);
        this.betweenQuery("double_null_none", "none", this.getDouble(4), this.getDouble(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("double_null_none", "none", this.getDouble(4), this.getDouble(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("double_null_none", "none", this.getDouble(4), this.getDouble(6), 5, 6);
        this.greaterEqualAndLessThanQuery("double_null_none", "none", this.getDouble(4), this.getDouble(6), 4, 5);
        this.greaterThanAndLessThanQuery("double_null_none", "none", this.getDouble(4), this.getDouble(6), 5);
    }

    private void createAllDoubleTypesInstances(int number) {
        for (int i = 0; i < number; ++i) {
            DoubleTypes instance = (DoubleTypes)this.session.newInstance(DoubleTypes.class);
            instance.setId(i);
            instance.setDouble_not_null_hash(this.getDouble(i));
            instance.setDouble_not_null_btree(this.getDouble(i));
            instance.setDouble_not_null_both(this.getDouble(i));
            instance.setDouble_not_null_none(this.getDouble(i));
            instance.setDouble_null_hash(this.getDouble(i));
            instance.setDouble_null_btree(this.getDouble(i));
            instance.setDouble_null_both(this.getDouble(i));
            instance.setDouble_null_none(this.getDouble(i));
            this.instances.add(instance);
        }
    }

    protected Double getDouble(int number) {
        return 1.0E-5 * (double)number;
    }

    protected void printResultInstance(IdBase instance) {
        if (instance instanceof DoubleTypes) {
            DoubleTypes doubleTypes = (DoubleTypes)instance;
        }
    }

    public static String toString(IdBase idBase) {
        DoubleTypes instance = (DoubleTypes)idBase;
        StringBuffer buffer = new StringBuffer("DoubleTypes id: ");
        buffer.append(instance.getId());
        buffer.append("; double_not_null_both: ");
        buffer.append(instance.getDouble_not_null_both());
        buffer.append("; double_not_null_btree: ");
        buffer.append(instance.getDouble_not_null_btree());
        buffer.append("; double_not_null_hash: ");
        buffer.append(instance.getDouble_not_null_hash());
        buffer.append("; double_not_null_none: ");
        buffer.append(instance.getDouble_not_null_none());
        buffer.append("; double_null_both: ");
        buffer.append(instance.getDouble_null_both().toString());
        buffer.append("; double_null_btree: ");
        buffer.append(instance.getDouble_null_btree().toString());
        buffer.append("; double_null_hash: ");
        buffer.append(instance.getDouble_null_hash().toString());
        buffer.append("; double_null_none: ");
        buffer.append(instance.getDouble_null_none().toString());
        return buffer.toString();
    }
}

