/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import testsuite.clusterj.AbstractClusterJModelTest;
import testsuite.clusterj.model.Employee;

public class FindByPrimaryKeyTest
extends AbstractClusterJModelTest {
    private static final String tablename = "t_basic";
    private static final int NUMBER_TO_INSERT = 60;

    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.createEmployeeInstances(60);
        this.tx = this.session.currentTransaction();
        this.tx.begin();
        this.session.deletePersistentAll(Employee.class);
        this.tx.commit();
        this.addTearDownClasses(Employee.class);
    }

    public void testFind() {
        int i;
        this.tx = this.session.currentTransaction();
        this.tx.begin();
        int count = 0;
        for (i = 0; i < 60; ++i) {
            this.session.makePersistent(this.employees.get(i));
            ++count;
        }
        this.tx.commit();
        this.tx.begin();
        for (i = 0; i < 60; ++i) {
            Employee e = (Employee)this.session.find(Employee.class, (Object)i);
            this.consistencyCheck(e);
            int actualId = e.getId();
            if (actualId == i) continue;
            this.error("Expected Employee.id " + i + " but got " + actualId);
        }
        this.tx.commit();
        this.failOnError();
    }
}

