/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.ColumnMetadata;
import com.mysql.clusterj.ColumnType;
import com.mysql.clusterj.DynamicObject;
import com.mysql.clusterj.Query;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.query.QueryBuilder;
import com.mysql.clusterj.query.QueryDefinition;
import com.mysql.clusterj.query.QueryDomainType;
import testsuite.clusterj.AbstractClusterJModelTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicObjectTest
extends AbstractClusterJModelTest {
    private static final String tablename = "t_basic";
    private static final int NUMBER_TO_INSERT = 5;
    private DynamicObject[] instances = new TBasic[5];
    private DynamicObject tbasic;
    private Object[] expectedTBasicNames = new Object[]{"id", "name", "age", "magic"};
    private Object[] expectedTBasicTypes = new Object[]{ColumnType.Int, ColumnType.Varchar, ColumnType.Int, ColumnType.Int};
    private Object[] expectedTBasicJavaTypes = new Object[]{Integer.TYPE, String.class, Integer.class, Integer.TYPE};
    private Object[] expectedTBasicMaximumLengths = new Object[]{1, 32, 1, 1};
    private Object[] expectedTBasicNumbers = new Object[]{0, 1, 2, 3};
    private Object[] expectedTBasicIsPrimaryKeys = new Object[]{true, false, false, false};
    private Object[] expectedTBasicIsPartitionKeys = new Object[]{true, false, false, false};
    private Object[] expectedTBasicPrecisions = new Object[]{0, 0, 0, 0};
    private Object[] expectedTBasicScales = new Object[]{0, 0, 0, 0};
    private Object[] expectedTBasicNullables = new Object[]{false, true, true, false};
    private Object[] expectedTBasicCharsetNames = new Object[]{null, "latin1", null, null};

    @Override
    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.createDynamicInstances(TBasic.class, 5);
        this.tbasic = this.instances[0];
        this.tx = this.session.currentTransaction();
        int count = 0;
        for (int i = 0; i < 5; ++i) {
            try {
                this.session.deletePersistent(TBasic.class, (Object)i);
                ++count;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.addTearDownClasses(TBasic.class);
    }

    private <T extends DynamicObject> void createDynamicInstances(Class<T> dynamicClass, int numberToInsert) {
        for (int i = 0; i < numberToInsert; ++i) {
            DynamicObject instance = (DynamicObject)this.createInstance(dynamicClass, i);
            instance.set(1, (Object)String.valueOf(i));
            instance.set(2, (Object)i);
            instance.set(3, (Object)i);
            this.instances[i] = instance;
        }
    }

    private <T> T createInstance(Class<T> cls, int i) {
        Object instance = this.session.newInstance(cls, (Object)i);
        return (T)instance;
    }

    public void test() {
        this.insert();
        this.find();
        this.findAnnotated();
        this.lookup();
        this.query();
        this.badClass(DynamicObjectPrivate.class);
        this.badClass(DynamicObjectProtectedConstructor.class);
        this.badClass(DynamicObjectNonStatic.class);
        this.badClass(DynamicObjectPrivateConstructor.class);
        this.badClass(DynamicObjectNullTableName.class);
        this.badClass(DynamicObjectTableDoesNotExist.class);
        this.checkMetadata();
        this.failOnError();
    }

    private void insert() {
        this.session.makePersistent((Object)this.instances);
    }

    private void find() {
        TBasic instance = (TBasic)((Object)this.session.find(TBasic.class, (Object)0));
        this.validateInstance(instance);
    }

    private void findAnnotated() {
        AnnotatedTBasic instance = (AnnotatedTBasic)((Object)this.session.find(AnnotatedTBasic.class, (Object)0));
        this.validateInstance(instance);
    }

    private void lookup() {
        QueryBuilder builder = this.session.getQueryBuilder();
        QueryDomainType queryTBasic = builder.createQueryDefinition(TBasic.class);
        queryTBasic.where(queryTBasic.get("magic").equal(queryTBasic.param("magic")));
        Query query = this.session.createQuery((QueryDefinition)queryTBasic);
        query.setParameter("magic", (Object)1);
        TBasic instance = (TBasic)((Object)query.getResultList().get(0));
        this.validateInstance(instance);
    }

    private void query() {
        QueryBuilder builder = this.session.getQueryBuilder();
        QueryDomainType queryTBasic = builder.createQueryDefinition(TBasic.class);
        queryTBasic.where(queryTBasic.get("name").equal(queryTBasic.param("name")));
        Query query = this.session.createQuery((QueryDefinition)queryTBasic);
        query.setParameter("name", (Object)"2");
        TBasic instance = (TBasic)((Object)query.getResultList().get(0));
        this.validateInstance(instance);
    }

    private void validateInstance(DynamicObject instance) {
        int id = (Integer)instance.get(0);
        this.errorIfNotEqual("validate name", String.valueOf(id), instance.get(1));
        this.errorIfNotEqual("validate age", id, instance.get(2));
        this.errorIfNotEqual("validate magic", id, instance.get(3));
    }

    private void badClass(Class<?> cls) {
        try {
            this.session.newInstance(cls);
        }
        catch (ClusterJUserException e) {
        }
        catch (Throwable t) {
            this.error(cls.getClass().getName() + " threw wrong exception: " + t.getMessage());
        }
    }

    protected void checkMetadata() {
        ColumnMetadata[] metadata = this.tbasic.columnMetadata();
        for (int i = 0; i < metadata.length; ++i) {
            this.errorIfNotEqual("t_basic column " + i + " name", this.expectedTBasicNames[i], metadata[i].name());
            this.errorIfNotEqual("t_basic column " + i + " type", this.expectedTBasicTypes[i], metadata[i].columnType());
            this.errorIfNotEqual("t_basic column " + i + " javaType", this.expectedTBasicJavaTypes[i], metadata[i].javaType());
            this.errorIfNotEqual("t_basic column " + i + " maximumLength", this.expectedTBasicMaximumLengths[i], metadata[i].maximumLength());
            this.errorIfNotEqual("t_basic column " + i + " charsetName", this.expectedTBasicCharsetNames[i], metadata[i].charsetName());
            this.errorIfNotEqual("t_basic column " + i + " number", this.expectedTBasicNumbers[i], metadata[i].number());
            this.errorIfNotEqual("t_basic column " + i + " isPrimaryKey", this.expectedTBasicIsPrimaryKeys[i], metadata[i].isPrimaryKey());
            this.errorIfNotEqual("t_basic column " + i + " isPartitionKey", this.expectedTBasicIsPartitionKeys[i], metadata[i].isPartitionKey());
            this.errorIfNotEqual("t_basic column " + i + " precision", this.expectedTBasicPrecisions[i], metadata[i].precision());
            this.errorIfNotEqual("t_basic column " + i + " scale", this.expectedTBasicScales[i], metadata[i].scale());
            this.errorIfNotEqual("t_basic column " + i + " nullable", this.expectedTBasicNullables[i], metadata[i].nullable());
        }
    }

    public static class DynamicObjectNullTableName
    extends DynamicObject {
    }

    public static class DynamicObjectTableDoesNotExist
    extends DynamicObject {
        private DynamicObjectTableDoesNotExist() {
        }

        public String table() {
            return "DynamicObjectTableDoesNotExist";
        }
    }

    public static class DynamicObjectPrivateConstructor
    extends DynamicObject {
        private DynamicObjectPrivateConstructor() {
        }

        public String table() {
            return "DynamicObjectPrivateConstructor";
        }
    }

    public class DynamicObjectNonStatic
    extends DynamicObject {
        public String table() {
            return "DynamicObjectProtectedConstructor";
        }
    }

    private static class DynamicObjectPrivate
    extends DynamicObject {
        private DynamicObjectPrivate() {
        }
    }

    public static class DynamicObjectProtectedConstructor
    extends DynamicObject {
        protected DynamicObjectProtectedConstructor() {
        }

        public String table() {
            return "DynamicObjectProtectedConstructor";
        }
    }

    @PersistenceCapable(table="t_basic")
    public static class AnnotatedTBasic
    extends DynamicObject {
    }

    public static class TBasic
    extends DynamicObject {
        public String table() {
            return DynamicObjectTest.tablename;
        }
    }
}

