/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import testsuite.clusterj.AbstractClusterJModelTest;
import testsuite.clusterj.model.BlobTypes;

public class BlobTest
extends AbstractClusterJModelTest {
    private static final int NUMBER_TO_INSERT = 16;
    protected List<BlobTypes> blobs = new ArrayList<BlobTypes>();

    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.createBlobInstances(16);
        this.tx = this.session.currentTransaction();
        this.tx.begin();
        this.session.deletePersistentAll(BlobTypes.class);
        this.tx.commit();
        this.addTearDownClasses(BlobTypes.class);
    }

    public void test() {
        this.insert();
        this.update();
        this.failOnError();
    }

    protected void insert() {
        this.tx = this.session.currentTransaction();
        this.tx.begin();
        int count = 0;
        for (int i = 0; i < 16; ++i) {
            this.session.makePersistent((Object)this.blobs.get(i));
            ++count;
        }
        this.tx.commit();
    }

    protected void update() {
        byte[] bytes;
        int actualId;
        BlobTypes e;
        int i;
        this.tx.begin();
        for (i = 1; i < 16; ++i) {
            e = (BlobTypes)this.session.find(BlobTypes.class, (Object)i);
            actualId = e.getId();
            if (actualId != i) {
                this.error("Expected BlobTypes.id " + i + " but got " + actualId);
            }
            if ((bytes = e.getBlobbytes()) == null) {
                this.error("Unexpected blob bytes null for id " + i);
                continue;
            }
            this.checkBlobBytes("before update", bytes, i, false);
            int position = this.getBlobSizeFor(i) / 2;
            if (bytes.length != position * 2) continue;
            bytes[position] = (byte)(position % 128);
            this.checkBlobBytes("after update", bytes, i, true);
            this.session.markModified((Object)e, "blobbytes");
            this.session.updatePersistent((Object)e);
        }
        this.tx.commit();
        this.tx.begin();
        for (i = 1; i < 16; ++i) {
            e = (BlobTypes)this.session.find(BlobTypes.class, (Object)i);
            actualId = e.getId();
            if (actualId != i) {
                this.error("Expected BlobTypes.id " + i + " but got " + actualId);
            }
            if ((bytes = e.getBlobbytes()) == null) {
                this.error("Unexpected blob bytes null for id " + i);
                continue;
            }
            this.checkBlobBytes("after commit", e.getBlobbytes(), i, true);
        }
        this.tx.commit();
    }

    protected void createBlobInstances(int number) {
        for (int i = 0; i < number; ++i) {
            BlobTypes instance = (BlobTypes)this.session.newInstance(BlobTypes.class);
            instance.setId(i);
            int length = this.getBlobSizeFor(i);
            instance.setBlobbytes(this.getBlobBytes(length));
            this.blobs.add(instance);
        }
    }

    protected byte[] getBlobBytes(int size) {
        byte[] result = new byte[size];
        for (int i = 0; i < size; ++i) {
            result[i] = (byte)(i % 256 - 128);
        }
        return result;
    }

    protected void checkBlobBytes(String where, byte[] bytes, int number, boolean updated) {
        this.dumpBlob(where, bytes);
        int expectedSize = this.getBlobSizeFor(number);
        int actualSize = bytes.length;
        if (expectedSize != actualSize) {
            this.error("In " + where + " wrong size of byte[]; " + "expected: " + expectedSize + " actual: " + actualSize);
        }
        for (int i = 0; i < actualSize; ++i) {
            byte actual;
            int position = expectedSize / 2;
            byte expected = updated && i == position ? (byte)(position % 128) : (byte)(i % 256 - 128);
            if (expected == (actual = bytes[i])) continue;
            this.error("In " + where + " for size: " + actualSize + " mismatch in byte[] at position " + i + " expected: " + expected + " actual: " + actual);
        }
    }

    protected InputStream getBlobStream(final int i) {
        return new InputStream(){
            int counter = 0;

            public int read() throws IOException {
                if (this.counter >= i) {
                    return -1;
                }
                return this.counter++ % 256;
            }
        };
    }

    protected void dumpBlob(String where, byte[] blob) {
    }

    protected int getBlobSizeFor(int i) {
        int length = (int)Math.pow(2.0, i);
        return length;
    }
}

