/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.openjpa;

import com.mysql.clusterj.ColumnMetadata;
import com.mysql.clusterj.core.CacheManager;
import com.mysql.clusterj.core.spi.DomainTypeHandler;
import com.mysql.clusterj.core.spi.ValueHandler;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.openjpa.NdbOpenJPAStoreManager;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.BitSet;
import org.apache.openjpa.kernel.OpenJPAStateManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NdbOpenJPAValueHandler
implements ValueHandler {
    protected OpenJPAStateManager sm;
    private NdbOpenJPAStoreManager store;
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(NdbOpenJPAValueHandler.class);

    protected OpenJPAStateManager getStateManager() {
        return this.sm;
    }

    protected NdbOpenJPAStoreManager getStoreManager() {
        return this.store;
    }

    public NdbOpenJPAValueHandler(OpenJPAStateManager sm) {
        this.sm = sm;
    }

    public NdbOpenJPAValueHandler(OpenJPAStateManager sm, NdbOpenJPAStoreManager store) {
        this.sm = sm;
        this.store = store;
    }

    @Override
    public boolean isNull(int fieldNumber) {
        return this.sm.fetchObject(fieldNumber) == null;
    }

    @Override
    public boolean isModified(int fieldNumber) {
        BitSet modified = this.sm.getDirty();
        return modified.get(fieldNumber);
    }

    @Override
    public void resetModified() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void markModified(int fieldNumber) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean getBoolean(int fieldNumber) {
        return this.sm.fetchBoolean(fieldNumber);
    }

    @Override
    public boolean[] getBooleans(int fieldNumber) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Boolean getObjectBoolean(int fieldNumber) {
        return this.sm.fetchBoolean(fieldNumber);
    }

    @Override
    public byte getByte(int fieldNumber) {
        return this.sm.fetchByte(fieldNumber);
    }

    @Override
    public byte[] getBytes(int fieldNumber) {
        return (byte[])this.sm.fetchObject(fieldNumber);
    }

    @Override
    public short getShort(int fieldNumber) {
        return this.sm.fetchShort(fieldNumber);
    }

    @Override
    public int getInt(int fieldNumber) {
        int value = this.sm.fetchInt(fieldNumber);
        if (logger.isDetailEnabled()) {
            logger.detail(" fieldNumber: " + fieldNumber + " value: " + value);
        }
        return value;
    }

    @Override
    public long getLong(int fieldNumber) {
        long value = this.sm.fetchLong(fieldNumber);
        if (logger.isDetailEnabled()) {
            logger.detail(" fieldNumber: " + fieldNumber + " value: " + value);
        }
        return value;
    }

    @Override
    public float getFloat(int fieldNumber) {
        return this.sm.fetchFloat(fieldNumber);
    }

    @Override
    public double getDouble(int fieldNumber) {
        return this.sm.fetchDouble(fieldNumber);
    }

    @Override
    public Byte getObjectByte(int fieldNumber) {
        return (Byte)this.sm.fetchObject(fieldNumber);
    }

    @Override
    public Short getObjectShort(int fieldNumber) {
        return (Short)this.sm.fetchObject(fieldNumber);
    }

    @Override
    public Integer getObjectInt(int fieldNumber) {
        Integer value = (Integer)this.sm.fetchObject(fieldNumber);
        if (logger.isDetailEnabled()) {
            logger.detail(" fieldNumber: " + fieldNumber + " value: " + value);
        }
        return value;
    }

    @Override
    public Long getObjectLong(int fieldNumber) {
        return (Long)this.sm.fetchObject(fieldNumber);
    }

    @Override
    public Float getObjectFloat(int fieldNumber) {
        return (Float)this.sm.fetchObject(fieldNumber);
    }

    @Override
    public Double getObjectDouble(int fieldNumber) {
        return (Double)this.sm.fetchObject(fieldNumber);
    }

    @Override
    public BigDecimal getBigDecimal(int fieldNumber) {
        return (BigDecimal)this.sm.fetchObject(fieldNumber);
    }

    @Override
    public BigInteger getBigInteger(int fieldNumber) {
        return (BigInteger)this.sm.fetchObject(fieldNumber);
    }

    @Override
    public String getString(int fieldNumber) {
        return this.sm.fetchString(fieldNumber);
    }

    @Override
    public Date getJavaSqlDate(int fieldNumber) {
        return (Date)this.sm.fetchObject(fieldNumber);
    }

    @Override
    public java.util.Date getJavaUtilDate(int fieldNumber) {
        return (java.util.Date)this.sm.fetchObject(fieldNumber);
    }

    @Override
    public Time getJavaSqlTime(int fieldNumber) {
        return (Time)this.sm.fetchObject(fieldNumber);
    }

    @Override
    public Timestamp getJavaSqlTimestamp(int fieldNumber) {
        return (Timestamp)this.sm.fetchObject(fieldNumber);
    }

    @Override
    public void setBoolean(int fieldNumber, boolean value) {
        this.sm.storeBoolean(fieldNumber, value);
    }

    @Override
    public void setBooleans(int fieldNumber, boolean[] value) {
        this.sm.storeObject(fieldNumber, (Object)value);
    }

    @Override
    public void setByte(int fieldNumber, byte value) {
        this.sm.storeByte(fieldNumber, value);
    }

    @Override
    public void setBytes(int fieldNumber, byte[] value) {
        this.sm.storeObject(fieldNumber, (Object)value);
    }

    @Override
    public void setShort(int fieldNumber, short value) {
        this.sm.storeShort(fieldNumber, value);
    }

    @Override
    public void setInt(int fieldNumber, int value) {
        if (logger.isDetailEnabled()) {
            logger.detail(" fieldNumber: " + fieldNumber + " value: " + value);
        }
        this.sm.storeInt(fieldNumber, value);
    }

    @Override
    public void setLong(int fieldNumber, long value) {
        this.sm.storeLong(fieldNumber, value);
    }

    @Override
    public void setFloat(int fieldNumber, float value) {
        this.sm.storeFloat(fieldNumber, value);
    }

    @Override
    public void setDouble(int fieldNumber, double value) {
        this.sm.storeDouble(fieldNumber, value);
    }

    @Override
    public void setObjectBoolean(int fieldNumber, Boolean value) {
        this.sm.storeObject(fieldNumber, (Object)value);
    }

    @Override
    public void setObjectByte(int fieldNumber, Byte value) {
        this.sm.storeObject(fieldNumber, (Object)value);
    }

    @Override
    public void setObjectShort(int fieldNumber, Short value) {
        this.sm.storeObject(fieldNumber, (Object)value);
    }

    @Override
    public void setObjectInt(int fieldNumber, Integer value) {
        if (logger.isDetailEnabled()) {
            logger.detail(" fieldNumber: " + fieldNumber + " value: " + value);
        }
        this.sm.storeObject(fieldNumber, (Object)value);
    }

    @Override
    public void setObjectLong(int fieldNumber, Long value) {
        this.sm.storeObject(fieldNumber, (Object)value);
    }

    @Override
    public void setObjectFloat(int fieldNumber, Float value) {
        this.sm.storeObject(fieldNumber, (Object)value);
    }

    @Override
    public void setObjectDouble(int fieldNumber, Double value) {
        this.sm.storeObject(fieldNumber, (Object)value);
    }

    @Override
    public void setBigDecimal(int fieldNumber, BigDecimal value) {
        this.sm.storeObject(fieldNumber, (Object)value);
    }

    @Override
    public void setBigInteger(int fieldNumber, BigInteger value) {
        this.sm.storeObject(fieldNumber, (Object)value);
    }

    @Override
    public void setString(int fieldNumber, String value) {
        this.sm.storeString(fieldNumber, value);
    }

    @Override
    public void setObject(int fieldNumber, Object value) {
        this.sm.storeObject(fieldNumber, value);
    }

    @Override
    public void setJavaSqlDate(int fieldNumber, Date value) {
        this.sm.storeObject(fieldNumber, (Object)value);
    }

    @Override
    public void setJavaUtilDate(int fieldNumber, java.util.Date value) {
        this.sm.storeObject(fieldNumber, (Object)value);
    }

    @Override
    public void setJavaSqlTime(int fieldNumber, Time value) {
        this.sm.storeObject(fieldNumber, (Object)value);
    }

    @Override
    public void setJavaSqlTimestamp(int fieldNumber, Timestamp value) {
        this.sm.storeObject(fieldNumber, (Object)value);
    }

    @Override
    public String pkToString(DomainTypeHandler<?> domainTypeHandler) {
        StringBuffer sb = new StringBuffer(" key: [");
        int[] keys = domainTypeHandler.getKeyFieldNumbers();
        String separator = "";
        for (int i : keys) {
            sb.append(separator);
            sb.append(this.sm.fetch(i));
            separator = ";";
        }
        sb.append("]");
        return sb.toString();
    }

    private void dumpStackTrace() {
        Throwable t = new Throwable();
        t.printStackTrace();
    }

    @Override
    public void found(Boolean found) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ColumnMetadata[] columnMetadata() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Boolean found() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object get(int columnNumber) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void set(int columnNumber, Object value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public byte[] getLobBytes(int fieldNumber) {
        return (byte[])this.sm.fetchObject(fieldNumber);
    }

    @Override
    public String getLobString(int fieldNumber) {
        return this.sm.fetchString(fieldNumber);
    }

    @Override
    public void setCacheManager(CacheManager cm) {
    }

    @Override
    public void setLobBytes(int fieldNumber, byte[] value) {
        this.sm.storeObject(fieldNumber, (Object)value);
    }

    @Override
    public void setLobString(int fieldNumber, String value) {
        this.sm.storeString(fieldNumber, value);
    }

    @Override
    public void setProxy(Object proxy) {
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object getProxy() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

