/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.core.query;

import com.mysql.clusterj.ClusterJException;
import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.core.query.CandidateIndexImpl;
import com.mysql.clusterj.core.query.ParameterImpl;
import com.mysql.clusterj.core.query.PredicateImpl;
import com.mysql.clusterj.core.query.PropertyImpl;
import com.mysql.clusterj.core.query.QueryDomainTypeImpl;
import com.mysql.clusterj.core.spi.QueryExecutionContext;
import com.mysql.clusterj.core.store.IndexScanOperation;
import com.mysql.clusterj.core.store.ScanFilter;
import com.mysql.clusterj.core.store.ScanOperation;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InPredicateImpl
extends PredicateImpl {
    protected PropertyImpl property;
    protected ParameterImpl parameter;

    public InPredicateImpl(QueryDomainTypeImpl<?> dobj, PropertyImpl property, ParameterImpl parameter) {
        super(dobj);
        this.property = property;
        this.parameter = parameter;
        parameter.setProperty(property);
        property.setComplexParameter();
    }

    @Override
    public void markParameters() {
        this.parameter.mark();
    }

    @Override
    public void unmarkParameters() {
        this.parameter.unmark();
    }

    @Override
    public void markBoundsForCandidateIndices(QueryExecutionContext context, CandidateIndexImpl[] candidateIndices) {
        if (this.parameter.getParameterValue(context) == null) {
            return;
        }
        this.property.markInBound(candidateIndices, this);
    }

    @Override
    public void markBoundsForCandidateIndices(CandidateIndexImpl[] candidateIndices) {
        this.property.markInBound(candidateIndices, this);
    }

    public int operationSetBound(QueryExecutionContext context, IndexScanOperation op, int index, boolean lastColumn) {
        if (lastColumn) {
            return this.operationSetBound(context, op, index, IndexScanOperation.BoundType.BoundEQ);
        }
        return this.operationSetBound(context, op, index, IndexScanOperation.BoundType.BoundLE) + this.operationSetBound(context, op, index, IndexScanOperation.BoundType.BoundGE);
    }

    public int operationSetUpperBound(QueryExecutionContext context, IndexScanOperation op, int index) {
        return this.operationSetBound(context, op, index, IndexScanOperation.BoundType.BoundGE);
    }

    public int operationSetLowerBound(QueryExecutionContext context, IndexScanOperation op, int index) {
        return this.operationSetBound(context, op, index, IndexScanOperation.BoundType.BoundLE);
    }

    private int operationSetBound(QueryExecutionContext context, IndexScanOperation op, int index, IndexScanOperation.BoundType boundType) {
        Object parameterValue = this.parameter.getParameterValue(context);
        if (parameterValue == null) {
            throw new ClusterJUserException(local.message("ERR_Parameter_Cannot_Be_Null", (Object)"operator in", (Object)this.parameter.parameterName));
        }
        if (parameterValue instanceof List) {
            List parameterList = (List)parameterValue;
            Object value = parameterList.get(index);
            if (logger.isDetailEnabled()) {
                logger.detail("InPredicateImpl.operationSetBound for " + this.property.fmd.getName() + " List index: " + index + " value: " + value + " boundType: " + (Object)((Object)boundType));
            }
            this.property.operationSetBounds(value, boundType, op);
        } else if (parameterValue.getClass().isArray()) {
            Object[] parameterArray = (Object[])parameterValue;
            Object value = parameterArray[index];
            this.property.operationSetBounds(value, boundType, op);
            if (logger.isDetailEnabled()) {
                logger.detail("InPredicateImpl.operationSetBound for " + this.property.fmd.getName() + "  array index: " + index + " value: " + value + " boundType: " + (Object)((Object)boundType));
            }
        } else {
            throw new ClusterJUserException(local.message("ERR_Parameter_Wrong_Type", this.parameter.parameterName, parameterValue.getClass().getName(), "List<?> or Object[]"));
        }
        return BOTH_BOUNDS_SET;
    }

    public void operationSetAllBounds(QueryExecutionContext context, IndexScanOperation op) {
        Object parameterValue = this.parameter.getParameterValue(context);
        int index = 0;
        if (parameterValue == null) {
            throw new ClusterJUserException(local.message("ERR_Parameter_Cannot_Be_Null", (Object)"operator in", (Object)this.parameter.parameterName));
        }
        if (parameterValue instanceof List) {
            List parameterList = (List)parameterValue;
            for (Object value : parameterList) {
                this.property.operationSetBounds(value, IndexScanOperation.BoundType.BoundEQ, op);
                if (logger.isDetailEnabled()) {
                    logger.detail("InPredicateImpl.operationSetAllBounds for List index: " + index + " value: " + value);
                }
                op.endBound(index++);
            }
        } else if (parameterValue.getClass().isArray()) {
            Object[] parameterArray;
            for (Object value : parameterArray = (Object[])parameterValue) {
                this.property.operationSetBounds(value, IndexScanOperation.BoundType.BoundEQ, op);
                if (logger.isDetailEnabled()) {
                    logger.detail("InPredicateImpl.operationSetAllBounds for array index: " + index + " value: " + value);
                }
                op.endBound(index++);
            }
        } else {
            throw new ClusterJUserException(local.message("ERR_Parameter_Wrong_Type", this.parameter.parameterName, parameterValue.getClass().getName(), "List<?> or Object[]"));
        }
    }

    @Override
    public void filterCmpValue(QueryExecutionContext context, ScanOperation op) {
        try {
            ScanFilter filter = op.getScanFilter(context);
            this.filterCmpValue(context, op, filter);
        }
        catch (ClusterJException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ClusterJException(local.message("ERR_Get_NdbFilter"), ex);
        }
    }

    @Override
    public void filterCmpValue(QueryExecutionContext context, ScanOperation op, ScanFilter filter) {
        try {
            filter.begin(ScanFilter.Group.GROUP_OR);
            Object parameterValue = this.parameter.getParameterValue(context);
            if (parameterValue == null) {
                throw new ClusterJUserException(local.message("ERR_Parameter_Cannot_Be_Null", (Object)"operator in", (Object)this.parameter.parameterName));
            }
            if (parameterValue instanceof Iterable) {
                Iterable iterable = (Iterable)parameterValue;
                for (Object value : iterable) {
                    this.property.filterCmpValue(value, ScanFilter.BinaryCondition.COND_EQ, filter);
                }
            } else if (Object[].class.isAssignableFrom(parameterValue.getClass())) {
                Object[] parameterArray;
                for (Object value : parameterArray = (Object[])parameterValue) {
                    this.property.filterCmpValue(value, ScanFilter.BinaryCondition.COND_EQ, filter);
                }
            } else {
                throw new ClusterJUserException(local.message("ERR_Parameter_Wrong_Type", this.parameter.parameterName, parameterValue.getClass().getName(), "Iterable<?> or Object[]"));
            }
            filter.end();
        }
        catch (ClusterJException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ClusterJException(local.message("ERR_Get_NdbFilter"), ex);
        }
    }

    public int getParameterSize(QueryExecutionContext context) {
        Class<?> cls;
        int result = 1;
        Object parameterValue = this.parameter.getParameterValue(context);
        if (parameterValue instanceof List) {
            result = ((List)parameterValue).size();
        }
        if ((cls = parameterValue.getClass()).isArray()) {
            if (!Object.class.isAssignableFrom(cls.getComponentType())) {
                throw new ClusterJUserException(local.message("ERR_Wrong_Parameter_Type_For_In", (Object)this.property.fmd.getName()));
            }
            Object[] parameterArray = (Object[])parameterValue;
            result = parameterArray.length;
        }
        if (result > 4096) {
            throw new ClusterJUserException(local.message("ERR_Parameter_Too_Big_For_In", (Object)this.property.fmd.getName(), (Object)result));
        }
        return result;
    }

    @Override
    public boolean isUsable(QueryExecutionContext context) {
        return this.parameter.getParameterValue(context) != null;
    }
}

