/* Copyright (C) 2003 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 of the License.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

#ifndef NDB_VERSION_H
#define NDB_VERSION_H

#include <ndb_types.h>

#define NDB_VERSION_MAJOR 6
#define NDB_VERSION_MINOR 2
#define NDB_VERSION_BUILD 17

/* NDB status version */
#define NDB_VERSION_STATUS "-alpha"

#define NDB_MYSQL_VERSION_MAJOR 6
#define NDB_MYSQL_VERSION_MINOR 0
#define NDB_MYSQL_VERSION_BUILD 11

#define NDB_MAKE_VERSION(A,B,C) (((A) << 16) | ((B) << 8)  | ((C) << 0))

#define NDB_MYSQL_VERSION_D NDB_MAKE_VERSION(NDB_MYSQL_VERSION_MAJOR, NDB_MYSQL_VERSION_MINOR, NDB_MYSQL_VERSION_BUILD)
#define NDB_VERSION_D NDB_MAKE_VERSION(NDB_VERSION_MAJOR, NDB_VERSION_MINOR, NDB_VERSION_BUILD)
#define NDB_VERSION_STRING_BUF_SZ 100
#ifdef __cplusplus
extern "C" {
#endif

void ndbPrintVersion();

Uint32 ndbMakeVersion(Uint32 major, Uint32 minor, Uint32 build);

Uint32 ndbGetMajor(Uint32 version);

Uint32 ndbGetMinor(Uint32 version);

Uint32 ndbGetBuild(Uint32 version);

const char* ndbGetVersionString(Uint32 version, Uint32 mysql_version, const char * status,
                                char *buf, unsigned sz);
const char* ndbGetOwnVersionString();

Uint32 ndbGetOwnVersion();

#ifdef __cplusplus
}
#endif

#define NDB_VERSION_STRING ndbGetOwnVersionString()

#define NDB_VERSION ndbGetOwnVersion()

/**
 * Version id
 *
 *  Used by transporter and when communicating with
 *     managment server
 */
/*#define NDB_VERSION_ID 0*/

/**
 * From which version do we support rowid
 */
#define NDBD_ROWID_VERSION (NDB_MAKE_VERSION(5,1,6))
#define NDBD_INCL_NODECONF_VERSION_4 NDB_MAKE_VERSION(4,1,17)
#define NDBD_INCL_NODECONF_VERSION_5 NDB_MAKE_VERSION(5,0,18)
#define NDBD_FRAGID_VERSION (NDB_MAKE_VERSION(5,1,6))
#define NDBD_DICT_LOCK_VERSION_5 NDB_MAKE_VERSION(5,0,23)
#define NDBD_DICT_LOCK_VERSION_5_1 NDB_MAKE_VERSION(5,1,12)

#define NDBD_UPDATE_FRAG_DIST_KEY_50 NDB_MAKE_VERSION(5,0,26)
#define NDBD_UPDATE_FRAG_DIST_KEY_51 NDB_MAKE_VERSION(5,1,12)

#define NDBD_QMGR_SINGLEUSER_VERSION_5 NDB_MAKE_VERSION(5,0,25)

#define NDBD_SPLIT_VERSION NDB_MAKE_VERSION(6,1,0)
#define NDBD_NODE_VERSION_REP NDB_MAKE_VERSION(6,1,1)

#define NDBD_255_NODES_VERSION NDB_MAKE_VERSION(5,1,4)

#define NDBD_MICRO_GCP_62 NDB_MAKE_VERSION(6,2,5)
#define NDBD_MICRO_GCP_63 NDB_MAKE_VERSION(6,3,2)

static
inline
int
ndb_check_micro_gcp(Uint32 version)
{
  if (version == NDB_VERSION_D)
    return 1;
  {
    const Uint32 major = (version >> 16) & 0xFF;
    const Uint32 minor = (version >>  8) & 0xFF;
    if (major >= 6)
    {
      if (minor == 2)
        return version >= NDBD_MICRO_GCP_62;
      return version >= NDBD_MICRO_GCP_63;
    }
  }
  return 0;
}

#define NDBD_PREPARE_COPY_FRAG_VERSION NDB_MAKE_VERSION(6,2,1)
#define NDBD_PREPARE_COPY_FRAG_V2_51 NDB_MAKE_VERSION(5,1,23)
#define NDBD_PREPARE_COPY_FRAG_V2_62 NDB_MAKE_VERSION(6,2,8)
#define NDBD_PREPARE_COPY_FRAG_V2_63 NDB_MAKE_VERSION(6,3,6)

/**
 * 0 = NO PREP COPY FRAG SUPPORT
 * 1 = NO MAX PAGE SUPPORT
 * 2 = LATEST VERSION
 */
static
inline
int
ndb_check_prep_copy_frag_version(Uint32 version)
{
  const Uint32 major = (version >> 16) & 0xFF;
  const Uint32 minor = (version >>  8) & 0xFF;

  if (version == NDB_VERSION_D)
    return 2;

  if (major >= 6)
  {
    if (minor == 2)
    {
      if (version >= NDBD_PREPARE_COPY_FRAG_V2_62)
        return 2;
      if (version >= NDBD_PREPARE_COPY_FRAG_VERSION)
        return 1;
      return 0;
    }
    else if (minor == 3)
    {
      if (version >= NDBD_PREPARE_COPY_FRAG_V2_63)
        return 2;
      return 1;
    }
    return 2;
  }
  else if (major == 5 && minor == 1)
  {
    if (version >= NDBD_PREPARE_COPY_FRAG_V2_51)
      return 2;
  }
  return 0;
}

#define NDBD_SUMA_DICT_LOCK_62 NDB_MAKE_VERSION(6,2,14)
#define NDBD_SUMA_DICT_LOCK_63 NDB_MAKE_VERSION(6,3,11)

static
inline
int
ndbd_suma_dictlock(Uint32 x)
{
  if (x >= NDB_VERSION_D)
    return 1;
  
  {
    const Uint32 major = (x >> 16) & 0xFF;
    const Uint32 minor = (x >>  8) & 0xFF;
    
    if (major >= 6)
    {
      if (minor == 2)
      return x >= NDBD_SUMA_DICT_LOCK_62;
    }
    
    return x >= NDBD_SUMA_DICT_LOCK_63;
  }
}

#define NDBD_LONG_LIST_TABLES_CONF_62 NDB_MAKE_VERSION(6,2,16)
#define NDBD_LONG_LIST_TABLES_CONF_63 NDB_MAKE_VERSION(6,3,15)

static
inline
int
ndbd_LIST_TABLES_CONF_long_signal(Uint32 x)
{
  if (x >= NDB_VERSION_D)
    return 1;

  {
    const Uint32 major = (x >> 16) & 0xFF;
    const Uint32 minor = (x >>  8) & 0xFF;
    
    if (major >= 6)
    {
      if (minor == 2)
        return x >= NDBD_LONG_LIST_TABLES_CONF_62;
    }
    
    return x >= NDBD_LONG_LIST_TABLES_CONF_63;
  }
}

#define NDBD_API_TAKE_OVERTCCONF_60 NDB_MAKE_VERSION(5,2,4)
#define NDBD_API_TAKE_OVERTCCONF_62 NDB_MAKE_VERSION(6,2,17)
#define NDBD_API_TAKE_OVERTCCONF_63 NDB_MAKE_VERSION(6,3,19)

static
inline
int
ndb_takeovertc(Uint32 x)
{
  if (x >= NDB_VERSION_D)
    return 1;

  {
    const Uint32 major = (x >> 16) & 0xFF;
    const Uint32 minor = (x >>  8) & 0xFF;
    
    if (major >= 6)
    {
      if (minor == 2)
        return x >= NDBD_API_TAKE_OVERTCCONF_62;
    }
    
    return x >= NDBD_API_TAKE_OVERTCCONF_63;
  }
}

#endif
