--source include/have_falcon.inc
#
# Record cache memory leak test second version. Inspired by Kevin.
#
# Note: This is a smaller version of the original test so that we
#       don't get timeouts on Pushbuild runs.
#

# ----------------------------------------------------- #
# --- Initialisation                                --- #
# ----------------------------------------------------- #
let $engine = 'Falcon';
eval SET @@storage_engine = $engine;

--disable_warnings
DROP TABLE IF EXISTS t1;
--enable_warnings

CREATE TABLE t1 (c1 varchar(100));
INSERT INTO t1 VALUES (repeat('A', 100));
INSERT INTO t1 VALUES (repeat('B', 100));
INSERT INTO t1 VALUES (repeat('C', 100));
COMMIT;

# ----------------------------------------------------- #
# --- Test                                          --- #
# ----------------------------------------------------- #
--disable_query_log
let $i= 10000;
while ($i) 
{
    BEGIN;
    UPDATE t1 SET c1 = lower(c1);
    UPDATE t1 SET c1 = upper(c1);
    UPDATE t1 SET c1 = lower(c1);
    UPDATE t1 SET c1 = upper(c1);
    UPDATE t1 SET c1 = lower(c1);
    UPDATE t1 SET c1 = upper(c1);
    UPDATE t1 SET c1 = lower(c1);
    UPDATE t1 SET c1 = upper(c1);
    COMMIT;

    dec $i;
}
--enable_query_log

# ----------------------------------------------------- #
# --- Check                                         --- #
# ----------------------------------------------------- #
SELECT count(*) FROM t1;

# ----------------------------------------------------- #
# --- Final cleanup                                 --- #
# ----------------------------------------------------- #
DROP TABLE t1;
