/* Copyright (C) 2006 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

#ifndef _STORAGE_HANDLER_H_
#define _STORAGE_HANDLER_H_

static const int connectionHashSize = 101;

enum OpenOption {
	CreateDatabase,
	OpenDatabase,
	OpenOrCreateDatabase,
	OpenTemporaryDatabase
	};
	

typedef void (Logger) (int, const char*, void *arg);

class StorageConnection;
class StorageHandler;
class StorageDatabase;
class SyncObject;
class Connection;
class THD;

extern "C" 
{
StorageHandler*	getFalconStorageHandler();
}

static const int databaseHashSize = 101;

class StorageHandler
{
public:
	StorageHandler(void);
	~StorageHandler(void);
	virtual void		startNfsServer(void);
	virtual void		addNfsLogger(int mask, Logger listener, void* arg);
	virtual int			isTempTable(const char *path);
	virtual StorageConnection* getStorageConnection(const char* path, THD* mySqlThread, OpenOption createFlag);

	virtual void		shutdownHandler(void);
	virtual void		databaseDropped(StorageConnection* storageConnection);
	virtual int			commit(THD* mySqlThread);
	virtual int			rollback(THD* mySqlThread);
	virtual int			releaseVerb(THD* mySqlThread);
	virtual int			rollbackVerb(THD* mySqlThread);
	virtual int			savepointSet(THD* mySqlThread, void* savePoint);
	virtual int			savepointRelease(THD* mySqlThread, void* savePoint);
	virtual int			savepointRollback(THD* mySqlThread, void* savePoint);
	virtual const char* getEngineStatus(THD* mySqlThread);
	virtual void		releaseText(const char* text);
	virtual int			commitByXID(int xidLength, const unsigned char* xid);
	virtual int			rollbackByXID(int xidLength, const unsigned char* xis);
	virtual Connection*	getDictionaryConnection(void);

	StorageDatabase*	getStorageDatabase(const char* dbName, const char* path);
	void				remove(StorageConnection* storageConnection);
	void				closeDatabase(const char* path);
	int					prepare(THD* mySqlThread, int xidSize, const unsigned char *xid);
	
	StorageConnection	*connections[connectionHashSize];
	SyncObject			*syncObject;
	SyncObject			*hashSyncObject;
	StorageDatabase		*storageDatabases[databaseHashSize];
	Connection			*dictionaryConnection;

	virtual int createTablespace(const char* tableSpaceName, const char* filename);
	virtual int deleteTablespace(const char* tableSpaceName);
};

#endif
