/* Copyright (C) 2006 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

// SearchWords.h: interface for the SearchWords class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SEARCHWORDS_H__AB755BA0_DE48_427F_90C1_8DD6D9793F69__INCLUDED_)
#define AFX_SEARCHWORDS_H__AB755BA0_DE48_427F_90C1_8DD6D9793F69__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "TableAttachment.h"
//#include "JString.h"	// Added by ClassView

class Database;
class Table;
class SymbolManager;
class Record;

class SearchWords : public TableAttachment
{
public:
	virtual void postCommit(Table *table, RecordVersion * record);
	JString getWord (Table *table, Record *record);
	bool isStopWord (const char *word);
	void initialize();
	void tableAdded (Table *table);
	SearchWords(Database *db);
	virtual ~SearchWords();

	Database		*database;
	SymbolManager	*symbols;
};

#endif // !defined(AFX_SEARCHWORDS_H__AB755BA0_DE48_427F_90C1_8DD6D9793F69__INCLUDED_)
