/* Copyright (C) 2006 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

// SRLSectionPage.cpp: implementation of the SRLSectionPage class.
//
//////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include "Engine.h"
#include "SRLSectionPage.h"
#include "SerialLog.h"
#include "Section.h"
#include "Dbb.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

SRLSectionPage::SRLSectionPage()
{

}

SRLSectionPage::~SRLSectionPage()
{

}

void SRLSectionPage::read()
{
	parentPage = getInt();
	pageNumber = getInt();
	sectionSlot = getInt();
	sectionId = getInt();
	sequence = getInt();
	level = getInt();
	
	if (log->tracePage == pageNumber ||
		(log->tracePage && log->tracePage == parentPage))
		print();
}

void SRLSectionPage::append(int32 parent, int32 page, int slot, int id, int seq, int lvl)
{
	START_RECORD(srlSectionPage, "SRLSectionPage::append");
	putInt(parent);
	putInt(page);
	putInt(slot);
	putInt(id);
	putInt(seq);
	putInt(lvl);
	sync.unlock();
}

void SRLSectionPage::pass1()
{
	log->bumpPageIncarnation(pageNumber, objInUse);
}

void SRLSectionPage::pass2()
{
	if (log->bumpPageIncarnation(pageNumber, objInUse))
		Section::redoSectionPage(log->dbb, parentPage, pageNumber, sectionSlot, sectionId, sequence, level);
}

void SRLSectionPage::redo()
{
	if (!log->bumpPageIncarnation(pageNumber, objInUse))
		return;

	//Section::redoSectionPage(log->dbb, parentPage, pageNumber, sectionSlot, sectionId, sequence, level);
}

void SRLSectionPage::print()
{
	logPrint("Section Page parent %d, page %d, slot %d, sectionId %d, sequence %d, level %d\n",
			parentPage, pageNumber, sectionSlot, sectionId, sequence, level);
}
