/* Copyright (C) 2006 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */
// SRLCreateIndex.cpp: implementation of the SRLCreateIndex class.
//
//////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include "Engine.h"
#include "SRLCreateIndex.h"
#include "SerialLogControl.h"
#include "Index.h"
#include "IndexRootPage.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

SRLCreateIndex::SRLCreateIndex()
{

}

SRLCreateIndex::~SRLCreateIndex()
{

}

void SRLCreateIndex::append(TransId transId, int32 id, int idxVersion)
{
	START_RECORD(srlCreateIndex, "SRLCreateIndex::append");
	log->getTransaction(transId);
	log->setIndexActive(id);
	putInt(id);
	putInt(idxVersion);
	putInt(transId);
	sync.unlock();
}

void SRLCreateIndex::read()
{
	indexId = getInt();

	if (control->version >= srlVersion6)
		indexVersion = getInt();
	else
		indexVersion = INDEX_VERSION_1;
		
	transactionId = getInt();
}

void SRLCreateIndex::pass1()
{
	log->bumpIndexIncarnation(indexId, objInUse);
}

void SRLCreateIndex::redo()
{
	if (!log->bumpIndexIncarnation(indexId, objInUse))
		return;

	switch (indexVersion)
		{
		case INDEX_VERSION_1:
			IndexRootPage::redoCreateIndex(log->dbb, indexId);
			break;
		
		default:
			ASSERT(false);
		}
}

void SRLCreateIndex::print()
{
	logPrint("Create Index %d\n", indexId);
}

void SRLCreateIndex::commit(void)
{
}
