/* Copyright (C) 2006 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

// RecoveryObjects.h: interface for the RecoveryObjects class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_RECOVERYOBJECTS_H__00C7CE5F_3C33_435C_9521_9C274CAB0581__INCLUDED_)
#define AFX_RECOVERYOBJECTS_H__00C7CE5F_3C33_435C_9521_9C274CAB0581__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

static const int RPG_HASH_SIZE			= 101;

class RecoveryPage;
class SerialLog;

class RecoveryObjects  
{
public:
	bool isObjectActive(int objectNumber);
	void reset();
	bool bumpIncarnation(int objectNumber, int state, bool pass1);
	void clear();
	RecoveryObjects(SerialLog *serialLog);
	virtual ~RecoveryObjects();

	SerialLog			*serialLog;
	RecoveryPage		*recoveryObjects[RPG_HASH_SIZE];
	RecoveryPage* findRecoveryObject(int objectNumber);
	void setActive(int objectNumber);
	void setInactive(int objectNumber);
	RecoveryPage* getRecoveryObject(int objectNumber);
	void deleteObject(int objectNumber);
	int getCurrentState(int objectNumber);
};

#endif // !defined(AFX_RECOVERYOBJECTS_H__00C7CE5F_3C33_435C_9521_9C274CAB0581__INCLUDED_)
