/* Copyright (C) 2006 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

#ifndef _MEMORY_MANAGER_H
#define _MEMORY_MANAGER_H

#ifdef _WIN32
#define THROWS_NOTHING
#define THROWS_BAD_ALLOC
#define WINSTATIC			static
#else
#include <new>
#define THROWS_NOTHING		throw()
#define THROWS_BAD_ALLOC	//throw (std::bad_alloc)
#define WINSTATIC
#endif

#define _MFC_OVERRIDES_NEW

#ifdef _WIN32
#define ALWAYS_INLINE inline /* for windows */
#else
#define ALWAYS_INLINE extern inline __attribute__ ((always_inline)) /* for gcc */
#endif
class Stream;
struct MemObject;

#ifdef _DEBUG
	extern void* MemMgrAllocateDebug (unsigned int s, const char *file, int line);
	WINSTATIC ALWAYS_INLINE void* operator new(size_t s) THROWS_BAD_ALLOC
		{ return MemMgrAllocateDebug (s, __FILE__, __LINE__); }
	WINSTATIC ALWAYS_INLINE void* operator new(size_t s, const int  &n) 
		{ return MemMgrAllocateDebug (s, __FILE__, __LINE__); }
	WINSTATIC ALWAYS_INLINE void* operator new(size_t s, const char *file, int line) 
		{ return MemMgrAllocateDebug (s, file, line); }
	WINSTATIC ALWAYS_INLINE void* operator new[](size_t s) THROWS_BAD_ALLOC
		{ return MemMgrAllocateDebug (s, __FILE__, __LINE__); }
	WINSTATIC ALWAYS_INLINE void* operator new[](size_t s, const char *file, int line) THROWS_BAD_ALLOC
		{ return MemMgrAllocateDebug (s, file, line); }

#define NEW	new (THIS_FILE, __LINE__)
#ifndef new
#define new NEW
#endif

#else
	extern void* MemMgrAllocate (unsigned int s);
	WINSTATIC ALWAYS_INLINE void* operator new(size_t s) THROWS_BAD_ALLOC
		{ return ::MemMgrAllocate (s); }
	WINSTATIC ALWAYS_INLINE void* operator new(size_t s, const int  &n) THROWS_BAD_ALLOC
		{ return ::MemMgrAllocate (s); }
	WINSTATIC ALWAYS_INLINE void* operator new[](size_t s) THROWS_BAD_ALLOC
		{ return ::MemMgrAllocate (s); }
#define NEW new
#endif

extern void		MemMgrRelease (void *object);
extern void		MemMgrValidate (void *object);
extern void		MemMgrAnalyze(int mask, Stream *stream);
extern void*	MemMgrRecordAllocate (int size, const char *file, int line);
extern void		MemMgrRecordDelete (char *record);
extern MemObject* MemMgrFindPriorBlock (void *block);

WINSTATIC ALWAYS_INLINE void operator delete(void *object) THROWS_NOTHING
	{ MemMgrRelease (object); }
WINSTATIC ALWAYS_INLINE void operator delete(void *object, const char *file, int line)
	{ MemMgrRelease (object); }
WINSTATIC ALWAYS_INLINE void operator delete[](void *object) THROWS_NOTHING
	{ MemMgrRelease (object); }
WINSTATIC ALWAYS_INLINE void operator delete[](void *object, const char *file, int line)
	{ MemMgrRelease (object); }

extern void MemMgrValidate ();

#endif
