#!/bin/sh
# mysql-test-run - originally written by Matt Wagner <matt@mysql.com>
# modified by Sasha Pachev <sasha@mysql.com>
# Slightly updated by Monty
# Cleaned up again by Matt
# Fixed by Sergei
# List of failed cases (--force) backported from 4.1 by Joerg
# :-)

#echo "##################################################";
#echo "This script is deprecated and will soon be removed";
#echo "Use mysql-test-run.pl instead";
#echo "##################################################";
#echo

#++
# Access Definitions
#--
DB=test
DBPASSWD=""
VERBOSE=""
USE_MANAGER=0
MY_TZ=GMT-3
TZ=$MY_TZ; export TZ # for UNIX_TIMESTAMP tests to work
LOCAL_SOCKET=@MYSQL_UNIX_ADDR@
MYSQL_TCP_PORT=@MYSQL_TCP_PORT@

umask 022

# For query_cache test
case `uname` in
    SCO_SV | UnixWare | OpenUNIX )
        # do nothing (Causes strange behavior)
        ;;
    QNX)
        # do nothing (avoid error message)
        ;;
    * )
        ulimit -n 1024
        ;;
esac

#++
# Program Definitions
#--

LC_COLLATE=C
export LC_COLLATE
PATH=/bin:/usr/bin:/usr/local/bin:/usr/bsd:/usr/X11R6/bin:/usr/openwin/bin:/usr/bin/X11:$PATH
MASTER_40_ARGS="--rpl-recovery-rank=1 --init-rpl-role=master"

# Standard functions

which ()
{
  IFS="${IFS=   }"; save_ifs="$IFS"; IFS=':'
  for file
  do
    for dir in $PATH
    do
      if test -f $dir/$file
      then
        echo "$dir/$file"
        continue 2
      fi
    done
    echo "Fatal error: Cannot find program $file in $PATH" 1>&2
    exit 1
  done
  IFS="$save_ifs"
  exit 0
}


sleep_until_file_deleted ()
{
  pid=$1;
  file=$2
  loop=$SLEEP_TIME_FOR_DELETE
  while (test $loop -gt 0)
  do
    if [ ! -r $file ]
    then
      if test $pid != "0"
      then
        wait_for_pid $pid
      fi
      return
    fi
    sleep 1
    loop=`expr $loop - 1`
  done
}

sleep_until_file_created ()
{
  file=$1
  loop=$2
  org_time=$2
  while (test $loop -gt 0)
  do
    if [ -r $file ]
    then
      return 0
    fi
    sleep 1
    loop=`expr $loop - 1`
  done
  echo "ERROR: $file was not created in $org_time seconds;  Aborting"
  exit 1;
}

# For the future

wait_for_pid()
{
  pid=$1
  #$WAIT_PID pid $SLEEP_TIME_FOR_DELETE
}

# Check that valgrind is installed
find_valgrind()
{
  FIND_VALGRIND=`which valgrind` # this will print an error if not found
  # Give good warning to the user and stop
  if [ -z "$FIND_VALGRIND" ] ; then
    $ECHO "You need to have the 'valgrind' program in your PATH to run mysql-test-run with option --valgrind. Valgrind's home page is http://valgrind.kde.org ."
    exit 1
  fi
  # >=2.1.2 requires the --tool option, some versions write to stdout, some to stderr
  valgrind --help 2>&1 | grep "\-\-tool" > /dev/null && FIND_VALGRIND="$FIND_VALGRIND --tool=memcheck"
  FIND_VALGRIND="$FIND_VALGRIND --alignment=8 --leak-check=yes --num-callers=16 --suppressions=$MYSQL_TEST_DIR/valgrind.supp"
}

# No paths below as we can't be sure where the program is!

SED=sed

BASENAME=`which basename`
if test $? != 0; then exit 1; fi
DIFF=`which diff | $SED q`
if test $? != 0; then exit 1; fi
CAT=cat
CUT=cut
HEAD=head
TAIL=tail
ECHO=echo # use internal echo if possible
EXPR=expr # use internal if possible
FIND=find
GREP=grep
if test $? != 0; then exit 1; fi
PRINTF=printf
RM=rm
if test $? != 0; then exit 1; fi
TR=tr
XARGS=`which xargs`
if test $? != 0; then exit 1; fi
SORT=sort

# Are we using a source or a binary distribution?

testdir=@testdir@
if [ -d bin/mysqld ] && [ -d mysql-test ] ; then
 cd mysql-test
else
 if [ -d $testdir/mysql-test ] ; then
   cd $testdir
 fi
fi

if [ ! -f ./mysql-test-run ] ; then
  $ECHO "Can't find the location for the mysql-test-run script"

  $ECHO "Go to to the mysql-test directory and execute the script as follows:"
  $ECHO "./mysql-test-run."
  exit 1
fi

#++
# Misc. Definitions
#--

# BASEDIR is always above mysql-test directory ...
MYSQL_TEST_DIR=`pwd`
cd ..

if [ -d ./sql ] ; then
   SOURCE_DIST=1
else
   BINARY_DIST=1

  # ... one level for tar.gz, two levels for a RPM installation
  if [ ! -f ./bin/mysql_upgrade ] ; then
     # Has to be RPM installation
    cd ..
  fi
fi
BASEDIR=`pwd`

cd $MYSQL_TEST_DIR
MYSQL_TEST_WINDIR=$MYSQL_TEST_DIR
MYSQLTEST_VARDIR=$MYSQL_TEST_DIR/var
export MYSQL_TEST_DIR MYSQL_TEST_WINDIR MYSQLTEST_VARDIR
STD_DATA=$MYSQL_TEST_DIR/std_data
hostname=`hostname`		# Installed in the mysql privilege table

MANAGER_QUIET_OPT="-q"
TESTDIR="$MYSQL_TEST_DIR/t"
TESTSUFFIX=test
TOT_SKIP=0
TOT_PASS=0
TOT_FAIL=0
TOT_TEST=0
GOT_WARNINGS=0
USERT=0
SYST=0
REALT=0
FAST_START=""
MYSQL_TMP_DIR=$MYSQL_TEST_DIR/var/tmp
export MYSQL_TMP_DIR

# Use a relative path for where the slave will find the dumps
# generated by "LOAD DATA" on the master. The path is relative
# since it must have fixed length to test logging
# i.e otherwise the output from "SHOW MASTER STATUS" will vary
# with the strlen() of MYSQL_TEST_DIR
SLAVE_LOAD_TMPDIR=../tmp

RES_SPACE="      "
MYSQLD_SRC_DIRS="strings mysys include extra regex myisam \
 myisammrg heap sql"
MY_LOG_DIR="$MYSQL_TEST_DIR/var/log" 
#
# Set LD_LIBRARY_PATH if we are using shared libraries
#
LD_LIBRARY_PATH="$BASEDIR/lib:$BASEDIR/libmysql/.libs:$BASEDIR/libmysql_r/.libs:$BASEDIR/zlib/.libs:$LD_LIBRARY_PATH"
DYLD_LIBRARY_PATH="$BASEDIR/lib:$BASEDIR/libmysql/.libs:$BASEDIR/libmysql_r/.libs:$BASEDIR/zlib/.libs:$DYLD_LIBRARY_PATH"
export LD_LIBRARY_PATH DYLD_LIBRARY_PATH

#
# Allow anyone in the group to see the generated database files
#
UMASK=0660
UMASK_DIR=0770
export UMASK UMASK_DIR

MASTER_RUNNING=0
MASTER1_RUNNING=0
MASTER_MYHOST=127.0.0.1
MASTER_MYPORT=9306
SLAVE_RUNNING=0
SLAVE_MYHOST=127.0.0.1
SLAVE_MYPORT=9308 # leave room for 2 masters for cluster tests
MYSQL_MANAGER_LOG=$MYSQL_TEST_DIR/var/log/manager.log
NDBCLUSTER_PORT=9350
NDBCLUSTER_PORT_SLAVE=9358

#
# To make it easier for different devs to work on the same host,
# an environment variable can be used to control all ports. A small
# number is to be used, 0 - 16 or similar.
#
# Note the MASTER_MYPORT has to be set the same in all 4.x and 5.x
# versions of this script, else a 4.0 test run might conflict with a
# 5.1 test run, even if different MTR_BUILD_THREAD is used. This means
# all port numbers might not be used in this version of the script.
#
if [ -n "$MTR_BUILD_THREAD" ] ; then
  MASTER_MYPORT=`expr $MTR_BUILD_THREAD '*' 10 + 10000`
  SLAVE_MYPORT=`expr $MASTER_MYPORT + 3`
  NDBCLUSTER_PORT=`expr $MASTER_MYPORT + 6`
  NDBCLUSTER_PORT_SLAVE=`expr $MASTER_MYPORT + 7`

  echo "Using MTR_BUILD_THREAD      = $MTR_BUILD_THREAD"
  echo "Using MASTER_MYPORT         = $MASTER_MYPORT"
  echo "Using SLAVE_MYPORT          = $SLAVE_MYPORT"
  echo "Using NDBCLUSTER_PORT       = $NDBCLUSTER_PORT"
  echo "Using NDBCLUSTER_PORT_SLAVE = $NDBCLUSTER_PORT_SLAVE"
fi

NO_SLAVE=0
USER_TEST=
FAILED_CASES=

EXTRA_MASTER_OPT=""
EXTRA_MYSQL_TEST_OPT=""
EXTRA_MYSQLCHECK_OPT=""
EXTRA_MYSQLDUMP_OPT=""
EXTRA_MYSQLSLAP_OPT=""
EXTRA_MYSQLSHOW_OPT=""
EXTRA_MYSQLBINLOG_OPT=""
USE_RUNNING_SERVER=0
USE_NDBCLUSTER=@USE_NDBCLUSTER@
USE_NDBCLUSTER_SLAVE=@USE_NDBCLUSTER@
USE_NDBCLUSTER_ALL=0
USE_NDBCLUSTER_ONLY=0
USE_RUNNING_NDBCLUSTER=""
USE_RUNNING_NDBCLUSTER_SLAVE=""
NDB_EXTRA_TEST=0
NDB_VERBOSE=0
NDBCLUSTER_EXTRA_OPTS=""
USE_PURIFY=""
PURIFY_LOGS=""
DO_GCOV=""
DO_GDB=""
MANUAL_GDB=""
DO_DDD=""
DO_CLIENT_GDB=""
SLEEP_TIME_AFTER_RESTART=1
SLEEP_TIME_FOR_DELETE=10
SLEEP_TIME_FOR_FIRST_MASTER=400		# Enough time to create innodb tables
SLEEP_TIME_FOR_SECOND_MASTER=400
SLEEP_TIME_FOR_FIRST_SLAVE=400
SLEEP_TIME_FOR_SECOND_SLAVE=300
CHARACTER_SET=latin1
DBUSER=""
START_WAIT_TIMEOUT=10
STOP_WAIT_TIMEOUT=10
MYSQL_TEST_SSL_OPTS=""
USE_TIMER=""
USE_EMBEDDED_SERVER=""
TEST_MODE=""

NDB_MGM_EXTRA_OPTS=
NDB_MGMD_EXTRA_OPTS=
NDBD_EXTRA_OPTS=
MASTER_MYSQLDBINLOG=1
SLAVE_MYSQLDBINLOG=1

DO_STRESS=""
STRESS_SUITE="main"
STRESS_MODE="random"
STRESS_THREADS=5
STRESS_TEST_COUNT=""
STRESS_LOOP_COUNT=""
STRESS_TEST_DURATION=""
STRESS_INIT_FILE=""
STRESS_TEST_FILE=""
STRESS_TEST=""

$ECHO "Logging: $0 $*"   # To ensure we see all arguments in the output, for the test analysis tool

while test $# -gt 0; do
  case "$1" in
    --embedded-server)
      USE_EMBEDDED_SERVER=1
      USE_MANAGER=0 NO_SLAVE=1
      USE_RUNNING_SERVER=0
      USE_NDBCLUSTER=""
      USE_NDBCLUSTER_SLAVE=""
      TEST_MODE="$TEST_MODE embedded" ;;
    --purify)
      USE_PURIFY=1
      USE_MANAGER=0
      USE_RUNNING_SERVER=0
      TEST_MODE="$TEST_MODE purify" ;;
    --user=*) DBUSER=`$ECHO "$1" | $SED -e "s;--user=;;"` ;;
    --force)  FORCE=1 ;;
    --timer)  USE_TIMER=1 ;;
    --old-master) MASTER_40_ARGS="";;
    --master-binary=*)
      MASTER_MYSQLD=`$ECHO "$1" | $SED -e "s;--master-binary=;;"` ;;
    --slave-binary=*)
      SLAVE_MYSQLD=`$ECHO "$1" | $SED -e "s;--slave-binary=;;"` ;;
    --local)   USE_RUNNING_SERVER=0 ;;
    --extern)  USE_RUNNING_SERVER=1 ;;
    --with-ndbcluster)
      USE_NDBCLUSTER="--ndbcluster" ;;
    --with-ndbcluster-slave)
      USE_NDBCLUSTER_SLAVE="--ndbcluster" ;;
    --with-ndbcluster-all)
      USE_NDBCLUSTER="--ndbcluster"
      USE_NDBCLUSTER_SLAVE="--ndbcluster"
      USE_NDBCLUSTER_ALL=1 ;;
    --with-ndbcluster-only)
      USE_NDBCLUSTER="--ndbcluster"
      USE_NDBCLUSTER_SLAVE="--ndbcluster"
      USE_NDBCLUSTER_ONLY=1 ;;
    --ndb-connectstring=*)
      USE_NDBCLUSTER="--ndbcluster" ;
      USE_RUNNING_NDBCLUSTER=`$ECHO "$1" | $SED -e "s;--ndb-connectstring=;;"` ;;
    --ndb-connectstring-slave=*)
      USE_NDBCLUSTER_SLAVE="--ndbcluster" ;
      USE_RUNNING_NDBCLUSTER_SLAVE=`$ECHO "$1" | $SED -e "s;--ndb-connectstring-slave=;;"` ;;
    --ndb-extra-test)
      NDBCLUSTER_EXTRA_OPTS=" "
      NDB_EXTRA_TEST=1 ;
      ;;
    --ndb-verbose)
      NDB_VERBOSE=2 ;;
    --ndb_mgm-extra-opts=*)
      NDB_MGM_EXTRA_OPTS=`$ECHO "$1" | $SED -e "s;--ndb_mgm-extra-opts=;;"` ;;
    --ndb_mgmd-extra-opts=*)
      NDB_MGMD_EXTRA_OPTS=`$ECHO "$1" | $SED -e "s;--ndb_mgmd-extra-opts=;;"` ;;
    --ndbd-extra-opts=*)
      NDBD_EXTRA_OPTS=`$ECHO "$1" | $SED -e "s;--ndbd-extra-opts=;;"` ;;
    --tmpdir=*) MYSQL_TMP_DIR=`$ECHO "$1" | $SED -e "s;--tmpdir=;;"` ;;
    --local-master)
      MASTER_MYPORT=3306;
      EXTRA_MYSQL_TEST_OPT="$EXTRA_MYSQL_TEST_OPT --host=127.0.0.1 \
      --port=$MYSQL_MYPORT"
      LOCAL_MASTER=1 ;;
    --master_port=*) MASTER_MYPORT=`$ECHO "$1" | $SED -e "s;--master_port=;;"` ;;
    --slave_port=*) SLAVE_MYPORT=`$ECHO "$1" | $SED -e "s;--slave_port=;;"` ;;
    --ndbcluster_port=*) NDBCLUSTER_PORT=`$ECHO "$1" | $SED -e "s;--ndbcluster_port=;;"` ;;
    --ndbcluster-port=*) NDBCLUSTER_PORT=`$ECHO "$1" | $SED -e "s;--ndbcluster-port=;;"` ;;
    --ndbcluster-port-slave=*) NDBCLUSTER_PORT_SLAVE=`$ECHO "$1" | $SED -e "s;--ndbcluster-port-slave=;;"` ;;
    --with-openssl)
     EXTRA_MASTER_MYSQLD_OPT="$EXTRA_MASTER_MYSQLD_OPT \
     --ssl-ca=$MYSQL_TEST_DIR/std_data/cacert.pem \
     --ssl-cert=$MYSQL_TEST_DIR/std_data/server-cert.pem \
     --ssl-key=$MYSQL_TEST_DIR/std_data/server-key.pem"
     EXTRA_SLAVE_MYSQLD_OPT="$EXTRA_SLAVE_MYSQLD_OPT \
     --ssl-ca=$MYSQL_TEST_DIR/std_data/cacert.pem \
     --ssl-cert=$MYSQL_TEST_DIR/std_data/server-cert.pem \
     --ssl-key=$MYSQL_TEST_DIR/std_data/server-key.pem"
     MYSQL_TEST_SSL_OPTS="--ssl-ca=$MYSQL_TEST_DIR/std_data/cacert.pem \
     --ssl-cert=$MYSQL_TEST_DIR/std_data/client-cert.pem \
     --ssl-key=$MYSQL_TEST_DIR/std_data/client-key.pem" ;;
    --start-and-exit)
     START_AND_EXIT=1
     ;;
    --socket=*) LOCAL_SOCKET=`$ECHO "$1" | $SED -e "s;--socket=;;"` ;;
    --skip-rpl) NO_SLAVE=1 ;;
    --skip-test=*) SKIP_TEST=`$ECHO "$1" | $SED -e "s;--skip-test=;;"`;;
    --do-test=*) DO_TEST=`$ECHO "$1" | $SED -e "s;--do-test=;;"`;;
    --start-from=* ) START_FROM=`$ECHO "$1" | $SED -e "s;--start-from=;;"` ;;
    --warnings | --log-warnings)
     EXTRA_MASTER_MYSQLD_OPT="$EXTRA_MASTER_MYSQLD_OPT --log-warnings"
     EXTRA_SLAVE_MYSQLD_OPT="$EXTRA_SLAVE_MYSQLD_OPT --log-warnings"
     ;;
    --wait-timeout=*)
     START_WAIT_TIMEOUT=`$ECHO "$1" | $SED -e "s;--wait-timeout=;;"`
     STOP_WAIT_TIMEOUT=$START_WAIT_TIMEOUT;;
    --record)
      RECORD=1;
      EXTRA_MYSQL_TEST_OPT="$EXTRA_MYSQL_TEST_OPT $1" ;;
    --small-bench)
      DO_SMALL_BENCH=1
      DO_BENCH=1
      NO_SLAVE=1
      ;;
    --bench)
      DO_BENCH=1
      NO_SLAVE=1
      ;;
    --stress)
      DO_STRESS=1
      NO_SLAVE=1
      SKIP_SLAVE=1
      ;;
    --stress-suite=*)
      STRESS_SUITE=`$ECHO "$1" | $SED -e "s;--stress-suite=;;"`
      ;;
    --stress-threads=*)
      STRESS_THREADS=`$ECHO "$1" | $SED -e "s;--stress-threads=;;"`
      ;;
    --stress-test-file=*)
      STRESS_TEST_FILE=`$ECHO "$1" | $SED -e "s;--stress-test-file=;;"`
      ;;
    --stress-init-file=*)
      STRESS_INIT_FILE=`$ECHO "$1" | $SED -e "s;--stress-init-file=;;"`
      ;; 
    --stress-mode=*)
      STRESS_MODE=`$ECHO "$1" | $SED -e "s;--stress-mode=;;"`
      ;;
    --stress-loop-count=*)
      STRESS_LOOP_COUNT=`$ECHO "$1" | $SED -e "s;--stress-loop-count=;;"`
      ;;
    --stress-test-count=*)
      STRESS_TEST_COUNT=`$ECHO "$1" | $SED -e "s;--stress-test-count=;;"`
      ;;      
    --stress-test-duration=*)
      STRESS_TEST_DURATION=`$ECHO "$1" | $SED -e "s;--stress-test-duration=;;"`
      ;;
    --big*)			# Actually --big-test
      EXTRA_MYSQL_TEST_OPT="$EXTRA_MYSQL_TEST_OPT $1" ;;
    --compress)
      EXTRA_MYSQL_TEST_OPT="$EXTRA_MYSQL_TEST_OPT $1" ;;
    --sleep=*)
      EXTRA_MYSQL_TEST_OPT="$EXTRA_MYSQL_TEST_OPT $1"
      SLEEP_TIME_AFTER_RESTART=`$ECHO "$1" | $SED -e "s;--sleep=;;"`
      ;;
    --ps-protocol)
      TEST_MODE="$TEST_MODE ps-protocol" EXTRA_MYSQL_TEST_OPT="$EXTRA_MYSQL_TEST_OPT $1" ;;
    --user-test=*)
      USER_TEST=`$ECHO "$1" | $SED -e "s;--user-test=;;"`
      ;;
    --mysqld=*)
       TMP=`$ECHO "$1" | $SED -e "s;--mysqld=;;"`
       EXTRA_MASTER_MYSQLD_OPT="$EXTRA_MASTER_MYSQLD_OPT $TMP"
       EXTRA_SLAVE_MYSQLD_OPT="$EXTRA_SLAVE_MYSQLD_OPT $TMP"
       ;;
    --gcov )
      if [ x$BINARY_DIST = x1 ] ; then
	$ECHO "Cannot do coverage test without the source - please use source dist"
	exit 1
      fi
      DO_GCOV=1
      GCOV=`which gcov`
      ;;
    --gprof )
      DO_GPROF=1
      ;;
    --gdb )
      START_WAIT_TIMEOUT=300
      STOP_WAIT_TIMEOUT=300
      if [ x$BINARY_DIST = x1 ] ; then
	$ECHO "Note: you will get more meaningful output on a source distribution compiled with debugging option when running tests with --gdb option"
      fi
      DO_GDB=1
      EXTRA_MASTER_MYSQLD_OPT="$EXTRA_MASTER_MYSQLD_OPT --gdb"
      EXTRA_SLAVE_MYSQLD_OPT="$EXTRA_SLAVE_MYSQLD_OPT --gdb"
      # This needs to be checked properly
      # USE_MANAGER=1
      USE_RUNNING_SERVER=0
      ;;
    --client-gdb )
      if [ x$BINARY_DIST = x1 ] ; then
	$ECHO "Note: you will get more meaningful output on a source distribution compiled with debugging option when running tests with --client-gdb option"
      fi
      DO_CLIENT_GDB=1
      EXTRA_MASTER_MYSQLD_OPT="$EXTRA_MASTER_MYSQLD_OPT --gdb"
      EXTRA_SLAVE_MYSQLD_OPT="$EXTRA_SLAVE_MYSQLD_OPT --gdb"
      ;;
    --manual-gdb )
      DO_GDB=1
      MANUAL_GDB=1
      USE_RUNNING_SERVER=0
      EXTRA_MASTER_MYSQLD_OPT="$EXTRA_MASTER_MYSQLD_OPT --gdb"
      EXTRA_SLAVE_MYSQLD_OPT="$EXTRA_SLAVE_MYSQLD_OPT --gdb"
      ;;
    --ddd )
      if [ x$BINARY_DIST = x1 ] ; then
	$ECHO "Note: you will get more meaningful output on a source distribution compiled with debugging option when running tests with --ddd option"
      fi
      DO_DDD=1
      USE_RUNNING_SERVER=0
      EXTRA_MASTER_MYSQLD_OPT="$EXTRA_MASTER_MYSQLD_OPT --gdb"
      EXTRA_SLAVE_MYSQLD_OPT="$EXTRA_SLAVE_MYSQLD_OPT --gdb"
      ;;
    --valgrind | --valgrind-all)
      find_valgrind;
      VALGRIND=$FIND_VALGRIND
      EXTRA_MASTER_MYSQLD_OPT="$EXTRA_MASTER_MYSQLD_OPT --skip-safemalloc"
      EXTRA_SLAVE_MYSQLD_OPT="$EXTRA_SLAVE_MYSQLD_OPT --skip-safemalloc"
      SLEEP_TIME_AFTER_RESTART=10
      SLEEP_TIME_FOR_DELETE=60
      USE_RUNNING_SERVER=0
      if test "$1" = "--valgrind-all"
      then
        VALGRIND="$VALGRIND -v --show-reachable=yes"
      fi
      ;;
    --valgrind-options=*)
      TMP=`$ECHO "$1" | $SED -e "s;--valgrind-options=;;"`
      VALGRIND="$VALGRIND $TMP"
      ;;
    --skip-ndbcluster-slave | --skip-ndb-slave)
      USE_NDBCLUSTER_SLAVE=""
      EXTRA_SLAVE_MYSQLD_OPT="$EXTRA_SLAVE_MYSQLD_OPT --skip-ndbcluster"
      ;;
    --valgrind-mysqltest | --valgrind-mysqltest-all)
      find_valgrind;
      VALGRIND_MYSQLTEST=$FIND_VALGRIND
      if test "$1" = "--valgrind-mysqltest-all"
      then
        VALGRIND_MYSQLTEST="$VALGRIND_MYSQLTEST -v --show-reachable=yes"
      fi
      ;;
    --skip-ndbcluster | --skip-ndb)
      USE_NDBCLUSTER=""
      USE_NDBCLUSTER_SLAVE=""
      EXTRA_MASTER_MYSQLD_OPT="$EXTRA_MASTER_MYSQLD_OPT --skip-ndbcluster"
      EXTRA_SLAVE_MYSQLD_OPT="$EXTRA_SLAVE_MYSQLD_OPT --skip-ndbcluster"
      ;;
    --skip-master-binlog) MASTER_MYSQLDBINLOG=0 ;;
    --skip-slave-binlog) SLAVE_MYSQLDBINLOG=0 ;;
    --skip-*)
      EXTRA_MASTER_MYSQLD_OPT="$EXTRA_MASTER_MYSQLD_OPT $1"
      EXTRA_SLAVE_MYSQLD_OPT="$EXTRA_SLAVE_MYSQLD_OPT $1"
      ;;
    --strace-client )
      STRACE_CLIENT=1
      ;;
    --debug)
      EXTRA_MASTER_MYSQLD_TRACE=" \
       --debug=d:t:i:A,$MYSQL_TEST_DIR/var/log/master.trace"
      EXTRA_SLAVE_MYSQLD_OPT="$EXTRA_SLAVE_MYSQLD_OPT \
       --debug=d:t:i:A,$MYSQL_TEST_DIR/var/log/slave.trace"
      EXTRA_MYSQL_TEST_OPT="$EXTRA_MYSQL_TEST_OPT \
       --debug=d:t:A,$MYSQL_TEST_DIR/var/log/mysqltest.trace"
      EXTRA_MYSQLCHECK_OPT="$EXTRA_MYSQLCHECK_OPT \
       --debug=d:t:A,$MYSQL_TEST_DIR/var/log/mysqlcheck.trace"
      EXTRA_MYSQLDUMP_OPT="$EXTRA_MYSQLDUMP_OPT \
       --debug=d:t:A,$MYSQL_TEST_DIR/var/log/mysqldump.trace"
      EXTRA_MYSQLSLAP_OPT="$EXTRA_MYSQLSLAP_OPT \
       --debug=d:t:A,$MYSQL_TEST_DIR/var/log/mysqlslap.trace"
      EXTRA_MYSQLSHOW_OPT="$EXTRA_MYSQLSHOW_OPT \
       --debug=d:t:A,$MYSQL_TEST_DIR/var/log/mysqlshow.trace"
      EXTRA_MYSQLBINLOG_OPT="$EXTRA_MYSQLBINLOG_OPT \
       --debug=d:t:A,$MYSQL_TEST_DIR/var/log/mysqlbinlog.trace"
      EXTRA_MYSQL_CLIENT_TEST_OPT="--debug=d:t:A,$MYSQL_TEST_DIR/var/log/mysql_client_test.trace"
      ;;
    --fast)
      FAST_START=1
      ;;
    --use-old-data)
      USE_OLD_DATA=1
      ;;
    --comment=*)
      TMP=`$ECHO "$1" | $SED -e "s;--comment=;;"`
      echo
      echo '############################################'
      echo "# $TMP"
      echo '############################################'
      ;;
    -- )  shift; break ;;
    --* ) $ECHO "Unrecognized option: $1"; exit 1 ;;
    * ) break ;;
  esac
  shift
done

if [ -z "$TEST_MODE" ] ; then
  TEST_MODE="default"
else
  # Remove the leading space if any
  TEST_MODE=`echo $TEST_MODE | sed 's/^ *//'`
fi

#++
# mysqld Environment Parameters
#--

MYRUN_DIR=$MYSQL_TEST_DIR/var/run

MASTER_MYDDIR="$MYSQL_TEST_DIR/var/master-data"
MASTER_MYSOCK="$MYSQL_TMP_DIR/master.sock"
MASTER_MYSOCK1=$MYSQL_MYSOCK"1"
MASTER_MYPID="$MYRUN_DIR/master.pid"
MASTER_MYLOG="$MYSQL_TEST_DIR/var/log/master.log"
MASTER_MYERR="$MYSQL_TEST_DIR/var/log/master.err"

SLAVE_MYDDIR="$MYSQL_TEST_DIR/var/slave-data"
SLAVE_MYSOCK="$MYSQL_TMP_DIR/slave.sock"
SLAVE_MYPID="$MYRUN_DIR/slave.pid"
SLAVE_MYLOG="$MYSQL_TEST_DIR/var/log/slave.log"
SLAVE_MYERR="$MYSQL_TEST_DIR/var/log/slave.err"

CURRENT_TEST="$MYSQL_TEST_DIR/var/log/current_test"
SMALL_SERVER="--key_buffer_size=1M --sort_buffer=256K --max_heap_table_size=1M"

export MASTER_MYHOST MASTER_MYPORT SLAVE_MYHOST SLAVE_MYPORT MYSQL_TCP_PORT MASTER_MYSOCK MASTER_MYSOCK1

NDBCLUSTER_OPTS="--port=$NDBCLUSTER_PORT --data-dir=$MYSQL_TEST_DIR/var --ndb_mgm-extra-opts=$NDB_MGM_EXTRA_OPTS --ndb_mgmd-extra-opts=$NDB_MGMD_EXTRA_OPTS --ndbd-extra-opts=$NDBD_EXTRA_OPTS"
NDBCLUSTER_OPTS_SLAVE="--port=$NDBCLUSTER_PORT_SLAVE --data-dir=$MYSQL_TEST_DIR/var"
if [ -n "$USE_NDBCLUSTER_SLAVE" ] ; then
  USE_NDBCLUSTER_SLAVE="$USE_NDBCLUSTER_SLAVE --ndb-connectstring=localhost:$NDBCLUSTER_PORT_SLAVE --ndb-extra-logging"
fi
NDB_BACKUP_DIR=$MYSQL_TEST_DIR/var/ndbcluster-$NDBCLUSTER_PORT
NDB_TOOLS_OUTPUT=$MYSQL_TEST_DIR/var/log/ndb_tools.log

if [ x$SOURCE_DIST = x1 ] ; then
 MY_BASEDIR=$MYSQL_TEST_DIR
else
 MY_BASEDIR=$BASEDIR
fi

# Create the directories

# This should be fixed to be not be dependent on the contence of MYSQL_TMP_DIR
# or MYRUN_DIR
# (mkdir -p is not portable)
[ -d $MYSQL_TEST_DIR/var ] || mkdir $MYSQL_TEST_DIR/var
[ -d $MYSQL_TEST_DIR/var/tmp ] || mkdir $MYSQL_TEST_DIR/var/tmp
[ -d $MYSQL_TEST_DIR/var/run ] || mkdir $MYSQL_TEST_DIR/var/run
[ -d $MYSQL_TEST_DIR/var/log ] || mkdir $MYSQL_TEST_DIR/var/log

# Use 'test', not '[' as the shell builtin might not have '-L
if test ! -L "$MYSQL_TEST_DIR/var/std_data_ln" ; then
  ln -s $MYSQL_TEST_DIR/std_data/ $MYSQL_TEST_DIR/var/std_data_ln
fi

if test ${COLUMNS:-0} -lt 80 ; then COLUMNS=80 ; fi
E=`$EXPR $COLUMNS - 8`
DASH72=`$ECHO '-------------------------------------------------------'|$CUT -c 1-$E`

# on source dist, we pick up freshly build executables
# on binary, use what is installed
if [ x$SOURCE_DIST = x1 ] ; then
 if [ "x$USE_EMBEDDED_SERVER" = "x1" ] ; then
   if [ -f "$BASEDIR/libmysqld/examples/mysqltest_embedded" ] ; then
     MYSQL_TEST="$BASEDIR/libmysqld/examples/mysqltest_embedded"
   else
     echo "Fatal error: Cannot find embedded server 'mysqltest_embedded'" 1>&2
     exit 1
   fi
   MYSQL_CLIENT_TEST="$BASEDIR/libmysqld/examples/mysql_client_test_embedded"
 else
   MYSQLD="$BASEDIR/sql/mysqld"
   if [ -n "$VALGRIND" ] ; then
     MYSQLD="$VALGRIND $MYSQLD"
   fi
   if [ -f "$BASEDIR/client/.libs/lt-mysqltest" ] ; then
     MYSQL_TEST="$BASEDIR/client/.libs/lt-mysqltest"
   elif [ -f "$BASEDIR/client/.libs/mysqltest" ] ; then
     MYSQL_TEST="$BASEDIR/client/.libs/mysqltest"
   else
     MYSQL_TEST="$BASEDIR/client/mysqltest"
   fi
   MYSQL_CLIENT_TEST="$BASEDIR/tests/mysql_client_test"
 fi
 if [ -f "$BASEDIR/client/.libs/mysqlcheck" ] ; then
   MYSQL_CHECK="$BASEDIR/client/.libs/mysqlcheck"
 else
   MYSQL_CHECK="$BASEDIR/client/mysqlcheck"
 fi
 if [ -f "$BASEDIR/client/.libs/mysqldump" ] ; then
   MYSQL_DUMP="$BASEDIR/client/.libs/mysqldump"
 else
   MYSQL_DUMP="$BASEDIR/client/mysqldump"
 fi
 if [ -f "$BASEDIR/client/.libs/mysqlslap" ] ; then
   MYSQL_SLAP="$BASEDIR/client/.libs/mysqlslap"
 else
   MYSQL_SLAP="$BASEDIR/client/mysqlslap"
 fi
 if [ -f "$BASEDIR/client/.libs/mysqlimport" ] ; then
   MYSQL_IMPORT="$BASEDIR/client/.libs/mysqlimport"
 else
   MYSQL_IMPORT="$BASEDIR/client/mysqlimport"
 fi
 if [ -f "$BASEDIR/client/.libs/mysqlshow" ] ; then
   MYSQL_SHOW="$BASEDIR/client/.libs/mysqlshow"
 else
   MYSQL_SHOW="$BASEDIR/client/mysqlshow"
 fi
 if [ -f "$BASEDIR/client/.libs/mysqlbinlog" ] ; then
   MYSQL_BINLOG="$BASEDIR/client/.libs/mysqlbinlog"
 else
   MYSQL_BINLOG="$BASEDIR/client/mysqlbinlog"
 fi
 if [ -n "$STRACE_CLIENT" ]; then
  MYSQL_TEST="strace -o $MYSQL_TEST_DIR/var/log/mysqltest.strace $MYSQL_TEST"
 fi

 CLIENT_BINDIR="$BASEDIR/client"
 MYSQLADMIN="$CLIENT_BINDIR/mysqladmin"
 WAIT_PID="$BASEDIR/extra/mysql_waitpid"
 MYSQL_MY_PRINT_DEFAULTS="$BASEDIR/extra/my_print_defaults"
 MYSQL="$CLIENT_BINDIR/mysql"
 LANGUAGE="$BASEDIR/sql/share/english/"
 CHARSETSDIR="$BASEDIR/sql/share/charsets"
 INSTALL_DB="./install_test_db"
 MYSQL_FIX_SYSTEM_TABLES="$BASEDIR/scripts/mysql_fix_privilege_tables"
 NDB_TOOLS_DIR="$BASEDIR/storage/ndb/tools"
 NDB_MGM="$BASEDIR/storage/ndb/src/mgmclient/ndb_mgm"

 if [ -n "$USE_PURIFY" ] ; then
   PSUP="$MYSQL_TEST_DIR/suppress.purify"
   PURIFYOPTIONS="-windows=no -log-file=%v.purifylog -append-logfile -add-suppression-files=$PSUP"
   if [ -f "${MYSQL_TEST}-purify" ] ; then
     MYSQL_TEST="${MYSQL_TEST}-purify"
     PLOG="$MYSQL_TEST.purifylog"
     if [ -f $PLOG ]; then
       mv $PLOG $PLOG.$$
     fi
     PURIFY_LOGS="$PLOG"
   fi
   if [ -f "${MYSQLD}-purify" ] ; then
     MYSQLD="${MYSQLD}-purify"
     PLOG="$MYSQLD.purifylog"
     if [ -f $PLOG ]; then
       mv $PLOG $PLOG.$$
     fi
     PURIFY_LOGS="$PURIFY_LOGS $PLOG"
   fi
 fi

else

 # We have a binary installation. Note that this can be both from
 # unpacking a MySQL AB binary distribution (created using
 # "scripts/make_binary_distribution", and from a "make install".
 # Unfortunately the structure differs a bit, for a "make install"
 # currently all binaries are in "bin", for a MySQL AB packaging
 # some are in "tests".

 if test -x "$BASEDIR/libexec/mysqld"
 then
   MYSQLD="$VALGRIND $BASEDIR/libexec/mysqld"
 elif test -x "$BASEDIR/bin/mysqld"
 then
   MYSQLD="$VALGRIND $BASEDIR/bin/mysqld"
 elif test -x "$BASEDIR/sbin/mysqld"
 then
   MYSQLD="$VALGRIND $BASEDIR/sbin/mysqld"
 else
   $ECHO "Fatal error: Cannot find program mysqld in $BASEDIR/{libexec,bin,sbin}" 1>&2
   exit 1
 fi
 CLIENT_BINDIR="$BASEDIR/bin"
 if test -d "$BASEDIR/tests"
 then
   TESTS_BINDIR="$BASEDIR/tests"
 else
   TESTS_BINDIR="$BASEDIR/bin"
 fi
 MYSQL_TEST="$CLIENT_BINDIR/mysqltest"
 MYSQL_CHECK="$CLIENT_BINDIR/mysqlcheck"
 MYSQL_SLAP="$CLIENT_BINDIR/mysqlslap"
 MYSQL_SHOW="$CLIENT_BINDIR/mysqlshow"
 MYSQL_IMPORT="$CLIENT_BINDIR/mysqlimport"
 MYSQL_BINLOG="$CLIENT_BINDIR/mysqlbinlog"
 MYSQLADMIN="$CLIENT_BINDIR/mysqladmin"
 WAIT_PID="$CLIENT_BINDIR/mysql_waitpid"
 MYSQL_MY_PRINT_DEFAULTS="$CLIENT_BINDIR/my_print_defaults"
 MYSQL="$CLIENT_BINDIR/mysql"
 INSTALL_DB="./install_test_db --bin"
 MYSQL_FIX_SYSTEM_TABLES="$CLIENT_BINDIR/mysql_fix_privilege_tables"
 NDB_TOOLS_DIR="$CLIENT_BINDIR"
 NDB_MGM="$CLIENT_BINDIR/ndb_mgm"
 if test -d "$BASEDIR/share/mysql/english"
 then
   LANGUAGE="$BASEDIR/share/mysql/english/"
   CHARSETSDIR="$BASEDIR/share/mysql/charsets"
 else
   LANGUAGE="$BASEDIR/share/english/"
   CHARSETSDIR="$BASEDIR/share/charsets"
 fi
 if [ "x$USE_EMBEDDED_SERVER" = "x1" ] ; then
   if [ -f "$CLIENT_BINDIR/mysqltest_embedded" ] ; then
     MYSQL_TEST="$CLIENT_BINDIR/mysqltest_embedded"
   else
     echo "Fatal error: Cannot find embedded server 'mysqltest_embedded'" 1>&2
     exit 1
   fi
   if [ -d "$BASEDIR/tests/mysql_client_test_embedded" ] ; then
     MYSQL_CLIENT_TEST="$TESTS_BINDIR/mysql_client_test_embedded"
   else
     MYSQL_CLIENT_TEST="$CLIENT_BINDIR/mysql_client_test_embedded"
   fi
 else
   MYSQL_TEST="$CLIENT_BINDIR/mysqltest"
   MYSQL_CLIENT_TEST="$CLIENT_BINDIR/mysql_client_test"
 fi
 if [ -f "$BASEDIR/client/.libs/mysqldump" ] ; then
   MYSQL_DUMP="$BASEDIR/client/.libs/mysqldump"
 elif  [ -f "$BASEDIR/client/mysqldump" ] ; then
   MYSQL_DUMP="$BASEDIR/client/mysqldump"
 else
   MYSQL_DUMP="$BASEDIR/bin/mysqldump"
 fi
fi

if [ -z "$MASTER_MYSQLD" ]
then
MASTER_MYSQLD=$MYSQLD
fi

if [ -z "$SLAVE_MYSQLD" ]
then
SLAVE_MYSQLD=$MYSQLD
fi

# If we should run all tests cases, we will use a local server for that

if [ -z "$1" -a -z "$DO_STRESS" ]
then
   USE_RUNNING_SERVER=0
fi
if [ $USE_RUNNING_SERVER -eq 1 ]
then
   MASTER_MYSOCK=$LOCAL_SOCKET;
   DBUSER=${DBUSER:-test}
else
   DBUSER=${DBUSER:-root}		# We want to do FLUSH xxx commands
fi

if [ -w / ]
then
  # We are running as root;  We need to add the --root argument
  EXTRA_MASTER_MYSQLD_OPT="$EXTRA_MASTER_MYSQLD_OPT --user=root"
  EXTRA_SLAVE_MYSQLD_OPT="$EXTRA_SLAVE_MYSQLD_OPT --user=root"
fi

MYSQL_CLIENT_TEST="$MYSQL_CLIENT_TEST --no-defaults --testcase --user=root --socket=$MASTER_MYSOCK --port=$MYSQL_TCP_PORT --silent $EXTRA_MYSQL_CLIENT_TEST_OPT"
# Need to pass additional arguments to MYSQL_CLIENT_TEST for embedded server
# -A marks each argument for passing to the function which initializes the
# embedded library
if [ "x$USE_EMBEDDED_SERVER" = "x1" ]; then
  MYSQL_CLIENT_TEST="$MYSQL_CLIENT_TEST -A --language=$LANGUAGE -A --datadir=$SLAVE_MYDDIR -A --character-sets-dir=$CHARSETSDIR"
fi
# Save path and name of mysqldump
MYSQL_DUMP_DIR="$MYSQL_DUMP"
export MYSQL_DUMP_DIR
MYSQL_CHECK="$MYSQL_CHECK --no-defaults --debug-info -uroot --socket=$MASTER_MYSOCK --password=$DBPASSWD $EXTRA_MYSQLCHECK_OPT"
MYSQL_DUMP="$MYSQL_DUMP --no-defaults --debug-info -uroot --socket=$MASTER_MYSOCK --password=$DBPASSWD $EXTRA_MYSQLDUMP_OPT"
MYSQL_SLAP="$MYSQL_SLAP -uroot --socket=$MASTER_MYSOCK --password=$DBPASSWD $EXTRA_MYSQLSLAP_OPT"
MYSQL_DUMP_SLAVE="$MYSQL_DUMP_DIR --no-defaults -uroot --socket=$SLAVE_MYSOCK --password=$DBPASSWD $EXTRA_MYSQLDUMP_OPT"
MYSQL_SHOW="$MYSQL_SHOW --no-defaults --debug-info -uroot --socket=$MASTER_MYSOCK --password=$DBPASSWD $EXTRA_MYSQLSHOW_OPT"
MYSQL_BINLOG="$MYSQL_BINLOG --debug-info --no-defaults --local-load=$MYSQL_TMP_DIR  --character-sets-dir=$CHARSETSDIR $EXTRA_MYSQLBINLOG_OPT"
MYSQL_IMPORT="$MYSQL_IMPORT --debug-info -uroot --socket=$MASTER_MYSOCK --password=$DBPASSWD $EXTRA_MYSQLDUMP_OPT"
MYSQL_FIX_SYSTEM_TABLES="$MYSQL_FIX_SYSTEM_TABLES --no-defaults --host=localhost --port=$MASTER_MYPORT --socket=$MASTER_MYSOCK --user=root --password=$DBPASSWD --basedir=$BASEDIR --bindir=$CLIENT_BINDIR --verbose"
MYSQL="$MYSQL --no-defaults --debug-info --host=localhost --port=$MASTER_MYPORT --socket=$MASTER_MYSOCK --user=root --password=$DBPASSWD"
export MYSQL MYSQL_CHECK MYSQL_DUMP MYSQL_DUMP_SLAVE MYSQL_SHOW MYSQL_BINLOG MYSQL_FIX_SYSTEM_TABLES MYSQL_IMPORT
export CLIENT_BINDIR MYSQL_CLIENT_TEST CHARSETSDIR MYSQL_MY_PRINT_DEFAULTS
export MYSQL_SLAP
export NDB_TOOLS_DIR
export NDB_MGM
export NDB_BACKUP_DIR
export NDB_TOOLS_OUTPUT
export PURIFYOPTIONS
NDB_STATUS_OK=1
export NDB_STATUS_OK
NDB_SLAVE_STATUS_OK=1
export NDB_SLAVE_STATUS_OK
export NDB_EXTRA_TEST NDBCLUSTER_PORT NDBCLUSTER_PORT_SLAVE

MYSQL_TEST_ARGS="--no-defaults --socket=$MASTER_MYSOCK --database=$DB \
 --user=$DBUSER --password=$DBPASSWD --silent -v --skip-safemalloc \
 --tmpdir=$MYSQL_TMP_DIR --port=$MASTER_MYPORT $MYSQL_TEST_SSL_OPTS"
if [ x$USE_TIMER = x1 ] ; then
  MYSQL_TEST_ARGS="$MYSQL_TEST_ARGS --timer-file=$MY_LOG_DIR/timer"
fi
MYSQL_TEST_BIN=$MYSQL_TEST
MYSQL_TEST="$MYSQL_TEST $MYSQL_TEST_ARGS"

# Export MYSQL_TEST variable for use from .test files
export MYSQL_TEST

GDB_CLIENT_INIT=$MYSQL_TMP_DIR/gdbinit.client
GDB_MASTER_INIT=$MYSQL_TMP_DIR/gdbinit.master
GDB_SLAVE_INIT=$MYSQL_TMP_DIR/gdbinit.slave
GCOV_MSG=$MYSQL_TMP_DIR/mysqld-gcov.out
GCOV_ERR=$MYSQL_TMP_DIR/mysqld-gcov.err
GPROF_DIR=$MYSQL_TMP_DIR/gprof
GPROF_MASTER=$GPROF_DIR/master.gprof
GPROF_SLAVE=$GPROF_DIR/slave.gprof
TIMEFILE="$MYSQL_TEST_DIR/var/log/mysqltest-time"
MYSQLTEST_LOG="$MYSQL_TEST_DIR/var/log/mysqltest.log"
if [ -n "$DO_CLIENT_GDB" -o -n "$DO_GDB" ] ; then
  XTERM=`which xterm`
fi

export MYSQL MYSQL_CHECK MYSQL_DUMP MYSQL_SHOW MYSQL_BINLOG MYSQL_FIX_SYSTEM_TABLES CLIENT_BINDIR MASTER_MYSOCK

#++
# Function Definitions
#--

prompt_user ()
{
 $ECHO $1
 read unused
}

# We can't use diff -u or diff -a as these are not portable

show_failed_diff ()
{
  reject_file=r/$1.reject
  result_file=r/$1.result
  eval_file=r/$1.eval

  if [ -f $eval_file ]
  then
    result_file=$eval_file
  fi

  if [ -x "$DIFF" ] && [ -f $reject_file ]
  then
    echo "Below are the diffs between actual and expected results:"
    echo "-------------------------------------------------------"
    $DIFF -c $result_file $reject_file
    echo "-------------------------------------------------------"
    echo "Please follow the instructions outlined at"
    echo "http://dev.mysql.com/doc/mysql/en/reporting-mysqltest-bugs.html"
    echo "to find the reason to this problem and how to report this."
    echo ""
  fi
}

do_gdb_test ()
{
  mysql_test_args="$MYSQL_TEST_ARGS $1"
  $ECHO "set args $mysql_test_args < $2" > $GDB_CLIENT_INIT
  echo "Set breakpoints ( if needed) and type 'run' in gdb window"
  #this xterm should not be backgrounded
  $XTERM -title "Client" -e gdb -x $GDB_CLIENT_INIT $MYSQL_TEST_BIN
}

error () {
    $ECHO  "Error:  $1"
    exit 1
}

error_is () {
    $ECHO "Errors are (from $TIMEFILE) :"
    $CAT < $TIMEFILE
    $ECHO "(the last lines may be the most important ones)"
}

prefix_to_8() {
 $ECHO "        $1" | $SED -e 's:.*\(........\)$:\1:'
}

pass_inc () {
    TOT_PASS=`$EXPR $TOT_PASS + 1`
}

fail_inc () {
    TOT_FAIL=`$EXPR $TOT_FAIL + 1`
}

skip_inc () {
    TOT_SKIP=`$EXPR $TOT_SKIP + 1`
}

total_inc () {
    TOT_TEST=`$EXPR $TOT_TEST + 1`
}


skip_test() {
   USERT="    ...."
   SYST="    ...."
   REALT="    ...."
   pname=`$ECHO "$1                        "|$CUT -c 1-24`
   RES="$pname"
   skip_inc
   $ECHO "$RES$RES_SPACE [ skipped ]"
}


disable_test() {
   USERT="    ...."
   SYST="    ...."
   REALT="    ...."
   pname=`$ECHO "$1                        "|$CUT -c 1-24`
   RES="$pname"
   skip_inc
   $ECHO "$RES$RES_SPACE [ disabled ]  $2"
}


report_current_test () {
   tname=$1
   echo "CURRENT_TEST: $tname" >> $MASTER_MYERR
   eval "master1_running=\$MASTER1_RUNNING"
   if [ x$master1_running = x1 ] ; then
     echo "CURRENT_TEST: $tname" >> $MASTER_MYERR"1"
   fi
   if [ -n "$PURIFY_LOGS" ] ; then
     for log in $PURIFY_LOGS
     do
       echo "CURRENT_TEST: $tname" >> $log
     done
   fi
}


report_stats () {
    if [ $TOT_FAIL = 0 ]; then
	$ECHO "All $TOT_TEST tests were successful."
    else
	xten=`$EXPR $TOT_PASS \* 10000`
	raw=`$EXPR $xten / $TOT_TEST`
	raw=`$PRINTF %.4d $raw`
	whole=`$PRINTF %.2s $raw`
	xwhole=`$EXPR $whole \* 100`
	deci=`$EXPR $raw - $xwhole`
	$ECHO  "Failed ${TOT_FAIL}/${TOT_TEST} tests, ${whole}.${deci}% were successful."
	$ECHO ""
        $ECHO "The log files in $MY_LOG_DIR may give you some hint"
	$ECHO "of what went wrong."
	$ECHO "If you want to report this error, please read first the documentation at"
        $ECHO "http://dev.mysql.com/doc/mysql/en/mysql-test-suite.html"
    fi

    if [ $USE_RUNNING_SERVER -eq 0 ]
    then

    # Report if there was any fatal warnings/errors in the log files
    #
    $RM -f $MY_LOG_DIR/warnings $MY_LOG_DIR/warnings.tmp
    # Remove some non fatal warnings from the log files
    $SED -e 's!Warning:  Table:.* on delete!!g' -e 's!Warning: Setting lower_case_table_names=2!!g' -e 's!Warning: One can only use the --user.*root!!g' -e 's|InnoDB: Warning: we did not need to do crash recovery||g' \
        $MY_LOG_DIR/*.err \
        | $SED -e 's!Warning:  Table:.* on rename!!g' \
        > $MY_LOG_DIR/warnings.tmp

    # Find errors
    for i in "^Warning:" "^Error:" "^==.* at 0x" "InnoDB: Warning" "missing DBUG_RETURN" "mysqld: Warning" "Attempting backtrace" "Assertion .* failed"
    do
      if $GREP "$i" $MY_LOG_DIR/warnings.tmp >> $MY_LOG_DIR/warnings
      then
        GOT_WARNINGS=1
      fi
    done
    $RM -f $MY_LOG_DIR/warnings.tmp
    if [ $GOT_WARNINGS = "1" ]
    then
      echo "WARNING: Got errors/warnings while running tests. Please examine"
      echo "$MY_LOG_DIR/warnings for details."
    fi

    fi # USE_RUNNING_SERVER

    # Check valgrind errors from mysqltest
    if [ ! -z "$VALGRIND_MYSQLTEST" ]
    then
      if $GREP "ERROR SUMMARY" $MYSQLTEST_LOG | $GREP -v "0 errors" > /dev/null
      then
	  $ECHO "Valgrind detected errors!"
	  $GREP "ERROR SUMMARY" $MYSQLTEST_LOG | $GREP -v "0 errors"
	  $ECHO "See $MYSQLTEST_LOG"
      fi
    fi
}

mysql_install_db () {
    $ECHO "Removing Stale Files"
    if [ -z "$USE_OLD_DATA" ]; then
      $RM -rf $MASTER_MYDDIR $MASTER_MYDDIR"1"
      $ECHO "Installing Master Databases"
      $INSTALL_DB
      if [ $? != 0 ]; then
	error "Could not install master test DBs"
        exit 1
      fi
    fi
    if [ ! -z "$USE_NDBCLUSTER" ]
    then
      $ECHO "Installing Master Databases 1"
#     $INSTALL_DB -1
      $RM -rf var/master-data1
      mkdir var/master-data1
      cp -r var/master-data/* var/master-data1
      if [ $? != 0 ]; then
	error "Could not install master test DBs 1"
	exit 1
      fi
    fi
    $ECHO "Installing Slave Databases"
    $RM -rf $SLAVE_MYDDIR $MY_LOG_DIR/* 
#    $INSTALL_DB -slave
    mkdir var/slave-data
    cp -r var/master-data/* var/slave-data
    if [ $? != 0 ]; then
	error "Could not install slave test DBs"
	exit 1
    fi

    for slave_num in 1 2 ;
    do
      $RM -rf var/slave$slave_num-data
      mkdir -p var/slave$slave_num-data/mysql
      mkdir -p var/slave$slave_num-data/test
      cp var/slave-data/mysql/* var/slave$slave_num-data/mysql
    done
    return 0
}

gprof_prepare ()
{
 $RM -rf $GPROF_DIR
 mkdir -p $GPROF_DIR
}

gprof_collect ()
{
 if [ -f $MASTER_MYDDIR/gmon.out ]; then
   gprof $MASTER_MYSQLD $MASTER_MYDDIR/gmon.out > $GPROF_MASTER
   echo "Master execution profile has been saved in $GPROF_MASTER"
 fi
 if [ -f $SLAVE_MYDDIR/gmon.out ]; then
   gprof $SLAVE_MYSQLD $SLAVE_MYDDIR/gmon.out > $GPROF_SLAVE
   echo "Slave execution profile has been saved in $GPROF_SLAVE"
 fi
}

gcov_prepare () {
    $FIND $BASEDIR -name \*.gcov \
    -or -name \*.da | $XARGS $RM
}

gcov_collect () {
    $ECHO "Collecting source coverage info..."
    [ -f $GCOV_MSG ] && $RM $GCOV_MSG
    [ -f $GCOV_ERR ] && $RM $GCOV_ERR
    for d in $MYSQLD_SRC_DIRS; do
	cd $BASEDIR/$d
	for f in *.h *.cc *.c; do
	    $GCOV $f 2>>$GCOV_ERR  >>$GCOV_MSG
	done
	cd $MYSQL_TEST_DIR
    done

    $ECHO "gcov info in $GCOV_MSG, errors in $GCOV_ERR"
}

abort_if_failed()
{
 if [ ! $? = 0 ] ; then
  echo $1
  exit 1
 fi
}

launch_in_background()
{
  shift
  echo $@ | /bin/sh  >> $CUR_MYERR 2>&1  &
  sleep 2 #hack
  return
}

shutdown_mysqld()
{
  pid=$1
  ident=$2
  # Shutdown time must be high as slave may be in reconnect
  $MYSQLADMIN --no-defaults -uroot --socket=$MYSQL_TMP_DIR/$ident.sock$3 --connect_timeout=5 --shutdown_timeout=70 shutdown >> $MYSQL_MANAGER_LOG 2>&1
  res=$?
  # Some systems require an extra connect
  $MYSQLADMIN --no-defaults -uroot --socket=$MYSQL_TMP_DIR/$ident.sock$3 --connect_timeout=1 ping >> $MYSQL_MANAGER_LOG 2>&1
  if test $res = 0
  then
    wait_for_pid $pid
  fi
  return $res
}

start_ndbcluster()
{
  if [ ! -n "$USE_NDBCLUSTER" ] ;
  then
    USING_NDBCLUSTER=0
    USE_NDBCLUSTER_OPT=
  fi
  
  if [ x$USING_NDBCLUSTER = x1 -a -z "$USE_NDBCLUSTER_OPT" ]
  then
  rm -f $NDB_TOOLS_OUTPUT
  if [ -z "$USE_RUNNING_NDBCLUSTER" ]
  then
    if [ "$DO_BENCH" != 1 -a -z "$NDBCLUSTER_EXTRA_OPTS" ]
    then
      NDBCLUSTER_EXTRA_OPTS="--small"
    fi
    OPTS="$NDBCLUSTER_OPTS $NDBCLUSTER_EXTRA_OPTS --character-sets-dir=$CHARSETSDIR --verbose=$NDB_VERBOSE --initial --relative-config-data-dir --core"
    if [ "x$NDB_VERBOSE" != "x0" ] ; then
      echo "Starting master ndbcluster " $OPTS
    fi
    ./ndb/ndbcluster $OPTS || NDB_STATUS_OK=0
    if [ x$NDB_STATUS_OK != x1 ] ; then
      if [ x$FORCE != x1 ] ; then
        exit 1
      fi
      USING_NDBCLUSTER=0
      USE_NDBCLUSTER_OPT=
      return
    fi

    NDB_CONNECTSTRING="host=localhost:$NDBCLUSTER_PORT"
  else
    NDB_CONNECTSTRING="$USE_RUNNING_NDBCLUSTER"
    echo "Using ndbcluster at $NDB_CONNECTSTRING"
  fi
  USE_NDBCLUSTER_OPT="$USE_NDBCLUSTER --ndb-connectstring=\"$NDB_CONNECTSTRING\" --ndb-extra-logging"
  export NDB_CONNECTSTRING
  fi
}

rm_ndbcluster_tables()
{
  $RM -f $1/mysql/apply_status*
  $RM -f $1/mysql/schema*
}

stop_ndbcluster()
{
 if [ -n "$USE_NDBCLUSTER_OPT" ]
 then
 USE_NDBCLUSTER_OPT=
 if [ -z "$USE_RUNNING_NDBCLUSTER" ]
 then
   # Kill any running ndbcluster stuff
   $ECHO "Stopping master cluster"
   ./ndb/ndbcluster $NDBCLUSTER_OPTS --stop
   # remove ndb table the hard way as not to upset later tests
   rm_ndbcluster_tables $MASTER_MYDDIR
   rm_ndbcluster_tables $MASTER_MYDDIR"1"
 fi
 fi
}

# The embedded server needs the cleanup so we do some of the start work
# but stop before actually running mysqld or anything.

start_master()
{
  eval "this_master_running=\$MASTER$1_RUNNING"
  if [ x$this_master_running = x1 ] || [ x$LOCAL_MASTER = x1 ] ; then
    return
  fi
  # Remove stale binary logs except for 2 tests which need them
  if [ "$tname" != "rpl_crash_binlog_ib_1b" ] && [ "$tname" != "rpl_crash_binlog_ib_2b" ] && [ "$tname" != "rpl_crash_binlog_ib_3b" ] 
  then
    $RM -f $MYSQL_TEST_DIR/var/log/master-bin$1.*
  fi

  # Remove old master.info and relay-log.info files
  $RM -f $MYSQL_TEST_DIR/var/master-data$1/master.info $MYSQL_TEST_DIR/var/master-data$1/relay-log.info

  #run master initialization shell script if one exists

  if [ -f "$master_init_script" ] ;
  then
      /bin/sh $master_init_script
  fi
  cd $BASEDIR # for gcov
  if [ -n "$1" ] ; then
   id=`$EXPR $1 + 101`;
   this_master_myport=`$EXPR $MASTER_MYPORT + $1`
   NOT_FIRST_MASTER_EXTRA_OPTS="--skip-innodb"
   eval "MASTER_MYPORT$1=$this_master_myport"
   export MASTER_MYPORT$1
  else
   id=1;
   this_master_myport=$MASTER_MYPORT
   NOT_FIRST_MASTER_EXTRA_OPTS=""
  fi
  if [ -n "$EXTRA_MASTER_MYSQLD_TRACE" ] 
  then
      CURR_MASTER_MYSQLD_TRACE="$EXTRA_MASTER_MYSQLD_TRACE$1"
  fi
  if [ x$MASTER_MYSQLDBINLOG = x1 ]
  then
    MASTER_MYSQLD_BINLOG_OPT="--log-bin=$MYSQL_TEST_DIR/var/log/master-bin$1"
  fi
  if [ -z "$DO_BENCH" -a -z "$DO_STRESS"  ]
  then
    master_args="--no-defaults \
  	    --server-id=$id  \
          --basedir=$MY_BASEDIR \
          --port=$this_master_myport \
          --port-open-timeout=380 \
          --local-infile \
          --exit-info=256 \
          --core \
          $USE_NDBCLUSTER_OPT \
          --datadir=$MASTER_MYDDIR$1 \
          --pid-file=$MASTER_MYPID$1 \
          --socket=$MASTER_MYSOCK$1 \
          --log=$MASTER_MYLOG$1 \
          --character-sets-dir=$CHARSETSDIR \
          --default-character-set=$CHARACTER_SET \
          --tmpdir=$MYSQL_TMP_DIR \
          --language=$LANGUAGE \
          --innodb_data_file_path=ibdata1:128M:autoextend \
	  --open-files-limit=1024 \
          --log-bin-trust-function-creators \
	   $MASTER_40_ARGS \
           $SMALL_SERVER \
           $MASTER_MYSQLD_BINLOG_OPT \
           $EXTRA_MASTER_MYSQLD_OPT $EXTRA_MASTER_OPT \
           $NOT_FIRST_MASTER_EXTRA_OPTS $CURR_MASTER_MYSQLD_TRACE"
  else
    master_args="--no-defaults \
          --server-id=$id --rpl-recovery-rank=1 \
          --basedir=$MY_BASEDIR --init-rpl-role=master \
          --port=$this_master_myport \
          --port-open-timeout=380 \
          --local-infile \
          --datadir=$MASTER_MYDDIR$1 \
          --pid-file=$MASTER_MYPID$1 \
          --socket=$MASTER_MYSOCK$1 \
          --character-sets-dir=$CHARSETSDIR \
          --default-character-set=$CHARACTER_SET \
          --core \
          $USE_NDBCLUSTER_OPT \
          --tmpdir=$MYSQL_TMP_DIR \
          --language=$LANGUAGE \
          --innodb_data_file_path=ibdata1:128M:autoextend \
          --log-bin-trust-function-creators \
	   $MASTER_40_ARGS \
           $SMALL_SERVER \
           $MASTER_MYSQLD_BINLOG_OPT \
           $EXTRA_MASTER_MYSQLD_OPT $EXTRA_MASTER_OPT \
           $NOT_FIRST_MASTER_EXTRA_OPTS"
  fi

  CUR_MYERR=$MASTER_MYERR$1
  CUR_MYSOCK=$MASTER_MYSOCK$1

  # For embedded server we collect the server flags and return
  if [ "x$USE_EMBEDDED_SERVER" = "x1" ] ; then
    # Add a -A to each argument to pass it to embedded server
    EMBEDDED_SERVER_OPTS=""
    for opt in $master_args
    do
      EMBEDDED_SERVER_OPTS="$EMBEDDED_SERVER_OPTS -A $opt"
    done
    EXTRA_MYSQL_TEST_OPT="$EMBEDDED_SERVER_OPTS"
    return
  fi

  if [ x$DO_DDD = x1 ]
  then
    $ECHO "set args $master_args" > $GDB_MASTER_INIT$1
    launch_in_background master ddd -display $DISPLAY --debugger \
    "gdb -x $GDB_MASTER_INIT$1" $MASTER_MYSQLD
  elif [ x$DO_GDB = x1 ]
  then
    if [ x$MANUAL_GDB = x1 ]
    then
      $ECHO "set args $master_args" > $GDB_MASTER_INIT$1
      $ECHO "To start gdb for the master , type in another window:"
      $ECHO "cd $MYSQL_TEST_DIR ; gdb -x $GDB_MASTER_INIT$1 $MASTER_MYSQLD"
      wait_for_master=1500
    else
      ( $ECHO set args $master_args;
      if [ $USE_MANAGER = 0 ] ; then
    cat <<EOF
b mysql_parse
commands 1
disa 1
end
r
EOF
      fi )  > $GDB_MASTER_INIT$1
      launch_in_background master $XTERM -display $DISPLAY \
      -title "Master" -e gdb -x $GDB_MASTER_INIT$1 $MASTER_MYSQLD
    fi
  else
    launch_in_background master $MASTER_MYSQLD $master_args
  fi
  sleep_until_file_created $MASTER_MYPID$1 $wait_for_master
  wait_for_master=$SLEEP_TIME_FOR_SECOND_MASTER
  eval "MASTER$1_RUNNING=1"
}

start_slave()
{
  [ x$SKIP_SLAVE = x1 ] && return
  eval "this_slave_running=\$SLAVE$1_RUNNING"
  [ x$this_slave_running = 1 ] && return

  # When testing fail-safe replication, we will have more than one slave
  # in this case, we start secondary slaves with an argument
  slave_ident="slave$1"
  if [ -n "$1" ] ;
  then
   slave_server_id=`$EXPR 2 + $1`
   slave_rpl_rank=$slave_server_id
   slave_port=`expr $SLAVE_MYPORT + $1`
   slave_log="$SLAVE_MYLOG.$1"
   slave_err="$SLAVE_MYERR.$1"
   slave_datadir="$SLAVE_MYDDIR/../$slave_ident-data/"
   slave_pid="$MYRUN_DIR/mysqld-$slave_ident.pid"
   slave_sock="$SLAVE_MYSOCK-$1"
  else
   slave_server_id=2
   slave_rpl_rank=2
   slave_port=$SLAVE_MYPORT
   slave_log=$SLAVE_MYLOG
   slave_err=$SLAVE_MYERR
   slave_datadir=$SLAVE_MYDDIR
   slave_pid=$SLAVE_MYPID
   slave_sock="$SLAVE_MYSOCK"
 fi

  #
  if [ x$USING_NDBCLUSTER = x1 -a -n "$USE_NDBCLUSTER_SLAVE" ] ; then
    if [ $slave_server_id -eq 2 ] ; then
      savedir=`pwd`
      cd $MYSQL_TEST_DIR
      if [ "$DO_BENCH" != 1 -a -z "$NDBCLUSTER_EXTRA_OPTS" ]
       then
         NDBCLUSTER_EXTRA_OPTS="--small"
      fi

      OPTS="$NDBCLUSTER_OPTS_SLAVE --initial $NDBCLUSTER_EXTRA_OPTS --ndbd-nodes=1 --verbose=$NDB_VERBOSE --relative-config-data-dir --core"
      if [ "x$NDB_VERBOSE" != "x0" ] ; then
        echo "Starting slave ndbcluster " $OPTS
      fi
      ./ndb/ndbcluster $OPTS \
                      || NDB_SLAVE_STATUS_OK=0
      #                > /dev/null 2>&1 || NDB_SLAVE_STATUS_OK=0
      cd $savedir
      if [ x$NDB_SLAVE_STATUS_OK != x1 ] ; then
        if [ x$FORCE != x1 ] ; then
          exit 1
        fi
        USE_NDBCLUSTER_SLAVE_OPT=
        USE_NDBCLUSTER_SLAVE=
      fi
      USE_NDBCLUSTER_SLAVE_OPT=$USE_NDBCLUSTER_SLAVE
    fi
  else
    USE_NDBCLUSTER_SLAVE_OPT=
  fi

  # Remove stale binary logs and old master.info files
  # except for too tests which need them
  if [ "$tname" != "rpl_crash_binlog_ib_1b" ] && [ "$tname" != "rpl_crash_binlog_ib_2b" ] && [ "$tname" != "rpl_crash_binlog_ib_3b" ]
  then
    $RM -f $MYSQL_TEST_DIR/var/log/$slave_ident-*bin.*
    $RM -f $slave_datadir/master.info $slave_datadir/relay-log.info
  fi

  #run slave initialization shell script if one exists
  if [ -f "$slave_init_script" ] ;
  then
        /bin/sh $slave_init_script
  fi

  if [ -z "$SLAVE_MASTER_INFO" ] ; then
    master_info="--master-user=root \
          --master-connect-retry=1 \
          --master-host=127.0.0.1 \
          --master-password="" \
          --master-port=$MASTER_MYPORT \
          --server-id=$slave_server_id --rpl-recovery-rank=$slave_rpl_rank"
 else
   master_info=$SLAVE_MASTER_INFO
 fi

  if [ x$SLAVE_MYSQLDBINLOG = x1 ]
  then
    SLAVE_MYSQLD_BINLOG_OPT="--log-bin=$MYSQL_TEST_DIR/var/log/$slave_ident-bin --log-slave-updates"
  fi

  $RM -f $slave_datadir/log.*
  slave_args="--no-defaults $master_info \
  	    --exit-info=256 \
          $SLAVE_MYSQLDBINLOG_OPT \
          --relay-log=$MYSQL_TEST_DIR/var/log/$slave_ident-relay-bin \
          --log=$slave_log \
          --basedir=$MY_BASEDIR \
          --datadir=$slave_datadir \
          --pid-file=$slave_pid \
          --port=$slave_port \
          --port-open-timeout=380 \
          --socket=$slave_sock \
          --character-sets-dir=$CHARSETSDIR \
          --default-character-set=$CHARACTER_SET \
          --core --init-rpl-role=slave \
          --tmpdir=$MYSQL_TMP_DIR \
          --language=$LANGUAGE \
          --skip-innodb --skip-ndbcluster --skip-slave-start \
          --slave-load-tmpdir=$SLAVE_LOAD_TMPDIR \
          --report-host=127.0.0.1 --report-user=root \
          --report-port=$slave_port \
          --master-retry-count=10 \
          -O slave_net_timeout=10 \
          --log-bin-trust-function-creators \
           $SMALL_SERVER \
           $SLAVE_MYSQLD_BINLOG_OPT \
           $EXTRA_SLAVE_MYSQLD_OPT $EXTRA_SLAVE_OPT \
           $USE_NDBCLUSTER_SLAVE_OPT"
  CUR_MYERR=$slave_err
  CUR_MYSOCK=$slave_sock

  if [ x$DO_DDD = x1 ]
  then
    $ECHO "set args $slave_args" > $GDB_SLAVE_INIT
    launch_in_background $slave_ident ddd -display $DISPLAY --debugger \
     "gdb -x $GDB_SLAVE_INIT" $SLAVE_MYSQLD
  elif [ x$DO_GDB = x1 ]
  then
    if [ x$MANUAL_GDB = x1 ]
    then
      $ECHO "set args $slave_args" > $GDB_SLAVE_INIT
      echo "To start gdb for the slave, type in another window:"
      echo "cd $MYSQL_TEST_DIR ; gdb -x $GDB_SLAVE_INIT $SLAVE_MYSQLD"
      wait_for_slave=1500
    else
      ( $ECHO set args $slave_args;
      if [ $USE_MANAGER = 0 ] ; then
    cat <<EOF
b mysql_parse
commands 1
disa 1
end
r
EOF
      fi )  > $GDB_SLAVE_INIT
      launch_in_background $slave_ident $XTERM -display $DISPLAY -title "Slave" -e \
      gdb -x $GDB_SLAVE_INIT $SLAVE_MYSQLD
    fi
  else
    launch_in_background $slave_ident $SLAVE_MYSQLD $slave_args
  fi
  eval "SLAVE$1_RUNNING=1"
  sleep_until_file_created $slave_pid $wait_for_slave
  wait_for_slave=$SLEEP_TIME_FOR_SECOND_SLAVE
}

mysql_start ()
{
# We should not start the daemon here as we don't know the arguments
# for the test.  Better to let the test start the daemon

#  $ECHO "Starting MySQL daemon"
#  start_master
#  start_slave
  cd $MYSQL_TEST_DIR
  return 1
}

stop_slave ()
{
  eval "this_slave_running=\$SLAVE$1_RUNNING"
  slave_ident="slave$1"
  if [ -n "$1" ] ;
  then
   slave_pid="$MYRUN_DIR/mysqld-$slave_ident.pid"
  else
   slave_pid=$SLAVE_MYPID
  fi
  if [ x$this_slave_running = x1 ]
  then
    pid=`$CAT $slave_pid`
    shutdown_mysqld $pid $slave_ident
    if [ $? != 0 ] && [ -f $slave_pid ]
    then # try harder!
      $ECHO "slave not cooperating with mysqladmin, will try manual kill"
      kill $pid
      sleep_until_file_deleted $pid $slave_pid
      if [ -f $slave_pid ] ; then
        $ECHO "slave refused to die. Sending SIGKILL"
        kill -9 `$CAT $slave_pid`
        $RM -f $slave_pid
      else
        $ECHO "slave responded to SIGTERM "
      fi
    else
      sleep $SLEEP_TIME_AFTER_RESTART
    fi
    eval "SLAVE$1_RUNNING=0"
    if [ -n "$USE_NDBCLUSTER_SLAVE_OPT" ] ; then
      savedir=`pwd`
      cd $MYSQL_TEST_DIR
        $ECHO "Stopping slave cluster"
      ./ndb/ndbcluster $NDBCLUSTER_OPTS_SLAVE --stop
      rm_ndbcluster_tables $SLAVE_MYDDIR
      cd $savedir
    fi
  fi
}

stop_slave_threads ()
{
  eval "this_slave_running=\$SLAVE$1_RUNNING"
  slave_ident="slave$1"
  if [ x$this_slave_running = x1 ]
  then
    $MYSQLADMIN --no-defaults -uroot --socket=$MYSQL_TMP_DIR/$slave_ident.sock stop-slave > /dev/null 2>&1
  fi
}

stop_master ()
{
  eval "this_master_running=\$MASTER$1_RUNNING"
  if [ x$this_master_running = x1 ]
  then
    # For embedded server we don't stop anyting but mark that
    # MASTER_RUNNING=0 to get cleanup when calling start_master().
    if [ x$USE_EMBEDDED_SERVER != x1 ] ; then
      pid=`$CAT $MASTER_MYPID$1`
      shutdown_mysqld $pid master $1
      if [ $? != 0 ] && [ -f $MASTER_MYPID$1 ]
      then # try harder!
	$ECHO "master not cooperating with mysqladmin, will try manual kill"
	kill $pid
	sleep_until_file_deleted $pid $MASTER_MYPID$1
	if [ -f $MASTER_MYPID$1 ] ; then
	  $ECHO "master refused to die. Sending SIGKILL"
	  kill -9 `$CAT $MASTER_MYPID$1`
	  $RM -f $MASTER_MYPID$1
	else
	  $ECHO "master responded to SIGTERM "
	fi
      else
	sleep $SLEEP_TIME_AFTER_RESTART
      fi
    fi
    eval "MASTER$1_RUNNING=0"
  fi
}

mysql_stop ()
{
  if [ "$MASTER_RUNNING" = 1 ]
  then
    $ECHO  "Ending Tests"
    $ECHO  "Shutting-down MySQL daemon"
    $ECHO  ""
    stop_master
    stop_master 1
    $ECHO "Master shutdown finished"
    stop_slave
    stop_slave 1
    stop_slave 2
    $ECHO "Slave shutdown finished"
    stop_ndbcluster
  fi
  return 1
}

mysql_restart ()
{
  mysql_stop
  mysql_start
  return 1
}

mysql_loadstd () {

    # cp $STD_DATA/*.frm $STD_DATA/*.MRG $MASTER_MYDDIR/test
    return 1
}

run_testcase ()
{
 tf=$1
 tname=`$BASENAME $tf .test`
 master_opt_file=$TESTDIR/$tname-master.opt
 slave_opt_file=$TESTDIR/$tname-slave.opt
 master_init_script=$TESTDIR/$tname-master.sh
 slave_init_script=$TESTDIR/$tname-slave.sh
 slave_master_info_file=$TESTDIR/$tname.slave-mi
 tsrcdir=$TESTDIR/$tname-src
 result_file="r/$tname.result"
 echo $tname > $CURRENT_TEST
 SKIP_SLAVE=`$EXPR \( $tname : rpl \) = 0 \& \( $tname : federated \) = 0`
 NDBCLUSTER_TEST=`$EXPR \( $tname : '.*ndb.*' \) != 0`
 if [ "x$USE_NDBCLUSTER_ALL" = "x1" ] ; then
   NDBCLUSTER_TEST=1
 fi
 if [ "x$USE_NDBCLUSTER_ONLY" = "x1" -a "x$NDBCLUSTER_TEST" != "x1" ] ; then
   skip_test $tname
   return
 fi
 if [ "$USE_MANAGER" = 1 ] ; then
  many_slaves=`$EXPR \( \( $tname : rpl_failsafe \) != 0 \) \| \( \( $tname : rpl_chain_temp_table \) != 0 \)`
 fi
 if $EXPR "$tname" '<' "$START_FROM" > /dev/null ; then
   #skip_test $tname
   return
 fi

 if [ "$SKIP_TEST" ] ; then
   if $EXPR \( "$tname" : "$SKIP_TEST" \) > /dev/null ; then
     skip_test $tname
     return
   fi
 fi

 if [ "$DO_TEST" ] ; then
   if $EXPR \( "$tname" : "$DO_TEST" \) > /dev/null ; then
     : #empty command to keep some shells happy
   else
     #skip_test $tname
     return
   fi
 fi

 if [ x${NO_SLAVE}x$SKIP_SLAVE = x1x0 ] ; then
   skip_test $tname
   return
 fi

# if [ -f "$TESTDIR/$tname.disabled" ]
# then
#   comment=`$CAT $TESTDIR/$tname.disabled`;
#   disable_test $tname "$comment"
#   return
# fi
 if [ -f "$TESTDIR/disabled.def" ] ; then
   comment=`$GREP "^$tname *: *" $TESTDIR/disabled.def`;
   if [ -n "$comment" ]
   then
     comment=`echo $comment | sed 's/^[^:]*: *//'`
     disable_test $tname "$comment"
     return
   fi
 fi

 if [ "x$USE_EMBEDDED_SERVER" != "x1" ] ; then
   # Stop all slave threads, so that we don't have useless reconnection
   #  attempts and error messages in case the slave and master servers restart.
   stop_slave_threads
   stop_slave_threads 1
   stop_slave_threads 2
 fi

 # FIXME temporary solution, we will get a new C version of this
 # script soon anyway so it is not worth it spending the time
 if [ "x$USE_EMBEDDED_SERVER" = "x1" -a -z "$DO_TEST" ] ; then
   for t in \
       "init_connect" \
       "init_file"
   do
     if [ "$tname" = "$t" ] ; then
       skip_test $tname
       return
     fi
   done
 fi

 if [ $USE_RUNNING_SERVER -eq 0 ] ;
 then
   if [ -f $master_opt_file ] ;
   then
     EXTRA_MASTER_OPT=`$CAT $master_opt_file | $SED -e "s;\\$MYSQL_TEST_DIR;$MYSQL_TEST_DIR;"`
     case "$EXTRA_MASTER_OPT" in
       --timezone=*)
	 TZ=`$ECHO "$EXTRA_MASTER_OPT" | $SED -e "s;--timezone=;;"`
	 export TZ
	 # Note that this must be set to space, not "" for test-reset to work
	 EXTRA_MASTER_OPT=" "
	 ;;
       --result-file=*)
         result_file=`$ECHO "$EXTRA_MASTER_OPT" | $SED -e "s;--result-file=;;"`
         result_file="r/$result_file.result"
         # Note that this must be set to space, not "" for test-reset to work
	 EXTRA_MASTER_OPT=" "
         ;;
       --force-restart)
         # Note that this must be set to space, not "" for test-reset to work
	 EXTRA_MASTER_OPT=" "
	 ;;
     esac
     stop_master
     stop_master 1

     # only stop the cluster if this test will not use cluster
     if [ x$NDBCLUSTER_TEST != x1 ] ;
     then
       stop_ndbcluster
     fi

     report_current_test $tname
     USING_NDBCLUSTER=$NDBCLUSTER_TEST
     # start_ndbcluster knows if cluster is already started
     start_ndbcluster
     start_master
     if [ x$USING_NDBCLUSTER = x1 -a -z "$DO_BENCH" -a -z "$DO_STRESS" ] ; then
       echo "CURRENT_TEST: $tname" >> $MASTER_MYERR"1"
       start_master 1
     fi
     TZ=$MY_TZ; export TZ
   else
     # If we had extra master opts to the previous run
     # or there is no master running (FIXME strange.....)
     # or there is a master init script
     if [ ! -z "$EXTRA_MASTER_OPT" ] || [ x$MASTER_RUNNING != x1 ] || \
	[ -f $master_init_script ] || \
        [ -n "$USE_NDBCLUSTER" -a x$NDBCLUSTER_TEST != x$USING_NDBCLUSTER ]
     then
       EXTRA_MASTER_OPT=""
       stop_master
       stop_master 1

       # only stop the cluster if this test will not use cluster
       if [ x$NDBCLUSTER_TEST != x1 ] ;
       then
         stop_ndbcluster
       fi

       report_current_test $tname
       USING_NDBCLUSTER=$NDBCLUSTER_TEST
       # start_ndbcluster knows if cluster is already started
       start_ndbcluster
       start_master
       if [ x$USING_NDBCLUSTER = x1  -a -z "$DO_BENCH" -a -z "$DO_STRESS" ] ; then
         echo "CURRENT_TEST: $tname" >> $MASTER_MYERR"1"
         start_master 1
       fi
     else
       report_current_test $tname
     fi
   fi

   # We never start a slave if embedded server is used
   if [ "x$USE_EMBEDDED_SERVER" != "x1" ] ; then
     do_slave_restart=0
     if [ -f $slave_opt_file ] ;
     then
       EXTRA_SLAVE_OPT=`$CAT $slave_opt_file | $SED -e "s;\\$MYSQL_TEST_DIR;$MYSQL_TEST_DIR;"`
       do_slave_restart=1
     else
      if [ ! -z "$EXTRA_SLAVE_OPT" ] || [ x$SLAVE_RUNNING != x1 ] ;
      then
	EXTRA_SLAVE_OPT=""
	do_slave_restart=1
      fi
     fi

     if [ -f $slave_master_info_file ] ; then
       SLAVE_MASTER_INFO=`$CAT $slave_master_info_file`
       do_slave_restart=1
     else
       if [ ! -z "$SLAVE_MASTER_INFO" ] || [ x$SLAVE_RUNNING != x1 ] ;
       then
	 SLAVE_MASTER_INFO=""
	 do_slave_restart=1
       fi
     fi

     USING_NDBCLUSTER=$NDBCLUSTER_TEST
     if [ -n "$USE_NDBCLUSTER_SLAVE_OPT" ] ; then
       if [ x$USING_NDBCLUSTER != x1 ] ; then
         do_slave_restart=1
       fi
     else
       if [ x$USING_NDBCLUSTER = x1 ] ; then
         do_slave_restart=1
       fi
     fi


     if [ x$do_slave_restart = x1 ] ; then
       stop_slave
       echo "CURRENT_TEST: $tname" >> $SLAVE_MYERR
       start_slave
     else
       echo "CURRENT_TEST: $tname" >> $SLAVE_MYERR
     fi
     if [ x$many_slaves = x1 ]; then
      start_slave 1
      start_slave 2
     fi
   fi
 fi

 if [ "x$START_AND_EXIT" = "x1" ] ; then
  echo "Servers started, exiting"
  exit
 fi

 cd $MYSQL_TEST_DIR

 if [ -f $tf ] ; then
    $RM -f r/$tname.*reject
    mysql_test_args="-R $result_file $EXTRA_MYSQL_TEST_OPT"
    if [ -z "$DO_CLIENT_GDB" ] ; then
      `$VALGRIND_MYSQLTEST $MYSQL_TEST  $mysql_test_args < $tf 2> $TIMEFILE`;
    else
      do_gdb_test "$mysql_test_args" "$tf"
    fi

    res=$?

    # Save the testcase log to mysqltest log file
    echo "CURRENT_TEST: $tname" >> $MYSQLTEST_LOG
    cat $TIMEFILE >> $MYSQLTEST_LOG

    pname=`$ECHO "$tname                        "|$CUT -c 1-24`
    RES="$pname"

    if [ x$many_slaves = x1 ] ; then
     stop_slave 1
     stop_slave 2
    fi

    if [ $res = 0 ]; then
      total_inc
      pass_inc
      TIMER=""
      if [ x$USE_TIMER = x1 -a -f "$MY_LOG_DIR/timer" ]; then
	TIMER=`cat $MY_LOG_DIR/timer`
	TIMER=`$PRINTF "%13s" $TIMER`
      fi
      $ECHO "$RES$RES_SPACE [ pass ]   $TIMER"
    else
      # why the following ``if'' ? That is why res==1 is special ?
      if [ $res = 62 ]; then
        skip_inc
	$ECHO "$RES$RES_SPACE [ skipped ]"
      else
        if [ $res -ne 1 ]; then
          $ECHO "mysqltest returned unexpected code $res, it has probably crashed" >> $TIMEFILE
        fi
	total_inc
        fail_inc
	$ECHO "$RES$RES_SPACE [ fail ]"
        $ECHO
	error_is
	show_failed_diff $tname
	$ECHO
	if [ x$FORCE != x1 ] ; then
	 $ECHO "Aborting: $tname failed in $TEST_MODE mode. To continue, re-run with '--force'."
	 $ECHO
         if [ -z "$DO_GDB" ] && [ $USE_RUNNING_SERVER -eq 0 ] && \
	    [ -z "$DO_DDD" ] && [ -z "$USE_EMBEDDED_SERVER" ]
	 then
	   mysql_stop
   	 fi
	 exit 1
	fi
	FAILED_CASES="$FAILED_CASES $tname"
        if [ -z "$DO_GDB" ] && [ $USE_RUNNING_SERVER -eq 0 ] && \
	   [ -z "$DO_DDD" ] && [ -z "$USE_EMBEDDED_SERVER" ]
	then
	  mysql_restart
	fi
      fi
    fi
  fi
}

run_stress_test()
{

  STRESS_BASEDIR="$MYSQL_TEST_DIR/var/stress"

  #Clean-up old stress test basedir
  if [ -d $STRESS_BASEDIR ] ; then 
    $RM -rf $STRESS_BASEDIR
  fi
  #Create stress test basedir 
  mkdir $STRESS_BASEDIR

  if [ "$STRESS_SUITE" != "main" -a "$STRESS_SUITE" != "default" ] ; then
    STRESS_SUITE_DIR="$MYSQL_TEST_DIR/suite/$STRESS_SUITE"
  else
    STRESS_SUITE_DIR="$MYSQL_TEST_DIR"
  fi

  if [ -d "$STRESS_SUITE_DIR" ] ; then 
    STRESS_SUITE_T_DIR="$STRESS_SUITE_DIR/t"
    STRESS_SUITE_R_DIR="$STRESS_SUITE_DIR/r"
    #FIXME: check that dirs above are exist
  else
    echo "Directory $STRESS_SUITE_DIR with test suite doesn't exists. Abort stress testing"
    exit 1
  fi
  
  if [ -n "$STRESS_TEST" ] ; then 
    STRESS_TEST_FILE="$STRESS_BASEDIR/stress_tests.txt"
    echo $STRESS_TEST > $STRESS_TEST_FILE
  elif [ -n "$STRESS_TEST_FILE" ] ; then    
    STRESS_TEST_FILE="$STRESS_SUITE_DIR/$STRESS_TEST_FILE"
    if [ ! -f  "$STRESS_TEST_FILE" ] ; then 
      echo "Specified file $STRESS_TEST_FILE with list of tests does not exist"
      echo "Please ensure that file exists and has proper permissions"
      exit 1
    fi
  else 
    STRESS_TEST_FILE="$STRESS_SUITE_DIR/stress_tests.txt"
    if [ ! -f  "$STRESS_TEST_FILE" ] ; then 
      echo "Default file $STRESS_TEST_FILE with list of tests does not exist."
      echo "Please use --stress-test-file option to specify custom one or you can" 
      echo "just specify name of test for testing as last argument in command line"
      exit 1
    fi
  fi

  if [ -n "$STRESS_INIT_FILE" ] ; then 
    STRESS_INIT_FILE="$STRESS_SUITE_DIR/$STRESS_INIT_FILE"
    if [ ! -f  "$STRESS_INIT_FILE" ] ; then 
      echo "Specified file $STRESS_INIT_FILE with list of tests doesn't exist."
      echo "Please ensure that file exists and has proper permissions"
      exit 1
    fi
  else
    STRESS_INIT_FILE="$STRESS_SUITE_DIR/stress_init.txt"
    #Check for default init file
    if [ ! -f "$STRESS_INIT_FILE" ] ; then 
      STRESS_INIT_FILE=""
    fi
  fi

  if [ "$STRESS_MODE" != "random" -a "$STRESS_MODE" != "seq" ] ; then
    echo "You specified wrong mode '$STRESS_MODE' for stress test."
    echo "Correct values are 'random' or 'seq'"
    exit 1
  fi
 
  STRESS_TEST_ARGS="--server-socket=$MASTER_MYSOCK \
                    --server-user=$DBUSER \
                    --server-database=$DB \
                    --stress-suite-basedir=$MYSQL_TEST_DIR \
                    --suite=$STRESS_SUITE \
                    --stress-tests-file=$STRESS_TEST_FILE \
                    --stress-basedir=$STRESS_BASEDIR \
                    --server-logs-dir=$STRESS_BASEDIR \
                    --stress-mode=$STRESS_MODE \
                    --mysqltest=$CLIENT_BINDIR/mysqltest \
                    --threads=$STRESS_THREADS \
                    --verbose \
                    --cleanup \
                    --log-error-details \
                    --abort-on-error" 
  
  if [ -n "$STRESS_INIT_FILE" ] ; then 
    STRESS_TEST_ARGS="$STRESS_TEST_ARGS --stress-init-file=$STRESS_INIT_FILE"
  fi

  if [ -z "$STRESS_LOOP_COUNT" -a -z  "$STRESS_TEST_COUNT" -a 
       -z "$STRESS_TEST_DURATION" ] ; then 

    #Limit stress testing with 20 loops in case when any limit parameter
    #was specified
    STRESS_TEST_COUNT=20
  fi

  if [ -n "$STRESS_LOOP_COUNT" ] ; then 
    STRESS_TEST_ARGS="$STRESS_TEST_ARGS --loop-count=$STRESS_LOOP_COUNT"
  fi

  if [ -n "$STRESS_TEST_COUNT" ] ; then 
    STRESS_TEST_ARGS="$STRESS_TEST_ARGS --test-count=$STRESS_TEST_COUNT"
  fi

  if [ -n "$STRESS_TEST_DURATION" ] ; then 
    STRESS_TEST_ARGS="$STRESS_TEST_ARGS --test-duration=$STRESS_TEST_DURATION"
  fi  

  echo "Stress test related variables:"
  echo "TESTS                - $1"
  echo "STRESS               - $DO_STRESS"
  echo "STRESS_SUITE         - $STRESS_SUITE"
  echo "STRESS_TEST_FILE     - $STRESS_TEST_FILE"
  echo "STRESS_INIT_FILE     - $STRESS_INIT_FILE"
  echo "STRESS_THREADS       - $STRESS_THREADS"
  echo "STRESS_MODE          - $STRESS_MODE"
  echo "STRESS_TEST_COUNT    - $STRESS_TEST_COUNT"
  echo "STRESS_LOOP_COUNT    - $STRESS_LOOP_COUNT"  
  echo "STRESS_TEST_DURATION - $STRESS_TEST_DURATION"

  #echo "$STRESS_TEST_ARGS";
  #Run stress test 
  $MYSQL_TEST_DIR/mysql-stress-test.pl $STRESS_TEST_ARGS


}

######################################################################
# Main script starts here
######################################################################

[ "$DO_GCOV" -a ! -x "$GCOV" ] && error "No gcov found"

[ "$DO_GCOV" ] && gcov_prepare
[ "$DO_GPROF" ] && gprof_prepare

if [ $USE_RUNNING_SERVER -eq 0 ]
then
  if [ -z "$FAST_START" ]
  then
    # Ensure that no old mysqld test servers are running
    $MYSQLADMIN --no-defaults --socket=$MASTER_MYSOCK -u root -O connect_timeout=5 -O shutdown_timeout=20 shutdown > /dev/null 2>&1
    $MYSQLADMIN --no-defaults --socket=$MASTER_MYSOCK1 -u root -O connect_timeout=5 -O shutdown_timeout=20 shutdown > /dev/null 2>&1
    $MYSQLADMIN --no-defaults --socket=$SLAVE_MYSOCK -u root -O connect_timeout=5 -O shutdown_timeout=20 shutdown > /dev/null 2>&1
    $MYSQLADMIN --no-defaults --host=$hostname --port=$MASTER_MYPORT --protocol=tcp -u root -O connect_timeout=5 -O shutdown_timeout=20 shutdown > /dev/null 2>&1
    $MYSQLADMIN --no-defaults --host=$hostname --protocol=tcp --port=`expr $MASTER_MYPORT + 1` -u root -O connect_timeout=5 -O shutdown_timeout=20 shutdown > /dev/null 2>&1
    $MYSQLADMIN --no-defaults --host=$hostname --protocol=tcp --port=$SLAVE_MYPORT -u root -O connect_timeout=5 -O shutdown_timeout=20 shutdown > /dev/null 2>&1
    $MYSQLADMIN --no-defaults --host=$hostname --protocol=tcp --port=`expr $SLAVE_MYPORT + 1` -u root -O connect_timeout=5 -O shutdown_timeout=20 shutdown > /dev/null 2>&1
    sleep_until_file_deleted 0 $MASTER_MYPID
    sleep_until_file_deleted 0 $MASTER_MYPID"1"
    sleep_until_file_deleted 0 $SLAVE_MYPID
  else
    rm $MASTER_MYPID $MASTER_MYPID"1" $SLAVE_MYPID
  fi

  # just to force stopping anything from previous runs
  USE_NDBCLUSTER_OPT=$USE_NDBCLUSTER
  stop_ndbcluster

  # Remove files that can cause problems
  $RM -rf $MYSQL_TEST_DIR/var/ndbcluster
  $RM -rf $MYSQL_TEST_DIR/var/tmp/snapshot*
  $RM -rf $MYSQL_TEST_DIR/var/run/* $MYSQL_TEST_DIR/var/tmp/*

  # Remove old berkeley db log files that can confuse the server
  $RM -f $MASTER_MYDDIR/log.*
  $RM -f $MASTER_MYDDIR"1"/log.*

  # Remove old log and reject files
  $RM -f r/*.reject r/*.progress r/*.log r/*.warnings

  wait_for_master=$SLEEP_TIME_FOR_FIRST_MASTER
  wait_for_slave=$SLEEP_TIME_FOR_FIRST_SLAVE
  $ECHO "Installing Test Databases"
  mysql_install_db

  if [ -n "$1" -a `expr "X$*" : '.*ndb'` -eq 0 ]
  then
    USING_NDBCLUSTER=0
    USE_NDBCLUSTER_OPT=
  fi

  mysql_start
  $ECHO  "Loading Standard Test Databases"
  mysql_loadstd
fi

$ECHO  "Starting Tests"

# Some test cases need USE_RUNNING_SERVER
export USE_RUNNING_SERVER

#
# This can probably be deleted
#
if [ "$DO_BENCH" = 1 ]
then
  start_master

  if [ "$DO_SMALL_BENCH" = 1 ]
  then
    EXTRA_BENCH_ARGS="--small-test --small-tables"
  fi

  if [ x$USING_NDBCLUSTER = x1 ]
  then
    EXTRA_BENCH_ARGS="--create-options=TYPE=ndb $EXTRA_BENCH_ARGS"
  fi 

  BENCHDIR=$BASEDIR/sql-bench/
  savedir=`pwd`
  cd $BENCHDIR
  if [ -z "$1" ]
  then
    ./run-all-tests --socket=$MASTER_MYSOCK --user=root $EXTRA_BENCH_ARGS --log
  else
    if [ -x "./$1" ]
    then
       ./$1 --socket=$MASTER_MYSOCK --user=root $EXTRA_BENCH_ARGS
    else
      echo "benchmark $1 not found"
    fi
  fi
  cd $savedir
  mysql_stop
  exit
fi

#
# Stress testing
#
if [ "$DO_STRESS" = 1 ] 
then

  if [ -n "$1" ] ; then
    STRESS_TEST="$1";
  fi                      
 
  if [ $USE_RUNNING_SERVER -eq 0 ] ; then 
    start_master
  fi
 
  run_stress_test

  if [ $USE_RUNNING_SERVER -eq 0 ] ; then
    mysql_stop
  fi
  
  exit

fi


$ECHO
if [ x$USE_TIMER = x1 ] ; then
$ECHO "TEST                            RESULT        TIME (ms)"
else
$ECHO "TEST                            RESULT"
fi
$ECHO $DASH72

if [ -z "$1" ] ;
then
  if [ x$RECORD = x1 ]; then
    $ECHO "Will not run in record mode without a specific test case."
  else
    for tf in $TESTDIR/*.$TESTSUFFIX
    do
      run_testcase $tf
    done
    $RM -f $TIMEFILE	# Remove for full test
  fi
else
  while [ ! -z "$1" ]; do
    tname=`$BASENAME $1 .test`
    tf=$TESTDIR/$tname.$TESTSUFFIX
    if [ -f $tf ] ; then
      run_testcase $tf
    else
      $ECHO "Test case $tf does not exist."
    fi
    shift
  done
fi

$ECHO $DASH72
$ECHO

if [ -z "$DO_GDB" ] && [ $USE_RUNNING_SERVER -eq 0 ] && [ -z "$DO_DDD" ]
then
    mysql_stop
fi
report_stats
$ECHO

[ "$DO_GCOV" ] && gcov_collect # collect coverage information
[ "$DO_GPROF" ] && gprof_collect # collect coverage information

if [ $TOT_FAIL -ne 0 ]; then
  $ECHO "mysql-test-run in $TEST_MODE mode: *** Failing the test(s):$FAILED_CASES"
  $ECHO
  exit 1
fi
if [ $GOT_WARNINGS -ne 0 ]; then
  exit 1
fi
exit 0
