#ifndef PG_CLIENT_H
#define PG_CLIENT_H

#include <libpq-fe.h>

class Pg_client: public Client
{
protected:
  PGconn* con;
  PGresult* res;
public:  
  Pg_client():Client(),con(0),res(0){}
  ~Pg_client() { clean_up(); }
  void do_connect();
  int safe_query(const char* query, int abort_on_error = 1);
  void lose_result();
  void disconnect();
  int check_error(int fatal = 1);
  int compare_result(const char* cmp_file, int abort_on_error = 1) ;
  int dump_result(const char* dump_file, int abort_on_error = 1);
  int get_table_info(Table& t);
  int load_table_data(string& table_name, const char* data_file_name);
};

#endif
