#include <string.h>
#include <malloc.h>
#include "forms.h"
#include "Xmysql.h"
#include "XmysqlDB.h"
#include "XmysqlErr.h"
#include "Xmysql_def.h"

/* GLOBAL FOR HELP */
int *FOUND_LINES = 0;
int CURRENT_FOUND_IDX = 0;

/* force exit via callback */
int 
XmysqlDefaultAtCloseCB (FL_FORM * form, void *data)
{
	return FL_IGNORE;
}

/* idle callback for results window */
int 
Results_IdleCB (XEvent * ev, void *data)
{
	int xoffsetBrowser = 0;
	int xoffsetHeader = 0;

	if (Xmysql_query_results_screen &&
			Xmysql_query_results_screen->Xmysql_query_results != 0) {
		xoffsetBrowser = fl_get_browser_xoffset (Xmysql_query_results_screen->xmysql_results);
		xoffsetHeader = fl_get_input_xoffset (Xmysql_query_results_screen->xmysql_header);
		if (xoffsetBrowser != xoffsetHeader)
			fl_set_input_xoffset (Xmysql_query_results_screen->xmysql_header,
														xoffsetBrowser);
	}
	return 0;
}

/* callbacks for form Xmysql_main */
void 
ShowDatabasesCB (FL_OBJECT * ob, long data)
{
	/* fill-in code for callback */
	XmysqlDB (XMYSQL_GET_DATABASES, 0);
}

void 
SelectedDatabaseCB (FL_OBJECT * ob, long data)
{
	/* fill-in code for callback */
	const char *brData = 0;

	brData = (char *) fl_get_browser_line (ob, fl_get_browser (ob));
	sprintf (CURRENT_DATABASE, "%s", brData);
	XmysqlDB (XMYSQL_GET_TABLES, 0);
	fl_activate_object (Xmysql_main_screen->xmysql_batch);
	fl_set_object_lcol (Xmysql_main_screen->xmysql_batch,
											FL_BLACK);
	fl_activate_object (Xmysql_main_screen->xmysql_adminTables);
	fl_set_object_lcol (Xmysql_main_screen->xmysql_adminTables,
											FL_BLACK);
	/* grey out other buttons */
	fl_deactivate_object (Xmysql_main_screen->xmysql_quickSelect);
	fl_set_object_lcol (Xmysql_main_screen->xmysql_quickSelect, FL_INACTIVE);
	fl_deactivate_object (Xmysql_main_screen->xmysql_sqlQuery);
	fl_set_object_lcol (Xmysql_main_screen->xmysql_sqlQuery, FL_INACTIVE);
}

void 
XmySQL_abboutCB (FL_OBJECT * ob, long data)
{
	/* fill-in code for callback */
	FD_Xmysql_about *fd;

	if (Xmysql_about_screen == 0) {
		fd = create_form_Xmysql_about ();
		fl_show_form (Xmysql_about_screen->Xmysql_about,
									FL_PLACE_CENTER | FL_FREE_SIZE,
									FL_FULLBORDER,
									"About XmySQL");
	}
}

void 
ExitCB (FL_OBJECT * ob, long data)
{
	/* fill-in code for callback */
	/* free memory */
	if (Xmysql_table_admin_screen)
		free (Xmysql_table_admin_screen);
	if (Xmysql_batch_query_screen)
		free (Xmysql_batch_query_screen);
	if (Xmysql_query_results_screen)
		free (Xmysql_query_results_screen);
	if (Xmysql_sql_screen)
		free (Xmysql_sql_screen);
	if (Xmysql_main_screen)
		free (Xmysql_main_screen);
	if (FOUND_LINES != 0)
		free (FOUND_LINES);
	exit (0);
}

void 
HelpCB (FL_OBJECT * ob, long data)
{
	/* fill-in code for callback */
	FD_Xmysql_help *fd;

	if (Xmysql_help_screen == 0) {
		fd = create_form_Xmysql_help ();
		fl_show_form (Xmysql_help_screen->Xmysql_help,
									FL_PLACE_CENTER | FL_FREE_SIZE,
									FL_FULLBORDER,
									"SQL Help");
	}
}

void 
ConfigCB (FL_OBJECT * ob, long data)
{
	/* fill-in code for callback */
	FD_Xmysql_config *fd;

	if (Xmysql_config_screen == 0) {
		fd = create_form_Xmysql_config ();
		fl_show_form (Xmysql_config_screen->Xmysql_config,
									FL_PLACE_CENTER | FL_FREE_SIZE,
									FL_FULLBORDER,
									"XmySQL Configure");
	}
}

void 
SelectedTableCB (FL_OBJECT * ob, long data)
{
	/* fill-in code for callback */
	char *brData = 0;

	brData = (char *) fl_get_browser_line (ob, fl_get_browser (ob));
	sprintf (CURRENT_TABLE, "%s", brData);
	if (XmysqlDB (XMYSQL_GET_FIELDS_MAIN, 0) == FALSE) {
		fl_activate_object (Xmysql_main_screen->xmysql_sqlQuery);
		fl_set_object_lcol (Xmysql_main_screen->xmysql_sqlQuery,
												FL_BLACK);
		fl_activate_object (Xmysql_main_screen->xmysql_quickSelect);
		fl_set_object_lcol (Xmysql_main_screen->xmysql_quickSelect,
												FL_BLACK);
	}
}

void 
SelectedTableFieldCB (FL_OBJECT * ob, long data)
{
	/* fill-in code for callback */
	char table[NAME_LEN + 50];
	int popup;
	FD_Xmysql_add_record *fd;

	popup = fl_newpup (FL_ObjWin (ob));
	fl_addtopup (popup,
							 "Special Edit %t|Insert record...|Update record...");
	switch (fl_dopup (popup)) {
		case 1:
			if (Xmysql_addrec_screen == 0) {
				SPECIAL_EDIT = SPECIAL_ADD_REC;
				fd = create_form_Xmysql_add_record ();
				sprintf (table, "Insert Record: %s", CURRENT_TABLE);
				fl_show_form (Xmysql_addrec_screen->Xmysql_add_record,
											FL_PLACE_CENTER | FL_FREE_SIZE,
											FL_FULLBORDER,
											table);
			};
			break;
		case 2:
			if (Xmysql_addrec_screen == 0) {
				SPECIAL_EDIT = SPECIAL_UPDATE_REC;
				fd = create_form_Xmysql_add_record ();
				if (fd) {
					sprintf (table, "Update Record: %s", CURRENT_TABLE);
					fl_show_form (Xmysql_addrec_screen->Xmysql_add_record,
												FL_PLACE_CENTER | FL_FREE_SIZE,
												FL_FULLBORDER,
												table);
				}
				else
					Xmysql_addrec_screen = 0;
			}
			break;
	}
}

void 
AdminTablesCB (FL_OBJECT * ob, long data)
{
	/* fill-in code for callback */
	FD_Xmysql_table_admin *fd;

	if (Xmysql_table_admin_screen == 0) {
		fd = create_form_Xmysql_table_admin ();
		fl_show_form (Xmysql_table_admin_screen->Xmysql_table_admin,
									FL_PLACE_CENTER | FL_FREE_SIZE,
									FL_FULLBORDER,
									"Table Administration");
	}
}

void 
SqlQueryCB (FL_OBJECT * ob, long data)
{
	/* fill-in code for callback */
	FD_Xmysql_sql *fd_Xmysql_sql;

	if (Xmysql_sql_screen == 0) {
		fd_Xmysql_sql = create_form_Xmysql_sql ();
		fl_show_form (Xmysql_sql_screen->Xmysql_sql,
									FL_PLACE_CENTER | FL_FREE_SIZE,
									FL_FULLBORDER,
									"SQL Query");
	}
}

void 
QuickSelectCB (FL_OBJECT * ob, long data)
{
	/* fill-in code for callback */
	XmysqlDB (XMYSQL_QUICK_SELECT, 0);
}



/* callbacks for form Xmysql_sql */
void 
SqlCommandCB (FL_OBJECT * ob, long data)
{
	/* fill-in code for callback */
	char tab_and_field[200];
	char *brData = 0;

	brData = (char *) fl_get_browser_line (ob, fl_get_browser (ob));
	if ((strcmp (brData, "UPDATE") == 0) ||
			(strcmp (brData, "INSERT INTO") == 0) ||
			(strcmp (brData, "DELETE FROM") == 0)) {
		sprintf (tab_and_field, "%s %s ", brData, CURRENT_TABLE);
		Build_SQL (tab_and_field, 0);
	}
	else {
		sprintf (tab_and_field, "%s ", brData);
		Build_SQL (tab_and_field, 0);
	}
	/* do help if applicable */
	DoHelp (brData);
}

void 
SQLFieldCB (FL_OBJECT * ob, long data)
{
	/* fill-in code for callback */
	char tab_and_field[200];
	char *brData = 0;

	brData = (char *) fl_get_browser_line (ob, fl_get_browser (ob));
	if (strcmp (brData, "*") != 0) {
		sprintf (tab_and_field, "%s.%s ", CURRENT_SQL_TABLE, brData);
		Build_SQL (tab_and_field, 0);
	}
	else {
		sprintf (tab_and_field, "%s ", brData);
		Build_SQL (tab_and_field, 0);
	}
}

void 
SQLConditionalsCB (FL_OBJECT * ob, long data)
{
	/* fill-in code for callback */
	char tab_and_field[200];
	char *brData = 0;

	brData = (char *) fl_get_browser_line (ob, fl_get_browser (ob));
	if (strcmp (brData, "FROM") == 0 || strcmp (brData, "INTO") == 0) {
		sprintf (tab_and_field, "%s %s ", brData, CURRENT_SQL_TABLE);
		Build_SQL (tab_and_field, 0);
	}
	else {
		sprintf (tab_and_field, "%s ", brData);
		Build_SQL (tab_and_field, 0);
	}
}

void 
SQLOperatorsCB (FL_OBJECT * ob, long data)
{
	/* fill-in code for callback */
	char tab_and_field[200];
	char *brData = 0;

	brData = (char *) fl_get_browser_line (ob, fl_get_browser (ob));
	sprintf (tab_and_field, "%s ", brData);
	Build_SQL (tab_and_field, 0);
}

void 
SQLExitCB (FL_OBJECT * ob, long data)
{
	/* fill-in code for callback */
	if (Xmysql_sql_screen && Xmysql_sql_screen->Xmysql_sql != 0) {
		fl_hide_form (Xmysql_sql_screen->Xmysql_sql);
		fl_free_form (Xmysql_sql_screen->Xmysql_sql);
		Xmysql_sql_screen->Xmysql_sql = 0;
		fl_free (Xmysql_sql_screen);
		Xmysql_sql_screen = 0;
	}
}

void 
SQLSaveCB (FL_OBJECT * ob, long data)
{
	/* fill-in code for callback */
	FILE *fptr;
	const char *fname = 0;
	const char *input = 0;
	char buffer[1024];
	int len;

	fname = fl_show_file_selector ("SQL File To Save", "", "*", "");
	if (fname == NULL)
		return;
	if (strcmp (fname, "") != 0) {
		input = fl_get_input (Xmysql_sql_screen->xmysql_freeForm);
		strcpy (buffer, input);
		input = buffer;
		strcat (buffer, "\n");
		len = strlen (buffer);
		fptr = fopen (fname, "w");
		if (fptr) {
			fwrite (buffer, len, sizeof (char), fptr);

			fclose (fptr);
		}
	}
}

void 
SQLLoadCB (FL_OBJECT * ob, long data)
{
	/* fill-in code for callback */
	const char *line;
	char *buffer;
	char storage[2048];
	int total_lines, i;
	const char *fname;
	FL_OBJECT *obj;
	FL_FORM *form;


	buffer = storage;

	/* The invisible form (a storage area) */

	fl_disable_fselector_cache (TRUE);
	form = fl_bgn_form (FL_NO_BOX, FALSE, FALSE);
	obj = fl_add_browser (FL_NORMAL_BROWSER, FALSE, FALSE, FALSE, FALSE, "");
	fl_end_form ();

	fname = fl_show_file_selector ("SQL File To Load", "", "*", "");
	if (fname && strcmp (fname, "") != 0) {
		if (!fl_load_browser (obj, fname)) {
			XmysqlErr ("ALERT",
								 "ERROR: Can't load SQL file:",
								 fname, " ");
			return;
		}
		total_lines = fl_get_browser_maxline (obj);
		line = fl_get_browser_line (obj, TRUE);
		strcpy (buffer, line);
		strcat (buffer, "\n");
		for (i = 2; i < total_lines; i++) {
			line = fl_get_browser_line (obj, i);
			strcat (buffer, line);
			strcat (buffer, "\n");
		}
		fl_set_input (Xmysql_sql_screen->xmysql_freeForm, buffer);
	}
}

void 
SQLClearCB (FL_OBJECT * ob, long data)
{
	/* fill-in code for callback */
	fl_set_input (Xmysql_sql_screen->xmysql_freeForm, "");
}

void 
SQLSubmitCB (FL_OBJECT * ob, long data)
{
	/* fill-in code for callback */
	XmysqlDB (XMYSQL_SUBMIT_SQL, 0);
}

void 
SQLTablesCB (FL_OBJECT * ob, long data)
{
	/* fill-in code for callback */
	char *brData = 0;

	brData = (char *) fl_get_browser_line (ob, fl_get_browser (ob));
	sprintf (CURRENT_SQL_TABLE, "%s", brData);
	XmysqlDB (XMYSQL_SQLGET_FIELDS, 0);
}

/* callbacks for form Xmysql_query_results */
void 
Result_ExitCB (FL_OBJECT * ob, long data)
{
	/* fill-in code for callback */
	if (Xmysql_query_results_screen->Xmysql_query_results != 0) {
		fl_hide_form (Xmysql_query_results_screen->Xmysql_query_results);
		fl_free_form (Xmysql_query_results_screen->Xmysql_query_results);
		Xmysql_query_results_screen->Xmysql_query_results = 0;
		fl_free (Xmysql_query_results_screen->Xmysql_query_results);
		Xmysql_query_results_screen = 0;
	}
}

void 
Result_FontCB (FL_OBJECT * ob, long data)
{
	/* fill-in code for callback */
	int fontType = 0;
	int font = FL_NORMAL_SIZE;

	fontType = fl_get_choice (ob);
	switch (fontType) {
		case 1:
			font = FL_NORMAL_SIZE;
			break;
		case 2:
			font = FL_TINY_SIZE;
			break;
		case 3:
			font = FL_SMALL_SIZE;
			break;
		case 4:
			font = FL_MEDIUM_SIZE;
			break;
		case 5:
			font = FL_LARGE_SIZE;
			break;
		case 6:
			font = FL_HUGE_SIZE;
			break;
		default:
			font = FL_NORMAL_SIZE;
	}
	fl_set_browser_fontsize (Xmysql_query_results_screen->xmysql_results, font);
	fl_set_object_lsize (Xmysql_query_results_screen->xmysql_header, font);
}

void 
Result_SaveCB (FL_OBJECT * ob, long data)
{
	/* fill-in code for callback */
	FILE_OUT = fl_show_file_selector ("Save Results to File", "", "*", "");
	if (FILE_OUT == NULL)
		return;
	if (strcmp (FILE_OUT, "") != 0) {

		XmysqlDB (LAST_DB_ACTION, 1);
	}
}

void 
Batch_SelectCB (FL_OBJECT * ob, long data)
{
	/* fill-in code for callback */
	int maxBrowserLines = 0;
	int selectLine = 0;
	int i = 0;
	const char *brData = 0;
	char *found = 0;

	maxBrowserLines =
		fl_get_browser_maxline (Xmysql_batch_query_screen->xmysql_batch);

	selectLine = fl_get_browser (ob);

	/* multiline browser fixup */
	if (selectLine < 0)
		selectLine = selectLine * -1;

	/* deselect all previous lines */
	fl_deselect_browser (Xmysql_batch_query_screen->xmysql_batch);

	found = 0;
	for (i = selectLine; i <= maxBrowserLines; i++) {
		brData = fl_get_browser_line (Xmysql_batch_query_screen->xmysql_batch,
																	i);
		/* search for ; to end batch, selecting as we go */
		found = strchr (brData, ';');
		if (!fl_isselected_browser_line (Xmysql_batch_query_screen->xmysql_batch, i))
			fl_select_browser_line (Xmysql_batch_query_screen->xmysql_batch, i);
		if (found)
			break;
	}
	if (found == 0) {
		XmysqlErr ("ALERT",
							 "ERROR: Ending batch mark (;) not found.",
							 "Syntax Error", " ");
	}
}

void 
BatchSQLCB (FL_OBJECT * ob, long data)
{
	/* fill-in code for callback */
	FD_Xmysql_batch_query *fd_Xmysql_batch_sql;

	if (Xmysql_batch_query_screen == 0) {
		fd_Xmysql_batch_sql = create_form_Xmysql_batch_query ();
		fl_show_form (Xmysql_batch_query_screen->Xmysql_batch_query,
									FL_PLACE_CENTER | FL_FREE_SIZE,
									FL_FULLBORDER,
									"SQL Batch");
	}
}
void 
Batch_ExitCB (FL_OBJECT * ob, long data)
{
	/* fill-in code for callback */
	if (Xmysql_batch_query_screen->Xmysql_batch_query != 0) {
		fl_hide_form (Xmysql_batch_query_screen->Xmysql_batch_query);
		fl_free_form (Xmysql_batch_query_screen->Xmysql_batch_query);
		Xmysql_batch_query_screen->Xmysql_batch_query = 0;
		fl_free (Xmysql_batch_query_screen->Xmysql_batch_query);
		Xmysql_batch_query_screen = 0;
	}
}
void 
Batch_SubmitCB (FL_OBJECT * ob, long data)
{
	/* fill-in code for callback */
	int i;
	const char *brData = 0;
	int maxBrowserLines = 0;
	char *found = 0;

	memset (BATCH_SQL, 0, sizeof (BATCH_SQL));
	maxBrowserLines =
		fl_get_browser_maxline (Xmysql_batch_query_screen->xmysql_batch);
	if (maxBrowserLines > 0) {
		for (i = 1; i <= maxBrowserLines; i++) {
			if (fl_isselected_browser_line (Xmysql_batch_query_screen->xmysql_batch,
																			i)) {
				brData = fl_get_browser_line (Xmysql_batch_query_screen->xmysql_batch,
																			i);
				strcat (BATCH_SQL, brData);
				strcat (BATCH_SQL, " ");
				fl_deselect_browser_line (Xmysql_batch_query_screen->xmysql_batch,
																	i);
			}
		}
	}
	if (BATCH_SQL[0] != '\0') {
		found = 0;
		found = strchr (BATCH_SQL, ';');
		if (found)
			*found = ' ';
		XmysqlDB (XMYSQL_BATCH_SQL, 0);
	}
	else
		XmysqlErr ("INFO",
							 "ERROR: So batch selections were made",
							 " ", " ");
}
void 
Batch_LoadCB (FL_OBJECT * ob, long data)
{
	/* fill-in code for callback */
	const char *fname;

	fl_disable_fselector_cache (TRUE);

	fname = fl_show_file_selector ("Batch SQL File To Load", "", "*", "");
	if (fname && strcmp (fname, "") != 0) {
		if (!fl_load_browser (Xmysql_batch_query_screen->xmysql_batch, fname)) {
			XmysqlErr ("ALERT",
								 "ERROR: Can't load batch SQL file:",
								 fname, " ");
			return;
		}
	}
}

/* callbacks for form Xmysql_table_admin */
void 
TblCommandCB (FL_OBJECT * ob, long data)
{
	/* fill-in code for callback */
	char tab_and_field[200];
	char *brData = 0;

	brData = (char *) fl_get_browser_line (ob, fl_get_browser (ob));
	sprintf (tab_and_field, "%s ", brData);
	Build_SQL (tab_and_field, 1);
	/* do help if applicable */
	DoHelp (brData);
}

void 
TblDataTypesCB (FL_OBJECT * ob, long data)
{
	/* fill-in code for callback */
	char tab_and_field[200];
	char *brData = 0;

	brData = (char *) fl_get_browser_line (ob, fl_get_browser (ob));
	sprintf (tab_and_field, "%s ", brData);
	Build_SQL (tab_and_field, 1);
}

void 
TblFreeFormCB (FL_OBJECT * ob, long data)
{
	/* fill-in code for callback */
}

void 
TblExitCB (FL_OBJECT * ob, long data)
{
	/* fill-in code for callback */
	if (Xmysql_table_admin_screen &&
			Xmysql_table_admin_screen->Xmysql_table_admin != 0) {
		fl_hide_form (Xmysql_table_admin_screen->Xmysql_table_admin);
		fl_free_form (Xmysql_table_admin_screen->Xmysql_table_admin);
		Xmysql_table_admin_screen->Xmysql_table_admin = 0;
		fl_free (Xmysql_table_admin_screen);
		Xmysql_table_admin_screen = 0;
	}
}

void 
TblSaveCB (FL_OBJECT * ob, long data)
{
	/* fill-in code for callback */
	FILE *fptr;
	const char *fname;
	const char *input;
	char buffer[1024];
	int len;

	fname = fl_show_file_selector ("Table Admin. File To Save", "", "*", "");
	if (fname == NULL)
		return;
	if (strcmp (fname, "") != 0) {
		input = fl_get_input (Xmysql_table_admin_screen->xmysql_freeform);
		strcpy (buffer, input);
		input = buffer;
		strcat (buffer, "\n");
		len = strlen (buffer);
		fptr = fopen (fname, "w");
		if (fptr) {
			fwrite (buffer, len, sizeof (char), fptr);

			fclose (fptr);
		}
	}
}

void 
TblLoadCB (FL_OBJECT * ob, long data)
{
	/* fill-in code for callback */
	const char *line;
	char *buffer;
	char storage[2048];
	int total_lines, i;
	const char *fname;
	FL_OBJECT *obj;
	FL_FORM *form;


	buffer = storage;

	/* The invisible form (a storage area) */

	fl_disable_fselector_cache (TRUE);
	form = fl_bgn_form (FL_NO_BOX, FALSE, FALSE);
	obj = fl_add_browser (FL_NORMAL_BROWSER, FALSE, FALSE, FALSE, FALSE, "");
	fl_end_form ();

	fname = fl_show_file_selector ("Table Admin.File To Load", "", "*", "");
	if (fname && strcmp (fname, "") != 0) {
		if (!fl_load_browser (obj, fname)) {
			XmysqlErr ("ALERT",
								 "ERROR: Can't load table admin. file:",
								 fname, " ");
			return;
		}
		total_lines = fl_get_browser_maxline (obj);
		line = fl_get_browser_line (obj, TRUE);
		strcpy (buffer, line);
		strcat (buffer, "\n");
		for (i = 2; i < total_lines; i++) {
			line = fl_get_browser_line (obj, i);
			strcat (buffer, line);
			strcat (buffer, "\n");
		}
		fl_set_input (Xmysql_table_admin_screen->xmysql_freeform, buffer);
	}
}

void 
TblClearCB (FL_OBJECT * ob, long data)
{
	/* fill-in code for callback */
	fl_set_input (Xmysql_table_admin_screen->xmysql_freeform, "");
}

void 
TblSubmitCB (FL_OBJECT * ob, long data)
{
	/* fill-in code for callback */
	XmysqlDB (XMYSQL_SUBMIT_TABLESQL, 0);
}

void 
TblTableCB (FL_OBJECT * ob, long data)
{
	/* fill-in code for callback */
	char tab_and_field[200];
	char *brData = 0;

	brData = (char *) fl_get_browser_line (ob, fl_get_browser (ob));
	sprintf (tab_and_field, "%s ", brData);
	Build_SQL (tab_and_field, 1);
}

/* callbacks for form Xmysql_about */
void 
About_ExitCB (FL_OBJECT * ob, long data)
{
	/* fill-in code for callback */
	if (Xmysql_about_screen && Xmysql_about_screen->Xmysql_about != 0) {
		fl_hide_form (Xmysql_about_screen->Xmysql_about);
		fl_free_form (Xmysql_about_screen->Xmysql_about);
		Xmysql_about_screen->Xmysql_about = 0;
		fl_free (Xmysql_about_screen);
		Xmysql_about_screen = 0;
	}
}

/* callbacks for form Xmysql_help */
void 
Help_ExitCB (FL_OBJECT * ob, long data)
{
	/* fill-in code for callback */
	if (Xmysql_help_screen && Xmysql_help_screen->Xmysql_help != 0) {
		fl_hide_form (Xmysql_help_screen->Xmysql_help);
		fl_free_form (Xmysql_help_screen->Xmysql_help);
		Xmysql_help_screen->Xmysql_help = 0;
		fl_free (Xmysql_help_screen);
		Xmysql_help_screen = 0;
	}
}

void 
Help_SearchTxtCB (FL_OBJECT * ob, long data)
{
	/* fill-in code for callback */
}

void 
Help_FindCB (FL_OBJECT * ob, long data)
{
	/* fill-in code for callback */
	int total_lines;
	int i;
	const char *brData = 0;
	char dataLine[1000];
	char newLine[1000];
	const char *input = 0;
	char *found = 0;
	int firstFound = 0;

	input = fl_get_input (Xmysql_help_screen->xmysql_search_string);
	if (*input) {
		fl_freeze_form (Xmysql_help_screen->Xmysql_help);
		sprintf (dataLine, "%s/%s", XMYSQL_HELPPATH, "sqlhelp.txt");
		fl_load_browser (Xmysql_help_screen->xmysql_help, dataLine);
		fl_unfreeze_form (Xmysql_help_screen->Xmysql_help);
		total_lines = fl_get_browser_maxline (Xmysql_help_screen->xmysql_help);

		/* setup memory for found lines */
		if (FOUND_LINES != 0)
			free (FOUND_LINES);

		FOUND_LINES = (int *) calloc (total_lines + 1, sizeof (int));

		for (i = 1; i < total_lines; i++) {
			brData = fl_get_browser_line (Xmysql_help_screen->xmysql_help, i);
			strcpy (dataLine, brData);
			found = strstr (dataLine, input);
			if (found) {
				if (firstFound == 0)
					firstFound = i;
				FOUND_LINES[i] = i;
				sprintf (newLine, "@C%d%s", FL_RED, dataLine);
				fl_replace_browser_line (Xmysql_help_screen->xmysql_help, i,
																 newLine);
			}
		}
		if (firstFound) {
			CURRENT_FOUND_IDX = firstFound;
			fl_set_browser_topline (Xmysql_help_screen->xmysql_help, firstFound);
			fl_set_input (Xmysql_help_screen->xmysql_search_string, "");
		}
	}

}

void 
Help_PreviousCB (FL_OBJECT * ob, long data)
{
	/* fill-in code for callback */
	int x = CURRENT_FOUND_IDX - 1;

	for (; x > 0; x--) {
		if (FOUND_LINES[x] != 0) {
			CURRENT_FOUND_IDX = FOUND_LINES[x];
			fl_set_browser_topline (Xmysql_help_screen->xmysql_help, CURRENT_FOUND_IDX);
			break;
		}
	}
}

void 
Help_NextCB (FL_OBJECT * ob, long data)
{
	/* fill-in code for callback */
	int total_lines;
	int x = CURRENT_FOUND_IDX + 1;

	total_lines = fl_get_browser_maxline (Xmysql_help_screen->xmysql_help);

	for (; x < total_lines; x++) {
		if (FOUND_LINES && FOUND_LINES[x] != 0) {
			CURRENT_FOUND_IDX = FOUND_LINES[x];
			fl_set_browser_topline (Xmysql_help_screen->xmysql_help, CURRENT_FOUND_IDX);
			break;
		}
	}
}

/* callbacks for form Xmysql_config */
void 
Config_ExitCB (FL_OBJECT * ob, long data)
{
	/* fill-in code for callback */
	if (Xmysql_config_screen && Xmysql_config_screen->Xmysql_config != 0) {
		fl_hide_form (Xmysql_config_screen->Xmysql_config);
		fl_free_form (Xmysql_config_screen->Xmysql_config);
		Xmysql_config_screen->Xmysql_config = 0;
		fl_free (Xmysql_config_screen);
		Xmysql_config_screen = 0;
	}
}

void 
Config_AcceptCB (FL_OBJECT * ob, long data)
{
	/* fill-in code for callback */
	char title[300];
	const char *host = 0;
	const char *user = 0;
	const char *pass = 0;
	const char *limit = 0;
	const char *port = 0;
	const char *isocket = 0;

	host = fl_get_input (Xmysql_config_screen->xmysql_host);
	user = fl_get_input (Xmysql_config_screen->xmysql_user);
	pass = fl_get_input (Xmysql_config_screen->xmysql_password);
	limit = fl_get_input (Xmysql_config_screen->xmysql_qlimit);
	port = fl_get_input (Xmysql_config_screen->xmysql_port);
	isocket = fl_get_input (Xmysql_config_screen->xmysql_socket);
	if (limit) {
		QUICK_LIMIT = atoi (limit);
	}
	if (*port)
		strcpy (CURRENT_PORT, port);
	if (*isocket)
		strcpy (CURRENT_SOCKET, isocket);
	if (host) {
		strcpy (CURRENT_SERVER, host);
		if (QUICK_LIMIT > 0)
			sprintf (title, "Xmysql - Server: %s   QLimit: %d",
							 CURRENT_SERVER, QUICK_LIMIT);
		else
			sprintf (title, "Xmysql - Server: %s", CURRENT_SERVER);
		fl_wintitle (Xmysql_main_screen->Xmysql_main->window, title);
	}
	/* Monty: removed check for password and user ******************* 
	if (*user && *pass) {
		strcpy (CURRENT_USER, user);
		strcpy (CURRENT_PASSWORD, pass);
		Config_ExitCB (0, 0);
	}
	else if ((*user && !*pass) || (*pass && !*user))
		XmysqlErr ("INFO",
							 "ERROR: Both user and password should be",
							 "entered for security reasons!",
							 " ");
	else {
		memset (CURRENT_USER, 0, sizeof (CURRENT_USER));
		memset (CURRENT_PASSWORD, 0, sizeof (CURRENT_PASSWORD));
		Config_ExitCB (0, 0);
	}
	****************************************************************/
	strcpy (CURRENT_USER, user);
	strcpy (CURRENT_PASSWORD, pass);
	Config_ExitCB (0, 0);
}

/* callbacks for form Xmysql_add_record */
void 
AddRec_ExitCB (FL_OBJECT * ob, long data)
{
	/* fill-in code for callback */
	if (Xmysql_addrec_screen && Xmysql_addrec_screen->Xmysql_add_record != 0) {
		fl_hide_form (Xmysql_addrec_screen->Xmysql_add_record);
		fl_free_form (Xmysql_addrec_screen->Xmysql_add_record);
		Xmysql_addrec_screen->Xmysql_add_record = 0;
		fl_free (Xmysql_addrec_screen);
		Xmysql_addrec_screen = 0;
	}
}

void 
AddRec_AddCB (FL_OBJECT * ob, long data)
{
	/* fill-in code for callback */
	if (TABLEFIELDINFO.nbrFields > 0) {
		if (SPECIAL_EDIT == SPECIAL_ADD_REC)
			XmysqlDB (XMYSQL_ADDREC, 0);
		else if (SPECIAL_EDIT == SPECIAL_UPDATE_REC) {
			XmysqlDB (XMYSQL_UPDATEREC, 0);
			AddRec_ExitCB (0, 0);
		}
	}
}

void 
AddRec_SelectedFieldCB (FL_OBJECT * ob, long data)
{
	/* fill-in code for callback */
	const char *brData = 0;
	char dataPart[10000];
	char temp[10000];
	int idx = 0;
	int total_lines = 0;
	int maxSize = 0;

	memset (dataPart, 0, sizeof (dataPart));
	memset (temp, 0, sizeof (temp));

	idx = fl_get_browser (Xmysql_addrec_screen->xmysql_record);

	total_lines = fl_get_browser_maxline (Xmysql_addrec_screen->xmysql_record);

	/* find longest field name */
	maxSize = GetMaxFieldSize ();

	/*  fl_select_browser_line(Xmysql_addrec_screen->xmysql_record, idx); */
	brData = fl_get_browser_line (Xmysql_addrec_screen->xmysql_record, idx);
	strcpy (temp, brData);
	strcpy (dataPart, &temp[maxSize + 1]);
	if (strlen (dataPart) == 0)
		fl_set_input (Xmysql_addrec_screen->xmysql_input, "");
	else {
		fl_set_input (Xmysql_addrec_screen->xmysql_input, dataPart);
		fl_set_input_selected (Xmysql_addrec_screen->xmysql_input, 1);
	}
}

void 
AddRec_OkCB (FL_OBJECT * ob, long data)
{
	/* fill-in code for callback */
	char dataPart[10000];
	int idx = 0;
	int total_lines = 0;
	int maxSize = 0;
	const char *brData = 0;
	const char *input = 0;
	char *found = 0;
	char field[NAME_LEN + 5];

	memset (dataPart, 0, sizeof (dataPart));
	memset (field, 0, sizeof (field));
	maxSize = GetMaxFieldSize ();

	idx = fl_get_browser (Xmysql_addrec_screen->xmysql_record);

	total_lines = fl_get_browser_maxline (Xmysql_addrec_screen->xmysql_record);
	brData = fl_get_browser_line (Xmysql_addrec_screen->xmysql_record, idx);
	input = fl_get_input (Xmysql_addrec_screen->xmysql_input);
	strcpy (dataPart, brData);
	found = strchr (dataPart, ' ');
	if (found)
		*found = 0;

	strcpy (field, dataPart);
	if (input) {
		sprintf (dataPart, "%-*s %s", maxSize, field, input);
		fl_replace_browser_line (Xmysql_addrec_screen->xmysql_record, idx,
														 dataPart);
	}

	/* see if we should continue */
	idx++;
	if (idx > total_lines);
	else {
		fl_select_browser_line (Xmysql_addrec_screen->xmysql_record, idx);
		fl_set_browser_topline (Xmysql_addrec_screen->xmysql_record, idx);
		AddRec_SelectedFieldCB (0, 0);
	}
}

void 
AddRec_ClearCB (FL_OBJECT * ob, long data)
{
	/* fill-in code for callback */
	fl_set_input (Xmysql_addrec_screen->xmysql_input, "");
}
