#include "udm_config.h"

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/time.h>
#include <errno.h>

#include <sys/socket.h>
#include <netinet/in.h>
#include <string.h>

#include "udm_common.h"
#include "udm_socket.h"
#include "udm_utils.h"
#include "udm_proto.h"
#include "udm_log.h"
#include "udm_xmalloc.h"
#include "udm_proto.h"


void socket_close( UDM_CONN *connp ){
	if (!connp)
		return;

	if (connp->conn_fd > 0){
		close(connp->conn_fd);
		fclose(connp->in);
		fclose(connp->out);
		connp->conn_fd = 0;
	}    
	return;
}


int socket_open( UDM_CONN *connp ) {
	int op, len;
	
	op=1;
	len = sizeof(struct sockaddr_in);
	
	/* Create cocket */
	connp->conn_fd = socket(PF_INET, SOCK_STREAM, IPPROTO_TCP);
	if (connp->conn_fd == -1){
		connp->err = UDM_NET_ERROR;
		return -1;
	}

	if (setsockopt(connp->conn_fd, SOL_SOCKET, SO_REUSEADDR,
					(char *)&op,sizeof(op))==-1) {
		connp->err = UDM_NET_ERROR;
		return -1;
	}

	connp->in = fdopen(connp->conn_fd, "r");
	if (!connp->in){
		return -1;
	}
	
	connp->out = fdopen(connp->conn_fd, "w");
	if (!connp->out){
		return -1;
	}
	connp->sin.sin_family = AF_INET;
	return 0;
}

int socket_connect( UDM_CONN *connp){
        int len;

	if (connect(connp->conn_fd, (struct sockaddr *)&connp->sin,
	    				    sizeof(connp->sin)) == -1) {
		connp->err = UDM_NET_CANT_CONNECT;
		return -1;
	}
	
	len = sizeof(struct sockaddr_in);
	if (getsockname(connp->conn_fd, (struct sockaddr *)&connp->sin, &len) == -1){
		connp->err = UDM_NET_ERROR;
                return -1;
	}
	connp->connected = NET_CONNECTED;
	return 0;
}


int socket_select( UDM_CONN *connp, int timeout, char mode) {
        fd_set fds;
        struct timeval tv;
	int rfd;

        FD_ZERO(&fds);

        tv.tv_sec = timeout;
        tv.tv_usec = 0;
    do{
        FD_ZERO(&fds);
	FD_SET(connp->conn_fd, &fds);
	if (mode == 'r')
    		rfd = select(connp->conn_fd+1, &fds, 0, 0, &tv);
	else
    		rfd = select(connp->conn_fd+1, 0, &fds, 0, &tv);
	
	if (rfd == 0 ) {
		/* timeout */
		if (timeout)
			connp->err = UDM_NET_TIMEOUT;
		return -1;
	
	}
    }while( rfd == -1 && errno == EINTR);
	return 0;	
}

int socket_read( UDM_CONN *connp, int maxsize){
	int num_read, num_read_total;
    
	num_read_total = 0;

	if (connp->buf)
		UDM_FREE(connp->buf);

	connp->buf_len_total = 0;
	connp->buf_len = 0;
	connp->err = 0;
	
	do {
		if (socket_select(connp, connp->timeout, 'r') == -1){
			return -1;
		}

		if (connp->buf_len_total <= num_read_total+NET_BUF_SIZE){
			connp->buf_len_total += NET_BUF_SIZE;
			connp->buf = UdmXrealloc(connp->buf, connp->buf_len_total+1);
		}
		
		num_read = read(connp->conn_fd, connp->buf+num_read_total, NET_BUF_SIZE);
		num_read_total += num_read;		

		if (num_read < 0){
			connp->err = UDM_NET_ERROR;
			return -1;
		}else if (num_read == 0)
			break;
		if (num_read_total >=maxsize ){
			connp->err = UDM_NET_FILE_TL;
			break;
		}
	}while (num_read!=0);
	connp->buf_len = num_read_total;
	return num_read_total;	
}


int socket_read_line( UDM_CONN *connp ){
	int num_read_total, buf_size;
	
        buf_size = NET_BUF_SIZE;
	num_read_total = 0;

	if (connp->buf)
		UDM_FREE(connp->buf);
	
	connp->buf_len_total = 0;
	connp->buf_len = 0;

	while(1){
		if (connp->buf_len_total <= num_read_total+NET_BUF_SIZE) {
			connp->buf_len_total += NET_BUF_SIZE;
			connp->buf = UdmXrealloc(connp->buf, connp->buf_len_total +1); 
		}
	
		connp->buf[num_read_total] = fgetc(connp->in);
		if (connp->buf[num_read_total] == EOF)
			return -1;
		if (connp->buf[num_read_total] == '\n')
			break;
		else if (connp->buf[num_read_total] == 0)
			break;
		num_read_total++;
        }
/*
	if (!fgets(connp->buf, NET_BUF_SIZE, connp->in) == -1){
		connp->err = UDM_NET_ERROR;
		return -1;
	}
*/
	connp->buf_len = strlen(connp->buf);
	return num_read_total;	
}

int socket_write(UDM_CONN *connp, char *buf){
	
	if (socket_select(connp, NET_READ_TIMEOUT, 'w') == -1)
		return -1;

	if (send(connp->conn_fd, buf, strlen(buf), 0) == -1){
		connp->err = UDM_NET_ERROR;
		return -1;
	}
	return 0;
}

int socket_accept(UDM_CONN *connp){
	struct sockaddr sa;
	int sfd, len;
        if (socket_select(connp, NET_ACC_TIMEOUT, 'r') == -1)
		return -1;

	len = sizeof(struct sockaddr);
						
	sfd = accept(connp->conn_fd, &sa, &len);
	socket_close(connp);

	if (sfd == -1){
		connp->err = UDM_NET_ERROR;
		return -1;
	}
	connp->conn_fd = sfd;

	connp->in = fdopen(connp->conn_fd, "r");
	if (!connp->in){
		return -1;
	}
	
	connp->out = fdopen(connp->conn_fd, "w");
	if (!connp->out){
		return -1;
	}
	
	memcpy(&connp->sin, &sa, sizeof(connp->sin));
	return 0;
}

int socket_listen(UDM_CONN *connp){

        connp->sin.sin_port = 0; 

        if (bind(connp->conn_fd, (struct sockaddr *)&connp->sin, 
				    sizeof(struct sockaddr_in)) == -1){
		connp->err = UDM_NET_ERROR;
	        return -1;
	}
	if (socket_getname(connp, &connp->sin) == -1)
	    return -1;	
								
        if (listen(connp->conn_fd, 1) == -1){
		connp->err = UDM_NET_ERROR;
	        return -1;
	}
        return 0;
}

int socket_getname(UDM_CONN *connp, struct sockaddr_in *sin){
        int len;
	
	len = sizeof(struct sockaddr_in);
        if (getsockname(connp->conn_fd, (struct sockaddr *)sin, &len) == -1){
		connp->err = UDM_NET_ERROR;
                return -1;
	}
	return 0;
}

void socket_buf_clear(UDM_CONN *connp){
	char buf[1024];
	int len;
	do {
    		if (socket_select(connp, 0, 'r')==-1)
			return;
		len = read(connp->conn_fd, buf, 1024);
	}while(len > 0);
}

