/*
* parsedate.c
* author: Heiko Stoermer, innominate AG, stoermer@innominate.de
* 20000316
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "udm_parsedate.h"

#define BUFF 20

static int get_month(char * month)
{
	if(strcmp(month,"Jan") == 0)
		return 1;
	else if(strcmp(month,"Feb") == 0)
		return 2;
	else if(strcmp(month,"Mar") == 0)
		return 3;
	else if(strcmp(month,"Apr") == 0)
		return 4;
	else if(strcmp(month,"May") == 0)
		return 5;
	else if(strcmp(month,"Jun") == 0)
		return 6;
	else if(strcmp(month,"Jul") == 0)
		return 7;
	else if(strcmp(month,"Aug") == 0)
		return 8;
	else if(strcmp(month,"Sep") == 0)
		return 9;
	else if(strcmp(month,"Oct") == 0)
		return 10;
	else if(strcmp(month,"Nov") == 0)
		return 11;
	else if(strcmp(month,"Dec") == 0)
		return 12;
	else
		return 0;
}

/* returns allocated pointer to string containing the sql-conformant datetime type.
* processes nntp datestrings of the following types:
* 1: 17 Jun 1999 11:05:42 GMT
* 2: Wed, 08 Mar 2000 13:52:43 +0100 
*/

char * UdmParseDate(const char * datestring)
{
	
	/* buffers */
	char year  [BUFF] = "";
	char month [BUFF] = "";
	char date  [BUFF] = "";
	char time  [BUFF] = "";
	char * tokens[4];
	/* result */
	char * res = NULL;
	/* some ints for substring indices */
	int pos  = 0;
	int allocsize = 0;

	/* pointers for parsing */
	char * next = NULL;
	char * prev = NULL;
	int len = 0;
	/* working copy and copy-copy */
	char * copy = NULL;
	char * copyref = NULL;
	/* we need this for the different types */
	int offset = 0;
	/* initialize everythign nicely */
	tokens[0] = date;
	tokens[1] = month;
	tokens[2] = year;
	tokens[3] = time;

	if(strlen(datestring))
	{
		/* select string type */
		if((pos = (int)strchr(datestring,',')))
		{
			/* simply skip the first characters containing the weekday string */
			offset = (int) ( (int)pos - (int)datestring);	
			offset += 2; /* skip comma and whitespace */
		}
		copy = malloc(strlen(datestring+offset)+1);
		strcpy(copy,datestring+offset);
		copyref = copy; /* save the pointer for deallocation later */
	
		/* now we can start.*/
		/* split up the string*/
		pos = 0;
		prev = copy;
		next = strtok(copy," ");
		while(pos < 4)
		{
			if((next = strtok(NULL," ")) == NULL) /* last element */
				len = strlen(prev);
			else
				len = (int) (next-prev);
			if(len > BUFF) /* unexpected token length*/
				return NULL;
			strncpy(tokens[pos],prev,len);
			/* preparations for the next run*/
			prev = next;
			++pos;
			 /*next = strtok(NULL," ");*/
		}


		/* o.k., this type of parsing is no fexible enough... :(*/
		/*
		strncpy(date,datestring+offset,2);
		date[2] = 0;
		strncpy(month,datestring+offset+3,3);
		month[3] = 0;
		strncpy(year,datestring+offset+7,4); 
		year[4] = 0;
		strncpy(time,datestring+offset+12,8);	
		time[8] = 0;
		*/

		/* we allocate 4 extra characters for separators and \0  */
		allocsize = strlen(date)+strlen(month)+strlen(year)+strlen(time)+ 4;
		res = malloc(allocsize);
		sprintf(res,"%s-%02i-%02i %s",year,get_month(month),atoi(date),time);	
		res[allocsize-1] = 0;
		/* clean up nicely. we dont want memory leaks within 100 lines...*/
		free(copyref);
	}
	return res;
}
