#ifndef _UDM_DBMS_H
#define _UDM_DBMS_H

/* for stl_info_t */
#include "udm_search_tl.h"

/* Database type */
#define UDM_DB_UNK		0
#define UDM_DB_MSQL		1
#define UDM_DB_MYSQL		2
#define UDM_DB_PGSQL		3
#define UDM_DB_SOLID		4
#define UDM_DB_ORACLE		5
#define UDM_DB_VIRT		6
#define UDM_DB_IBASE		7
#define UDM_DB_ORACLE8		8
#define UDM_DB_ORACLE7		9
#define UDM_DB_MSSQL		10
#define UDM_DB_FILES		100

/* FIXME: hide this function into SQL.c */
extern char * escstr(char *x,char *y);

extern int UdmLoadStopList(void * db);
extern int UdmAddURL(UDM_INDEXER * Indexer,char *url,int referrer,int hops, char * msg_id);
extern int UdmDeleteWordFromURL(UDM_INDEXER* Indexer,int url_id);
extern int UdmDeleteUrl(UDM_INDEXER* Indexer,int url_id);
extern int UdmUpdateUrl(UDM_INDEXER* Indexer,int url_id,int status,int period);

#ifdef NEWS_EXT
extern int UdmRegisterChild(UDM_INDEXER *Indexer, int parent_id, int child_id);
extern int UdmFindMsgID(UDM_INDEXER *Indexer, const char * msg_id);
extern int UdmDeleteAllFromThread(UDM_INDEXER* Indexer);
extern int UdmLongUpdateUrl(UDM_INDEXER *Indexer,
	int url_id,int status,int changed,int size,int period,
	char * tag,int index,
	time_t last_mod_time,
	char *text_escaped,
	char *title_escaped,
	char *content_type,
	char *keywords_escaped,
	char *descript_escaped,
	udmcrc32_t crc32,
	char *lang,
	char *category,
	char *hd_date,
	char *hd_subj,
	char *hd_from,
	char *hd_group,
	char *hd_ref,
	char *msg_id
);
#else
extern int UdmLongUpdateUrl(UDM_INDEXER* Indexer,
	int url_id,int status,int is_changed,
	int size,int period,char *tag,int index,
	time_t last_mod_time,
	char *text_escaped,
	char *title_escaped,
	char *content_type,
	char *keywords_escaped,
	char *descript_escaped,
	udmcrc32_t crc32,
	char *lang,
	char *category);
#endif

extern int UdmStoreWords(UDM_INDEXER * Indexer, int url_id, int status);
extern int UdmFindOrigin(UDM_INDEXER* Indexer, udmcrc32_t crc32, int size);
extern int UdmUpdateClone(UDM_INDEXER* Indexer, int url_id, int status, int period,
	char *content_type, time_t last_mod_time, udmcrc32_t crc32);

extern int UdmDeleteAllFromDict(UDM_INDEXER* Indexer);
extern int UdmDeleteAllFromUrl(UDM_INDEXER* Indexer);
extern int UdmDeleteRobotsFromHost(UDM_INDEXER* Indexer,char *hostinfo);
extern int UdmAddRobotsToHost(UDM_INDEXER* Indexer,char *hostinfo,char *s);

extern UDM_DOCUMENT * UdmFind(void * db,char *q,int np,int ps, int mode,int sort_order,char *wordinfo,int *found);
extern UDM_DOCUMENT * UdmCloneList(void * db, udmcrc32_t crc32);
extern UDM_DOCUMENT * UdmGetDocInfo(UDM_INDEXER* Indexer,int expired_first);
extern UDM_STOPWORD * UdmIsStopWord(char *word);
extern char * UdmDBErrorMsg(void *db);
extern int UdmDBErrorCode(void *db);

extern void * UdmAllocDB(int mode);
extern void   UdmFreeDB(void * db);
extern int    UdmLoadRobots(UDM_INDEXER *Indexer);
extern int    UdmMarkForReindex(UDM_INDEXER * Indexer);
extern int    UdmClearDB(UDM_INDEXER * Indexer);
extern int    UdmInitDB();

extern int         UdmInsertSpell(UDM_INDEXER *,char *,char *,char *);
extern UDM_SPELL * UdmFindWordDB(char *);
extern int 	   UdmInsertAffix(UDM_INDEXER *,char ,char *,char *,char *,char *,char *);
extern int         UdmDBImportAffixes(void *);
extern UDM_CATEGORY  *  UdmCatPath(void * db,char * addr);
extern UDM_CATEGORY  *  UdmCatList(void * db,char * addr);

extern __INDLIB__ int UdmAddTagLimit(char * tag);
extern __INDLIB__ int UdmAddStatusLimit(int status);
extern __INDLIB__ int UdmAddURLLimit(char * URL);
extern __INDLIB__ int UdmAddLangLimit(char * lang);
extern __INDLIB__ int UdmAddTimeLimit(struct udm_stl_info_t *stl);
extern __INDLIB__ int UdmAddCatLimit(char * category);
extern __INDLIB__ int UdmClearURLLimit();
extern __INDLIB__ int UdmClearLimits();
extern __INDLIB__ int UdmGetReferers(UDM_INDEXER * Indexer);
extern __INDLIB__ int UdmGetStatistics();
extern __INDLIB__ char * UdmVersion();


#ifdef USE_HTDB
int UdmHTDBGet(UDM_INDEXER * Indexer,char *path,char *filename,char * htdb_list, char * htdb_doc,
		char *buf,int MaxDocSize);
#endif

#ifdef ENABLE_DB_UPDATE
extern int UpdateDatabase(UDM_INDEXER * Indexer);
#endif /* ENABLE_DB_UPDATE */


#endif
